/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchViewer;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchChange {
    @NotNull
    private final ApplyPatchViewer myViewer;
    private final int myIndex;
    @NotNull
    private final LineRange myPatchDeletionRange;
    @NotNull
    private final LineRange myPatchInsertionRange;
    @NotNull
    private final AppliedTextPatch.HunkStatus myStatus;
    @Nullable
    private final List<DiffFragment> myPatchInnerDifferences;
    @NotNull
    private final List<DiffGutterOperation> myOperations;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    private boolean myResolved;

    ApplyPatchChange(@NotNull PatchChangeBuilder.AppliedHunk hunk, int index, @NotNull ApplyPatchViewer viewer) {
        if (hunk == null) {
            ApplyPatchChange.$$$reportNull$$$0(0);
        }
        if (viewer == null) {
            ApplyPatchChange.$$$reportNull$$$0(1);
        }
        this.myOperations = new ArrayList<DiffGutterOperation>();
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myIndex = index;
        this.myViewer = viewer;
        this.myPatchDeletionRange = hunk.getPatchDeletionRange();
        this.myPatchInsertionRange = hunk.getPatchInsertionRange();
        this.myStatus = hunk.getStatus();
        DocumentEx patchDocument = viewer.getPatchEditor().getDocument();
        this.myPatchInnerDifferences = PatchChangeBuilder.computeInnerDifferences((Document)patchDocument, hunk);
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.myViewer.repaintDivider();
    }

    private void installHighlighters() {
        this.createResultHighlighters();
        this.createPatchHighlighters();
        this.createStatusHighlighter();
        this.createOperations();
    }

    private void createPatchHighlighters() {
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters((Editor)patchEditor, (LineRange)this.myPatchDeletionRange, (LineRange)this.myPatchInsertionRange, this.myPatchInnerDifferences));
    }

    private void createResultHighlighters() {
        LineRange resultRange = this.getResultRange();
        if (resultRange == null) {
            return;
        }
        EditorEx editor = this.myViewer.getResultEditor();
        int startLine = resultRange.start;
        int endLine = resultRange.end;
        TextDiffType type = this.getDiffType();
        boolean resolved = this.isRangeApplied();
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)editor, startLine, endLine, type).withResolved(resolved).done());
    }

    private void createStatusHighlighter() {
        int line1 = this.myPatchDeletionRange.start;
        int line2 = this.myPatchInsertionRange.end;
        Color color = this.getStatusColor();
        if (this.isResolved()) {
            color = ColorUtil.mix((Color)color, (Color)this.myViewer.getPatchEditor().getGutterComponentEx().getBackground(), (double)0.6f);
        }
        String tooltip = this.getStatusText();
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        DocumentEx document = patchEditor.getDocument();
        MarkupModelEx markupModel = patchEditor.getMarkupModel();
        TextRange textRange = DiffUtil.getLinesRange((Document)document, (int)line1, (int)line2);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(null, textRange.getStartOffset(), textRange.getEndOffset(), 6000, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyGutterRenderer(line1, line2, color, tooltip));
        this.myHighlighters.add(highlighter);
    }

    private void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public AppliedTextPatch.HunkStatus getStatus() {
        AppliedTextPatch.HunkStatus hunkStatus = this.myStatus;
        if (hunkStatus == null) {
            ApplyPatchChange.$$$reportNull$$$0(2);
        }
        return hunkStatus;
    }

    @NotNull
    public LineRange getPatchRange() {
        return new LineRange(this.myPatchDeletionRange.start, this.myPatchInsertionRange.end);
    }

    @NotNull
    public LineRange getPatchAffectedRange() {
        LineRange lineRange = this.isRangeApplied() ? this.myPatchInsertionRange : this.myPatchDeletionRange;
        if (lineRange == null) {
            ApplyPatchChange.$$$reportNull$$$0(3);
        }
        return lineRange;
    }

    @NotNull
    public LineRange getPatchDeletionRange() {
        LineRange lineRange = this.myPatchDeletionRange;
        if (lineRange == null) {
            ApplyPatchChange.$$$reportNull$$$0(4);
        }
        return lineRange;
    }

    @NotNull
    public LineRange getPatchInsertionRange() {
        LineRange lineRange = this.myPatchInsertionRange;
        if (lineRange == null) {
            ApplyPatchChange.$$$reportNull$$$0(5);
        }
        return lineRange;
    }

    @Nullable
    public LineRange getResultRange() {
        ApplyPatchViewer.MyModel model = this.myViewer.getModel();
        int lineStart = model.getLineStart(this.myIndex);
        int lineEnd = model.getLineEnd(this.myIndex);
        if (lineStart != -1 || lineEnd != -1) {
            return new LineRange(lineStart, lineEnd);
        }
        return null;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getDiffType((!this.myPatchDeletionRange.isEmpty() ? 1 : 0) != 0, (!this.myPatchInsertionRange.isEmpty() ? 1 : 0) != 0);
        if (textDiffType == null) {
            ApplyPatchChange.$$$reportNull$$$0(6);
        }
        return textDiffType;
    }

    public boolean isRangeApplied() {
        return this.myResolved || this.getStatus() == AppliedTextPatch.HunkStatus.ALREADY_APPLIED;
    }

    @NotNull
    @NlsContexts.Tooltip
    private String getStatusText() {
        String string = VcsBundle.message((String)(switch (this.myStatus) {
            default -> throw new IncompatibleClassChangeError();
            case AppliedTextPatch.HunkStatus.ALREADY_APPLIED -> "patch.apply.already.applied.status";
            case AppliedTextPatch.HunkStatus.EXACTLY_APPLIED -> "patch.apply.automatically.applied.status";
            case AppliedTextPatch.HunkStatus.NOT_APPLIED -> "patch.apply.not.applied.status";
        }), (Object[])new Object[0]);
        if (string == null) {
            ApplyPatchChange.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private Color getStatusColor() {
        Color color = switch (this.myStatus) {
            default -> throw new IncompatibleClassChangeError();
            case AppliedTextPatch.HunkStatus.ALREADY_APPLIED -> JBColor.YELLOW.darker();
            case AppliedTextPatch.HunkStatus.EXACTLY_APPLIED -> new JBColor(new Color(0, 180, 5), new Color(0, 147, 5));
            case AppliedTextPatch.HunkStatus.NOT_APPLIED -> JBColor.RED.darker();
        };
        if (color == null) {
            ApplyPatchChange.$$$reportNull$$$0(8);
        }
        return color;
    }

    private void createOperations() {
        if (this.myViewer.isReadOnly()) {
            return;
        }
        if (this.isResolved()) {
            return;
        }
        if (this.myStatus == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.APPLY));
        } else {
            ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.COPY));
        }
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.IGNORE));
    }

    @Nullable
    private DiffGutterOperation createOperation(@NotNull OperationType type) {
        if (type == null) {
            ApplyPatchChange.$$$reportNull$$$0(9);
        }
        if (this.isResolved()) {
            return null;
        }
        EditorEx editor = this.myViewer.getPatchEditor();
        int line = type == OperationType.COPY ? this.getPatchInsertionRange().start : this.getPatchRange().start;
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, (int)line);
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OperationType.APPLY -> this.createApplyRenderer();
            case OperationType.COPY -> this.createCopyRenderer();
            case OperationType.IGNORE -> this.createIgnoreRenderer();
        });
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]), DiffUtil.getArrowIcon((Side)Side.RIGHT), () -> this.myViewer.executeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), () -> this.myViewer.replaceChange(this)));
    }

    @Nullable
    private GutterIconRenderer createCopyRenderer() {
        if (this.getPatchInsertionRange().isEmpty()) {
            return null;
        }
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.copy.text", (Object[])new Object[0]), AllIcons.Actions.Copy, () -> this.myViewer.executeCommand(DiffBundle.message((String)"patch.dialog.copy.change.command", (Object[])new Object[0]), () -> this.myViewer.copyChangeToClipboard(this)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]), AllIcons.Diff.Remove, () -> this.myViewer.executeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), () -> this.myViewer.markChangeResolved(this)));
    }

    @Nullable
    private static GutterIconRenderer createIconRenderer(@NotNull @NlsContexts.Tooltip String text, @NotNull Icon icon, final @NotNull Runnable perform) {
        if (text == null) {
            ApplyPatchChange.$$$reportNull$$$0(10);
        }
        if (icon == null) {
            ApplyPatchChange.$$$reportNull$$$0(11);
        }
        if (perform == null) {
            ApplyPatchChange.$$$reportNull$$$0(12);
        }
        String tooltipText = DiffUtil.createTooltipText((String)text, null);
        return new DiffGutterRenderer(icon, tooltipText){

            protected void handleMouseClick() {
                perform.run();
            }
        };
    }

    @NotNull
    public State storeState() {
        LineRange resultRange = this.getResultRange();
        return new State(this.myIndex, resultRange != null ? resultRange.start : -1, resultRange != null ? resultRange.end : -1, this.myResolved);
    }

    public void restoreState(@NotNull State state) {
        if (state == null) {
            ApplyPatchChange.$$$reportNull$$$0(13);
        }
        this.myResolved = state.myResolved;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchAffectedRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchDeletionRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchInsertionRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private class MyGutterRenderer
    implements ActiveGutterRenderer {
        private final int myLine1;
        private final int myLine2;
        private final Color myColor;
        private final @NlsContexts.Tooltip String myTooltip;

        MyGutterRenderer(int line1, int line2, @NlsContexts.Tooltip Color color, String tooltip) {
            this.myLine1 = line1;
            this.myLine2 = line2;
            this.myColor = color;
            this.myTooltip = tooltip;
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            if (editor == null) {
                MyGutterRenderer.$$$reportNull$$$0(0);
            }
            if (g == null) {
                MyGutterRenderer.$$$reportNull$$$0(1);
            }
            if (r == null) {
                MyGutterRenderer.$$$reportNull$$$0(2);
            }
            LineStatusMarkerDrawUtil.paintSimpleRange((Graphics)g, (Editor)editor, (int)this.myLine1, (int)this.myLine2, (Color)this.myColor);
        }

        public String getTooltipText() {
            return this.myTooltip;
        }

        public boolean canDoAction(@NotNull MouseEvent e) {
            if (e == null) {
                MyGutterRenderer.$$$reportNull$$$0(3);
            }
            return LineStatusMarkerDrawUtil.isInsideMarkerArea((MouseEvent)e);
        }

        public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            if (editor == null) {
                MyGutterRenderer.$$$reportNull$$$0(4);
            }
            if (e == null) {
                MyGutterRenderer.$$$reportNull$$$0(5);
            }
            if (ApplyPatchChange.this.getResultRange() != null) {
                e.consume();
                ApplyPatchChange.this.myViewer.scrollToChange(ApplyPatchChange.this, Side.RIGHT, false);
            }
        }

        @NotNull
        public String getAccessibleName() {
            String string = VcsBundle.message((String)"patch.apply.marker.renderer", (Object[])new Object[]{this.getTooltipText()});
            if (string == null) {
                MyGutterRenderer.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange$MyGutterRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange$MyGutterRenderer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canDoAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doAction";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private static enum OperationType {
        APPLY,
        COPY,
        IGNORE;

    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved;

        public State(int index, int startLine, int endLine, boolean resolved) {
            super(index, startLine, endLine);
            this.myResolved = resolved;
        }
    }
}

