/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.action;

import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a8\u0010\u0000\u001a\u00020\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a8\u0006\u000e"}, d2={"shutdownNotebook", "", "actionClass", "Lkotlin/reflect/KClass;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "classForLogging", "project", "Lcom/intellij/openapi/project/Project;", "editors", "", "Lcom/intellij/openapi/editor/Editor;", "virtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterShutdownNotebookAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterShutdownNotebookAction.kt\ncom/intellij/jupyter/core/jupyter/connections/action/JupyterShutdownNotebookActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1863#2,2:82\n1863#2,2:84\n*S KotlinDebug\n*F\n+ 1 JupyterShutdownNotebookAction.kt\ncom/intellij/jupyter/core/jupyter/connections/action/JupyterShutdownNotebookActionKt\n*L\n68#1:82,2\n74#1:84,2\n*E\n"})
public final class JupyterShutdownNotebookActionKt {
    private static final void shutdownNotebook(KClass<?> actionClass, AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor(e);
        Object[] objectArray = JupyterAnActionEventExtensionsKt.getVirtualFiles(e);
        List list = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List virtualFiles = list;
        JupyterShutdownNotebookActionKt.shutdownNotebook(actionClass, project, CollectionsKt.listOfNotNull((Object)editor), virtualFiles);
    }

    public static final void shutdownNotebook(@NotNull KClass<?> classForLogging, @Nullable Project project, @NotNull List<? extends Editor> editors, @NotNull List<? extends VirtualFile> virtualFiles) {
        Intrinsics.checkNotNullParameter(classForLogging, (String)"classForLogging");
        Intrinsics.checkNotNullParameter(editors, (String)"editors");
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        if (project == null) {
            return;
        }
        Iterable $this$forEach$iv = editors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            JupyterShutdownNotebookActionKt.shutdownNotebook$clearOnPooledThread(classForLogging, (Function0<String>)((Function0)() -> JupyterShutdownNotebookActionKt.shutdownNotebook$lambda$3$lambda$1(editor)), (Function0<Unit>)((Function0)() -> JupyterShutdownNotebookActionKt.shutdownNotebook$lambda$3$lambda$2(project, editor)));
        }
        $this$forEach$iv = virtualFiles;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile virtualFile2 = (VirtualFile)element$iv;
            boolean bl = false;
            JupyterShutdownNotebookActionKt.shutdownNotebook$clearOnPooledThread(classForLogging, (Function0<String>)((Function0)() -> JupyterShutdownNotebookActionKt.shutdownNotebook$lambda$6$lambda$4(virtualFile2)), (Function0<Unit>)((Function0)() -> JupyterShutdownNotebookActionKt.shutdownNotebook$lambda$6$lambda$5(project, virtualFile2)));
        }
    }

    private static final void shutdownNotebook$clearOnPooledThread$lambda$0(Function0 $body, KClass $classForLogging, Function0 $notebookNameProvider) {
        try {
            $body.invoke();
        }
        catch (Exception e) {
            Logger.getInstance((Class)JvmClassMappingKt.getJavaClass((KClass)$classForLogging)).warn("Failed to shutdown Jupyter notebook " + $notebookNameProvider.invoke(), (Throwable)e);
        }
    }

    private static final void shutdownNotebook$clearOnPooledThread(KClass<?> $classForLogging, Function0<String> notebookNameProvider, Function0<Unit> body) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> JupyterShutdownNotebookActionKt.shutdownNotebook$clearOnPooledThread$lambda$0(body, $classForLogging, notebookNameProvider));
    }

    private static final String shutdownNotebook$lambda$3$lambda$1(Editor $editor) {
        String string = $editor.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit shutdownNotebook$lambda$3$lambda$2(Project $project, Editor $editor) {
        JupyterRuntimeService.Companion.getInstance($project).clearRuntime($editor);
        return Unit.INSTANCE;
    }

    private static final String shutdownNotebook$lambda$6$lambda$4(VirtualFile $virtualFile) {
        String string = $virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit shutdownNotebook$lambda$6$lambda$5(Project $project, VirtualFile $virtualFile) {
        JupyterRuntimeService.Companion.getInstance($project).clearRuntime($virtualFile);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$shutdownNotebook(KClass actionClass, AnActionEvent e) {
        JupyterShutdownNotebookActionKt.shutdownNotebook(actionClass, e);
    }
}

