/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown.latex;

import com.intellij.jupyter.core.jupyter.editor.markdown.latex.TexLexerToolsKt;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int INSIDE_SINGLE = 2;
    public static final int INSIDE_MULTIPLE = 4;
    public static final int INSIDE_ENV = 6;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
    static final char[] ZZ_CMAP_Z = TexLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0002\t\u0001\n\u0001\u000b\u0006\f\u0001\r\u0013\f\u0001\u000e\u0001\f\u0001\u000f\u0001\u0010\n\f\u0001\u0011\b\t\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0002\t\u0001\f\u0001\u001e\u0003\t\u0001\u001f\b\t\u0001 \u0001!\u0005\f\u0001\"\u0001#\t\t\u0001$\u0002\t\u0001%\u0005\t\u0001&\u0004\t\u0001'\u0001(\u0004\t)\f\u0001)\u0003\f\u0001*\u0001+\u0004\f\u0001,\n\t\u0001-\u0381\t");
    static final char[] ZZ_CMAP_Y = TexLexer.zzUnpackCMap("\u0002\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0002\u0000\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\t\u0001\n\u001c\t\u0001\u000b\u0001\f\u0001\r\b\u0000\u0001\u000e\u0001\u000f\u0001\t\u0001\u0010\u0004\t\u0001\u0011\b\t\u0001\u0012\n\t\u0001\u0013\u0001\t\u0001\u0014\u0001\u0013\u0001\t\u0001\u0015\u0004\u0000\u0001\t\u0001\u0016\u0001\u0017\u0002\u0000\u0002\t\u0001\u0016\u0001\u0000\u0001\u0018\u0001\u0013\u0005\t\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u0000\u0001\u001c\u0001\t\u0001\u0000\u0001\u001d\u0005\t\u0001\u001e\u0001\u001f\u0001 \u0001\t\u0001\u0016\u0001!\u0001\t\u0001\"\u0001#\u0001\u0000\u0001\t\u0001$\u0004\u0000\u0001\t\u0001%\u0004\u0000\u0001&\u0002\t\u0001'\u0001\u0000\u0001(\u0001\f\u0001\u0013\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0002\f\u0001/\u0001*\u0001+\u00010\u0001\u0000\u00011\u0001\u0000\u00012\u00013\u0001\u0010\u0001+\u00014\u0001\u0000\u00015\u0001\f\u00016\u00017\u0001*\u0001+\u00014\u0001\u0000\u0001.\u0001\f\u0001\u001f\u00018\u00019\u0001:\u0001;\u0001\u0000\u00015\u0002\u0000\u0001<\u0001\u001c\u0001+\u0001'\u0001\u0000\u0001=\u0001\f\u0001\u0000\u0001>\u0001\u001c\u0001+\u0001?\u0001\u0000\u0001-\u0001\f\u0001@\u0001<\u0001\u001c\u0001\t\u0001A\u0001-\u0001B\u0001\f\u0001 \u0001C\u0001D\u0001\t\u0001E\u0001F\u0003\u0000\u0001\u0013\u0002\t\u0001G\u0001F\u0003\u0000\u0001H\u0001I\u0001J\u0001K\u0001L\u0001M\u0002\u0000\u00015\u0003\u0000\u0001N\u0001\t\u0001O\u0001\u0000\u0001P\u0007\u0000\u0002\t\u0001\u0016\u0001Q\u0001\u0000\u0001R\u0001S\u0001T\u0001U\u0001\u0000\u0002\t\u0001V\u0002\t\u0001W\u0014\t\u0001X\u0001Y\u0002\t\u0001X\u0002\t\u0001Z\u0001[\u0001\n\u0003\t\u0001[\u0003\t\u0001\u0016\u0002\u0000\u0001\t\u0001\u0000\u0005\t\u0001\\\u0001\u0013%\t\u0001]\u0001\t\u0001\u0013\u0001\u0016\u0004\t\u0001\u0016\u0001^\u0001_\u0001\f\u0001\t\u0001\f\u0001\t\u0001\f\u0001_\u00015\u0003\t\u0001`\u0001\u0000\u0001a\u0004\u0000\u0005\t\u0001\u0015\u0001b\u0001\t\u0001c\u0004\t\u0001\u001e\u0001\t\u0001d\u0003\u0000\u0001\t\u0001e\u0001f\u0002\t\u0001g\u0001\t\u0001;\u0003\u0000\u0001\t\u0001F\u0003\t\u0001f\u0004\u0000\u0001h\u0005\u0000\u0001C\u0002\t\u0001`\u0001i\u0003\u0000\u0001j\u0001\t\u0001k\u0001 \u0002\t\u0001\u001e\u0001\u0000\u0002\t\u0001`\u0001\u0000\u0001\u001d\u0001 \u0001\t\u0001e\u0001$\u0005\u0000\u0001l\u0001m\f\t\u0004\u0000\u0011\t\u0001\\\u0002\t\u0001\\\u0001n\u0001\t\u0001e\u0003\t\u0001o\u0001p\u0001q\u0001O\u0001p\u0007\u0000\u0001r\u0001\u0000\u0001O\u0006\u0000\u0001s\u0001t\u0001u\u0001v\u0001w\u0003\u0000\u0001xg\u0000\u0002\t\u0001d\u0002\t\u0001d\b\t\u0001y\u0001z\u0002\t\u0001V\u0003\t\u0001{\u0001\u0000\u0001\t\u0001F\u0004|\u0004\u0000\u0001Q\u001d\u0000\u0001}\u0002\u0000\u0001~\u0001\u0013\u0004\t\u0001\u007f\u0001\u0013\u0004\t\u0001W\u0001C\u0001\t\u0001e\u0001\u0013\u0004\t\u0001d\u0001\u0000\u0001\t\u0001\u0016\u0003\u0000\u0001\t \u0000[\t\u0001\u001e\u0004\u0000]\t\u0001\u001e\u0002\u0000\b\t\u0001O\u0004\u0000\u0002\t\u0001e\u0010\t\u0001O\u0001\t\u0001\u0080\u0001\u0000\u0002\t\u0001d\u0001Q\u0001\t\u0001e\u0004\t\u0001\u001e\u0002\u0000\u0001\u0081\u0001\u0082\u0005\t\u0001\u0083\u0001\t\u0001d\u0001\u0015\u0003\u0000\u0001\u0081\u0001\u0084\u0001\t\u0001\u0017\u0001\u0000\u0003\t\u0001`\u0001\u0082\u0002\t\u0001`\u0003\u0000\u0001\u0085\u0001 \u0001\t\u0001\u001e\u0001\t\u0001F\u0001\u0000\u0001\t\u0001O\u0001&\u0002\t\u0001\u0017\u0001Q\u0001\u0000\u0001\u0086\u0001\u0087\u0002\t\u0001$\u0001\u0000\u0001\u0088\u0001\u0000\u0001\t\u0001\u0089\u0003\t\u0001\u008a\u0001\u008b\u0001\u008c\u0001\u0016\u00012\u0001\u008d\u0001\u008e\u0001|\u0002\t\u0001W\u0001\u001e\u0007\t\u0001\u0017\u0001\u0000:\t\u0001`\u0001\t\u0001\u008f\u0002\t\u0001g\u0010\u0000\u0016\t\u0001e\u0006\t\u0001;\u0002\u0000\u0001F\u0001\u0090\u0001+\u0001\u0091\u0001\u0092\u0006\t\u0001\f\u0001\u0000\u0001j\u0015\t\u0001e\u0001\u0000\u0004\t\u0001\u0082\u0002\t\u0001\u0015\u0002\u0000\u0001g\u0007\u0000\u0001\u0086\u0007\t\u0001O\u0002\u0000\u0001\u0013\u0001\u0016\u0001\u0013\u0001\u0016\u0001\u0093\u0004\t\u0001d\u0001\u0094\u0001\u0095\u0002\u0000\u0001\u0096\u0001\t\u0001\n\u0001\u0097\u0002e\u0002\u0000\u0007\t\u0001\u0016\u0018\u0000\u0001\t\u0001O\u0003\t\u00015\u0002\u0000\u0002\t\u0001\u0000\u0001\t\u0001\u0098\u0002\t\u0001\u001e\u0001\t\u0001e\u0002\t\u0001\u0099\u0003\u0000\t\t\u0001e\u0001\u0000\u0002\t\u0001\u0099\u0001\t\u0001g\u0002\t\u0001\u0015\u0003\t\u0001`\t\u0000\u0013\t\u0001F\u0001\t\u0001\u001e\u0001\u0015\t\u0000\u0001\u009a\u0002\t\u0001\u009b\u0001\t\u0001\u001e\u0001\t\u0001F\u0001\t\u0001d\u0004\u0000\u0001\t\u0001\u009c\u0001\t\u0001\u001e\u0001\t\u0001;\u0004\u0000\u0003\t\u0001\u009d\u0004\u0000\u00015\u0001\u009e\u0001\t\u0001`\u0002\u0000\u0001\t\u0001O\u0001\t\u0001O\u0002\u0000\u0001N\u0001\t\u0001f\u0001\u0000\u0003\t\u0001\u001e\u0001\t\u0001\u001e\u0001\t\u0001\u0017\u0001\t\u0001\f\u0006\u0000\u0004\t\u0001$\u0003\u0000\u0003\t\u0001\u0017\u0003\t\u0001\u00170\u0000\u0001j\u0002\t\u0001\u0015\u0004\u0000\u0001j\u0002\t\u0002\u0000\u0001\t\u0001$\u0001\u0000\u0001j\u0001\t\u0001F\u0002\u0000\u0002\t\u0001\u009f\u0001j\u0002\t\u0001\u0017\u0001\u00a0\u0001\u00a1\u0002\u0000\u0001\t\u0001\u0010\u0001g\u0005\u0000\u0001\u00a2\u0001\u00a3\u0001$\u0002\t\u0001d\u0002\u0000\u00017\u0001*\u0001+\u00014\u0001\u0000\u0001\u00a4\u0001\f\t\u0000\u0003\t\u0001f\u0001\u00a5\u0003\u0000\u0003\t\u0001\u0000\u0001\u00a6\u000b\u0000\u0002\t\u0001d\u0002\u0000\u0001\u00a7\u0002\u0000\u0003\t\u0001\u0000\u0001\u00a8\u0003\u0000\u0002\t\u0001\u0016\u0005\u0000\u0001\t\u0001;\u0018\u0000\u0004\t\u0001\u0000\u0001Q\u001c\u0000\u0003\t\u0001$\u0010\u0000\u0001+\u0001\t\u0001d\u0001\u0000\u00015\u0002\u0000\u0001\u0082\u0001\t7\u00009\t\u0001;\u000e\u0000\f\t\u0001`+\u0000\u0002\t\u0001d=\u0000$\t\u0001F\u001b\u0000#\t\u0001$\u0001\t\u0001d\u0007\u0000\u0001\t\u0001e\u0001\u0000\u0003\t\u0001\u0000\u0001`\u0001\u0000\u0001j\u0001\u00a9\u0001\t7\u0000\u0004\t\u0001f\u00015\u0003\u0000\u0001j\u0004\u0000\u00015\u0001\u0000>\t\u0001O\u0001\u0000/\t\u0001\u0017\u0010\u0000\u0001\f?\u0000\u0006\t\u0001\u0016\u0001O\u0001$\u0001;6\u0000\u0005\t\u0001\u0086\u0003\t\u0001_\u0001\u00aa\u0001\u00ab\u0001\u00ac\u0003\t\u0001\u00ad\u0001\u00ae\u0001\t\u0001\u00af\u0001\u00b0\u0001\u001c\u0014\t\u0001\u00b1\u0001\t\u0001\u001c\u0001W\u0001\t\u0001W\u0001\t\u0001\u0086\u0001\t\u0001\u0086\u0001d\u0001\t\u0001d\u0001\t\u0001+\u0001\t\u0001+\u0001\t\u0001\u0088\u0003\u0000\f\t\u0001f\u0003\u0000\u0004\t\u0001`K\u0000\u0001\u00ac\u0001\t\u0001\u00b2\u0001\u00b3\u0001\u00b4\u0001\u00b5\u0001\u00b6\u0001\u00b7\u0001\u00b8\u0001g\u0001\u00b9\u0001g\u0014\u0000-\t\u0001F\u0002\u0000C\t\u0001f\r\t\u0001eh\t\u0001\f\u0015\u0000!\t\u0001e\u001e\u0000");
    static final char[] ZZ_CMAP_A = TexLexer.zzUnpackCMap("\u0014\u0000\u0001\u0001\u0005\u0000\u0001\t\u0005\u0000\n\t\u0007\u0000\u001a\r\u0001\u0000\u0001\u0002\u0004\u0000\u0001\r\u0001\u0003\u0001\r\u0001\u000b\u0001\u0004\u0001\r\u0001\u0005\u0001\r\u0001\u0006\u0004\r\u0001\u0007\f\r\u0001\b\u0001\u0000\u0001\n\f\u0000\u0001\f\n\u0000\u0001\f\u0004\u0000\u0001\f\u0005\u0000\u0017\f\u0001\u0000\n\f\u0004\u0000\f\f\u000e\u0000\u0005\f\u0007\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0005\f\u0001\u0000\u0002\f\u0002\u0000\u0004\f\u0001\u0000\u0001\f\u0006\u0000\u0001\f\u0001\u0000\u0003\f\u0001\u0000\u0001\f\u0001\u0000\u0004\f\u0001\u0000\u0013\f\u0001\u0000\u000b\f\b\u0000\u0006\f\u0001\u0000\u0016\f\u0002\u0000\u0001\f\u0006\u0000\b\f\b\u0000\u000b\f\u0005\u0000\u0003\f\u001b\u0000\u0006\f\u0001\u0000\u0001\f\u000f\u0000\u0002\f\u0007\u0000\u0002\f\n\u0000\u0003\f\u0002\u0000\u0002\f\u0001\u0000\u000e\f\r\u0000\t\f\u000b\u0000\u0001\f\u0018\u0000\u0006\f\u0004\u0000\u0002\f\u0004\u0000\u0001\f\u0005\u0000\u0006\f\u0004\u0000\u0001\f\t\u0000\u0001\f\u0003\u0000\u0001\f\u0007\u0000\t\f\u0007\u0000\u0005\f\u0001\u0000\b\f\u0006\u0000\u0016\f\u0003\u0000\u0001\f\u0002\u0000\u0001\f\u0007\u0000\t\f\u0004\u0000\b\f\u0002\u0000\u0002\f\u0002\u0000\u0016\f\u0001\u0000\u0007\f\u0001\u0000\u0001\f\u0003\u0000\u0004\f\u0003\u0000\u0001\f\u0010\u0000\u0001\f\r\u0000\u0002\f\u0001\u0000\u0001\f\u0005\u0000\u0006\f\u0004\u0000\u0002\f\u0001\u0000\u0002\f\u0001\u0000\u0002\f\u0001\u0000\u0002\f\u000f\u0000\u0004\f\u0001\u0000\u0001\f\u0003\u0000\u0003\f\u0010\u0000\t\f\u0001\u0000\u0002\f\u0001\u0000\u0002\f\u0001\u0000\u0005\f\u0003\u0000\u0001\f\u0002\u0000\u0001\f\u0018\u0000\u0001\f\u000b\u0000\b\f\u0002\u0000\u0001\f\u0003\u0000\u0001\f\u0001\u0000\u0006\f\u0003\u0000\u0003\f\u0001\u0000\u0004\f\u0003\u0000\u0002\f\u0001\u0000\u0001\f\u0001\u0000\u0002\f\u0003\u0000\u0002\f\u0003\u0000\u0003\f\u0003\u0000\f\f\u000b\u0000\b\f\u0001\u0000\u0002\f\b\u0000\u0003\f\u0005\u0000\u0001\f\u0004\u0000\b\f\u0001\u0000\u0006\f\u0001\u0000\u0005\f\u0003\u0000\u0001\f\u0003\u0000\u0002\f\r\u0000\u000b\f\u0002\u0000\u0001\f\u0006\u0000\u0003\f\b\u0000\u0001\f\u0005\u0000\u0012\f\u0003\u0000\b\f\u0001\u0000\t\f\u0001\u0000\u0001\f\u0002\u0000\u0007\f\t\u0000\u0001\f\u0001\u0000\u0002\f\r\u0000\u0002\f\u0001\u0000\u0001\f\u0002\u0000\u0002\f\u0001\u0000\u0001\f\u0002\u0000\u0001\f\u0006\u0000\u0004\f\u0001\u0000\u0007\f\u0001\u0000\u0003\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0002\u0000\u0002\f\u0001\u0000\u0004\f\u0001\u0000\u0002\f\t\u0000\u0001\f\u0002\u0000\u0005\f\u0001\u0000\u0001\f\u0015\u0000\f\f\u0001\u0000\u0014\f\u000b\u0000\u0005\f\u0012\u0000\u0007\f\u0004\u0000\u0004\f\u0003\u0000\u0001\f\u0003\u0000\u0002\f\u0007\u0000\u0003\f\u0004\u0000\r\f\f\u0000\u0001\f\u0001\u0000\u0006\f\u0001\u0000\u0001\f\u0005\u0000\u0001\f\u0002\u0000\u000b\f\u0001\u0000\r\f\u0001\u0000\u0004\f\u0002\u0000\u0007\f\u0001\u0000\u0001\f\u0001\u0000\u0004\f\u0002\u0000\u0001\f\u0001\u0000\u0004\f\u0002\u0000\u0007\f\u0001\u0000\u0001\f\u0001\u0000\u0004\f\u0002\u0000\u000e\f\u0002\u0000\u0006\f\u0002\u0000\r\f\u0002\u0000\u0001\f\u0001\u0000\b\f\u0007\u0000\r\f\u0001\u0000\u0006\f\u0013\u0000\u0001\f\u0004\u0000\u0001\f\u0003\u0000\u0005\f\u0002\u0000\u0012\f\u0001\u0000\u0001\f\u0005\u0000\u000f\f\u0001\u0000\u000e\f\u0002\u0000\u0005\f\u000b\u0000\f\f\u000b\u0000\u0001\f\r\u0000\u0007\f\u0007\u0000\u000e\f\r\u0000\u0002\f\t\u0000\u0004\f\u0001\u0000\u0004\f\u0003\u0000\u0002\f\t\u0000\b\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0006\f\u0001\u0000\u0007\f\u0001\u0000\u0001\f\u0003\u0000\u0003\f\u0001\u0000\u0007\f\u0003\u0000\u0004\f\u0002\u0000\u0006\f\u0005\u0000\u0001\f\r\u0000\u0001\f\u0002\u0000\u0001\f\u0004\u0000\u0001\f\u0002\u0000\n\f\u0001\u0000\u0001\f\u0003\u0000\u0005\f\u0006\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0004\f\u0001\u0000\u000b\f\u0002\u0000\u0004\f\u0005\u0000\u0005\f\u0004\u0000\u0001\f\u0004\u0000\u0002\f\u000b\u0000\u0005\f\u0006\u0000\u0004\f\u0003\u0000\u0002\f\f\u0000\b\f\u0007\u0000\b\f\u0001\u0000\u0007\f\u0006\u0000\u0002\f\n\u0000\u0005\f\u0005\u0000\u0002\f\u0003\u0000\u0007\f\u0006\u0000\u0003\f\n\u0000\u0002\f\u000b\u0000\t\f\u0002\u0000\u0017\f\u0002\u0000\u0007\f\u0001\u0000\u0003\f\u0001\u0000\u0004\f\u0001\u0000\u0004\f\u0002\u0000\u0006\f\u0003\u0000\u0001\f\u0001\u0000\u0001\f\u0002\u0000\u0005\f\u0001\u0000\n\f\n\u0000\u0005\f\u0001\u0000\u0003\f\u0001\u0000\b\f\u0004\u0000\u0007\f\u0003\u0000\u0001\f\u0003\u0000\u0002\f\u0001\u0000\u0001\f\u0003\u0000\u0002\f\u0002\u0000\u0005\f\u0002\u0000\u0001\f\u0001\u0000\u0001\f\u0018\u0000\u0003\f\u0003\u0000\u0006\f\u0002\u0000\u0006\f\u0002\u0000\u0006\f\t\u0000\u0007\f\u0004\u0000\u0005\f\u0003\u0000\u0005\f\u0005\u0000\u0001\f\u0001\u0000\b\f\u0001\u0000\u0005\f\u0001\u0000\u0001\f\u0001\u0000\u0002\f\u0001\u0000\u0002\f\u0001\u0000\n\f\u0006\u0000\n\f\u0002\u0000\u0006\f\u0002\u0000\u0006\f\u0002\u0000\u0006\f\u0002\u0000\u0003\f\u0003\u0000\f\f\u0001\u0000\u000e\f\u0001\u0000\u0002\f\u0001\u0000\u0002\f\u0001\u0000\b\f\u0006\u0000\u0004\f\u0004\u0000\u000e\f\u0002\u0000\u0001\f\u0001\u0000\f\f\u0001\u0000\u0002\f\u0003\u0000\u0001\f\u0002\u0000\u0004\f\u0001\u0000\u0002\f\n\u0000\b\f\u0006\u0000\u0006\f\u0001\u0000\u0003\f\u0001\u0000\n\f\u0003\u0000\u0001\f\n\u0000\u0004\f\u0015\u0000\u0001\f\u0001\u0000\u0001\f\u0003\u0000\u0007\f\u0001\u0000\u0001\f\u0001\u0000\u0004\f\u0001\u0000\u000f\f\u0001\u0000\u0002\f\f\u0000\u0003\f\u0007\u0000\u0004\f\t\u0000\u0002\f\u0001\u0000\u0001\f\u0010\u0000\u0004\f\b\u0000\u0001\f\u000b\u0000\b\f\u0005\u0000\u0003\f\u0002\u0000\u0001\f\u0002\u0000\u0002\f\u0002\u0000\u0004\f\u0001\u0000\f\f\u0001\u0000\u0001\f\u0001\u0000\u0007\f\u0001\u0000\u0011\f\u0001\u0000\u0004\f\u0002\u0000\b\f\u0001\u0000\u0007\f\u0001\u0000\f\f\u0001\u0000\u0004\f\u0001\u0000\u0005\f\u0001\u0000\u0001\f\u0003\u0000\f\f\u0002\u0000\b\f\u0001\u0000\u0002\f\u0001\u0000\u0001\f\u0002\u0000\u0001\f\u0001\u0000\n\f\u0001\u0000\u0004\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0006\u0000\u0001\f\u0004\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0003\f\u0001\u0000\u0002\f\u0001\u0000\u0001\f\u0002\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0002\f\u0001\u0000\u0001\f\u0002\u0000\u0004\f\u0001\u0000\u0007\f\u0001\u0000\u0004\f\u0001\u0000\u0004\f\u0001\u0000\u0001\f\u0001\u0000\n\f\u0001\u0000\u0005\f\u0001\u0000\u0003\f\u0001\u0000\u0005\f\u0001\u0000\u0005\f");
    private static final int[] ZZ_ACTION = TexLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0004\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0001\u0003\u0001\u0004\u0003\u0003\u0001\u0005\u0001\u0000\u0004\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0003\u0000\u0001\u0006\u0004\u0000\u0001\u0007\u0001\b\u0002\u0000\u0001\t\u0001\n";
    private static final int[] ZZ_ROWMAP = TexLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u000e\u0000\u001c\u0000*\u00008\u0000F\u0000T\u00008\u00008\u0000b\u0000p\u0000~\u00008\u0000\u008c\u0000\u009a\u0000\u00a8\u0000\u00b6\u0000\u00c4\u0000\u00d2\u0000\u00e0\u0000\u00ee\u0000\u00fc\u0000\u010a\u0000\u0118\u0000\u0126\u0000\u0134\u0000\u0142\u0000\u0150\u0000\u015e\u0000\u016c\u0000\u017a\u0000\u0188\u0000\u0196\u0000\u01a4\u0000\u01b2\u0000\u01c0\u00008\u00008\u0000\u01ce\u0000\u01dc\u00008\u00008";
    private static final int[] ZZ_TRANS = TexLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0005\u0001\u0006\u0001\u0007\u000b\u0005\u0001\b\u0001\t\u0001\n\f\b\u0001\u000b\u0001\n\r\b\u0001\f\u000b\b\u000f\u0000\u0001\r\u000f\u0000\u0001\u000e\r\u0000\u0001\u000f\u0001\u0010\u0003\u0011\u0003\u0000\u0003\u0011\u0001\u0000\u0001\t\u000f\u0000\u0001\u000f\u0001\u0012\u0003\u0011\u0003\u0000\u0003\u0011\u0004\u0000\u0001\u0013\f\u0000\u0001\u0011\u0001\u0014\u0003\u0011\u0003\u0000\u0003\u0011\u0003\u0000\u0004\u0011\u0001\u0015\u0003\u0000\u0003\u0011\u0003\u0000\u0005\u0011\u0003\u0000\u0003\u0011\u0003\u0000\u0004\u0011\u0001\u0016\u0003\u0000\u0003\u0011\u0005\u0000\u0001\u0017\u000b\u0000\u0002\u0011\u0001\u0018\u0002\u0011\u0003\u0000\u0003\u0011\u0003\u0000\u0005\u0011\u0003\u0000\u0001\u0019\u0002\u0011\u0003\u0000\u0005\u0011\u0003\u0000\u0001\u001a\u0002\u0011\u0006\u0000\u0001\u001b\n\u0000\u0003\u0011\u0001\u001c\u0001\u0011\u0003\u0000\u0003\u0011\u0003\u0000\u0005\u0011\u0001\u001d\u0002\u0000\u0003\u0011\u0003\u0000\u0005\u0011\u0001\u001e\u0002\u0000\u0003\u0011\u0007\u0000\u0001\u001f\t\u0000\u0004\u0011\u0001 \u0003\u0000\u0003\u0011\u0003\u0000\u0005!\u0001\u0000\u0001!\u0001\u0000\u0001!\u0001\u0000\u0001!\u0003\u0000\u0005\"\u0001\u0000\u0001\"\u0001\u0000\u0001\"\u0001\u0000\u0001\"\b\u0000\u0001#\b\u0000\u0005\u0011\u0001$\u0002\u0000\u0003\u0011\u0003\u0000\u0005!\u0001\u0000\u0001!\u0001%\u0001!\u0001\u0000\u0001!\u0003\u0000\u0005\"\u0001\u0000\u0001\"\u0001&\u0001\"\u0001\u0000\u0001\"\u0003\u0000\u0005'\u0001\u0000\u0001'\u0001\u0000\u0001'\u0001\u0000\u0001'\u0003\u0000\u0005(\u0001\u0000\u0001(\u0001\u0000\u0001(\u0001\u0000\u0001(\u0003\u0000\u0005'\u0001\u0000\u0001'\u0001)\u0001'\u0001\u0000\u0001'\u0003\u0000\u0005(\u0001\u0000\u0001(\u0001*\u0001(\u0001\u0000\u0001(";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = TexLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0004\u0000\u0001\t\u0002\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0000\u0004\u0001\u0001\u0000\u0003\u0001\u0001\u0000\u0003\u0001\u0001\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0004\u0000\u0002\t\u0002\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState;
    private CharSequence zzBuffer;
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    int yychar;
    private CharSequence myEnvName;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 10] << 6 | ch >> 4 & 0x3F] << 4 | ch & 0xF];
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[42];
        int offset = 0;
        offset = TexLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[42];
        int offset = 0;
        offset = TexLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[490];
        int offset = 0;
        offset = TexLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[42];
        int offset = 0;
        offset = TexLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    TexLexer(@NotNull String text) {
        if (text == null) {
            TexLexer.$$$reportNull$$$0(0);
        }
        this((Reader)null);
        this.reset(text, 0, text.length(), 0);
    }

    public TexLexer(Reader in) {
        this.zzLexicalState = 0;
        this.zzBuffer = "";
        this.zzAtBOL = true;
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start2, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start2;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public TexType yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block22: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + TexLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return TexType.PLAIN_CHAR;
                }
                case 11: {
                    continue block22;
                }
                case 2: {
                    this.yybegin(2);
                    return TexType.OPEN_INLINE_TEX;
                }
                case 12: {
                    continue block22;
                }
                case 3: {
                    return TexType.TEX_CHAR;
                }
                case 13: {
                    continue block22;
                }
                case 4: {
                    this.yybegin(0);
                    return TexType.CLOSE_TEX;
                }
                case 14: {
                    continue block22;
                }
                case 5: {
                    this.yybegin(4);
                    return TexType.OPEN_BLOCK_TEX;
                }
                case 15: {
                    continue block22;
                }
                case 6: {
                    return TexType.TEX_ESCAPED_KEY;
                }
                case 16: {
                    continue block22;
                }
                case 7: {
                    return TexType.TEX_CLOSE_SUB_ENV;
                }
                case 17: {
                    continue block22;
                }
                case 8: {
                    if (!Objects.equals(TexLexerToolsKt.getEnvName(this.yytext(), false), this.myEnvName)) {
                        return TexType.TEX_CLOSE_SUB_ENV;
                    }
                    this.yybegin(0);
                    return TexType.CLOSE_TEX;
                }
                case 18: {
                    continue block22;
                }
                case 9: {
                    this.yybegin(6);
                    this.myEnvName = TexLexerToolsKt.getEnvName(this.yytext(), true);
                    return TexType.OPEN_BLOCK_TEX;
                }
                case 19: {
                    continue block22;
                }
                case 10: {
                    return TexType.TEX_OPEN_SUB_ENV;
                }
                case 20: {
                    continue block22;
                }
            }
            this.zzScanError(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/jupyter/core/jupyter/editor/markdown/latex/TexLexer", "<init>"));
    }

    static enum TexType {
        OPEN_INLINE_TEX,
        OPEN_BLOCK_TEX,
        CLOSE_TEX,
        TEX_CHAR,
        PLAIN_CHAR,
        TEX_ESCAPED_KEY,
        TEX_OPEN_SUB_ENV,
        TEX_CLOSE_SUB_ENV;

    }
}

