/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.shared;

import com.charliemouse.cambozola.shared.ExceptionReporter;
import com.charliemouse.cambozola.shared.ImageChangeEvent;
import com.charliemouse.cambozola.shared.ImageChangeListener;
import com.charliemouse.cambozola.shared.StreamSplit;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CamStream
extends Thread {
    public static final int CONNECT_STYLE_SOCKET = 1;
    public static final int CONNECT_STYLE_HTTP = 2;
    private static final int IMG_FLUFF_FACTOR = 1;
    private ExceptionReporter m_reporter = null;
    private Vector m_listeners;
    private Object m_lock = new Object();
    private Image m_imain = null;
    private Toolkit m_tk = Toolkit.getDefaultToolkit();
    private URL m_stream;
    private URL m_docBase;
    private DataInputStream m_inputStream = null;
    private boolean m_isDefunct = false;
    private boolean m_collecting = false;
    private byte[] m_rawImage;
    private String m_imageType = "image/jpeg";
    private long m_startTime = 0L;
    private int m_imgidx = 0;
    private int m_retryCount = 1;
    private int m_retryDelay = 1000;
    private String m_appName = "";
    private boolean m_debug = false;
    private int m_connectionMethod = 2;

    public CamStream(URL uRL, String string, URL uRL2, int n, int n2, ExceptionReporter exceptionReporter, boolean bl) {
        this.m_listeners = new Vector();
        this.m_stream = uRL;
        this.m_appName = string;
        this.m_reporter = exceptionReporter;
        this.m_isDefunct = false;
        this.m_docBase = uRL2;
        this.m_retryCount = n;
        this.m_retryDelay = n2;
        this.m_debug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getCurrent() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_imain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRawImage() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_rawImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_imgidx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_imageType;
        }
    }

    public URL getStreamURL() {
        return this.m_stream;
    }

    public double getFPS() {
        if (this.m_startTime == 0L) {
            return 0.0;
        }
        long l = System.currentTimeMillis();
        return 1000.0 * (double)(this.m_imgidx - 1) / (double)(l - this.m_startTime);
    }

    public void addImageChangeListener(ImageChangeListener imageChangeListener) {
        this.m_listeners.addElement(imageChangeListener);
    }

    public void removeImageChangeListener(ImageChangeListener imageChangeListener) {
        this.m_listeners.removeElement(imageChangeListener);
    }

    private void fireImageChange() {
        if (this.m_debug) {
            System.err.println("// " + System.currentTimeMillis() + " - Notification of image update sent");
        }
        ImageChangeEvent imageChangeEvent = new ImageChangeEvent(this);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ImageChangeListener)enumeration.nextElement()).imageChanged(imageChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamSplit streamSplit = null;
        try {
            CharSequence charSequence;
            Enumeration enumeration;
            Object object;
            int n;
            String string = null;
            String string2 = null;
            String string3 = null;
            Hashtable hashtable = null;
            int n2 = 0;
            int n3 = this.m_retryCount;
            int n4 = this.m_retryDelay;
            do {
                ++n2;
                if (this.m_debug) {
                    System.err.println("// Connection type = " + this.m_connectionMethod + ", URL = " + this.m_stream);
                }
                if (this.m_connectionMethod == 1) {
                    n = this.m_stream.getPort();
                    object = new Socket(this.m_stream.getHost(), n);
                    enumeration = new DataOutputStream(((Socket)object).getOutputStream());
                    this.m_inputStream = new DataInputStream(new BufferedInputStream(((Socket)object).getInputStream()));
                    charSequence = new StringBuffer();
                    charSequence.append("GET " + this.m_stream.getFile() + " HTTP/1.0\r\n");
                    if (this.m_docBase != null) {
                        charSequence.append("Referer: " + this.m_docBase + "\r\n");
                    }
                    charSequence.append("User-Agent: " + this.m_appName + "\r\n");
                    if (string != null) {
                        charSequence.append("Authorization: Basic " + string + "\r\n");
                    }
                    charSequence.append("Host: " + this.m_stream.getHost() + "\r\n");
                    charSequence.append("\r\n");
                    ((DataOutputStream)((Object)enumeration)).writeBytes(charSequence.toString());
                    ((FilterOutputStream)((Object)enumeration)).close();
                    streamSplit = new StreamSplit(this.m_inputStream);
                    hashtable = streamSplit.readHeaders();
                } else {
                    URLConnection uRLConnection = this.m_stream.openConnection();
                    if (this.m_docBase != null) {
                        uRLConnection.setRequestProperty("Referer", this.m_docBase.toString());
                    }
                    uRLConnection.setRequestProperty("User-Agent", this.m_appName);
                    uRLConnection.setRequestProperty("Host", this.m_stream.getHost());
                    this.m_inputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
                    streamSplit = new StreamSplit(this.m_inputStream);
                    hashtable = streamSplit.readHeaders(uRLConnection);
                }
                if (this.m_debug) {
                    System.err.println("// Request sent; Main Response headers:");
                    Enumeration enumeration2 = hashtable.keys();
                    while (enumeration2.hasMoreElements()) {
                        object = (String)enumeration2.nextElement();
                        System.err.println("//   " + (String)object + " = " + hashtable.get(object));
                    }
                }
                this.m_collecting = true;
                string2 = null;
                string3 = (String)hashtable.get("content-type");
                if (string3 == null) {
                    string2 = "No main content type";
                } else if (string3.indexOf("text") != -1) {
                    String string4 = null;
                    while ((string4 = this.m_inputStream.readLine()) != null) {
                        System.out.println(string4);
                    }
                    string2 = "Failed to connect to server (denied?)";
                }
                if (string2 == null) break;
                if (this.m_isDefunct) {
                    return;
                }
                if (this.m_debug) {
                    System.err.println("// Waiting for " + n4 + " ms");
                }
                this.m_reporter.reportFailure(string2);
                Thread.sleep(n4);
            } while (n2 < n3);
            if (string2 != null) {
                return;
            }
            n = string3.indexOf("boundary=");
            object = "--";
            if (n != -1) {
                object = string3.substring(n + 9);
                string3 = string3.substring(0, n);
                if (!((String)object).startsWith("--")) {
                    object = "--" + (String)object;
                }
            }
            if (string3.startsWith("multipart/x-mixed-replace")) {
                if (this.m_debug) {
                    System.err.println("// Reading up to boundary");
                }
                streamSplit.skipToBoundary((String)object);
            }
            do {
                if (this.m_collecting) {
                    if (object != null) {
                        hashtable = streamSplit.readHeaders();
                        if (this.m_debug) {
                            System.err.println("// Chunk Headers recieved:");
                            enumeration = hashtable.keys();
                            while (enumeration.hasMoreElements()) {
                                charSequence = (String)enumeration.nextElement();
                                System.err.println("//   " + (String)charSequence + " = " + hashtable.get(charSequence));
                            }
                        }
                        if (streamSplit.isAtStreamEnd()) {
                            break;
                        }
                        string3 = (String)hashtable.get("content-type");
                        if (string3 == null) {
                            throw new Exception("No part content type");
                        }
                    }
                    if (string3.startsWith("multipart/x-mixed-replace")) {
                        n = string3.indexOf("boundary=");
                        object = string3.substring(n + 9);
                        if (this.m_debug) {
                            System.err.println("// Skipping to boundary");
                        }
                        streamSplit.skipToBoundary((String)object);
                    } else {
                        if (this.m_debug) {
                            System.err.println("// Reading to boundary");
                        }
                        if (((Enumeration<K>)(enumeration = (Enumeration)streamSplit.readToBoundary((String)object))).length == 0) {
                            break;
                        }
                        if (this.m_imgidx > 1 && this.m_startTime == 0L) {
                            this.m_startTime = System.currentTimeMillis();
                        }
                        this.updateImage(string3, (byte[])enumeration);
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.m_isDefunct);
        }
        catch (Exception exception) {
            if (!this.m_collecting) {
                this.m_reporter.reportFailure(exception.toString());
            } else if (!this.m_isDefunct) {
                this.m_reporter.reportError(exception);
            }
        }
        finally {
            this.unhook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage(String string, byte[] byArray) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_imageType = string;
            this.m_imain = this.m_tk.createImage(byArray);
            this.m_rawImage = byArray;
            ++this.m_imgidx;
            this.m_imain.getWidth(new ImageObserver(){

                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    boolean bl;
                    if (CamStream.this.m_debug) {
                        System.err.println("// Image Progress = " + n);
                    }
                    boolean bl2 = bl = (n & 0x24) != 0;
                    if (bl) {
                        CamStream.this.fireImageChange();
                    }
                    return !bl;
                }
            });
        }
    }

    public void finalize() {
        this.unhook();
    }

    public void unhook() {
        this.m_collecting = false;
        this.m_isDefunct = true;
        try {
            if (this.m_inputStream != null) {
                this.m_inputStream.close();
            }
            this.m_inputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

