#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "uostr.h"
#include "uoio.h"
#include "uogetopt.h"
#include "smtp.h"
#include "smtptools.h"
#include "maildirblast.h"
#include "attribs.h"
#include "dns.h"

extern void _exit P__((int)) UO_ATTRIB_NORET;

int logmsgfd=2;

char *myhostname=0;
uoio_t *reply_log_chan=NULL;

/* user changeable options */
const char *greeting=NULL; /* runqueue needs to know */
unsigned long smtpport=25;
unsigned long connect_timeout=90;
unsigned long read_timeout=1200;
unsigned long write_timeout=1200;
unsigned long max_bounce_lines=0;
static char *maildir;
const char *postmaster; /* runqueue needs to know */
const char *doublebounceto; /* runqueue needs to know */
const char *prefix; /* runqueue needs to know */
const char *relayhost=NULL;  /* runqueue needs to know */
static long reply_log_fd;
static const char *reply_log_file;

static struct uogetopt myopts[]={
	{'C',"connect-timeout", UOGO_ULONG,&connect_timeout,0, 
		"timeout for SMTP connect", "TIMEOUT"},
	{'d',"doublebounceto", UOGO_STRING,&doublebounceto,0, "bounced bounces to ...","ADDRESS"},
	{'e',"prefix", UOGO_STRING,&prefix,0, "prefix in maildir", "PREFIX"},
	{'g',"greeting", UOGO_STRING,&greeting,0, "name to use for HELO","MYHOSTNAME"},
	{'M',"max-bounce-lines", UOGO_ULONG,&max_bounce_lines,0, "queue maildir to send messages from","LIMIT"},
	{'m',"maildir", UOGO_STRING,&maildir,0, "queue maildir to send messages from","DIR"},
	{'P',"postmaster", UOGO_STRING,&postmaster,0, "address of the postmaster","ADDRESS"},
	{'p',"port", UOGO_ULONG,&smtpport,0, "TCP port of the SMTP server","PORT"},
	{'R',"read-timeout", UOGO_ULONG,&read_timeout,0, 
		"timeout for reading from remote", "TIMEOUT"},
	{'r',"relayhost", UOGO_STRING,&relayhost,0, 
		"host name of SMTP server to use\nmake sure you are allowed to use it!","RELAYHOST"},
	{  0,"reply-log-file", UOGO_STRING,&reply_log_file,0, "file to log SMTP replies into","SMTPLOGFILE"},
	{  0,"reply-log-fd", UOGO_LONG,&reply_log_fd,0, "file descriptor to log SMTP replies into","SMTPLOGFD"},
	{'W',"write-timeout", UOGO_ULONG,&write_timeout,0, 
		"timeout for writing to remote", "TIMEOUT"},
	{0,0}
};

static void exitmsguo P__((int exitcode,uostr_t *s)) UO_ATTRIB_NORET;
static void exitmsg0 P__((int exitcode,const char *s)) UO_ATTRIB_NORET;

static int 
translate_exitcode(int exitcode)
{
	switch(exitcode) {
	case SMTP_SUCCESS: return (0);
	case SMTP_DEFER: return (111);
	case SMTP_FATAL: return (100);
	default: return (111); /* should never arrive here */
	}
}

static void
exitmsguo(int exitcode,uostr_t *s)
{
	logmsguo(exitcode,s);
	_exit(translate_exitcode(exitcode));
}

static void
exitmsg0(int exitcode,const char *s)
{
	uostr_t us;
	union { const char *co; char *nco; } u;
	u.co=s;
	us.data=u.nco;
	us.len=strlen(s);
	exitmsguo(exitcode,&us);
}

int 
main(int argc, char **argv)
{
	char buf[128];
	const char *argv0;
	argv0=strrchr(argv[0],'/'); if (!argv0) argv0=argv[0];

	if (gethostname(buf,sizeof(buf)-1)==-1) {
		exitmsg0(1,"hostname too long"); /* unsuited for mail, anyway */
	} else {
		buf[sizeof(buf)-1]=0;
		myhostname=malloc(strlen(buf)+1);
		if (!myhostname) exitmsg0(1,"out of memory");
		memcpy(myhostname,buf,strlen(buf)+1);
	}
	greeting=myhostname;

	uogetopt("smtpblast",PACKAGE,VERSION,&argc,argv,uogetopt_out,0,myopts,0);

	if (reply_log_file || reply_log_fd) {
		struct stat st;
		if (reply_log_file) {
			reply_log_fd=open(reply_log_file,O_WRONLY|O_CREAT|O_APPEND,0600);
			if (reply_log_fd==-1) {
				logmsg5(SMTP_DEFER,argv0,": cannot open ",reply_log_file, ": ",strerror(errno));
				_exit(translate_exitcode(SMTP_DEFER));
			}
		} else if (-1==fstat(reply_log_fd,&st)) {
			logmsg3(SMTP_FATAL,argv0,": reply-log-fd: ",strerror(errno));
			_exit(translate_exitcode(SMTP_DEFER));
		} 
		reply_log_chan=malloc(sizeof(uoio_t));
		if (!reply_log_chan) exitmsg0(SMTP_DEFER,"out of memory");
		uoio_assign_w(reply_log_chan,reply_log_fd,write,0);
	}
	if (smtpport>65535) exitmsg0(SMTP_FATAL,"SMTP port too large\n");
	/* need target host, from and to */
	if (relayhost && !*relayhost) exitmsg0(SMTP_FATAL,"relay host is empty\n");

	if (maildir && -1==chdir(maildir)) {
		uostr_t s;s.data=0;
		uostr_xadd_cstrmulti(&s,argv0,": cannot chdir(",maildir,"): ",strerror(errno),"\n",0);
		exitmsguo(SMTP_FATAL,&s);
	}
	if (!postmaster) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,"postmaster@",greeting,NULL);
		uostr_x0(&s);
		postmaster=strdup(s.data);
		if (!postmaster) exitmsg0(1,"out of memory");
		uostr_freedata(&s);
	}
	if (!strchr(postmaster,'@')) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,postmaster,"@",greeting,NULL);
		uostr_x0(&s);
		postmaster=strdup(s.data);
		if (!postmaster) exitmsg0(1,"out of memory");
		uostr_freedata(&s);
	}
	if (!doublebounceto) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,"postmaster@",myhostname,NULL);
		uostr_x0(&s);
		doublebounceto=strdup(s.data);
		if (!doublebounceto) exitmsg0(1,"out of memory");
		uostr_freedata(&s);
	}
	if (!strchr(doublebounceto,'@')) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,doublebounceto,"@", myhostname,NULL);
		uostr_x0(&s);
		doublebounceto=strdup(s.data);
		if (!doublebounceto) exitmsg0(1,"out of memory");
		uostr_freedata(&s);
	}
	runqueue();
	_exit(0);
}
