#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1602
#define LARGE_STATE_COUNT 322
#define SYMBOL_COUNT 181
#define ALIAS_COUNT 0
#define TOKEN_COUNT 82
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 10
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 13

enum {
  sym__lower_id = 1,
  anon_sym_module = 2,
  anon_sym_LBRACE = 3,
  anon_sym_RBRACE = 4,
  anon_sym_import = 5,
  anon_sym_as = 6,
  anon_sym_EQ = 7,
  anon_sym_SEMI = 8,
  anon_sym_or = 9,
  anon_sym_LPAREN = 10,
  anon_sym_COMMA = 11,
  anon_sym_RPAREN = 12,
  anon_sym_newtype = 13,
  anon_sym_from = 14,
  anon_sym_where = 15,
  anon_sym_select = 16,
  anon_sym_class = 17,
  anon_sym_extends = 18,
  anon_sym_in = 19,
  anon_sym_instanceof = 20,
  anon_sym_not = 21,
  anon_sym_if = 22,
  anon_sym_then = 23,
  anon_sym_else = 24,
  anon_sym_and = 25,
  anon_sym_implies = 26,
  anon_sym_PIPE = 27,
  sym_specialId = 28,
  anon_sym_exists = 29,
  anon_sym_forall = 30,
  anon_sym_forex = 31,
  sym_underscore = 32,
  anon_sym_DOT = 33,
  anon_sym_LBRACK = 34,
  anon_sym_RBRACK = 35,
  anon_sym_DOT_DOT = 36,
  anon_sym_BANG_EQ = 37,
  anon_sym_LT = 38,
  anon_sym_GT = 39,
  anon_sym_LT_EQ = 40,
  anon_sym_GT_EQ = 41,
  anon_sym_PLUS = 42,
  anon_sym_DASH = 43,
  anon_sym_STAR = 44,
  anon_sym_SLASH = 45,
  anon_sym_PERCENT = 46,
  anon_sym_asc = 47,
  anon_sym_desc = 48,
  anon_sym_order = 49,
  anon_sym_by = 50,
  sym_qldoc = 51,
  anon_sym_COLON_COLON = 52,
  anon_sym_boolean = 53,
  anon_sym_date = 54,
  anon_sym_float = 55,
  anon_sym_int = 56,
  anon_sym_string = 57,
  sym_dbtype = 58,
  anon_sym_avg = 59,
  anon_sym_concat = 60,
  anon_sym_strictconcat = 61,
  anon_sym_count = 62,
  anon_sym_max = 63,
  anon_sym_min = 64,
  anon_sym_rank = 65,
  anon_sym_strictcount = 66,
  anon_sym_strictsum = 67,
  anon_sym_sum = 68,
  anon_sym_any = 69,
  sym__upper_id = 70,
  sym_integer = 71,
  sym_float = 72,
  sym_string = 73,
  sym_line_comment = 74,
  sym_block_comment = 75,
  sym_false = 76,
  sym_predicate = 77,
  sym_result = 78,
  sym_super = 79,
  sym_this = 80,
  sym_true = 81,
  sym_ql = 82,
  sym_module = 83,
  sym_moduleMember = 84,
  sym_importDirective = 85,
  sym_moduleAliasBody = 86,
  sym_predicateAliasBody = 87,
  sym_typeAliasBody = 88,
  sym_typeUnionBody = 89,
  sym_classlessPredicate = 90,
  sym_datatype = 91,
  sym_datatypeBranches = 92,
  sym_datatypeBranch = 93,
  sym_select = 94,
  sym_dataclass = 95,
  sym_classMember = 96,
  sym_charpred = 97,
  sym_memberPredicate = 98,
  sym_field = 99,
  sym__optbody = 100,
  sym_empty = 101,
  sym_body = 102,
  sym_higherOrderTerm = 103,
  sym_special_call = 104,
  sym_prefix_cast = 105,
  sym_unary_expr = 106,
  sym_mul_expr = 107,
  sym_add_expr = 108,
  sym_in_expr = 109,
  sym_comp_term = 110,
  sym_instance_of = 111,
  sym_negation = 112,
  sym_if_term = 113,
  sym_conjunction = 114,
  sym_disjunction = 115,
  sym_implication = 116,
  sym_quantified = 117,
  sym_quantifier = 118,
  sym__call_arg = 119,
  sym_qualifiedRhs = 120,
  sym_call_body = 121,
  sym_unqual_agg_body = 122,
  sym__call_or_unqual_agg_body = 123,
  sym_call_or_unqual_agg_expr = 124,
  sym_qualified_expr = 125,
  sym_super_ref = 126,
  sym_full_aggregate_body = 127,
  sym_expr_aggregate_body = 128,
  sym_aggregate = 129,
  sym_range = 130,
  sym_set_literal = 131,
  sym_par_expr = 132,
  sym__exprOrTerm = 133,
  sym__primary = 134,
  sym_literal = 135,
  sym_bool = 136,
  sym_variable = 137,
  sym_compop = 138,
  sym_unop = 139,
  sym_mulop = 140,
  sym_addop = 141,
  sym_closure = 142,
  sym_direction = 143,
  sym_varDecl = 144,
  sym_asExprs = 145,
  sym_asExpr = 146,
  sym_orderBys = 147,
  sym_orderBy = 148,
  sym_literalId = 149,
  sym_annotation = 150,
  sym_annotName = 151,
  sym_annotArg = 152,
  sym_moduleName = 153,
  sym_qualModuleExpr = 154,
  sym_importModuleExpr = 155,
  sym_moduleExpr = 156,
  sym_primitiveType = 157,
  sym_simpleId = 158,
  sym_className = 159,
  sym_typeExpr = 160,
  sym_predicateName = 161,
  sym_aritylessPredicateExpr = 162,
  sym_predicateExpr = 163,
  sym_varName = 164,
  sym_aggId = 165,
  aux_sym_ql_repeat1 = 166,
  aux_sym_moduleMember_repeat1 = 167,
  aux_sym_typeUnionBody_repeat1 = 168,
  aux_sym_classlessPredicate_repeat1 = 169,
  aux_sym_datatypeBranches_repeat1 = 170,
  aux_sym_dataclass_repeat1 = 171,
  aux_sym_dataclass_repeat2 = 172,
  aux_sym_higherOrderTerm_repeat1 = 173,
  aux_sym_higherOrderTerm_repeat2 = 174,
  aux_sym_aggregate_repeat1 = 175,
  aux_sym_asExprs_repeat1 = 176,
  aux_sym_orderBys_repeat1 = 177,
  aux_sym_annotation_repeat1 = 178,
  aux_sym_qualModuleExpr_repeat1 = 179,
  aux_sym_importModuleExpr_repeat1 = 180,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__lower_id] = "_lower_id",
  [anon_sym_module] = "module",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_import] = "import",
  [anon_sym_as] = "as",
  [anon_sym_EQ] = "=",
  [anon_sym_SEMI] = ";",
  [anon_sym_or] = "or",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_newtype] = "newtype",
  [anon_sym_from] = "from",
  [anon_sym_where] = "where",
  [anon_sym_select] = "select",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_in] = "in",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_not] = "not",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_and] = "and",
  [anon_sym_implies] = "implies",
  [anon_sym_PIPE] = "|",
  [sym_specialId] = "specialId",
  [anon_sym_exists] = "exists",
  [anon_sym_forall] = "forall",
  [anon_sym_forex] = "forex",
  [sym_underscore] = "underscore",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_asc] = "asc",
  [anon_sym_desc] = "desc",
  [anon_sym_order] = "order",
  [anon_sym_by] = "by",
  [sym_qldoc] = "qldoc",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_boolean] = "boolean",
  [anon_sym_date] = "date",
  [anon_sym_float] = "float",
  [anon_sym_int] = "int",
  [anon_sym_string] = "string",
  [sym_dbtype] = "dbtype",
  [anon_sym_avg] = "avg",
  [anon_sym_concat] = "concat",
  [anon_sym_strictconcat] = "strictconcat",
  [anon_sym_count] = "count",
  [anon_sym_max] = "max",
  [anon_sym_min] = "min",
  [anon_sym_rank] = "rank",
  [anon_sym_strictcount] = "strictcount",
  [anon_sym_strictsum] = "strictsum",
  [anon_sym_sum] = "sum",
  [anon_sym_any] = "any",
  [sym__upper_id] = "_upper_id",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [sym_string] = "string",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_false] = "false",
  [sym_predicate] = "predicate",
  [sym_result] = "result",
  [sym_super] = "super",
  [sym_this] = "this",
  [sym_true] = "true",
  [sym_ql] = "ql",
  [sym_module] = "module",
  [sym_moduleMember] = "moduleMember",
  [sym_importDirective] = "importDirective",
  [sym_moduleAliasBody] = "moduleAliasBody",
  [sym_predicateAliasBody] = "predicateAliasBody",
  [sym_typeAliasBody] = "typeAliasBody",
  [sym_typeUnionBody] = "typeUnionBody",
  [sym_classlessPredicate] = "classlessPredicate",
  [sym_datatype] = "datatype",
  [sym_datatypeBranches] = "datatypeBranches",
  [sym_datatypeBranch] = "datatypeBranch",
  [sym_select] = "select",
  [sym_dataclass] = "dataclass",
  [sym_classMember] = "classMember",
  [sym_charpred] = "charpred",
  [sym_memberPredicate] = "memberPredicate",
  [sym_field] = "field",
  [sym__optbody] = "_optbody",
  [sym_empty] = "empty",
  [sym_body] = "body",
  [sym_higherOrderTerm] = "higherOrderTerm",
  [sym_special_call] = "special_call",
  [sym_prefix_cast] = "prefix_cast",
  [sym_unary_expr] = "unary_expr",
  [sym_mul_expr] = "mul_expr",
  [sym_add_expr] = "add_expr",
  [sym_in_expr] = "in_expr",
  [sym_comp_term] = "comp_term",
  [sym_instance_of] = "instance_of",
  [sym_negation] = "negation",
  [sym_if_term] = "if_term",
  [sym_conjunction] = "conjunction",
  [sym_disjunction] = "disjunction",
  [sym_implication] = "implication",
  [sym_quantified] = "quantified",
  [sym_quantifier] = "quantifier",
  [sym__call_arg] = "_call_arg",
  [sym_qualifiedRhs] = "qualifiedRhs",
  [sym_call_body] = "call_body",
  [sym_unqual_agg_body] = "unqual_agg_body",
  [sym__call_or_unqual_agg_body] = "_call_or_unqual_agg_body",
  [sym_call_or_unqual_agg_expr] = "call_or_unqual_agg_expr",
  [sym_qualified_expr] = "qualified_expr",
  [sym_super_ref] = "super_ref",
  [sym_full_aggregate_body] = "full_aggregate_body",
  [sym_expr_aggregate_body] = "expr_aggregate_body",
  [sym_aggregate] = "aggregate",
  [sym_range] = "range",
  [sym_set_literal] = "set_literal",
  [sym_par_expr] = "par_expr",
  [sym__exprOrTerm] = "_exprOrTerm",
  [sym__primary] = "_primary",
  [sym_literal] = "literal",
  [sym_bool] = "bool",
  [sym_variable] = "variable",
  [sym_compop] = "compop",
  [sym_unop] = "unop",
  [sym_mulop] = "mulop",
  [sym_addop] = "addop",
  [sym_closure] = "closure",
  [sym_direction] = "direction",
  [sym_varDecl] = "varDecl",
  [sym_asExprs] = "asExprs",
  [sym_asExpr] = "asExpr",
  [sym_orderBys] = "orderBys",
  [sym_orderBy] = "orderBy",
  [sym_literalId] = "literalId",
  [sym_annotation] = "annotation",
  [sym_annotName] = "annotName",
  [sym_annotArg] = "annotArg",
  [sym_moduleName] = "moduleName",
  [sym_qualModuleExpr] = "qualModuleExpr",
  [sym_importModuleExpr] = "importModuleExpr",
  [sym_moduleExpr] = "moduleExpr",
  [sym_primitiveType] = "primitiveType",
  [sym_simpleId] = "simpleId",
  [sym_className] = "className",
  [sym_typeExpr] = "typeExpr",
  [sym_predicateName] = "predicateName",
  [sym_aritylessPredicateExpr] = "aritylessPredicateExpr",
  [sym_predicateExpr] = "predicateExpr",
  [sym_varName] = "varName",
  [sym_aggId] = "aggId",
  [aux_sym_ql_repeat1] = "ql_repeat1",
  [aux_sym_moduleMember_repeat1] = "moduleMember_repeat1",
  [aux_sym_typeUnionBody_repeat1] = "typeUnionBody_repeat1",
  [aux_sym_classlessPredicate_repeat1] = "classlessPredicate_repeat1",
  [aux_sym_datatypeBranches_repeat1] = "datatypeBranches_repeat1",
  [aux_sym_dataclass_repeat1] = "dataclass_repeat1",
  [aux_sym_dataclass_repeat2] = "dataclass_repeat2",
  [aux_sym_higherOrderTerm_repeat1] = "higherOrderTerm_repeat1",
  [aux_sym_higherOrderTerm_repeat2] = "higherOrderTerm_repeat2",
  [aux_sym_aggregate_repeat1] = "aggregate_repeat1",
  [aux_sym_asExprs_repeat1] = "asExprs_repeat1",
  [aux_sym_orderBys_repeat1] = "orderBys_repeat1",
  [aux_sym_annotation_repeat1] = "annotation_repeat1",
  [aux_sym_qualModuleExpr_repeat1] = "qualModuleExpr_repeat1",
  [aux_sym_importModuleExpr_repeat1] = "importModuleExpr_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__lower_id] = sym__lower_id,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_newtype] = anon_sym_newtype,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_where] = anon_sym_where,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [sym_specialId] = sym_specialId,
  [anon_sym_exists] = anon_sym_exists,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_forex] = anon_sym_forex,
  [sym_underscore] = sym_underscore,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_asc] = anon_sym_asc,
  [anon_sym_desc] = anon_sym_desc,
  [anon_sym_order] = anon_sym_order,
  [anon_sym_by] = anon_sym_by,
  [sym_qldoc] = sym_qldoc,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_date] = anon_sym_date,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_string] = anon_sym_string,
  [sym_dbtype] = sym_dbtype,
  [anon_sym_avg] = anon_sym_avg,
  [anon_sym_concat] = anon_sym_concat,
  [anon_sym_strictconcat] = anon_sym_strictconcat,
  [anon_sym_count] = anon_sym_count,
  [anon_sym_max] = anon_sym_max,
  [anon_sym_min] = anon_sym_min,
  [anon_sym_rank] = anon_sym_rank,
  [anon_sym_strictcount] = anon_sym_strictcount,
  [anon_sym_strictsum] = anon_sym_strictsum,
  [anon_sym_sum] = anon_sym_sum,
  [anon_sym_any] = anon_sym_any,
  [sym__upper_id] = sym__upper_id,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [sym_string] = sym_string,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_false] = sym_false,
  [sym_predicate] = sym_predicate,
  [sym_result] = sym_result,
  [sym_super] = sym_super,
  [sym_this] = sym_this,
  [sym_true] = sym_true,
  [sym_ql] = sym_ql,
  [sym_module] = sym_module,
  [sym_moduleMember] = sym_moduleMember,
  [sym_importDirective] = sym_importDirective,
  [sym_moduleAliasBody] = sym_moduleAliasBody,
  [sym_predicateAliasBody] = sym_predicateAliasBody,
  [sym_typeAliasBody] = sym_typeAliasBody,
  [sym_typeUnionBody] = sym_typeUnionBody,
  [sym_classlessPredicate] = sym_classlessPredicate,
  [sym_datatype] = sym_datatype,
  [sym_datatypeBranches] = sym_datatypeBranches,
  [sym_datatypeBranch] = sym_datatypeBranch,
  [sym_select] = sym_select,
  [sym_dataclass] = sym_dataclass,
  [sym_classMember] = sym_classMember,
  [sym_charpred] = sym_charpred,
  [sym_memberPredicate] = sym_memberPredicate,
  [sym_field] = sym_field,
  [sym__optbody] = sym__optbody,
  [sym_empty] = sym_empty,
  [sym_body] = sym_body,
  [sym_higherOrderTerm] = sym_higherOrderTerm,
  [sym_special_call] = sym_special_call,
  [sym_prefix_cast] = sym_prefix_cast,
  [sym_unary_expr] = sym_unary_expr,
  [sym_mul_expr] = sym_mul_expr,
  [sym_add_expr] = sym_add_expr,
  [sym_in_expr] = sym_in_expr,
  [sym_comp_term] = sym_comp_term,
  [sym_instance_of] = sym_instance_of,
  [sym_negation] = sym_negation,
  [sym_if_term] = sym_if_term,
  [sym_conjunction] = sym_conjunction,
  [sym_disjunction] = sym_disjunction,
  [sym_implication] = sym_implication,
  [sym_quantified] = sym_quantified,
  [sym_quantifier] = sym_quantifier,
  [sym__call_arg] = sym__call_arg,
  [sym_qualifiedRhs] = sym_qualifiedRhs,
  [sym_call_body] = sym_call_body,
  [sym_unqual_agg_body] = sym_unqual_agg_body,
  [sym__call_or_unqual_agg_body] = sym__call_or_unqual_agg_body,
  [sym_call_or_unqual_agg_expr] = sym_call_or_unqual_agg_expr,
  [sym_qualified_expr] = sym_qualified_expr,
  [sym_super_ref] = sym_super_ref,
  [sym_full_aggregate_body] = sym_full_aggregate_body,
  [sym_expr_aggregate_body] = sym_expr_aggregate_body,
  [sym_aggregate] = sym_aggregate,
  [sym_range] = sym_range,
  [sym_set_literal] = sym_set_literal,
  [sym_par_expr] = sym_par_expr,
  [sym__exprOrTerm] = sym__exprOrTerm,
  [sym__primary] = sym__primary,
  [sym_literal] = sym_literal,
  [sym_bool] = sym_bool,
  [sym_variable] = sym_variable,
  [sym_compop] = sym_compop,
  [sym_unop] = sym_unop,
  [sym_mulop] = sym_mulop,
  [sym_addop] = sym_addop,
  [sym_closure] = sym_closure,
  [sym_direction] = sym_direction,
  [sym_varDecl] = sym_varDecl,
  [sym_asExprs] = sym_asExprs,
  [sym_asExpr] = sym_asExpr,
  [sym_orderBys] = sym_orderBys,
  [sym_orderBy] = sym_orderBy,
  [sym_literalId] = sym_literalId,
  [sym_annotation] = sym_annotation,
  [sym_annotName] = sym_annotName,
  [sym_annotArg] = sym_annotArg,
  [sym_moduleName] = sym_moduleName,
  [sym_qualModuleExpr] = sym_qualModuleExpr,
  [sym_importModuleExpr] = sym_importModuleExpr,
  [sym_moduleExpr] = sym_moduleExpr,
  [sym_primitiveType] = sym_primitiveType,
  [sym_simpleId] = sym_simpleId,
  [sym_className] = sym_className,
  [sym_typeExpr] = sym_typeExpr,
  [sym_predicateName] = sym_predicateName,
  [sym_aritylessPredicateExpr] = sym_aritylessPredicateExpr,
  [sym_predicateExpr] = sym_predicateExpr,
  [sym_varName] = sym_varName,
  [sym_aggId] = sym_aggId,
  [aux_sym_ql_repeat1] = aux_sym_ql_repeat1,
  [aux_sym_moduleMember_repeat1] = aux_sym_moduleMember_repeat1,
  [aux_sym_typeUnionBody_repeat1] = aux_sym_typeUnionBody_repeat1,
  [aux_sym_classlessPredicate_repeat1] = aux_sym_classlessPredicate_repeat1,
  [aux_sym_datatypeBranches_repeat1] = aux_sym_datatypeBranches_repeat1,
  [aux_sym_dataclass_repeat1] = aux_sym_dataclass_repeat1,
  [aux_sym_dataclass_repeat2] = aux_sym_dataclass_repeat2,
  [aux_sym_higherOrderTerm_repeat1] = aux_sym_higherOrderTerm_repeat1,
  [aux_sym_higherOrderTerm_repeat2] = aux_sym_higherOrderTerm_repeat2,
  [aux_sym_aggregate_repeat1] = aux_sym_aggregate_repeat1,
  [aux_sym_asExprs_repeat1] = aux_sym_asExprs_repeat1,
  [aux_sym_orderBys_repeat1] = aux_sym_orderBys_repeat1,
  [aux_sym_annotation_repeat1] = aux_sym_annotation_repeat1,
  [aux_sym_qualModuleExpr_repeat1] = aux_sym_qualModuleExpr_repeat1,
  [aux_sym_importModuleExpr_repeat1] = aux_sym_importModuleExpr_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__lower_id] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_newtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_specialId] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_exists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forex] = {
    .visible = true,
    .named = false,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_desc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_order] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [sym_qldoc] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_date] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [sym_dbtype] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_avg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_concat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictconcat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_count] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_max] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_min] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rank] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictcount] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictsum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [sym__upper_id] = {
    .visible = false,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_result] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_ql] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleMember] = {
    .visible = true,
    .named = true,
  },
  [sym_importDirective] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_typeAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_typeUnionBody] = {
    .visible = true,
    .named = true,
  },
  [sym_classlessPredicate] = {
    .visible = true,
    .named = true,
  },
  [sym_datatype] = {
    .visible = true,
    .named = true,
  },
  [sym_datatypeBranches] = {
    .visible = true,
    .named = true,
  },
  [sym_datatypeBranch] = {
    .visible = true,
    .named = true,
  },
  [sym_select] = {
    .visible = true,
    .named = true,
  },
  [sym_dataclass] = {
    .visible = true,
    .named = true,
  },
  [sym_classMember] = {
    .visible = true,
    .named = true,
  },
  [sym_charpred] = {
    .visible = true,
    .named = true,
  },
  [sym_memberPredicate] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__optbody] = {
    .visible = false,
    .named = true,
  },
  [sym_empty] = {
    .visible = true,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym_higherOrderTerm] = {
    .visible = true,
    .named = true,
  },
  [sym_special_call] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_mul_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_add_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_in_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_comp_term] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_of] = {
    .visible = true,
    .named = true,
  },
  [sym_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_if_term] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_implication] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier] = {
    .visible = true,
    .named = true,
  },
  [sym__call_arg] = {
    .visible = false,
    .named = true,
  },
  [sym_qualifiedRhs] = {
    .visible = true,
    .named = true,
  },
  [sym_call_body] = {
    .visible = true,
    .named = true,
  },
  [sym_unqual_agg_body] = {
    .visible = true,
    .named = true,
  },
  [sym__call_or_unqual_agg_body] = {
    .visible = false,
    .named = true,
  },
  [sym_call_or_unqual_agg_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_super_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_full_aggregate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_aggregate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_par_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__exprOrTerm] = {
    .visible = false,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_compop] = {
    .visible = true,
    .named = true,
  },
  [sym_unop] = {
    .visible = true,
    .named = true,
  },
  [sym_mulop] = {
    .visible = true,
    .named = true,
  },
  [sym_addop] = {
    .visible = true,
    .named = true,
  },
  [sym_closure] = {
    .visible = true,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [sym_varDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_asExprs] = {
    .visible = true,
    .named = true,
  },
  [sym_asExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_orderBys] = {
    .visible = true,
    .named = true,
  },
  [sym_orderBy] = {
    .visible = true,
    .named = true,
  },
  [sym_literalId] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotName] = {
    .visible = true,
    .named = true,
  },
  [sym_annotArg] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleName] = {
    .visible = true,
    .named = true,
  },
  [sym_qualModuleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_importModuleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_primitiveType] = {
    .visible = true,
    .named = true,
  },
  [sym_simpleId] = {
    .visible = true,
    .named = true,
  },
  [sym_className] = {
    .visible = true,
    .named = true,
  },
  [sym_typeExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateName] = {
    .visible = true,
    .named = true,
  },
  [sym_aritylessPredicateExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_varName] = {
    .visible = true,
    .named = true,
  },
  [sym_aggId] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_ql_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_moduleMember_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeUnionBody_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_classlessPredicate_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_datatypeBranches_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dataclass_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dataclass_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_higherOrderTerm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_higherOrderTerm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_aggregate_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_asExprs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_orderBys_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_qualModuleExpr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_importModuleExpr_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_args = 1,
  field_cond = 2,
  field_first = 3,
  field_left = 4,
  field_lower = 5,
  field_name = 6,
  field_returnType = 7,
  field_right = 8,
  field_second = 9,
  field_upper = 10,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_args] = "args",
  [field_cond] = "cond",
  [field_first] = "first",
  [field_left] = "left",
  [field_lower] = "lower",
  [field_name] = "name",
  [field_returnType] = "returnType",
  [field_right] = "right",
  [field_second] = "second",
  [field_upper] = "upper",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 2},
  [9] = {.index = 12, .length = 2},
  [10] = {.index = 14, .length = 3},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_name, 1, .inherited = true},
  [3] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [5] =
    {field_name, 1},
    {field_returnType, 0},
  [7] =
    {field_name, 2},
  [8] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [10] =
    {field_left, 0},
    {field_right, 2},
  [12] =
    {field_args, 2},
    {field_name, 0},
  [14] =
    {field_args, 2},
    {field_args, 3},
    {field_name, 0},
  [17] =
    {field_lower, 1},
    {field_upper, 3},
  [19] =
    {field_cond, 1},
    {field_first, 3},
    {field_second, 5},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(18);
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '%') ADVANCE(42);
      if (lookahead == '(') ADVANCE(23);
      if (lookahead == ')') ADVANCE(25);
      if (lookahead == '*') ADVANCE(39);
      if (lookahead == '+') ADVANCE(37);
      if (lookahead == ',') ADVANCE(24);
      if (lookahead == '-') ADVANCE(38);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == ':') ADVANCE(12);
      if (lookahead == ';') ADVANCE(22);
      if (lookahead == '<') ADVANCE(33);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(34);
      if (lookahead == '@') ADVANCE(16);
      if (lookahead == '[') ADVANCE(29);
      if (lookahead == ']') ADVANCE(30);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == '{') ADVANCE(19);
      if (lookahead == '|') ADVANCE(26);
      if (lookahead == '}') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(46);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 3:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 4:
      if (lookahead == '*') ADVANCE(3);
      if (lookahead == '/') ADVANCE(52);
      END_STATE();
    case 5:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(43);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(53);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '/') ADVANCE(53);
      END_STATE();
    case 11:
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == ':') ADVANCE(44);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(32);
      END_STATE();
    case 14:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(1);
      END_STATE();
    case 15:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 16:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(45);
      END_STATE();
    case 17:
      if (eof) ADVANCE(18);
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '%') ADVANCE(42);
      if (lookahead == '(') ADVANCE(23);
      if (lookahead == ')') ADVANCE(25);
      if (lookahead == '*') ADVANCE(39);
      if (lookahead == '+') ADVANCE(37);
      if (lookahead == ',') ADVANCE(24);
      if (lookahead == '-') ADVANCE(38);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == '/') ADVANCE(41);
      if (lookahead == ':') ADVANCE(12);
      if (lookahead == ';') ADVANCE(22);
      if (lookahead == '<') ADVANCE(33);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(34);
      if (lookahead == '@') ADVANCE(16);
      if (lookahead == '[') ADVANCE(29);
      if (lookahead == ']') ADVANCE(30);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == '{') ADVANCE(19);
      if (lookahead == '|') ADVANCE(26);
      if (lookahead == '}') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(46);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_underscore);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(31);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(36);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(2);
      if (lookahead == '/') ADVANCE(52);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(3);
      if (lookahead == '/') ADVANCE(52);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_qldoc);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_dbtype);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym__upper_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym__lower_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_block_comment);
      if (lookahead == '*') ADVANCE(6);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'm') ADVANCE(8);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'w') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      if (lookahead == 'v') ADVANCE(18);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(19);
      if (lookahead == 'y') ADVANCE(20);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(23);
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(25);
      if (lookahead == 'x') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(27);
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(31);
      if (lookahead == 'm') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(41);
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(48);
      END_STATE();
    case 16:
      if (lookahead == 'd') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'c') ADVANCE(51);
      END_STATE();
    case 18:
      if (lookahead == 'g') ADVANCE(52);
      END_STATE();
    case 19:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_by);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 28:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 29:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(66);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 34:
      if (lookahead == 'x') ADVANCE(69);
      END_STATE();
    case 35:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 36:
      if (lookahead == 'd') ADVANCE(71);
      END_STATE();
    case 37:
      if (lookahead == 'w') ADVANCE(72);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(73);
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'd') ADVANCE(75);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 43:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 44:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 45:
      if (lookahead == 'm') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(83);
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(85);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_asc);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_avg);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(87);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 55:
      if (lookahead == 'c') ADVANCE(89);
      END_STATE();
    case 56:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(92);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 60:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(97);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 65:
      if (lookahead == 'm') ADVANCE(100);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(101);
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_max);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_min);
      END_STATE();
    case 71:
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(108);
      END_STATE();
    case 77:
      if (lookahead == 'k') ADVANCE(109);
      END_STATE();
    case 78:
      if (lookahead == 'u') ADVANCE(110);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 80:
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_sum);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(119);
      END_STATE();
    case 89:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_date);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_desc);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(123);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 97:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(126);
      END_STATE();
    case 99:
      if (lookahead == 'x') ADVANCE(127);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(131);
      END_STATE();
    case 105:
      if (lookahead == 'y') ADVANCE(132);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_specialId);
      END_STATE();
    case 107:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 108:
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_rank);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(135);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(136);
      END_STATE();
    case 112:
      if (lookahead == 'c') ADVANCE(137);
      if (lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(139);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_count);
      END_STATE();
    case 122:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(144);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_forex);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 132:
      if (lookahead == 'p') ADVANCE(150);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_order);
      END_STATE();
    case 134:
      if (lookahead == 'c') ADVANCE(151);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 137:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 138:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_concat);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_exists);
      END_STATE();
    case 144:
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 146:
      if (lookahead == 's') ADVANCE(158);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 148:
      if (lookahead == 'c') ADVANCE(159);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(161);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_result);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 154:
      if (lookahead == 'c') ADVANCE(162);
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 159:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_newtype);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 162:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 163:
      if (lookahead == 'u') ADVANCE(167);
      END_STATE();
    case 164:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 166:
      if (lookahead == 'n') ADVANCE(170);
      if (lookahead == 'u') ADVANCE(171);
      END_STATE();
    case 167:
      if (lookahead == 'm') ADVANCE(172);
      END_STATE();
    case 168:
      if (lookahead == 'f') ADVANCE(173);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_predicate);
      END_STATE();
    case 170:
      if (lookahead == 'c') ADVANCE(174);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(175);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_strictsum);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(176);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_strictcount);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_strictconcat);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 17},
  [3] = {.lex_state = 17},
  [4] = {.lex_state = 17},
  [5] = {.lex_state = 17},
  [6] = {.lex_state = 17},
  [7] = {.lex_state = 17},
  [8] = {.lex_state = 17},
  [9] = {.lex_state = 17},
  [10] = {.lex_state = 17},
  [11] = {.lex_state = 17},
  [12] = {.lex_state = 17},
  [13] = {.lex_state = 17},
  [14] = {.lex_state = 17},
  [15] = {.lex_state = 17},
  [16] = {.lex_state = 17},
  [17] = {.lex_state = 17},
  [18] = {.lex_state = 17},
  [19] = {.lex_state = 17},
  [20] = {.lex_state = 17},
  [21] = {.lex_state = 17},
  [22] = {.lex_state = 17},
  [23] = {.lex_state = 17},
  [24] = {.lex_state = 17},
  [25] = {.lex_state = 17},
  [26] = {.lex_state = 17},
  [27] = {.lex_state = 17},
  [28] = {.lex_state = 17},
  [29] = {.lex_state = 17},
  [30] = {.lex_state = 17},
  [31] = {.lex_state = 17},
  [32] = {.lex_state = 17},
  [33] = {.lex_state = 17},
  [34] = {.lex_state = 17},
  [35] = {.lex_state = 17},
  [36] = {.lex_state = 17},
  [37] = {.lex_state = 17},
  [38] = {.lex_state = 17},
  [39] = {.lex_state = 17},
  [40] = {.lex_state = 17},
  [41] = {.lex_state = 17},
  [42] = {.lex_state = 17},
  [43] = {.lex_state = 17},
  [44] = {.lex_state = 17},
  [45] = {.lex_state = 17},
  [46] = {.lex_state = 17},
  [47] = {.lex_state = 17},
  [48] = {.lex_state = 17},
  [49] = {.lex_state = 17},
  [50] = {.lex_state = 17},
  [51] = {.lex_state = 17},
  [52] = {.lex_state = 17},
  [53] = {.lex_state = 17},
  [54] = {.lex_state = 17},
  [55] = {.lex_state = 17},
  [56] = {.lex_state = 17},
  [57] = {.lex_state = 17},
  [58] = {.lex_state = 17},
  [59] = {.lex_state = 17},
  [60] = {.lex_state = 17},
  [61] = {.lex_state = 17},
  [62] = {.lex_state = 17},
  [63] = {.lex_state = 17},
  [64] = {.lex_state = 17},
  [65] = {.lex_state = 17},
  [66] = {.lex_state = 17},
  [67] = {.lex_state = 17},
  [68] = {.lex_state = 17},
  [69] = {.lex_state = 17},
  [70] = {.lex_state = 17},
  [71] = {.lex_state = 17},
  [72] = {.lex_state = 17},
  [73] = {.lex_state = 17},
  [74] = {.lex_state = 17},
  [75] = {.lex_state = 17},
  [76] = {.lex_state = 17},
  [77] = {.lex_state = 17},
  [78] = {.lex_state = 17},
  [79] = {.lex_state = 17},
  [80] = {.lex_state = 17},
  [81] = {.lex_state = 17},
  [82] = {.lex_state = 17},
  [83] = {.lex_state = 17},
  [84] = {.lex_state = 17},
  [85] = {.lex_state = 17},
  [86] = {.lex_state = 17},
  [87] = {.lex_state = 17},
  [88] = {.lex_state = 17},
  [89] = {.lex_state = 17},
  [90] = {.lex_state = 17},
  [91] = {.lex_state = 17},
  [92] = {.lex_state = 17},
  [93] = {.lex_state = 17},
  [94] = {.lex_state = 17},
  [95] = {.lex_state = 17},
  [96] = {.lex_state = 17},
  [97] = {.lex_state = 17},
  [98] = {.lex_state = 17},
  [99] = {.lex_state = 17},
  [100] = {.lex_state = 17},
  [101] = {.lex_state = 17},
  [102] = {.lex_state = 17},
  [103] = {.lex_state = 17},
  [104] = {.lex_state = 17},
  [105] = {.lex_state = 17},
  [106] = {.lex_state = 17},
  [107] = {.lex_state = 17},
  [108] = {.lex_state = 17},
  [109] = {.lex_state = 17},
  [110] = {.lex_state = 17},
  [111] = {.lex_state = 17},
  [112] = {.lex_state = 17},
  [113] = {.lex_state = 17},
  [114] = {.lex_state = 17},
  [115] = {.lex_state = 17},
  [116] = {.lex_state = 17},
  [117] = {.lex_state = 17},
  [118] = {.lex_state = 17},
  [119] = {.lex_state = 17},
  [120] = {.lex_state = 17},
  [121] = {.lex_state = 17},
  [122] = {.lex_state = 17},
  [123] = {.lex_state = 17},
  [124] = {.lex_state = 17},
  [125] = {.lex_state = 17},
  [126] = {.lex_state = 17},
  [127] = {.lex_state = 17},
  [128] = {.lex_state = 17},
  [129] = {.lex_state = 17},
  [130] = {.lex_state = 17},
  [131] = {.lex_state = 17},
  [132] = {.lex_state = 17},
  [133] = {.lex_state = 17},
  [134] = {.lex_state = 17},
  [135] = {.lex_state = 17},
  [136] = {.lex_state = 17},
  [137] = {.lex_state = 17},
  [138] = {.lex_state = 17},
  [139] = {.lex_state = 17},
  [140] = {.lex_state = 17},
  [141] = {.lex_state = 17},
  [142] = {.lex_state = 17},
  [143] = {.lex_state = 17},
  [144] = {.lex_state = 17},
  [145] = {.lex_state = 17},
  [146] = {.lex_state = 17},
  [147] = {.lex_state = 17},
  [148] = {.lex_state = 17},
  [149] = {.lex_state = 17},
  [150] = {.lex_state = 17},
  [151] = {.lex_state = 17},
  [152] = {.lex_state = 17},
  [153] = {.lex_state = 17},
  [154] = {.lex_state = 17},
  [155] = {.lex_state = 17},
  [156] = {.lex_state = 17},
  [157] = {.lex_state = 17},
  [158] = {.lex_state = 17},
  [159] = {.lex_state = 17},
  [160] = {.lex_state = 17},
  [161] = {.lex_state = 17},
  [162] = {.lex_state = 17},
  [163] = {.lex_state = 17},
  [164] = {.lex_state = 17},
  [165] = {.lex_state = 17},
  [166] = {.lex_state = 17},
  [167] = {.lex_state = 17},
  [168] = {.lex_state = 17},
  [169] = {.lex_state = 17},
  [170] = {.lex_state = 17},
  [171] = {.lex_state = 17},
  [172] = {.lex_state = 17},
  [173] = {.lex_state = 17},
  [174] = {.lex_state = 17},
  [175] = {.lex_state = 17},
  [176] = {.lex_state = 17},
  [177] = {.lex_state = 17},
  [178] = {.lex_state = 17},
  [179] = {.lex_state = 17},
  [180] = {.lex_state = 17},
  [181] = {.lex_state = 17},
  [182] = {.lex_state = 17},
  [183] = {.lex_state = 17},
  [184] = {.lex_state = 17},
  [185] = {.lex_state = 17},
  [186] = {.lex_state = 17},
  [187] = {.lex_state = 17},
  [188] = {.lex_state = 17},
  [189] = {.lex_state = 17},
  [190] = {.lex_state = 17},
  [191] = {.lex_state = 17},
  [192] = {.lex_state = 17},
  [193] = {.lex_state = 17},
  [194] = {.lex_state = 17},
  [195] = {.lex_state = 17},
  [196] = {.lex_state = 17},
  [197] = {.lex_state = 17},
  [198] = {.lex_state = 17},
  [199] = {.lex_state = 17},
  [200] = {.lex_state = 17},
  [201] = {.lex_state = 17},
  [202] = {.lex_state = 17},
  [203] = {.lex_state = 17},
  [204] = {.lex_state = 17},
  [205] = {.lex_state = 17},
  [206] = {.lex_state = 17},
  [207] = {.lex_state = 17},
  [208] = {.lex_state = 17},
  [209] = {.lex_state = 17},
  [210] = {.lex_state = 17},
  [211] = {.lex_state = 17},
  [212] = {.lex_state = 17},
  [213] = {.lex_state = 17},
  [214] = {.lex_state = 17},
  [215] = {.lex_state = 17},
  [216] = {.lex_state = 17},
  [217] = {.lex_state = 17},
  [218] = {.lex_state = 17},
  [219] = {.lex_state = 17},
  [220] = {.lex_state = 17},
  [221] = {.lex_state = 17},
  [222] = {.lex_state = 17},
  [223] = {.lex_state = 17},
  [224] = {.lex_state = 17},
  [225] = {.lex_state = 17},
  [226] = {.lex_state = 17},
  [227] = {.lex_state = 17},
  [228] = {.lex_state = 17},
  [229] = {.lex_state = 17},
  [230] = {.lex_state = 17},
  [231] = {.lex_state = 17},
  [232] = {.lex_state = 17},
  [233] = {.lex_state = 17},
  [234] = {.lex_state = 17},
  [235] = {.lex_state = 17},
  [236] = {.lex_state = 17},
  [237] = {.lex_state = 17},
  [238] = {.lex_state = 17},
  [239] = {.lex_state = 17},
  [240] = {.lex_state = 17},
  [241] = {.lex_state = 17},
  [242] = {.lex_state = 17},
  [243] = {.lex_state = 17},
  [244] = {.lex_state = 17},
  [245] = {.lex_state = 17},
  [246] = {.lex_state = 17},
  [247] = {.lex_state = 17},
  [248] = {.lex_state = 17},
  [249] = {.lex_state = 17},
  [250] = {.lex_state = 17},
  [251] = {.lex_state = 17},
  [252] = {.lex_state = 17},
  [253] = {.lex_state = 17},
  [254] = {.lex_state = 17},
  [255] = {.lex_state = 17},
  [256] = {.lex_state = 17},
  [257] = {.lex_state = 17},
  [258] = {.lex_state = 17},
  [259] = {.lex_state = 17},
  [260] = {.lex_state = 17},
  [261] = {.lex_state = 17},
  [262] = {.lex_state = 17},
  [263] = {.lex_state = 17},
  [264] = {.lex_state = 17},
  [265] = {.lex_state = 17},
  [266] = {.lex_state = 17},
  [267] = {.lex_state = 17},
  [268] = {.lex_state = 17},
  [269] = {.lex_state = 17},
  [270] = {.lex_state = 17},
  [271] = {.lex_state = 17},
  [272] = {.lex_state = 17},
  [273] = {.lex_state = 17},
  [274] = {.lex_state = 17},
  [275] = {.lex_state = 17},
  [276] = {.lex_state = 17},
  [277] = {.lex_state = 17},
  [278] = {.lex_state = 17},
  [279] = {.lex_state = 17},
  [280] = {.lex_state = 17},
  [281] = {.lex_state = 17},
  [282] = {.lex_state = 17},
  [283] = {.lex_state = 17},
  [284] = {.lex_state = 17},
  [285] = {.lex_state = 17},
  [286] = {.lex_state = 17},
  [287] = {.lex_state = 17},
  [288] = {.lex_state = 17},
  [289] = {.lex_state = 17},
  [290] = {.lex_state = 17},
  [291] = {.lex_state = 17},
  [292] = {.lex_state = 17},
  [293] = {.lex_state = 17},
  [294] = {.lex_state = 17},
  [295] = {.lex_state = 17},
  [296] = {.lex_state = 17},
  [297] = {.lex_state = 17},
  [298] = {.lex_state = 17},
  [299] = {.lex_state = 17},
  [300] = {.lex_state = 17},
  [301] = {.lex_state = 17},
  [302] = {.lex_state = 17},
  [303] = {.lex_state = 17},
  [304] = {.lex_state = 17},
  [305] = {.lex_state = 17},
  [306] = {.lex_state = 17},
  [307] = {.lex_state = 17},
  [308] = {.lex_state = 17},
  [309] = {.lex_state = 17},
  [310] = {.lex_state = 17},
  [311] = {.lex_state = 17},
  [312] = {.lex_state = 17},
  [313] = {.lex_state = 17},
  [314] = {.lex_state = 17},
  [315] = {.lex_state = 17},
  [316] = {.lex_state = 17},
  [317] = {.lex_state = 17},
  [318] = {.lex_state = 17},
  [319] = {.lex_state = 17},
  [320] = {.lex_state = 17},
  [321] = {.lex_state = 17},
  [322] = {.lex_state = 17},
  [323] = {.lex_state = 17},
  [324] = {.lex_state = 17},
  [325] = {.lex_state = 17},
  [326] = {.lex_state = 17},
  [327] = {.lex_state = 17},
  [328] = {.lex_state = 17},
  [329] = {.lex_state = 17},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 17},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 17},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 17},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 17},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 17},
  [590] = {.lex_state = 17},
  [591] = {.lex_state = 17},
  [592] = {.lex_state = 17},
  [593] = {.lex_state = 17},
  [594] = {.lex_state = 17},
  [595] = {.lex_state = 17},
  [596] = {.lex_state = 17},
  [597] = {.lex_state = 17},
  [598] = {.lex_state = 17},
  [599] = {.lex_state = 17},
  [600] = {.lex_state = 17},
  [601] = {.lex_state = 17},
  [602] = {.lex_state = 17},
  [603] = {.lex_state = 17},
  [604] = {.lex_state = 17},
  [605] = {.lex_state = 17},
  [606] = {.lex_state = 17},
  [607] = {.lex_state = 17},
  [608] = {.lex_state = 17},
  [609] = {.lex_state = 17},
  [610] = {.lex_state = 17},
  [611] = {.lex_state = 17},
  [612] = {.lex_state = 17},
  [613] = {.lex_state = 17},
  [614] = {.lex_state = 17},
  [615] = {.lex_state = 17},
  [616] = {.lex_state = 17},
  [617] = {.lex_state = 17},
  [618] = {.lex_state = 17},
  [619] = {.lex_state = 17},
  [620] = {.lex_state = 17},
  [621] = {.lex_state = 17},
  [622] = {.lex_state = 17},
  [623] = {.lex_state = 17},
  [624] = {.lex_state = 17},
  [625] = {.lex_state = 17},
  [626] = {.lex_state = 17},
  [627] = {.lex_state = 17},
  [628] = {.lex_state = 17},
  [629] = {.lex_state = 17},
  [630] = {.lex_state = 17},
  [631] = {.lex_state = 17},
  [632] = {.lex_state = 17},
  [633] = {.lex_state = 17},
  [634] = {.lex_state = 17},
  [635] = {.lex_state = 17},
  [636] = {.lex_state = 17},
  [637] = {.lex_state = 17},
  [638] = {.lex_state = 17},
  [639] = {.lex_state = 17},
  [640] = {.lex_state = 17},
  [641] = {.lex_state = 17},
  [642] = {.lex_state = 17},
  [643] = {.lex_state = 17},
  [644] = {.lex_state = 17},
  [645] = {.lex_state = 17},
  [646] = {.lex_state = 17},
  [647] = {.lex_state = 17},
  [648] = {.lex_state = 17},
  [649] = {.lex_state = 17},
  [650] = {.lex_state = 17},
  [651] = {.lex_state = 17},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 17},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 17},
  [663] = {.lex_state = 17},
  [664] = {.lex_state = 17},
  [665] = {.lex_state = 17},
  [666] = {.lex_state = 17},
  [667] = {.lex_state = 17},
  [668] = {.lex_state = 17},
  [669] = {.lex_state = 17},
  [670] = {.lex_state = 17},
  [671] = {.lex_state = 17},
  [672] = {.lex_state = 17},
  [673] = {.lex_state = 17},
  [674] = {.lex_state = 17},
  [675] = {.lex_state = 17},
  [676] = {.lex_state = 17},
  [677] = {.lex_state = 17},
  [678] = {.lex_state = 17},
  [679] = {.lex_state = 17},
  [680] = {.lex_state = 17},
  [681] = {.lex_state = 17},
  [682] = {.lex_state = 17},
  [683] = {.lex_state = 17},
  [684] = {.lex_state = 17},
  [685] = {.lex_state = 17},
  [686] = {.lex_state = 17},
  [687] = {.lex_state = 17},
  [688] = {.lex_state = 17},
  [689] = {.lex_state = 17},
  [690] = {.lex_state = 17},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 17},
  [693] = {.lex_state = 17},
  [694] = {.lex_state = 17},
  [695] = {.lex_state = 17},
  [696] = {.lex_state = 17},
  [697] = {.lex_state = 17},
  [698] = {.lex_state = 17},
  [699] = {.lex_state = 17},
  [700] = {.lex_state = 17},
  [701] = {.lex_state = 17},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 17},
  [704] = {.lex_state = 17},
  [705] = {.lex_state = 17},
  [706] = {.lex_state = 17},
  [707] = {.lex_state = 17},
  [708] = {.lex_state = 17},
  [709] = {.lex_state = 17},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 17},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 17},
  [715] = {.lex_state = 17},
  [716] = {.lex_state = 17},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 17},
  [719] = {.lex_state = 17},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 17},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 17},
  [726] = {.lex_state = 17},
  [727] = {.lex_state = 17},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 17},
  [730] = {.lex_state = 17},
  [731] = {.lex_state = 17},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 17},
  [734] = {.lex_state = 17},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 17},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 17},
  [739] = {.lex_state = 17},
  [740] = {.lex_state = 17},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 17},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 17},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 17},
  [750] = {.lex_state = 17},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 17},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 17},
  [755] = {.lex_state = 17},
  [756] = {.lex_state = 17},
  [757] = {.lex_state = 17},
  [758] = {.lex_state = 17},
  [759] = {.lex_state = 17},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 17},
  [762] = {.lex_state = 17},
  [763] = {.lex_state = 17},
  [764] = {.lex_state = 17},
  [765] = {.lex_state = 17},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 17},
  [768] = {.lex_state = 17},
  [769] = {.lex_state = 17},
  [770] = {.lex_state = 17},
  [771] = {.lex_state = 17},
  [772] = {.lex_state = 17},
  [773] = {.lex_state = 17},
  [774] = {.lex_state = 17},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 17},
  [777] = {.lex_state = 17},
  [778] = {.lex_state = 17},
  [779] = {.lex_state = 17},
  [780] = {.lex_state = 17},
  [781] = {.lex_state = 17},
  [782] = {.lex_state = 17},
  [783] = {.lex_state = 17},
  [784] = {.lex_state = 17},
  [785] = {.lex_state = 17},
  [786] = {.lex_state = 17},
  [787] = {.lex_state = 17},
  [788] = {.lex_state = 17},
  [789] = {.lex_state = 17},
  [790] = {.lex_state = 17},
  [791] = {.lex_state = 17},
  [792] = {.lex_state = 17},
  [793] = {.lex_state = 17},
  [794] = {.lex_state = 17},
  [795] = {.lex_state = 17},
  [796] = {.lex_state = 17},
  [797] = {.lex_state = 17},
  [798] = {.lex_state = 17},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 17},
  [801] = {.lex_state = 17},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 17},
  [804] = {.lex_state = 17},
  [805] = {.lex_state = 17},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 17},
  [808] = {.lex_state = 17},
  [809] = {.lex_state = 17},
  [810] = {.lex_state = 17},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 17},
  [813] = {.lex_state = 17},
  [814] = {.lex_state = 17},
  [815] = {.lex_state = 17},
  [816] = {.lex_state = 17},
  [817] = {.lex_state = 17},
  [818] = {.lex_state = 17},
  [819] = {.lex_state = 17},
  [820] = {.lex_state = 17},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 17},
  [823] = {.lex_state = 17},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 17},
  [827] = {.lex_state = 17},
  [828] = {.lex_state = 17},
  [829] = {.lex_state = 17},
  [830] = {.lex_state = 17},
  [831] = {.lex_state = 17},
  [832] = {.lex_state = 17},
  [833] = {.lex_state = 17},
  [834] = {.lex_state = 17},
  [835] = {.lex_state = 17},
  [836] = {.lex_state = 17},
  [837] = {.lex_state = 17},
  [838] = {.lex_state = 17},
  [839] = {.lex_state = 17},
  [840] = {.lex_state = 17},
  [841] = {.lex_state = 17},
  [842] = {.lex_state = 17},
  [843] = {.lex_state = 17},
  [844] = {.lex_state = 17},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 17},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 17},
  [849] = {.lex_state = 17},
  [850] = {.lex_state = 17},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 17},
  [855] = {.lex_state = 17},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 17},
  [858] = {.lex_state = 17},
  [859] = {.lex_state = 17},
  [860] = {.lex_state = 17},
  [861] = {.lex_state = 17},
  [862] = {.lex_state = 17},
  [863] = {.lex_state = 17},
  [864] = {.lex_state = 17},
  [865] = {.lex_state = 17},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 17},
  [868] = {.lex_state = 17},
  [869] = {.lex_state = 17},
  [870] = {.lex_state = 17},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 17},
  [873] = {.lex_state = 17},
  [874] = {.lex_state = 17},
  [875] = {.lex_state = 17},
  [876] = {.lex_state = 17},
  [877] = {.lex_state = 17},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 17},
  [880] = {.lex_state = 17},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 17},
  [883] = {.lex_state = 17},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 17},
  [886] = {.lex_state = 17},
  [887] = {.lex_state = 17},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 17},
  [890] = {.lex_state = 17},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 17},
  [893] = {.lex_state = 17},
  [894] = {.lex_state = 17},
  [895] = {.lex_state = 17},
  [896] = {.lex_state = 17},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 17},
  [899] = {.lex_state = 17},
  [900] = {.lex_state = 17},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 17},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 17},
  [906] = {.lex_state = 17},
  [907] = {.lex_state = 17},
  [908] = {.lex_state = 17},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 17},
  [912] = {.lex_state = 17},
  [913] = {.lex_state = 17},
  [914] = {.lex_state = 17},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 17},
  [918] = {.lex_state = 17},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 17},
  [921] = {.lex_state = 17},
  [922] = {.lex_state = 17},
  [923] = {.lex_state = 17},
  [924] = {.lex_state = 17},
  [925] = {.lex_state = 17},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 17},
  [928] = {.lex_state = 17},
  [929] = {.lex_state = 17},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 17},
  [932] = {.lex_state = 17},
  [933] = {.lex_state = 17},
  [934] = {.lex_state = 17},
  [935] = {.lex_state = 17},
  [936] = {.lex_state = 17},
  [937] = {.lex_state = 17},
  [938] = {.lex_state = 17},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 17},
  [941] = {.lex_state = 17},
  [942] = {.lex_state = 17},
  [943] = {.lex_state = 17},
  [944] = {.lex_state = 17},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 17},
  [947] = {.lex_state = 17},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 17},
  [950] = {.lex_state = 17},
  [951] = {.lex_state = 17},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 17},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 17},
  [956] = {.lex_state = 17},
  [957] = {.lex_state = 17},
  [958] = {.lex_state = 17},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 17},
  [961] = {.lex_state = 17},
  [962] = {.lex_state = 17},
  [963] = {.lex_state = 17},
  [964] = {.lex_state = 17},
  [965] = {.lex_state = 17},
  [966] = {.lex_state = 17},
  [967] = {.lex_state = 17},
  [968] = {.lex_state = 17},
  [969] = {.lex_state = 17},
  [970] = {.lex_state = 17},
  [971] = {.lex_state = 17},
  [972] = {.lex_state = 17},
  [973] = {.lex_state = 17},
  [974] = {.lex_state = 17},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 17},
  [978] = {.lex_state = 17},
  [979] = {.lex_state = 17},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 17},
  [983] = {.lex_state = 17},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 17},
  [986] = {.lex_state = 17},
  [987] = {.lex_state = 17},
  [988] = {.lex_state = 17},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 17},
  [991] = {.lex_state = 17},
  [992] = {.lex_state = 17},
  [993] = {.lex_state = 17},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 17},
  [996] = {.lex_state = 17},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 17},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 17},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 17},
  [1101] = {.lex_state = 17},
  [1102] = {.lex_state = 17},
  [1103] = {.lex_state = 17},
  [1104] = {.lex_state = 17},
  [1105] = {.lex_state = 17},
  [1106] = {.lex_state = 17},
  [1107] = {.lex_state = 17},
  [1108] = {.lex_state = 17},
  [1109] = {.lex_state = 17},
  [1110] = {.lex_state = 17},
  [1111] = {.lex_state = 17},
  [1112] = {.lex_state = 17},
  [1113] = {.lex_state = 17},
  [1114] = {.lex_state = 17},
  [1115] = {.lex_state = 17},
  [1116] = {.lex_state = 17},
  [1117] = {.lex_state = 17},
  [1118] = {.lex_state = 17},
  [1119] = {.lex_state = 17},
  [1120] = {.lex_state = 17},
  [1121] = {.lex_state = 17},
  [1122] = {.lex_state = 17},
  [1123] = {.lex_state = 17},
  [1124] = {.lex_state = 17},
  [1125] = {.lex_state = 17},
  [1126] = {.lex_state = 17},
  [1127] = {.lex_state = 17},
  [1128] = {.lex_state = 17},
  [1129] = {.lex_state = 17},
  [1130] = {.lex_state = 17},
  [1131] = {.lex_state = 17},
  [1132] = {.lex_state = 17},
  [1133] = {.lex_state = 17},
  [1134] = {.lex_state = 17},
  [1135] = {.lex_state = 17},
  [1136] = {.lex_state = 17},
  [1137] = {.lex_state = 17},
  [1138] = {.lex_state = 17},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 17},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 17},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 17},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 17},
  [1153] = {.lex_state = 17},
  [1154] = {.lex_state = 17},
  [1155] = {.lex_state = 17},
  [1156] = {.lex_state = 17},
  [1157] = {.lex_state = 17},
  [1158] = {.lex_state = 17},
  [1159] = {.lex_state = 17},
  [1160] = {.lex_state = 17},
  [1161] = {.lex_state = 17},
  [1162] = {.lex_state = 17},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 17},
  [1165] = {.lex_state = 17},
  [1166] = {.lex_state = 17},
  [1167] = {.lex_state = 17},
  [1168] = {.lex_state = 17},
  [1169] = {.lex_state = 17},
  [1170] = {.lex_state = 17},
  [1171] = {.lex_state = 17},
  [1172] = {.lex_state = 17},
  [1173] = {.lex_state = 17},
  [1174] = {.lex_state = 17},
  [1175] = {.lex_state = 17},
  [1176] = {.lex_state = 17},
  [1177] = {.lex_state = 17},
  [1178] = {.lex_state = 17},
  [1179] = {.lex_state = 17},
  [1180] = {.lex_state = 17},
  [1181] = {.lex_state = 17},
  [1182] = {.lex_state = 17},
  [1183] = {.lex_state = 17},
  [1184] = {.lex_state = 17},
  [1185] = {.lex_state = 17},
  [1186] = {.lex_state = 17},
  [1187] = {.lex_state = 17},
  [1188] = {.lex_state = 17},
  [1189] = {.lex_state = 17},
  [1190] = {.lex_state = 17},
  [1191] = {.lex_state = 17},
  [1192] = {.lex_state = 17},
  [1193] = {.lex_state = 17},
  [1194] = {.lex_state = 17},
  [1195] = {.lex_state = 17},
  [1196] = {.lex_state = 17},
  [1197] = {.lex_state = 17},
  [1198] = {.lex_state = 17},
  [1199] = {.lex_state = 17},
  [1200] = {.lex_state = 17},
  [1201] = {.lex_state = 17},
  [1202] = {.lex_state = 17},
  [1203] = {.lex_state = 17},
  [1204] = {.lex_state = 17},
  [1205] = {.lex_state = 17},
  [1206] = {.lex_state = 17},
  [1207] = {.lex_state = 17},
  [1208] = {.lex_state = 17},
  [1209] = {.lex_state = 17},
  [1210] = {.lex_state = 17},
  [1211] = {.lex_state = 17},
  [1212] = {.lex_state = 17},
  [1213] = {.lex_state = 17},
  [1214] = {.lex_state = 17},
  [1215] = {.lex_state = 17},
  [1216] = {.lex_state = 17},
  [1217] = {.lex_state = 17},
  [1218] = {.lex_state = 17},
  [1219] = {.lex_state = 17},
  [1220] = {.lex_state = 17},
  [1221] = {.lex_state = 17},
  [1222] = {.lex_state = 17},
  [1223] = {.lex_state = 17},
  [1224] = {.lex_state = 17},
  [1225] = {.lex_state = 17},
  [1226] = {.lex_state = 17},
  [1227] = {.lex_state = 17},
  [1228] = {.lex_state = 17},
  [1229] = {.lex_state = 17},
  [1230] = {.lex_state = 17},
  [1231] = {.lex_state = 17},
  [1232] = {.lex_state = 17},
  [1233] = {.lex_state = 17},
  [1234] = {.lex_state = 17},
  [1235] = {.lex_state = 17},
  [1236] = {.lex_state = 17},
  [1237] = {.lex_state = 17},
  [1238] = {.lex_state = 17},
  [1239] = {.lex_state = 17},
  [1240] = {.lex_state = 17},
  [1241] = {.lex_state = 17},
  [1242] = {.lex_state = 17},
  [1243] = {.lex_state = 17},
  [1244] = {.lex_state = 17},
  [1245] = {.lex_state = 17},
  [1246] = {.lex_state = 17},
  [1247] = {.lex_state = 17},
  [1248] = {.lex_state = 17},
  [1249] = {.lex_state = 17},
  [1250] = {.lex_state = 17},
  [1251] = {.lex_state = 17},
  [1252] = {.lex_state = 17},
  [1253] = {.lex_state = 17},
  [1254] = {.lex_state = 17},
  [1255] = {.lex_state = 17},
  [1256] = {.lex_state = 17},
  [1257] = {.lex_state = 17},
  [1258] = {.lex_state = 17},
  [1259] = {.lex_state = 17},
  [1260] = {.lex_state = 17},
  [1261] = {.lex_state = 17},
  [1262] = {.lex_state = 17},
  [1263] = {.lex_state = 17},
  [1264] = {.lex_state = 17},
  [1265] = {.lex_state = 17},
  [1266] = {.lex_state = 17},
  [1267] = {.lex_state = 17},
  [1268] = {.lex_state = 17},
  [1269] = {.lex_state = 17},
  [1270] = {.lex_state = 17},
  [1271] = {.lex_state = 17},
  [1272] = {.lex_state = 17},
  [1273] = {.lex_state = 17},
  [1274] = {.lex_state = 17},
  [1275] = {.lex_state = 17},
  [1276] = {.lex_state = 17},
  [1277] = {.lex_state = 17},
  [1278] = {.lex_state = 17},
  [1279] = {.lex_state = 17},
  [1280] = {.lex_state = 17},
  [1281] = {.lex_state = 17},
  [1282] = {.lex_state = 17},
  [1283] = {.lex_state = 17},
  [1284] = {.lex_state = 17},
  [1285] = {.lex_state = 17},
  [1286] = {.lex_state = 17},
  [1287] = {.lex_state = 17},
  [1288] = {.lex_state = 17},
  [1289] = {.lex_state = 17},
  [1290] = {.lex_state = 17},
  [1291] = {.lex_state = 17},
  [1292] = {.lex_state = 17},
  [1293] = {.lex_state = 17},
  [1294] = {.lex_state = 17},
  [1295] = {.lex_state = 17},
  [1296] = {.lex_state = 17},
  [1297] = {.lex_state = 17},
  [1298] = {.lex_state = 17},
  [1299] = {.lex_state = 17},
  [1300] = {.lex_state = 17},
  [1301] = {.lex_state = 17},
  [1302] = {.lex_state = 17},
  [1303] = {.lex_state = 17},
  [1304] = {.lex_state = 17},
  [1305] = {.lex_state = 17},
  [1306] = {.lex_state = 17},
  [1307] = {.lex_state = 17},
  [1308] = {.lex_state = 17},
  [1309] = {.lex_state = 17},
  [1310] = {.lex_state = 17},
  [1311] = {.lex_state = 17},
  [1312] = {.lex_state = 17},
  [1313] = {.lex_state = 17},
  [1314] = {.lex_state = 17},
  [1315] = {.lex_state = 17},
  [1316] = {.lex_state = 17},
  [1317] = {.lex_state = 17},
  [1318] = {.lex_state = 17},
  [1319] = {.lex_state = 17},
  [1320] = {.lex_state = 17},
  [1321] = {.lex_state = 17},
  [1322] = {.lex_state = 17},
  [1323] = {.lex_state = 17},
  [1324] = {.lex_state = 17},
  [1325] = {.lex_state = 17},
  [1326] = {.lex_state = 17},
  [1327] = {.lex_state = 17},
  [1328] = {.lex_state = 17},
  [1329] = {.lex_state = 17},
  [1330] = {.lex_state = 17},
  [1331] = {.lex_state = 17},
  [1332] = {.lex_state = 17},
  [1333] = {.lex_state = 17},
  [1334] = {.lex_state = 17},
  [1335] = {.lex_state = 17},
  [1336] = {.lex_state = 17},
  [1337] = {.lex_state = 17},
  [1338] = {.lex_state = 17},
  [1339] = {.lex_state = 17},
  [1340] = {.lex_state = 17},
  [1341] = {.lex_state = 17},
  [1342] = {.lex_state = 17},
  [1343] = {.lex_state = 17},
  [1344] = {.lex_state = 17},
  [1345] = {.lex_state = 17},
  [1346] = {.lex_state = 17},
  [1347] = {.lex_state = 17},
  [1348] = {.lex_state = 17},
  [1349] = {.lex_state = 17},
  [1350] = {.lex_state = 17},
  [1351] = {.lex_state = 17},
  [1352] = {.lex_state = 17},
  [1353] = {.lex_state = 17},
  [1354] = {.lex_state = 17},
  [1355] = {.lex_state = 17},
  [1356] = {.lex_state = 17},
  [1357] = {.lex_state = 17},
  [1358] = {.lex_state = 17},
  [1359] = {.lex_state = 17},
  [1360] = {.lex_state = 17},
  [1361] = {.lex_state = 17},
  [1362] = {.lex_state = 17},
  [1363] = {.lex_state = 17},
  [1364] = {.lex_state = 17},
  [1365] = {.lex_state = 17},
  [1366] = {.lex_state = 17},
  [1367] = {.lex_state = 17},
  [1368] = {.lex_state = 17},
  [1369] = {.lex_state = 17},
  [1370] = {.lex_state = 17},
  [1371] = {.lex_state = 17},
  [1372] = {.lex_state = 17},
  [1373] = {.lex_state = 17},
  [1374] = {.lex_state = 17},
  [1375] = {.lex_state = 17},
  [1376] = {.lex_state = 17},
  [1377] = {.lex_state = 17},
  [1378] = {.lex_state = 17},
  [1379] = {.lex_state = 17},
  [1380] = {.lex_state = 17},
  [1381] = {.lex_state = 17},
  [1382] = {.lex_state = 17},
  [1383] = {.lex_state = 17},
  [1384] = {.lex_state = 17},
  [1385] = {.lex_state = 17},
  [1386] = {.lex_state = 17},
  [1387] = {.lex_state = 17},
  [1388] = {.lex_state = 17},
  [1389] = {.lex_state = 17},
  [1390] = {.lex_state = 17},
  [1391] = {.lex_state = 17},
  [1392] = {.lex_state = 17},
  [1393] = {.lex_state = 17},
  [1394] = {.lex_state = 17},
  [1395] = {.lex_state = 17},
  [1396] = {.lex_state = 17},
  [1397] = {.lex_state = 17},
  [1398] = {.lex_state = 17},
  [1399] = {.lex_state = 17},
  [1400] = {.lex_state = 17},
  [1401] = {.lex_state = 17},
  [1402] = {.lex_state = 17},
  [1403] = {.lex_state = 17},
  [1404] = {.lex_state = 17},
  [1405] = {.lex_state = 17},
  [1406] = {.lex_state = 17},
  [1407] = {.lex_state = 17},
  [1408] = {.lex_state = 17},
  [1409] = {.lex_state = 17},
  [1410] = {.lex_state = 17},
  [1411] = {.lex_state = 17},
  [1412] = {.lex_state = 17},
  [1413] = {.lex_state = 17},
  [1414] = {.lex_state = 17},
  [1415] = {.lex_state = 17},
  [1416] = {.lex_state = 17},
  [1417] = {.lex_state = 17},
  [1418] = {.lex_state = 17},
  [1419] = {.lex_state = 17},
  [1420] = {.lex_state = 17},
  [1421] = {.lex_state = 17},
  [1422] = {.lex_state = 17},
  [1423] = {.lex_state = 17},
  [1424] = {.lex_state = 17},
  [1425] = {.lex_state = 17},
  [1426] = {.lex_state = 17},
  [1427] = {.lex_state = 17},
  [1428] = {.lex_state = 17},
  [1429] = {.lex_state = 17},
  [1430] = {.lex_state = 17},
  [1431] = {.lex_state = 17},
  [1432] = {.lex_state = 17},
  [1433] = {.lex_state = 17},
  [1434] = {.lex_state = 17},
  [1435] = {.lex_state = 17},
  [1436] = {.lex_state = 17},
  [1437] = {.lex_state = 17},
  [1438] = {.lex_state = 17},
  [1439] = {.lex_state = 17},
  [1440] = {.lex_state = 17},
  [1441] = {.lex_state = 17},
  [1442] = {.lex_state = 17},
  [1443] = {.lex_state = 17},
  [1444] = {.lex_state = 17},
  [1445] = {.lex_state = 17},
  [1446] = {.lex_state = 17},
  [1447] = {.lex_state = 17},
  [1448] = {.lex_state = 17},
  [1449] = {.lex_state = 17},
  [1450] = {.lex_state = 17},
  [1451] = {.lex_state = 17},
  [1452] = {.lex_state = 17},
  [1453] = {.lex_state = 17},
  [1454] = {.lex_state = 17},
  [1455] = {.lex_state = 17},
  [1456] = {.lex_state = 17},
  [1457] = {.lex_state = 17},
  [1458] = {.lex_state = 17},
  [1459] = {.lex_state = 17},
  [1460] = {.lex_state = 17},
  [1461] = {.lex_state = 17},
  [1462] = {.lex_state = 17},
  [1463] = {.lex_state = 11},
  [1464] = {.lex_state = 17},
  [1465] = {.lex_state = 17},
  [1466] = {.lex_state = 17},
  [1467] = {.lex_state = 17},
  [1468] = {.lex_state = 17},
  [1469] = {.lex_state = 17},
  [1470] = {.lex_state = 17},
  [1471] = {.lex_state = 17},
  [1472] = {.lex_state = 17},
  [1473] = {.lex_state = 17},
  [1474] = {.lex_state = 17},
  [1475] = {.lex_state = 17},
  [1476] = {.lex_state = 17},
  [1477] = {.lex_state = 17},
  [1478] = {.lex_state = 17},
  [1479] = {.lex_state = 17},
  [1480] = {.lex_state = 17},
  [1481] = {.lex_state = 17},
  [1482] = {.lex_state = 17},
  [1483] = {.lex_state = 17},
  [1484] = {.lex_state = 17},
  [1485] = {.lex_state = 17},
  [1486] = {.lex_state = 17},
  [1487] = {.lex_state = 17},
  [1488] = {.lex_state = 17},
  [1489] = {.lex_state = 17},
  [1490] = {.lex_state = 17},
  [1491] = {.lex_state = 17},
  [1492] = {.lex_state = 17},
  [1493] = {.lex_state = 17},
  [1494] = {.lex_state = 17},
  [1495] = {.lex_state = 17},
  [1496] = {.lex_state = 17},
  [1497] = {.lex_state = 17},
  [1498] = {.lex_state = 17},
  [1499] = {.lex_state = 17},
  [1500] = {.lex_state = 17},
  [1501] = {.lex_state = 17},
  [1502] = {.lex_state = 17},
  [1503] = {.lex_state = 17},
  [1504] = {.lex_state = 17},
  [1505] = {.lex_state = 17},
  [1506] = {.lex_state = 17},
  [1507] = {.lex_state = 17},
  [1508] = {.lex_state = 17},
  [1509] = {.lex_state = 17},
  [1510] = {.lex_state = 17},
  [1511] = {.lex_state = 17},
  [1512] = {.lex_state = 17},
  [1513] = {.lex_state = 17},
  [1514] = {.lex_state = 17},
  [1515] = {.lex_state = 17},
  [1516] = {.lex_state = 17},
  [1517] = {.lex_state = 17},
  [1518] = {.lex_state = 17},
  [1519] = {.lex_state = 17},
  [1520] = {.lex_state = 17},
  [1521] = {.lex_state = 17},
  [1522] = {.lex_state = 17},
  [1523] = {.lex_state = 17},
  [1524] = {.lex_state = 17},
  [1525] = {.lex_state = 17},
  [1526] = {.lex_state = 17},
  [1527] = {.lex_state = 17},
  [1528] = {.lex_state = 17},
  [1529] = {.lex_state = 17},
  [1530] = {.lex_state = 17},
  [1531] = {.lex_state = 17},
  [1532] = {.lex_state = 17},
  [1533] = {.lex_state = 17},
  [1534] = {.lex_state = 17},
  [1535] = {.lex_state = 17},
  [1536] = {.lex_state = 17},
  [1537] = {.lex_state = 17},
  [1538] = {.lex_state = 17},
  [1539] = {.lex_state = 17},
  [1540] = {.lex_state = 17},
  [1541] = {.lex_state = 17},
  [1542] = {.lex_state = 17},
  [1543] = {.lex_state = 17},
  [1544] = {.lex_state = 17},
  [1545] = {.lex_state = 17},
  [1546] = {.lex_state = 17},
  [1547] = {.lex_state = 17},
  [1548] = {.lex_state = 17},
  [1549] = {.lex_state = 17},
  [1550] = {.lex_state = 17},
  [1551] = {.lex_state = 17},
  [1552] = {.lex_state = 17},
  [1553] = {.lex_state = 17},
  [1554] = {.lex_state = 17},
  [1555] = {.lex_state = 17},
  [1556] = {.lex_state = 17},
  [1557] = {.lex_state = 17},
  [1558] = {.lex_state = 17},
  [1559] = {.lex_state = 17},
  [1560] = {.lex_state = 17},
  [1561] = {.lex_state = 17},
  [1562] = {.lex_state = 17},
  [1563] = {.lex_state = 17},
  [1564] = {.lex_state = 17},
  [1565] = {.lex_state = 17},
  [1566] = {.lex_state = 17},
  [1567] = {.lex_state = 17},
  [1568] = {.lex_state = 17},
  [1569] = {.lex_state = 17},
  [1570] = {.lex_state = 17},
  [1571] = {.lex_state = 17},
  [1572] = {.lex_state = 17},
  [1573] = {.lex_state = 17},
  [1574] = {.lex_state = 17},
  [1575] = {.lex_state = 17},
  [1576] = {.lex_state = 17},
  [1577] = {.lex_state = 17},
  [1578] = {.lex_state = 17},
  [1579] = {.lex_state = 17},
  [1580] = {.lex_state = 17},
  [1581] = {.lex_state = 17},
  [1582] = {.lex_state = 17},
  [1583] = {.lex_state = 17},
  [1584] = {.lex_state = 17},
  [1585] = {.lex_state = 17},
  [1586] = {.lex_state = 17},
  [1587] = {.lex_state = 17},
  [1588] = {.lex_state = 17},
  [1589] = {.lex_state = 17},
  [1590] = {.lex_state = 17},
  [1591] = {.lex_state = 17},
  [1592] = {.lex_state = 17},
  [1593] = {.lex_state = 17},
  [1594] = {.lex_state = 17},
  [1595] = {.lex_state = 17},
  [1596] = {.lex_state = 17},
  [1597] = {.lex_state = 17},
  [1598] = {.lex_state = 17},
  [1599] = {.lex_state = 17},
  [1600] = {.lex_state = 17},
  [1601] = {.lex_state = 17},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__lower_id] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_newtype] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [sym_specialId] = ACTIONS(1),
    [anon_sym_exists] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_forex] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_asc] = ACTIONS(1),
    [anon_sym_desc] = ACTIONS(1),
    [anon_sym_order] = ACTIONS(1),
    [anon_sym_by] = ACTIONS(1),
    [sym_qldoc] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_date] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [sym_dbtype] = ACTIONS(1),
    [anon_sym_avg] = ACTIONS(1),
    [anon_sym_concat] = ACTIONS(1),
    [anon_sym_strictconcat] = ACTIONS(1),
    [anon_sym_count] = ACTIONS(1),
    [anon_sym_max] = ACTIONS(1),
    [anon_sym_min] = ACTIONS(1),
    [anon_sym_rank] = ACTIONS(1),
    [anon_sym_strictcount] = ACTIONS(1),
    [anon_sym_strictsum] = ACTIONS(1),
    [anon_sym_sum] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [sym__upper_id] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(5),
    [sym_false] = ACTIONS(1),
    [sym_predicate] = ACTIONS(1),
    [sym_result] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
  },
  [1] = {
    [sym_ql] = STATE(1593),
    [sym_module] = STATE(1051),
    [sym_moduleMember] = STATE(585),
    [sym_importDirective] = STATE(1051),
    [sym_classlessPredicate] = STATE(1051),
    [sym_datatype] = STATE(1051),
    [sym_select] = STATE(1051),
    [sym_dataclass] = STATE(1051),
    [sym_annotation] = STATE(594),
    [sym_annotName] = STATE(1101),
    [sym_moduleExpr] = STATE(1591),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(1411),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1409),
    [aux_sym_ql_repeat1] = STATE(585),
    [aux_sym_moduleMember_repeat1] = STATE(594),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym__lower_id] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_newtype] = ACTIONS(15),
    [anon_sym_from] = ACTIONS(17),
    [anon_sym_where] = ACTIONS(19),
    [anon_sym_select] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [sym_qldoc] = ACTIONS(25),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [sym__upper_id] = ACTIONS(31),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(5),
    [sym_predicate] = ACTIONS(33),
  },
  [2] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1522),
    [sym_expr_aggregate_body] = STATE(1522),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(39),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [3] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1569),
    [sym_expr_aggregate_body] = STATE(1569),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [4] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1465),
    [sym_expr_aggregate_body] = STATE(1465),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(71),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [5] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1446),
    [sym_expr_aggregate_body] = STATE(1446),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(73),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [6] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1503),
    [sym_expr_aggregate_body] = STATE(1503),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [7] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1483),
    [sym_expr_aggregate_body] = STATE(1483),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [8] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1537),
    [sym_expr_aggregate_body] = STATE(1537),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(79),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [9] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1511),
    [sym_expr_aggregate_body] = STATE(1511),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(81),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [10] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1598),
    [sym_expr_aggregate_body] = STATE(1598),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(83),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [11] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1555),
    [sym_expr_aggregate_body] = STATE(1555),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [12] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1458),
    [sym_expr_aggregate_body] = STATE(1458),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [13] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1455),
    [sym_expr_aggregate_body] = STATE(1455),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [14] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1512),
    [sym_expr_aggregate_body] = STATE(1512),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [15] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1513),
    [sym_expr_aggregate_body] = STATE(1513),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [16] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1601),
    [sym_expr_aggregate_body] = STATE(1601),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(95),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [17] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1514),
    [sym_expr_aggregate_body] = STATE(1514),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(97),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [18] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1561),
    [sym_expr_aggregate_body] = STATE(1561),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(99),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [19] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1583),
    [sym_expr_aggregate_body] = STATE(1583),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [20] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1584),
    [sym_expr_aggregate_body] = STATE(1584),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(103),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [21] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1566),
    [sym_expr_aggregate_body] = STATE(1566),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(105),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [22] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_full_aggregate_body] = STATE(1580),
    [sym_expr_aggregate_body] = STATE(1580),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_varDecl] = STATE(1229),
    [sym_asExprs] = STATE(1277),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1185),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [23] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1260),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1283),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(113),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [24] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1270),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1336),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(139),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(141),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [25] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1349),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1312),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(145),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(147),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [26] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1346),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1377),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(151),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(153),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(155),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [27] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1387),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1391),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(159),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [28] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1303),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1355),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(163),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(165),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(167),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [29] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1298),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1321),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(169),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(171),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(173),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [30] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1400),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(175),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [31] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1370),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(179),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(181),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [32] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1259),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(185),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [33] = {
    [sym_special_call] = STATE(924),
    [sym_prefix_cast] = STATE(924),
    [sym_unary_expr] = STATE(924),
    [sym_mul_expr] = STATE(924),
    [sym_add_expr] = STATE(924),
    [sym_in_expr] = STATE(924),
    [sym_comp_term] = STATE(924),
    [sym_instance_of] = STATE(924),
    [sym_negation] = STATE(924),
    [sym_if_term] = STATE(924),
    [sym_conjunction] = STATE(924),
    [sym_disjunction] = STATE(924),
    [sym_implication] = STATE(924),
    [sym_quantified] = STATE(924),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(924),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1227),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(189),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [34] = {
    [sym_special_call] = STATE(983),
    [sym_prefix_cast] = STATE(983),
    [sym_unary_expr] = STATE(983),
    [sym_mul_expr] = STATE(983),
    [sym_add_expr] = STATE(983),
    [sym_in_expr] = STATE(983),
    [sym_comp_term] = STATE(983),
    [sym_instance_of] = STATE(983),
    [sym_negation] = STATE(983),
    [sym_if_term] = STATE(983),
    [sym_conjunction] = STATE(983),
    [sym_disjunction] = STATE(983),
    [sym_implication] = STATE(983),
    [sym_quantified] = STATE(983),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(983),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1232),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(193),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [35] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1326),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [36] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1310),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(199),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(201),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [37] = {
    [sym_special_call] = STATE(960),
    [sym_prefix_cast] = STATE(960),
    [sym_unary_expr] = STATE(960),
    [sym_mul_expr] = STATE(960),
    [sym_add_expr] = STATE(960),
    [sym_in_expr] = STATE(960),
    [sym_comp_term] = STATE(960),
    [sym_instance_of] = STATE(960),
    [sym_negation] = STATE(960),
    [sym_if_term] = STATE(960),
    [sym_conjunction] = STATE(960),
    [sym_disjunction] = STATE(960),
    [sym_implication] = STATE(960),
    [sym_quantified] = STATE(960),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(960),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1226),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(205),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [38] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1288),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(207),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [39] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1295),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(211),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(213),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [40] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1319),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(215),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(217),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [41] = {
    [sym_special_call] = STATE(877),
    [sym_prefix_cast] = STATE(877),
    [sym_unary_expr] = STATE(877),
    [sym_mul_expr] = STATE(877),
    [sym_add_expr] = STATE(877),
    [sym_in_expr] = STATE(877),
    [sym_comp_term] = STATE(877),
    [sym_instance_of] = STATE(877),
    [sym_negation] = STATE(877),
    [sym_if_term] = STATE(877),
    [sym_conjunction] = STATE(877),
    [sym_disjunction] = STATE(877),
    [sym_implication] = STATE(877),
    [sym_quantified] = STATE(877),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(877),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1204),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(219),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(221),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [42] = {
    [sym_special_call] = STATE(987),
    [sym_prefix_cast] = STATE(987),
    [sym_unary_expr] = STATE(987),
    [sym_mul_expr] = STATE(987),
    [sym_add_expr] = STATE(987),
    [sym_in_expr] = STATE(987),
    [sym_comp_term] = STATE(987),
    [sym_instance_of] = STATE(987),
    [sym_negation] = STATE(987),
    [sym_if_term] = STATE(987),
    [sym_conjunction] = STATE(987),
    [sym_disjunction] = STATE(987),
    [sym_implication] = STATE(987),
    [sym_quantified] = STATE(987),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(987),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1195),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(225),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [43] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1268),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(227),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(229),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [44] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1361),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(231),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(233),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [45] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1331),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(235),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [46] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1385),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(239),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(241),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [47] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1357),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(243),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [48] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1280),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(249),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [49] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1284),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(251),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(253),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [50] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1341),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(255),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(257),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [51] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1354),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(261),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [52] = {
    [sym_special_call] = STATE(911),
    [sym_prefix_cast] = STATE(911),
    [sym_unary_expr] = STATE(911),
    [sym_mul_expr] = STATE(911),
    [sym_add_expr] = STATE(911),
    [sym_in_expr] = STATE(911),
    [sym_comp_term] = STATE(911),
    [sym_instance_of] = STATE(911),
    [sym_negation] = STATE(911),
    [sym_if_term] = STATE(911),
    [sym_conjunction] = STATE(911),
    [sym_disjunction] = STATE(911),
    [sym_implication] = STATE(911),
    [sym_quantified] = STATE(911),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(911),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1205),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(263),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(265),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [53] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1360),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(267),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(269),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [54] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1296),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(271),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [55] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1364),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [56] = {
    [sym_special_call] = STATE(953),
    [sym_prefix_cast] = STATE(953),
    [sym_unary_expr] = STATE(953),
    [sym_mul_expr] = STATE(953),
    [sym_add_expr] = STATE(953),
    [sym_in_expr] = STATE(953),
    [sym_comp_term] = STATE(953),
    [sym_instance_of] = STATE(953),
    [sym_negation] = STATE(953),
    [sym_if_term] = STATE(953),
    [sym_conjunction] = STATE(953),
    [sym_disjunction] = STATE(953),
    [sym_implication] = STATE(953),
    [sym_quantified] = STATE(953),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(953),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_varDecl] = STATE(1244),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1179),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(279),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(281),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [57] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1581),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [58] = {
    [sym_special_call] = STATE(734),
    [sym_prefix_cast] = STATE(734),
    [sym_unary_expr] = STATE(734),
    [sym_mul_expr] = STATE(734),
    [sym_add_expr] = STATE(734),
    [sym_in_expr] = STATE(734),
    [sym_comp_term] = STATE(734),
    [sym_instance_of] = STATE(734),
    [sym_negation] = STATE(734),
    [sym_if_term] = STATE(734),
    [sym_conjunction] = STATE(734),
    [sym_disjunction] = STATE(734),
    [sym_implication] = STATE(734),
    [sym_quantified] = STATE(734),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(734),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(283),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(285),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [59] = {
    [sym_special_call] = STATE(842),
    [sym_prefix_cast] = STATE(842),
    [sym_unary_expr] = STATE(842),
    [sym_mul_expr] = STATE(842),
    [sym_add_expr] = STATE(842),
    [sym_in_expr] = STATE(842),
    [sym_comp_term] = STATE(842),
    [sym_instance_of] = STATE(842),
    [sym_negation] = STATE(842),
    [sym_if_term] = STATE(842),
    [sym_conjunction] = STATE(842),
    [sym_disjunction] = STATE(842),
    [sym_implication] = STATE(842),
    [sym_quantified] = STATE(842),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(842),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(287),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(289),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [60] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1501),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [61] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1547),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [62] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1504),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [63] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1520),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [64] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_asExprs] = STATE(919),
    [sym_asExpr] = STATE(851),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [65] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1540),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [66] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_asExprs] = STATE(1313),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [67] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_asExprs] = STATE(994),
    [sym_asExpr] = STATE(851),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [68] = {
    [sym_special_call] = STATE(814),
    [sym_prefix_cast] = STATE(814),
    [sym_unary_expr] = STATE(814),
    [sym_mul_expr] = STATE(814),
    [sym_add_expr] = STATE(814),
    [sym_in_expr] = STATE(814),
    [sym_comp_term] = STATE(814),
    [sym_instance_of] = STATE(814),
    [sym_negation] = STATE(814),
    [sym_if_term] = STATE(814),
    [sym_conjunction] = STATE(814),
    [sym_disjunction] = STATE(814),
    [sym_implication] = STATE(814),
    [sym_quantified] = STATE(814),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(814),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(315),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(317),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [69] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1579),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [70] = {
    [sym_special_call] = STATE(858),
    [sym_prefix_cast] = STATE(858),
    [sym_unary_expr] = STATE(858),
    [sym_mul_expr] = STATE(858),
    [sym_add_expr] = STATE(858),
    [sym_in_expr] = STATE(858),
    [sym_comp_term] = STATE(858),
    [sym_instance_of] = STATE(858),
    [sym_negation] = STATE(858),
    [sym_if_term] = STATE(858),
    [sym_conjunction] = STATE(858),
    [sym_disjunction] = STATE(858),
    [sym_implication] = STATE(858),
    [sym_quantified] = STATE(858),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(858),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(321),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [71] = {
    [sym_special_call] = STATE(800),
    [sym_prefix_cast] = STATE(800),
    [sym_unary_expr] = STATE(800),
    [sym_mul_expr] = STATE(800),
    [sym_add_expr] = STATE(800),
    [sym_in_expr] = STATE(800),
    [sym_comp_term] = STATE(800),
    [sym_instance_of] = STATE(800),
    [sym_negation] = STATE(800),
    [sym_if_term] = STATE(800),
    [sym_conjunction] = STATE(800),
    [sym_disjunction] = STATE(800),
    [sym_implication] = STATE(800),
    [sym_quantified] = STATE(800),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(800),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(323),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(325),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [72] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1585),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [73] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_asExprs] = STATE(1304),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [74] = {
    [sym_special_call] = STATE(788),
    [sym_prefix_cast] = STATE(788),
    [sym_unary_expr] = STATE(788),
    [sym_mul_expr] = STATE(788),
    [sym_add_expr] = STATE(788),
    [sym_in_expr] = STATE(788),
    [sym_comp_term] = STATE(788),
    [sym_instance_of] = STATE(788),
    [sym_negation] = STATE(788),
    [sym_if_term] = STATE(788),
    [sym_conjunction] = STATE(788),
    [sym_disjunction] = STATE(788),
    [sym_implication] = STATE(788),
    [sym_quantified] = STATE(788),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(788),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(327),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(329),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [75] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1596),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [76] = {
    [sym_special_call] = STATE(774),
    [sym_prefix_cast] = STATE(774),
    [sym_unary_expr] = STATE(774),
    [sym_mul_expr] = STATE(774),
    [sym_add_expr] = STATE(774),
    [sym_in_expr] = STATE(774),
    [sym_comp_term] = STATE(774),
    [sym_instance_of] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_if_term] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_implication] = STATE(774),
    [sym_quantified] = STATE(774),
    [sym_quantifier] = STATE(1536),
    [sym__call_arg] = STATE(1443),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(774),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [77] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1529),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [78] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1475),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [79] = {
    [sym_special_call] = STATE(870),
    [sym_prefix_cast] = STATE(870),
    [sym_unary_expr] = STATE(870),
    [sym_mul_expr] = STATE(870),
    [sym_add_expr] = STATE(870),
    [sym_in_expr] = STATE(870),
    [sym_comp_term] = STATE(870),
    [sym_instance_of] = STATE(870),
    [sym_negation] = STATE(870),
    [sym_if_term] = STATE(870),
    [sym_conjunction] = STATE(870),
    [sym_disjunction] = STATE(870),
    [sym_implication] = STATE(870),
    [sym_quantified] = STATE(870),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(870),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(335),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [80] = {
    [sym_special_call] = STATE(351),
    [sym_prefix_cast] = STATE(351),
    [sym_unary_expr] = STATE(351),
    [sym_mul_expr] = STATE(351),
    [sym_add_expr] = STATE(351),
    [sym_in_expr] = STATE(351),
    [sym_comp_term] = STATE(351),
    [sym_instance_of] = STATE(351),
    [sym_negation] = STATE(351),
    [sym_if_term] = STATE(351),
    [sym_conjunction] = STATE(351),
    [sym_disjunction] = STATE(351),
    [sym_implication] = STATE(351),
    [sym_quantified] = STATE(351),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(351),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_asExprs] = STATE(984),
    [sym_asExpr] = STATE(811),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [81] = {
    [sym_special_call] = STATE(726),
    [sym_prefix_cast] = STATE(726),
    [sym_unary_expr] = STATE(726),
    [sym_mul_expr] = STATE(726),
    [sym_add_expr] = STATE(726),
    [sym_in_expr] = STATE(726),
    [sym_comp_term] = STATE(726),
    [sym_instance_of] = STATE(726),
    [sym_negation] = STATE(726),
    [sym_if_term] = STATE(726),
    [sym_conjunction] = STATE(726),
    [sym_disjunction] = STATE(726),
    [sym_implication] = STATE(726),
    [sym_quantified] = STATE(726),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(726),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(361),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(363),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [82] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_asExprs] = STATE(884),
    [sym_asExpr] = STATE(851),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [83] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1595),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [84] = {
    [sym_special_call] = STATE(822),
    [sym_prefix_cast] = STATE(822),
    [sym_unary_expr] = STATE(822),
    [sym_mul_expr] = STATE(822),
    [sym_add_expr] = STATE(822),
    [sym_in_expr] = STATE(822),
    [sym_comp_term] = STATE(822),
    [sym_instance_of] = STATE(822),
    [sym_negation] = STATE(822),
    [sym_if_term] = STATE(822),
    [sym_conjunction] = STATE(822),
    [sym_disjunction] = STATE(822),
    [sym_implication] = STATE(822),
    [sym_quantified] = STATE(822),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(822),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(365),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(367),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [85] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1582),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [86] = {
    [sym_special_call] = STATE(739),
    [sym_prefix_cast] = STATE(739),
    [sym_unary_expr] = STATE(739),
    [sym_mul_expr] = STATE(739),
    [sym_add_expr] = STATE(739),
    [sym_in_expr] = STATE(739),
    [sym_comp_term] = STATE(739),
    [sym_instance_of] = STATE(739),
    [sym_negation] = STATE(739),
    [sym_if_term] = STATE(739),
    [sym_conjunction] = STATE(739),
    [sym_disjunction] = STATE(739),
    [sym_implication] = STATE(739),
    [sym_quantified] = STATE(739),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(739),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(369),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(371),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [87] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1571),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [88] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_asExprs] = STATE(930),
    [sym_asExpr] = STATE(851),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [89] = {
    [sym_special_call] = STATE(727),
    [sym_prefix_cast] = STATE(727),
    [sym_unary_expr] = STATE(727),
    [sym_mul_expr] = STATE(727),
    [sym_add_expr] = STATE(727),
    [sym_in_expr] = STATE(727),
    [sym_comp_term] = STATE(727),
    [sym_instance_of] = STATE(727),
    [sym_negation] = STATE(727),
    [sym_if_term] = STATE(727),
    [sym_conjunction] = STATE(727),
    [sym_disjunction] = STATE(727),
    [sym_implication] = STATE(727),
    [sym_quantified] = STATE(727),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(727),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(373),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(375),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [90] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1567),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [91] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1461),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [92] = {
    [sym_special_call] = STATE(740),
    [sym_prefix_cast] = STATE(740),
    [sym_unary_expr] = STATE(740),
    [sym_mul_expr] = STATE(740),
    [sym_add_expr] = STATE(740),
    [sym_in_expr] = STATE(740),
    [sym_comp_term] = STATE(740),
    [sym_instance_of] = STATE(740),
    [sym_negation] = STATE(740),
    [sym_if_term] = STATE(740),
    [sym_conjunction] = STATE(740),
    [sym_disjunction] = STATE(740),
    [sym_implication] = STATE(740),
    [sym_quantified] = STATE(740),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(740),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(377),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(379),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [93] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_asExprs] = STATE(1348),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [94] = {
    [sym_special_call] = STATE(351),
    [sym_prefix_cast] = STATE(351),
    [sym_unary_expr] = STATE(351),
    [sym_mul_expr] = STATE(351),
    [sym_add_expr] = STATE(351),
    [sym_in_expr] = STATE(351),
    [sym_comp_term] = STATE(351),
    [sym_instance_of] = STATE(351),
    [sym_negation] = STATE(351),
    [sym_if_term] = STATE(351),
    [sym_conjunction] = STATE(351),
    [sym_disjunction] = STATE(351),
    [sym_implication] = STATE(351),
    [sym_quantified] = STATE(351),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(351),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_asExprs] = STATE(916),
    [sym_asExpr] = STATE(811),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [95] = {
    [sym_special_call] = STATE(849),
    [sym_prefix_cast] = STATE(849),
    [sym_unary_expr] = STATE(849),
    [sym_mul_expr] = STATE(849),
    [sym_add_expr] = STATE(849),
    [sym_in_expr] = STATE(849),
    [sym_comp_term] = STATE(849),
    [sym_instance_of] = STATE(849),
    [sym_negation] = STATE(849),
    [sym_if_term] = STATE(849),
    [sym_conjunction] = STATE(849),
    [sym_disjunction] = STATE(849),
    [sym_implication] = STATE(849),
    [sym_quantified] = STATE(849),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(849),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(381),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(383),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [96] = {
    [sym_special_call] = STATE(861),
    [sym_prefix_cast] = STATE(861),
    [sym_unary_expr] = STATE(861),
    [sym_mul_expr] = STATE(861),
    [sym_add_expr] = STATE(861),
    [sym_in_expr] = STATE(861),
    [sym_comp_term] = STATE(861),
    [sym_instance_of] = STATE(861),
    [sym_negation] = STATE(861),
    [sym_if_term] = STATE(861),
    [sym_conjunction] = STATE(861),
    [sym_disjunction] = STATE(861),
    [sym_implication] = STATE(861),
    [sym_quantified] = STATE(861),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(861),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(385),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(387),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [97] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1600),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [98] = {
    [sym_special_call] = STATE(830),
    [sym_prefix_cast] = STATE(830),
    [sym_unary_expr] = STATE(830),
    [sym_mul_expr] = STATE(830),
    [sym_add_expr] = STATE(830),
    [sym_in_expr] = STATE(830),
    [sym_comp_term] = STATE(830),
    [sym_instance_of] = STATE(830),
    [sym_negation] = STATE(830),
    [sym_if_term] = STATE(830),
    [sym_conjunction] = STATE(830),
    [sym_disjunction] = STATE(830),
    [sym_implication] = STATE(830),
    [sym_quantified] = STATE(830),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(830),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(389),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(391),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [99] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1456),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [100] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1478),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [101] = {
    [sym_special_call] = STATE(733),
    [sym_prefix_cast] = STATE(733),
    [sym_unary_expr] = STATE(733),
    [sym_mul_expr] = STATE(733),
    [sym_add_expr] = STATE(733),
    [sym_in_expr] = STATE(733),
    [sym_comp_term] = STATE(733),
    [sym_instance_of] = STATE(733),
    [sym_negation] = STATE(733),
    [sym_if_term] = STATE(733),
    [sym_conjunction] = STATE(733),
    [sym_disjunction] = STATE(733),
    [sym_implication] = STATE(733),
    [sym_quantified] = STATE(733),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(733),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(395),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [102] = {
    [sym_special_call] = STATE(790),
    [sym_prefix_cast] = STATE(790),
    [sym_unary_expr] = STATE(790),
    [sym_mul_expr] = STATE(790),
    [sym_add_expr] = STATE(790),
    [sym_in_expr] = STATE(790),
    [sym_comp_term] = STATE(790),
    [sym_instance_of] = STATE(790),
    [sym_negation] = STATE(790),
    [sym_if_term] = STATE(790),
    [sym_conjunction] = STATE(790),
    [sym_disjunction] = STATE(790),
    [sym_implication] = STATE(790),
    [sym_quantified] = STATE(790),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(790),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(397),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(399),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [103] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_asExprs] = STATE(904),
    [sym_asExpr] = STATE(851),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [104] = {
    [sym_special_call] = STATE(752),
    [sym_prefix_cast] = STATE(752),
    [sym_unary_expr] = STATE(752),
    [sym_mul_expr] = STATE(752),
    [sym_add_expr] = STATE(752),
    [sym_in_expr] = STATE(752),
    [sym_comp_term] = STATE(752),
    [sym_instance_of] = STATE(752),
    [sym_negation] = STATE(752),
    [sym_if_term] = STATE(752),
    [sym_conjunction] = STATE(752),
    [sym_disjunction] = STATE(752),
    [sym_implication] = STATE(752),
    [sym_quantified] = STATE(752),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(752),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(401),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(403),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [105] = {
    [sym_special_call] = STATE(725),
    [sym_prefix_cast] = STATE(725),
    [sym_unary_expr] = STATE(725),
    [sym_mul_expr] = STATE(725),
    [sym_add_expr] = STATE(725),
    [sym_in_expr] = STATE(725),
    [sym_comp_term] = STATE(725),
    [sym_instance_of] = STATE(725),
    [sym_negation] = STATE(725),
    [sym_if_term] = STATE(725),
    [sym_conjunction] = STATE(725),
    [sym_disjunction] = STATE(725),
    [sym_implication] = STATE(725),
    [sym_quantified] = STATE(725),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(725),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(405),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(407),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [106] = {
    [sym_special_call] = STATE(351),
    [sym_prefix_cast] = STATE(351),
    [sym_unary_expr] = STATE(351),
    [sym_mul_expr] = STATE(351),
    [sym_add_expr] = STATE(351),
    [sym_in_expr] = STATE(351),
    [sym_comp_term] = STATE(351),
    [sym_instance_of] = STATE(351),
    [sym_negation] = STATE(351),
    [sym_if_term] = STATE(351),
    [sym_conjunction] = STATE(351),
    [sym_disjunction] = STATE(351),
    [sym_implication] = STATE(351),
    [sym_quantified] = STATE(351),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(351),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_asExprs] = STATE(897),
    [sym_asExpr] = STATE(811),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [107] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1523),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [108] = {
    [sym_special_call] = STATE(742),
    [sym_prefix_cast] = STATE(742),
    [sym_unary_expr] = STATE(742),
    [sym_mul_expr] = STATE(742),
    [sym_add_expr] = STATE(742),
    [sym_in_expr] = STATE(742),
    [sym_comp_term] = STATE(742),
    [sym_instance_of] = STATE(742),
    [sym_negation] = STATE(742),
    [sym_if_term] = STATE(742),
    [sym_conjunction] = STATE(742),
    [sym_disjunction] = STATE(742),
    [sym_implication] = STATE(742),
    [sym_quantified] = STATE(742),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(742),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(409),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(411),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [109] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1448),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [110] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1516),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [111] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_asExprs] = STATE(1324),
    [sym_asExpr] = STATE(1211),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [112] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1502),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [113] = {
    [sym_special_call] = STATE(351),
    [sym_prefix_cast] = STATE(351),
    [sym_unary_expr] = STATE(351),
    [sym_mul_expr] = STATE(351),
    [sym_add_expr] = STATE(351),
    [sym_in_expr] = STATE(351),
    [sym_comp_term] = STATE(351),
    [sym_instance_of] = STATE(351),
    [sym_negation] = STATE(351),
    [sym_if_term] = STATE(351),
    [sym_conjunction] = STATE(351),
    [sym_disjunction] = STATE(351),
    [sym_implication] = STATE(351),
    [sym_quantified] = STATE(351),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(351),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_asExprs] = STATE(975),
    [sym_asExpr] = STATE(811),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [114] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1563),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [115] = {
    [sym_special_call] = STATE(784),
    [sym_prefix_cast] = STATE(784),
    [sym_unary_expr] = STATE(784),
    [sym_mul_expr] = STATE(784),
    [sym_add_expr] = STATE(784),
    [sym_in_expr] = STATE(784),
    [sym_comp_term] = STATE(784),
    [sym_instance_of] = STATE(784),
    [sym_negation] = STATE(784),
    [sym_if_term] = STATE(784),
    [sym_conjunction] = STATE(784),
    [sym_disjunction] = STATE(784),
    [sym_implication] = STATE(784),
    [sym_quantified] = STATE(784),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(784),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(413),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(415),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [116] = {
    [sym_special_call] = STATE(351),
    [sym_prefix_cast] = STATE(351),
    [sym_unary_expr] = STATE(351),
    [sym_mul_expr] = STATE(351),
    [sym_add_expr] = STATE(351),
    [sym_in_expr] = STATE(351),
    [sym_comp_term] = STATE(351),
    [sym_instance_of] = STATE(351),
    [sym_negation] = STATE(351),
    [sym_if_term] = STATE(351),
    [sym_conjunction] = STATE(351),
    [sym_disjunction] = STATE(351),
    [sym_implication] = STATE(351),
    [sym_quantified] = STATE(351),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(351),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_asExprs] = STATE(980),
    [sym_asExpr] = STATE(811),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [117] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1493),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [118] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1459),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [119] = {
    [sym_special_call] = STATE(351),
    [sym_prefix_cast] = STATE(351),
    [sym_unary_expr] = STATE(351),
    [sym_mul_expr] = STATE(351),
    [sym_add_expr] = STATE(351),
    [sym_in_expr] = STATE(351),
    [sym_comp_term] = STATE(351),
    [sym_instance_of] = STATE(351),
    [sym_negation] = STATE(351),
    [sym_if_term] = STATE(351),
    [sym_conjunction] = STATE(351),
    [sym_disjunction] = STATE(351),
    [sym_implication] = STATE(351),
    [sym_quantified] = STATE(351),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(351),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_asExprs] = STATE(976),
    [sym_asExpr] = STATE(811),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [120] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_asExprs] = STATE(888),
    [sym_asExpr] = STATE(851),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [121] = {
    [sym_special_call] = STATE(759),
    [sym_prefix_cast] = STATE(759),
    [sym_unary_expr] = STATE(759),
    [sym_mul_expr] = STATE(759),
    [sym_add_expr] = STATE(759),
    [sym_in_expr] = STATE(759),
    [sym_comp_term] = STATE(759),
    [sym_instance_of] = STATE(759),
    [sym_negation] = STATE(759),
    [sym_if_term] = STATE(759),
    [sym_conjunction] = STATE(759),
    [sym_disjunction] = STATE(759),
    [sym_implication] = STATE(759),
    [sym_quantified] = STATE(759),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(759),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(417),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(419),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [122] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1505),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [123] = {
    [sym_special_call] = STATE(770),
    [sym_prefix_cast] = STATE(770),
    [sym_unary_expr] = STATE(770),
    [sym_mul_expr] = STATE(770),
    [sym_add_expr] = STATE(770),
    [sym_in_expr] = STATE(770),
    [sym_comp_term] = STATE(770),
    [sym_instance_of] = STATE(770),
    [sym_negation] = STATE(770),
    [sym_if_term] = STATE(770),
    [sym_conjunction] = STATE(770),
    [sym_disjunction] = STATE(770),
    [sym_implication] = STATE(770),
    [sym_quantified] = STATE(770),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(770),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(423),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [124] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExprs] = STATE(1474),
    [sym_asExpr] = STATE(1261),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [125] = {
    [sym_special_call] = STATE(862),
    [sym_prefix_cast] = STATE(862),
    [sym_unary_expr] = STATE(862),
    [sym_mul_expr] = STATE(862),
    [sym_add_expr] = STATE(862),
    [sym_in_expr] = STATE(862),
    [sym_comp_term] = STATE(862),
    [sym_instance_of] = STATE(862),
    [sym_negation] = STATE(862),
    [sym_if_term] = STATE(862),
    [sym_conjunction] = STATE(862),
    [sym_disjunction] = STATE(862),
    [sym_implication] = STATE(862),
    [sym_quantified] = STATE(862),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(862),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(425),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(427),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [126] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_asExpr] = STATE(909),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [127] = {
    [sym_special_call] = STATE(690),
    [sym_prefix_cast] = STATE(690),
    [sym_unary_expr] = STATE(690),
    [sym_mul_expr] = STATE(690),
    [sym_add_expr] = STATE(690),
    [sym_in_expr] = STATE(690),
    [sym_comp_term] = STATE(690),
    [sym_instance_of] = STATE(690),
    [sym_negation] = STATE(690),
    [sym_if_term] = STATE(690),
    [sym_conjunction] = STATE(690),
    [sym_disjunction] = STATE(690),
    [sym_implication] = STATE(690),
    [sym_quantified] = STATE(690),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(690),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(435),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [128] = {
    [sym_special_call] = STATE(682),
    [sym_prefix_cast] = STATE(682),
    [sym_unary_expr] = STATE(682),
    [sym_mul_expr] = STATE(682),
    [sym_add_expr] = STATE(682),
    [sym_in_expr] = STATE(682),
    [sym_comp_term] = STATE(682),
    [sym_instance_of] = STATE(682),
    [sym_negation] = STATE(682),
    [sym_if_term] = STATE(682),
    [sym_conjunction] = STATE(682),
    [sym_disjunction] = STATE(682),
    [sym_implication] = STATE(682),
    [sym_quantified] = STATE(682),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(682),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(439),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [129] = {
    [sym_special_call] = STATE(665),
    [sym_prefix_cast] = STATE(665),
    [sym_unary_expr] = STATE(665),
    [sym_mul_expr] = STATE(665),
    [sym_add_expr] = STATE(665),
    [sym_in_expr] = STATE(665),
    [sym_comp_term] = STATE(665),
    [sym_instance_of] = STATE(665),
    [sym_negation] = STATE(665),
    [sym_if_term] = STATE(665),
    [sym_conjunction] = STATE(665),
    [sym_disjunction] = STATE(665),
    [sym_implication] = STATE(665),
    [sym_quantified] = STATE(665),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(665),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_asExpr] = STATE(1272),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [130] = {
    [sym_special_call] = STATE(701),
    [sym_prefix_cast] = STATE(701),
    [sym_unary_expr] = STATE(701),
    [sym_mul_expr] = STATE(701),
    [sym_add_expr] = STATE(701),
    [sym_in_expr] = STATE(701),
    [sym_comp_term] = STATE(701),
    [sym_instance_of] = STATE(701),
    [sym_negation] = STATE(701),
    [sym_if_term] = STATE(701),
    [sym_conjunction] = STATE(701),
    [sym_disjunction] = STATE(701),
    [sym_implication] = STATE(701),
    [sym_quantified] = STATE(701),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(701),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [131] = {
    [sym_special_call] = STATE(663),
    [sym_prefix_cast] = STATE(663),
    [sym_unary_expr] = STATE(663),
    [sym_mul_expr] = STATE(663),
    [sym_add_expr] = STATE(663),
    [sym_in_expr] = STATE(663),
    [sym_comp_term] = STATE(663),
    [sym_instance_of] = STATE(663),
    [sym_negation] = STATE(663),
    [sym_if_term] = STATE(663),
    [sym_conjunction] = STATE(663),
    [sym_disjunction] = STATE(663),
    [sym_implication] = STATE(663),
    [sym_quantified] = STATE(663),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(663),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_orderBy] = STATE(1271),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [132] = {
    [sym_special_call] = STATE(331),
    [sym_prefix_cast] = STATE(331),
    [sym_unary_expr] = STATE(331),
    [sym_mul_expr] = STATE(331),
    [sym_add_expr] = STATE(331),
    [sym_in_expr] = STATE(331),
    [sym_comp_term] = STATE(331),
    [sym_instance_of] = STATE(331),
    [sym_negation] = STATE(331),
    [sym_if_term] = STATE(331),
    [sym_conjunction] = STATE(331),
    [sym_disjunction] = STATE(331),
    [sym_implication] = STATE(331),
    [sym_quantified] = STATE(331),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(331),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_orderBy] = STATE(1025),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [133] = {
    [sym_special_call] = STATE(331),
    [sym_prefix_cast] = STATE(331),
    [sym_unary_expr] = STATE(331),
    [sym_mul_expr] = STATE(331),
    [sym_add_expr] = STATE(331),
    [sym_in_expr] = STATE(331),
    [sym_comp_term] = STATE(331),
    [sym_instance_of] = STATE(331),
    [sym_negation] = STATE(331),
    [sym_if_term] = STATE(331),
    [sym_conjunction] = STATE(331),
    [sym_disjunction] = STATE(331),
    [sym_implication] = STATE(331),
    [sym_quantified] = STATE(331),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(331),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_orderBy] = STATE(959),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [134] = {
    [sym_special_call] = STATE(680),
    [sym_prefix_cast] = STATE(680),
    [sym_unary_expr] = STATE(680),
    [sym_mul_expr] = STATE(680),
    [sym_add_expr] = STATE(680),
    [sym_in_expr] = STATE(680),
    [sym_comp_term] = STATE(680),
    [sym_instance_of] = STATE(680),
    [sym_negation] = STATE(680),
    [sym_if_term] = STATE(680),
    [sym_conjunction] = STATE(680),
    [sym_disjunction] = STATE(680),
    [sym_implication] = STATE(680),
    [sym_quantified] = STATE(680),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(680),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [135] = {
    [sym_special_call] = STATE(711),
    [sym_prefix_cast] = STATE(711),
    [sym_unary_expr] = STATE(711),
    [sym_mul_expr] = STATE(711),
    [sym_add_expr] = STATE(711),
    [sym_in_expr] = STATE(711),
    [sym_comp_term] = STATE(711),
    [sym_instance_of] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_if_term] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_implication] = STATE(711),
    [sym_quantified] = STATE(711),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(711),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_asExpr] = STATE(1272),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [136] = {
    [sym_special_call] = STATE(697),
    [sym_prefix_cast] = STATE(697),
    [sym_unary_expr] = STATE(697),
    [sym_mul_expr] = STATE(697),
    [sym_add_expr] = STATE(697),
    [sym_in_expr] = STATE(697),
    [sym_comp_term] = STATE(697),
    [sym_instance_of] = STATE(697),
    [sym_negation] = STATE(697),
    [sym_if_term] = STATE(697),
    [sym_conjunction] = STATE(697),
    [sym_disjunction] = STATE(697),
    [sym_implication] = STATE(697),
    [sym_quantified] = STATE(697),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(697),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [137] = {
    [sym_special_call] = STATE(330),
    [sym_prefix_cast] = STATE(330),
    [sym_unary_expr] = STATE(330),
    [sym_mul_expr] = STATE(330),
    [sym_add_expr] = STATE(330),
    [sym_in_expr] = STATE(330),
    [sym_comp_term] = STATE(330),
    [sym_instance_of] = STATE(330),
    [sym_negation] = STATE(330),
    [sym_if_term] = STATE(330),
    [sym_conjunction] = STATE(330),
    [sym_disjunction] = STATE(330),
    [sym_implication] = STATE(330),
    [sym_quantified] = STATE(330),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(330),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_orderBy] = STATE(1009),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [138] = {
    [sym_special_call] = STATE(330),
    [sym_prefix_cast] = STATE(330),
    [sym_unary_expr] = STATE(330),
    [sym_mul_expr] = STATE(330),
    [sym_add_expr] = STATE(330),
    [sym_in_expr] = STATE(330),
    [sym_comp_term] = STATE(330),
    [sym_instance_of] = STATE(330),
    [sym_negation] = STATE(330),
    [sym_if_term] = STATE(330),
    [sym_conjunction] = STATE(330),
    [sym_disjunction] = STATE(330),
    [sym_implication] = STATE(330),
    [sym_quantified] = STATE(330),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(330),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_orderBy] = STATE(926),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [139] = {
    [sym_special_call] = STATE(351),
    [sym_prefix_cast] = STATE(351),
    [sym_unary_expr] = STATE(351),
    [sym_mul_expr] = STATE(351),
    [sym_add_expr] = STATE(351),
    [sym_in_expr] = STATE(351),
    [sym_comp_term] = STATE(351),
    [sym_instance_of] = STATE(351),
    [sym_negation] = STATE(351),
    [sym_if_term] = STATE(351),
    [sym_conjunction] = STATE(351),
    [sym_disjunction] = STATE(351),
    [sym_implication] = STATE(351),
    [sym_quantified] = STATE(351),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(351),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_asExpr] = STATE(878),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [140] = {
    [sym_special_call] = STATE(667),
    [sym_prefix_cast] = STATE(667),
    [sym_unary_expr] = STATE(667),
    [sym_mul_expr] = STATE(667),
    [sym_add_expr] = STATE(667),
    [sym_in_expr] = STATE(667),
    [sym_comp_term] = STATE(667),
    [sym_instance_of] = STATE(667),
    [sym_negation] = STATE(667),
    [sym_if_term] = STATE(667),
    [sym_conjunction] = STATE(667),
    [sym_disjunction] = STATE(667),
    [sym_implication] = STATE(667),
    [sym_quantified] = STATE(667),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(667),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(519),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [141] = {
    [sym_special_call] = STATE(663),
    [sym_prefix_cast] = STATE(663),
    [sym_unary_expr] = STATE(663),
    [sym_mul_expr] = STATE(663),
    [sym_add_expr] = STATE(663),
    [sym_in_expr] = STATE(663),
    [sym_comp_term] = STATE(663),
    [sym_instance_of] = STATE(663),
    [sym_negation] = STATE(663),
    [sym_if_term] = STATE(663),
    [sym_conjunction] = STATE(663),
    [sym_disjunction] = STATE(663),
    [sym_implication] = STATE(663),
    [sym_quantified] = STATE(663),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(663),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_orderBy] = STATE(1406),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [142] = {
    [sym_special_call] = STATE(686),
    [sym_prefix_cast] = STATE(686),
    [sym_unary_expr] = STATE(686),
    [sym_mul_expr] = STATE(686),
    [sym_add_expr] = STATE(686),
    [sym_in_expr] = STATE(686),
    [sym_comp_term] = STATE(686),
    [sym_instance_of] = STATE(686),
    [sym_negation] = STATE(686),
    [sym_if_term] = STATE(686),
    [sym_conjunction] = STATE(686),
    [sym_disjunction] = STATE(686),
    [sym_implication] = STATE(686),
    [sym_quantified] = STATE(686),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(686),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [143] = {
    [sym_special_call] = STATE(996),
    [sym_prefix_cast] = STATE(996),
    [sym_unary_expr] = STATE(996),
    [sym_mul_expr] = STATE(996),
    [sym_add_expr] = STATE(996),
    [sym_in_expr] = STATE(996),
    [sym_comp_term] = STATE(996),
    [sym_instance_of] = STATE(996),
    [sym_negation] = STATE(996),
    [sym_if_term] = STATE(996),
    [sym_conjunction] = STATE(996),
    [sym_disjunction] = STATE(996),
    [sym_implication] = STATE(996),
    [sym_quantified] = STATE(996),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(996),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [144] = {
    [sym_special_call] = STATE(857),
    [sym_prefix_cast] = STATE(857),
    [sym_unary_expr] = STATE(857),
    [sym_mul_expr] = STATE(857),
    [sym_add_expr] = STATE(857),
    [sym_in_expr] = STATE(857),
    [sym_comp_term] = STATE(857),
    [sym_instance_of] = STATE(857),
    [sym_negation] = STATE(857),
    [sym_if_term] = STATE(857),
    [sym_conjunction] = STATE(857),
    [sym_disjunction] = STATE(857),
    [sym_implication] = STATE(857),
    [sym_quantified] = STATE(857),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(857),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [145] = {
    [sym_special_call] = STATE(730),
    [sym_prefix_cast] = STATE(730),
    [sym_unary_expr] = STATE(730),
    [sym_mul_expr] = STATE(730),
    [sym_add_expr] = STATE(730),
    [sym_in_expr] = STATE(730),
    [sym_comp_term] = STATE(730),
    [sym_instance_of] = STATE(730),
    [sym_negation] = STATE(730),
    [sym_if_term] = STATE(730),
    [sym_conjunction] = STATE(730),
    [sym_disjunction] = STATE(730),
    [sym_implication] = STATE(730),
    [sym_quantified] = STATE(730),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(730),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [146] = {
    [sym_special_call] = STATE(736),
    [sym_prefix_cast] = STATE(736),
    [sym_unary_expr] = STATE(736),
    [sym_mul_expr] = STATE(736),
    [sym_add_expr] = STATE(736),
    [sym_in_expr] = STATE(736),
    [sym_comp_term] = STATE(736),
    [sym_instance_of] = STATE(736),
    [sym_negation] = STATE(736),
    [sym_if_term] = STATE(736),
    [sym_conjunction] = STATE(736),
    [sym_disjunction] = STATE(736),
    [sym_implication] = STATE(736),
    [sym_quantified] = STATE(736),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(736),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [147] = {
    [sym_special_call] = STATE(929),
    [sym_prefix_cast] = STATE(929),
    [sym_unary_expr] = STATE(929),
    [sym_mul_expr] = STATE(929),
    [sym_add_expr] = STATE(929),
    [sym_in_expr] = STATE(929),
    [sym_comp_term] = STATE(929),
    [sym_instance_of] = STATE(929),
    [sym_negation] = STATE(929),
    [sym_if_term] = STATE(929),
    [sym_conjunction] = STATE(929),
    [sym_disjunction] = STATE(929),
    [sym_implication] = STATE(929),
    [sym_quantified] = STATE(929),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(929),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [148] = {
    [sym_special_call] = STATE(933),
    [sym_prefix_cast] = STATE(933),
    [sym_unary_expr] = STATE(933),
    [sym_mul_expr] = STATE(933),
    [sym_add_expr] = STATE(933),
    [sym_in_expr] = STATE(933),
    [sym_comp_term] = STATE(933),
    [sym_instance_of] = STATE(933),
    [sym_negation] = STATE(933),
    [sym_if_term] = STATE(933),
    [sym_conjunction] = STATE(933),
    [sym_disjunction] = STATE(933),
    [sym_implication] = STATE(933),
    [sym_quantified] = STATE(933),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(933),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [149] = {
    [sym_special_call] = STATE(923),
    [sym_prefix_cast] = STATE(923),
    [sym_unary_expr] = STATE(923),
    [sym_mul_expr] = STATE(923),
    [sym_add_expr] = STATE(923),
    [sym_in_expr] = STATE(923),
    [sym_comp_term] = STATE(923),
    [sym_instance_of] = STATE(923),
    [sym_negation] = STATE(923),
    [sym_if_term] = STATE(923),
    [sym_conjunction] = STATE(923),
    [sym_disjunction] = STATE(923),
    [sym_implication] = STATE(923),
    [sym_quantified] = STATE(923),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(923),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [150] = {
    [sym_special_call] = STATE(956),
    [sym_prefix_cast] = STATE(956),
    [sym_unary_expr] = STATE(956),
    [sym_mul_expr] = STATE(956),
    [sym_add_expr] = STATE(956),
    [sym_in_expr] = STATE(956),
    [sym_comp_term] = STATE(956),
    [sym_instance_of] = STATE(956),
    [sym_negation] = STATE(956),
    [sym_if_term] = STATE(956),
    [sym_conjunction] = STATE(956),
    [sym_disjunction] = STATE(956),
    [sym_implication] = STATE(956),
    [sym_quantified] = STATE(956),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(956),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [151] = {
    [sym_special_call] = STATE(992),
    [sym_prefix_cast] = STATE(992),
    [sym_unary_expr] = STATE(992),
    [sym_mul_expr] = STATE(992),
    [sym_add_expr] = STATE(992),
    [sym_in_expr] = STATE(992),
    [sym_comp_term] = STATE(992),
    [sym_instance_of] = STATE(992),
    [sym_negation] = STATE(992),
    [sym_if_term] = STATE(992),
    [sym_conjunction] = STATE(992),
    [sym_disjunction] = STATE(992),
    [sym_implication] = STATE(992),
    [sym_quantified] = STATE(992),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(992),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1442),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [152] = {
    [sym_special_call] = STATE(642),
    [sym_prefix_cast] = STATE(642),
    [sym_unary_expr] = STATE(642),
    [sym_mul_expr] = STATE(642),
    [sym_add_expr] = STATE(642),
    [sym_in_expr] = STATE(642),
    [sym_comp_term] = STATE(642),
    [sym_instance_of] = STATE(642),
    [sym_negation] = STATE(642),
    [sym_if_term] = STATE(642),
    [sym_conjunction] = STATE(642),
    [sym_disjunction] = STATE(642),
    [sym_implication] = STATE(642),
    [sym_quantified] = STATE(642),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(642),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [153] = {
    [sym_special_call] = STATE(991),
    [sym_prefix_cast] = STATE(991),
    [sym_unary_expr] = STATE(991),
    [sym_mul_expr] = STATE(991),
    [sym_add_expr] = STATE(991),
    [sym_in_expr] = STATE(991),
    [sym_comp_term] = STATE(991),
    [sym_instance_of] = STATE(991),
    [sym_negation] = STATE(991),
    [sym_if_term] = STATE(991),
    [sym_conjunction] = STATE(991),
    [sym_disjunction] = STATE(991),
    [sym_implication] = STATE(991),
    [sym_quantified] = STATE(991),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(991),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [154] = {
    [sym_special_call] = STATE(357),
    [sym_prefix_cast] = STATE(357),
    [sym_unary_expr] = STATE(357),
    [sym_mul_expr] = STATE(357),
    [sym_add_expr] = STATE(357),
    [sym_in_expr] = STATE(357),
    [sym_comp_term] = STATE(357),
    [sym_instance_of] = STATE(357),
    [sym_negation] = STATE(357),
    [sym_if_term] = STATE(357),
    [sym_conjunction] = STATE(357),
    [sym_disjunction] = STATE(357),
    [sym_implication] = STATE(357),
    [sym_quantified] = STATE(357),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(357),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [155] = {
    [sym_special_call] = STATE(854),
    [sym_prefix_cast] = STATE(854),
    [sym_unary_expr] = STATE(854),
    [sym_mul_expr] = STATE(854),
    [sym_add_expr] = STATE(854),
    [sym_in_expr] = STATE(854),
    [sym_comp_term] = STATE(854),
    [sym_instance_of] = STATE(854),
    [sym_negation] = STATE(854),
    [sym_if_term] = STATE(854),
    [sym_conjunction] = STATE(854),
    [sym_disjunction] = STATE(854),
    [sym_implication] = STATE(854),
    [sym_quantified] = STATE(854),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(854),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [156] = {
    [sym_special_call] = STATE(914),
    [sym_prefix_cast] = STATE(914),
    [sym_unary_expr] = STATE(914),
    [sym_mul_expr] = STATE(914),
    [sym_add_expr] = STATE(914),
    [sym_in_expr] = STATE(914),
    [sym_comp_term] = STATE(914),
    [sym_instance_of] = STATE(914),
    [sym_negation] = STATE(914),
    [sym_if_term] = STATE(914),
    [sym_conjunction] = STATE(914),
    [sym_disjunction] = STATE(914),
    [sym_implication] = STATE(914),
    [sym_quantified] = STATE(914),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(914),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [157] = {
    [sym_special_call] = STATE(875),
    [sym_prefix_cast] = STATE(875),
    [sym_unary_expr] = STATE(875),
    [sym_mul_expr] = STATE(875),
    [sym_add_expr] = STATE(875),
    [sym_in_expr] = STATE(875),
    [sym_comp_term] = STATE(875),
    [sym_instance_of] = STATE(875),
    [sym_negation] = STATE(875),
    [sym_if_term] = STATE(875),
    [sym_conjunction] = STATE(875),
    [sym_disjunction] = STATE(875),
    [sym_implication] = STATE(875),
    [sym_quantified] = STATE(875),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(875),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [158] = {
    [sym_special_call] = STATE(378),
    [sym_prefix_cast] = STATE(378),
    [sym_unary_expr] = STATE(378),
    [sym_mul_expr] = STATE(378),
    [sym_add_expr] = STATE(378),
    [sym_in_expr] = STATE(378),
    [sym_comp_term] = STATE(378),
    [sym_instance_of] = STATE(378),
    [sym_negation] = STATE(378),
    [sym_if_term] = STATE(378),
    [sym_conjunction] = STATE(378),
    [sym_disjunction] = STATE(378),
    [sym_implication] = STATE(378),
    [sym_quantified] = STATE(378),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(378),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [159] = {
    [sym_special_call] = STATE(676),
    [sym_prefix_cast] = STATE(676),
    [sym_unary_expr] = STATE(676),
    [sym_mul_expr] = STATE(676),
    [sym_add_expr] = STATE(676),
    [sym_in_expr] = STATE(676),
    [sym_comp_term] = STATE(676),
    [sym_instance_of] = STATE(676),
    [sym_negation] = STATE(676),
    [sym_if_term] = STATE(676),
    [sym_conjunction] = STATE(676),
    [sym_disjunction] = STATE(676),
    [sym_implication] = STATE(676),
    [sym_quantified] = STATE(676),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(676),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [160] = {
    [sym_special_call] = STATE(859),
    [sym_prefix_cast] = STATE(859),
    [sym_unary_expr] = STATE(859),
    [sym_mul_expr] = STATE(859),
    [sym_add_expr] = STATE(859),
    [sym_in_expr] = STATE(859),
    [sym_comp_term] = STATE(859),
    [sym_instance_of] = STATE(859),
    [sym_negation] = STATE(859),
    [sym_if_term] = STATE(859),
    [sym_conjunction] = STATE(859),
    [sym_disjunction] = STATE(859),
    [sym_implication] = STATE(859),
    [sym_quantified] = STATE(859),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(859),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [161] = {
    [sym_special_call] = STATE(966),
    [sym_prefix_cast] = STATE(966),
    [sym_unary_expr] = STATE(966),
    [sym_mul_expr] = STATE(966),
    [sym_add_expr] = STATE(966),
    [sym_in_expr] = STATE(966),
    [sym_comp_term] = STATE(966),
    [sym_instance_of] = STATE(966),
    [sym_negation] = STATE(966),
    [sym_if_term] = STATE(966),
    [sym_conjunction] = STATE(966),
    [sym_disjunction] = STATE(966),
    [sym_implication] = STATE(966),
    [sym_quantified] = STATE(966),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(966),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [162] = {
    [sym_special_call] = STATE(873),
    [sym_prefix_cast] = STATE(873),
    [sym_unary_expr] = STATE(873),
    [sym_mul_expr] = STATE(873),
    [sym_add_expr] = STATE(873),
    [sym_in_expr] = STATE(873),
    [sym_comp_term] = STATE(873),
    [sym_instance_of] = STATE(873),
    [sym_negation] = STATE(873),
    [sym_if_term] = STATE(873),
    [sym_conjunction] = STATE(873),
    [sym_disjunction] = STATE(873),
    [sym_implication] = STATE(873),
    [sym_quantified] = STATE(873),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(873),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [163] = {
    [sym_special_call] = STATE(722),
    [sym_prefix_cast] = STATE(722),
    [sym_unary_expr] = STATE(722),
    [sym_mul_expr] = STATE(722),
    [sym_add_expr] = STATE(722),
    [sym_in_expr] = STATE(722),
    [sym_comp_term] = STATE(722),
    [sym_instance_of] = STATE(722),
    [sym_negation] = STATE(722),
    [sym_if_term] = STATE(722),
    [sym_conjunction] = STATE(722),
    [sym_disjunction] = STATE(722),
    [sym_implication] = STATE(722),
    [sym_quantified] = STATE(722),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(722),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [164] = {
    [sym_special_call] = STATE(898),
    [sym_prefix_cast] = STATE(898),
    [sym_unary_expr] = STATE(898),
    [sym_mul_expr] = STATE(898),
    [sym_add_expr] = STATE(898),
    [sym_in_expr] = STATE(898),
    [sym_comp_term] = STATE(898),
    [sym_instance_of] = STATE(898),
    [sym_negation] = STATE(898),
    [sym_if_term] = STATE(898),
    [sym_conjunction] = STATE(898),
    [sym_disjunction] = STATE(898),
    [sym_implication] = STATE(898),
    [sym_quantified] = STATE(898),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(898),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [165] = {
    [sym_special_call] = STATE(922),
    [sym_prefix_cast] = STATE(922),
    [sym_unary_expr] = STATE(922),
    [sym_mul_expr] = STATE(922),
    [sym_add_expr] = STATE(922),
    [sym_in_expr] = STATE(922),
    [sym_comp_term] = STATE(922),
    [sym_instance_of] = STATE(922),
    [sym_negation] = STATE(922),
    [sym_if_term] = STATE(922),
    [sym_conjunction] = STATE(922),
    [sym_disjunction] = STATE(922),
    [sym_implication] = STATE(922),
    [sym_quantified] = STATE(922),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(922),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [166] = {
    [sym_special_call] = STATE(890),
    [sym_prefix_cast] = STATE(890),
    [sym_unary_expr] = STATE(890),
    [sym_mul_expr] = STATE(890),
    [sym_add_expr] = STATE(890),
    [sym_in_expr] = STATE(890),
    [sym_comp_term] = STATE(890),
    [sym_instance_of] = STATE(890),
    [sym_negation] = STATE(890),
    [sym_if_term] = STATE(890),
    [sym_conjunction] = STATE(890),
    [sym_disjunction] = STATE(890),
    [sym_implication] = STATE(890),
    [sym_quantified] = STATE(890),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(890),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [167] = {
    [sym_special_call] = STATE(922),
    [sym_prefix_cast] = STATE(922),
    [sym_unary_expr] = STATE(922),
    [sym_mul_expr] = STATE(922),
    [sym_add_expr] = STATE(922),
    [sym_in_expr] = STATE(922),
    [sym_comp_term] = STATE(922),
    [sym_instance_of] = STATE(922),
    [sym_negation] = STATE(922),
    [sym_if_term] = STATE(922),
    [sym_conjunction] = STATE(922),
    [sym_disjunction] = STATE(922),
    [sym_implication] = STATE(922),
    [sym_quantified] = STATE(922),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(922),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1435),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [168] = {
    [sym_special_call] = STATE(931),
    [sym_prefix_cast] = STATE(931),
    [sym_unary_expr] = STATE(931),
    [sym_mul_expr] = STATE(931),
    [sym_add_expr] = STATE(931),
    [sym_in_expr] = STATE(931),
    [sym_comp_term] = STATE(931),
    [sym_instance_of] = STATE(931),
    [sym_negation] = STATE(931),
    [sym_if_term] = STATE(931),
    [sym_conjunction] = STATE(931),
    [sym_disjunction] = STATE(931),
    [sym_implication] = STATE(931),
    [sym_quantified] = STATE(931),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(931),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [169] = {
    [sym_special_call] = STATE(936),
    [sym_prefix_cast] = STATE(936),
    [sym_unary_expr] = STATE(936),
    [sym_mul_expr] = STATE(936),
    [sym_add_expr] = STATE(936),
    [sym_in_expr] = STATE(936),
    [sym_comp_term] = STATE(936),
    [sym_instance_of] = STATE(936),
    [sym_negation] = STATE(936),
    [sym_if_term] = STATE(936),
    [sym_conjunction] = STATE(936),
    [sym_disjunction] = STATE(936),
    [sym_implication] = STATE(936),
    [sym_quantified] = STATE(936),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(936),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [170] = {
    [sym_special_call] = STATE(932),
    [sym_prefix_cast] = STATE(932),
    [sym_unary_expr] = STATE(932),
    [sym_mul_expr] = STATE(932),
    [sym_add_expr] = STATE(932),
    [sym_in_expr] = STATE(932),
    [sym_comp_term] = STATE(932),
    [sym_instance_of] = STATE(932),
    [sym_negation] = STATE(932),
    [sym_if_term] = STATE(932),
    [sym_conjunction] = STATE(932),
    [sym_disjunction] = STATE(932),
    [sym_implication] = STATE(932),
    [sym_quantified] = STATE(932),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(932),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [171] = {
    [sym_special_call] = STATE(827),
    [sym_prefix_cast] = STATE(827),
    [sym_unary_expr] = STATE(827),
    [sym_mul_expr] = STATE(827),
    [sym_add_expr] = STATE(827),
    [sym_in_expr] = STATE(827),
    [sym_comp_term] = STATE(827),
    [sym_instance_of] = STATE(827),
    [sym_negation] = STATE(827),
    [sym_if_term] = STATE(827),
    [sym_conjunction] = STATE(827),
    [sym_disjunction] = STATE(827),
    [sym_implication] = STATE(827),
    [sym_quantified] = STATE(827),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(827),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [172] = {
    [sym_special_call] = STATE(810),
    [sym_prefix_cast] = STATE(810),
    [sym_unary_expr] = STATE(810),
    [sym_mul_expr] = STATE(810),
    [sym_add_expr] = STATE(810),
    [sym_in_expr] = STATE(810),
    [sym_comp_term] = STATE(810),
    [sym_instance_of] = STATE(810),
    [sym_negation] = STATE(810),
    [sym_if_term] = STATE(810),
    [sym_conjunction] = STATE(810),
    [sym_disjunction] = STATE(810),
    [sym_implication] = STATE(810),
    [sym_quantified] = STATE(810),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(810),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [173] = {
    [sym_special_call] = STATE(958),
    [sym_prefix_cast] = STATE(958),
    [sym_unary_expr] = STATE(958),
    [sym_mul_expr] = STATE(958),
    [sym_add_expr] = STATE(958),
    [sym_in_expr] = STATE(958),
    [sym_comp_term] = STATE(958),
    [sym_instance_of] = STATE(958),
    [sym_negation] = STATE(958),
    [sym_if_term] = STATE(958),
    [sym_conjunction] = STATE(958),
    [sym_disjunction] = STATE(958),
    [sym_implication] = STATE(958),
    [sym_quantified] = STATE(958),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(958),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [174] = {
    [sym_special_call] = STATE(347),
    [sym_prefix_cast] = STATE(347),
    [sym_unary_expr] = STATE(347),
    [sym_mul_expr] = STATE(347),
    [sym_add_expr] = STATE(347),
    [sym_in_expr] = STATE(347),
    [sym_comp_term] = STATE(347),
    [sym_instance_of] = STATE(347),
    [sym_negation] = STATE(347),
    [sym_if_term] = STATE(347),
    [sym_conjunction] = STATE(347),
    [sym_disjunction] = STATE(347),
    [sym_implication] = STATE(347),
    [sym_quantified] = STATE(347),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(347),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [175] = {
    [sym_special_call] = STATE(793),
    [sym_prefix_cast] = STATE(793),
    [sym_unary_expr] = STATE(793),
    [sym_mul_expr] = STATE(793),
    [sym_add_expr] = STATE(793),
    [sym_in_expr] = STATE(793),
    [sym_comp_term] = STATE(793),
    [sym_instance_of] = STATE(793),
    [sym_negation] = STATE(793),
    [sym_if_term] = STATE(793),
    [sym_conjunction] = STATE(793),
    [sym_disjunction] = STATE(793),
    [sym_implication] = STATE(793),
    [sym_quantified] = STATE(793),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(793),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [176] = {
    [sym_special_call] = STATE(707),
    [sym_prefix_cast] = STATE(707),
    [sym_unary_expr] = STATE(707),
    [sym_mul_expr] = STATE(707),
    [sym_add_expr] = STATE(707),
    [sym_in_expr] = STATE(707),
    [sym_comp_term] = STATE(707),
    [sym_instance_of] = STATE(707),
    [sym_negation] = STATE(707),
    [sym_if_term] = STATE(707),
    [sym_conjunction] = STATE(707),
    [sym_disjunction] = STATE(707),
    [sym_implication] = STATE(707),
    [sym_quantified] = STATE(707),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(707),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [177] = {
    [sym_special_call] = STATE(965),
    [sym_prefix_cast] = STATE(965),
    [sym_unary_expr] = STATE(965),
    [sym_mul_expr] = STATE(965),
    [sym_add_expr] = STATE(965),
    [sym_in_expr] = STATE(965),
    [sym_comp_term] = STATE(965),
    [sym_instance_of] = STATE(965),
    [sym_negation] = STATE(965),
    [sym_if_term] = STATE(965),
    [sym_conjunction] = STATE(965),
    [sym_disjunction] = STATE(965),
    [sym_implication] = STATE(965),
    [sym_quantified] = STATE(965),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(965),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [178] = {
    [sym_special_call] = STATE(971),
    [sym_prefix_cast] = STATE(971),
    [sym_unary_expr] = STATE(971),
    [sym_mul_expr] = STATE(971),
    [sym_add_expr] = STATE(971),
    [sym_in_expr] = STATE(971),
    [sym_comp_term] = STATE(971),
    [sym_instance_of] = STATE(971),
    [sym_negation] = STATE(971),
    [sym_if_term] = STATE(971),
    [sym_conjunction] = STATE(971),
    [sym_disjunction] = STATE(971),
    [sym_implication] = STATE(971),
    [sym_quantified] = STATE(971),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(971),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [179] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1423),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [180] = {
    [sym_special_call] = STATE(874),
    [sym_prefix_cast] = STATE(874),
    [sym_unary_expr] = STATE(874),
    [sym_mul_expr] = STATE(874),
    [sym_add_expr] = STATE(874),
    [sym_in_expr] = STATE(874),
    [sym_comp_term] = STATE(874),
    [sym_instance_of] = STATE(874),
    [sym_negation] = STATE(874),
    [sym_if_term] = STATE(874),
    [sym_conjunction] = STATE(874),
    [sym_disjunction] = STATE(874),
    [sym_implication] = STATE(874),
    [sym_quantified] = STATE(874),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(874),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [181] = {
    [sym_special_call] = STATE(635),
    [sym_prefix_cast] = STATE(635),
    [sym_unary_expr] = STATE(635),
    [sym_mul_expr] = STATE(635),
    [sym_add_expr] = STATE(635),
    [sym_in_expr] = STATE(635),
    [sym_comp_term] = STATE(635),
    [sym_instance_of] = STATE(635),
    [sym_negation] = STATE(635),
    [sym_if_term] = STATE(635),
    [sym_conjunction] = STATE(635),
    [sym_disjunction] = STATE(635),
    [sym_implication] = STATE(635),
    [sym_quantified] = STATE(635),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(635),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [182] = {
    [sym_special_call] = STATE(643),
    [sym_prefix_cast] = STATE(643),
    [sym_unary_expr] = STATE(643),
    [sym_mul_expr] = STATE(643),
    [sym_add_expr] = STATE(643),
    [sym_in_expr] = STATE(643),
    [sym_comp_term] = STATE(643),
    [sym_instance_of] = STATE(643),
    [sym_negation] = STATE(643),
    [sym_if_term] = STATE(643),
    [sym_conjunction] = STATE(643),
    [sym_disjunction] = STATE(643),
    [sym_implication] = STATE(643),
    [sym_quantified] = STATE(643),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(643),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [183] = {
    [sym_special_call] = STATE(985),
    [sym_prefix_cast] = STATE(985),
    [sym_unary_expr] = STATE(985),
    [sym_mul_expr] = STATE(985),
    [sym_add_expr] = STATE(985),
    [sym_in_expr] = STATE(985),
    [sym_comp_term] = STATE(985),
    [sym_instance_of] = STATE(985),
    [sym_negation] = STATE(985),
    [sym_if_term] = STATE(985),
    [sym_conjunction] = STATE(985),
    [sym_disjunction] = STATE(985),
    [sym_implication] = STATE(985),
    [sym_quantified] = STATE(985),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(985),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [184] = {
    [sym_special_call] = STATE(644),
    [sym_prefix_cast] = STATE(644),
    [sym_unary_expr] = STATE(644),
    [sym_mul_expr] = STATE(644),
    [sym_add_expr] = STATE(644),
    [sym_in_expr] = STATE(644),
    [sym_comp_term] = STATE(644),
    [sym_instance_of] = STATE(644),
    [sym_negation] = STATE(644),
    [sym_if_term] = STATE(644),
    [sym_conjunction] = STATE(644),
    [sym_disjunction] = STATE(644),
    [sym_implication] = STATE(644),
    [sym_quantified] = STATE(644),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(644),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [185] = {
    [sym_special_call] = STATE(892),
    [sym_prefix_cast] = STATE(892),
    [sym_unary_expr] = STATE(892),
    [sym_mul_expr] = STATE(892),
    [sym_add_expr] = STATE(892),
    [sym_in_expr] = STATE(892),
    [sym_comp_term] = STATE(892),
    [sym_instance_of] = STATE(892),
    [sym_negation] = STATE(892),
    [sym_if_term] = STATE(892),
    [sym_conjunction] = STATE(892),
    [sym_disjunction] = STATE(892),
    [sym_implication] = STATE(892),
    [sym_quantified] = STATE(892),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(892),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [186] = {
    [sym_special_call] = STATE(674),
    [sym_prefix_cast] = STATE(674),
    [sym_unary_expr] = STATE(674),
    [sym_mul_expr] = STATE(674),
    [sym_add_expr] = STATE(674),
    [sym_in_expr] = STATE(674),
    [sym_comp_term] = STATE(674),
    [sym_instance_of] = STATE(674),
    [sym_negation] = STATE(674),
    [sym_if_term] = STATE(674),
    [sym_conjunction] = STATE(674),
    [sym_disjunction] = STATE(674),
    [sym_implication] = STATE(674),
    [sym_quantified] = STATE(674),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(674),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [187] = {
    [sym_special_call] = STATE(646),
    [sym_prefix_cast] = STATE(646),
    [sym_unary_expr] = STATE(646),
    [sym_mul_expr] = STATE(646),
    [sym_add_expr] = STATE(646),
    [sym_in_expr] = STATE(646),
    [sym_comp_term] = STATE(646),
    [sym_instance_of] = STATE(646),
    [sym_negation] = STATE(646),
    [sym_if_term] = STATE(646),
    [sym_conjunction] = STATE(646),
    [sym_disjunction] = STATE(646),
    [sym_implication] = STATE(646),
    [sym_quantified] = STATE(646),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(646),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [188] = {
    [sym_special_call] = STATE(648),
    [sym_prefix_cast] = STATE(648),
    [sym_unary_expr] = STATE(648),
    [sym_mul_expr] = STATE(648),
    [sym_add_expr] = STATE(648),
    [sym_in_expr] = STATE(648),
    [sym_comp_term] = STATE(648),
    [sym_instance_of] = STATE(648),
    [sym_negation] = STATE(648),
    [sym_if_term] = STATE(648),
    [sym_conjunction] = STATE(648),
    [sym_disjunction] = STATE(648),
    [sym_implication] = STATE(648),
    [sym_quantified] = STATE(648),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(648),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [189] = {
    [sym_special_call] = STATE(356),
    [sym_prefix_cast] = STATE(356),
    [sym_unary_expr] = STATE(356),
    [sym_mul_expr] = STATE(356),
    [sym_add_expr] = STATE(356),
    [sym_in_expr] = STATE(356),
    [sym_comp_term] = STATE(356),
    [sym_instance_of] = STATE(356),
    [sym_negation] = STATE(356),
    [sym_if_term] = STATE(356),
    [sym_conjunction] = STATE(356),
    [sym_disjunction] = STATE(356),
    [sym_implication] = STATE(356),
    [sym_quantified] = STATE(356),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(356),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [190] = {
    [sym_special_call] = STATE(348),
    [sym_prefix_cast] = STATE(348),
    [sym_unary_expr] = STATE(348),
    [sym_mul_expr] = STATE(348),
    [sym_add_expr] = STATE(348),
    [sym_in_expr] = STATE(348),
    [sym_comp_term] = STATE(348),
    [sym_instance_of] = STATE(348),
    [sym_negation] = STATE(348),
    [sym_if_term] = STATE(348),
    [sym_conjunction] = STATE(348),
    [sym_disjunction] = STATE(348),
    [sym_implication] = STATE(348),
    [sym_quantified] = STATE(348),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(348),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [191] = {
    [sym_special_call] = STATE(709),
    [sym_prefix_cast] = STATE(709),
    [sym_unary_expr] = STATE(709),
    [sym_mul_expr] = STATE(709),
    [sym_add_expr] = STATE(709),
    [sym_in_expr] = STATE(709),
    [sym_comp_term] = STATE(709),
    [sym_instance_of] = STATE(709),
    [sym_negation] = STATE(709),
    [sym_if_term] = STATE(709),
    [sym_conjunction] = STATE(709),
    [sym_disjunction] = STATE(709),
    [sym_implication] = STATE(709),
    [sym_quantified] = STATE(709),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(709),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [192] = {
    [sym_special_call] = STATE(638),
    [sym_prefix_cast] = STATE(638),
    [sym_unary_expr] = STATE(638),
    [sym_mul_expr] = STATE(638),
    [sym_add_expr] = STATE(638),
    [sym_in_expr] = STATE(638),
    [sym_comp_term] = STATE(638),
    [sym_instance_of] = STATE(638),
    [sym_negation] = STATE(638),
    [sym_if_term] = STATE(638),
    [sym_conjunction] = STATE(638),
    [sym_disjunction] = STATE(638),
    [sym_implication] = STATE(638),
    [sym_quantified] = STATE(638),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(638),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [193] = {
    [sym_special_call] = STATE(955),
    [sym_prefix_cast] = STATE(955),
    [sym_unary_expr] = STATE(955),
    [sym_mul_expr] = STATE(955),
    [sym_add_expr] = STATE(955),
    [sym_in_expr] = STATE(955),
    [sym_comp_term] = STATE(955),
    [sym_instance_of] = STATE(955),
    [sym_negation] = STATE(955),
    [sym_if_term] = STATE(955),
    [sym_conjunction] = STATE(955),
    [sym_disjunction] = STATE(955),
    [sym_implication] = STATE(955),
    [sym_quantified] = STATE(955),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(955),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [194] = {
    [sym_special_call] = STATE(745),
    [sym_prefix_cast] = STATE(745),
    [sym_unary_expr] = STATE(745),
    [sym_mul_expr] = STATE(745),
    [sym_add_expr] = STATE(745),
    [sym_in_expr] = STATE(745),
    [sym_comp_term] = STATE(745),
    [sym_instance_of] = STATE(745),
    [sym_negation] = STATE(745),
    [sym_if_term] = STATE(745),
    [sym_conjunction] = STATE(745),
    [sym_disjunction] = STATE(745),
    [sym_implication] = STATE(745),
    [sym_quantified] = STATE(745),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(745),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [195] = {
    [sym_special_call] = STATE(729),
    [sym_prefix_cast] = STATE(729),
    [sym_unary_expr] = STATE(729),
    [sym_mul_expr] = STATE(729),
    [sym_add_expr] = STATE(729),
    [sym_in_expr] = STATE(729),
    [sym_comp_term] = STATE(729),
    [sym_instance_of] = STATE(729),
    [sym_negation] = STATE(729),
    [sym_if_term] = STATE(729),
    [sym_conjunction] = STATE(729),
    [sym_disjunction] = STATE(729),
    [sym_implication] = STATE(729),
    [sym_quantified] = STATE(729),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(729),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [196] = {
    [sym_special_call] = STATE(893),
    [sym_prefix_cast] = STATE(893),
    [sym_unary_expr] = STATE(893),
    [sym_mul_expr] = STATE(893),
    [sym_add_expr] = STATE(893),
    [sym_in_expr] = STATE(893),
    [sym_comp_term] = STATE(893),
    [sym_instance_of] = STATE(893),
    [sym_negation] = STATE(893),
    [sym_if_term] = STATE(893),
    [sym_conjunction] = STATE(893),
    [sym_disjunction] = STATE(893),
    [sym_implication] = STATE(893),
    [sym_quantified] = STATE(893),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(893),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [197] = {
    [sym_special_call] = STATE(738),
    [sym_prefix_cast] = STATE(738),
    [sym_unary_expr] = STATE(738),
    [sym_mul_expr] = STATE(738),
    [sym_add_expr] = STATE(738),
    [sym_in_expr] = STATE(738),
    [sym_comp_term] = STATE(738),
    [sym_instance_of] = STATE(738),
    [sym_negation] = STATE(738),
    [sym_if_term] = STATE(738),
    [sym_conjunction] = STATE(738),
    [sym_disjunction] = STATE(738),
    [sym_implication] = STATE(738),
    [sym_quantified] = STATE(738),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(738),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [198] = {
    [sym_special_call] = STATE(977),
    [sym_prefix_cast] = STATE(977),
    [sym_unary_expr] = STATE(977),
    [sym_mul_expr] = STATE(977),
    [sym_add_expr] = STATE(977),
    [sym_in_expr] = STATE(977),
    [sym_comp_term] = STATE(977),
    [sym_instance_of] = STATE(977),
    [sym_negation] = STATE(977),
    [sym_if_term] = STATE(977),
    [sym_conjunction] = STATE(977),
    [sym_disjunction] = STATE(977),
    [sym_implication] = STATE(977),
    [sym_quantified] = STATE(977),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(977),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [199] = {
    [sym_special_call] = STATE(943),
    [sym_prefix_cast] = STATE(943),
    [sym_unary_expr] = STATE(943),
    [sym_mul_expr] = STATE(943),
    [sym_add_expr] = STATE(943),
    [sym_in_expr] = STATE(943),
    [sym_comp_term] = STATE(943),
    [sym_instance_of] = STATE(943),
    [sym_negation] = STATE(943),
    [sym_if_term] = STATE(943),
    [sym_conjunction] = STATE(943),
    [sym_disjunction] = STATE(943),
    [sym_implication] = STATE(943),
    [sym_quantified] = STATE(943),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(943),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [200] = {
    [sym_special_call] = STATE(995),
    [sym_prefix_cast] = STATE(995),
    [sym_unary_expr] = STATE(995),
    [sym_mul_expr] = STATE(995),
    [sym_add_expr] = STATE(995),
    [sym_in_expr] = STATE(995),
    [sym_comp_term] = STATE(995),
    [sym_instance_of] = STATE(995),
    [sym_negation] = STATE(995),
    [sym_if_term] = STATE(995),
    [sym_conjunction] = STATE(995),
    [sym_disjunction] = STATE(995),
    [sym_implication] = STATE(995),
    [sym_quantified] = STATE(995),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(995),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [201] = {
    [sym_special_call] = STATE(876),
    [sym_prefix_cast] = STATE(876),
    [sym_unary_expr] = STATE(876),
    [sym_mul_expr] = STATE(876),
    [sym_add_expr] = STATE(876),
    [sym_in_expr] = STATE(876),
    [sym_comp_term] = STATE(876),
    [sym_instance_of] = STATE(876),
    [sym_negation] = STATE(876),
    [sym_if_term] = STATE(876),
    [sym_conjunction] = STATE(876),
    [sym_disjunction] = STATE(876),
    [sym_implication] = STATE(876),
    [sym_quantified] = STATE(876),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(876),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [202] = {
    [sym_special_call] = STATE(977),
    [sym_prefix_cast] = STATE(977),
    [sym_unary_expr] = STATE(977),
    [sym_mul_expr] = STATE(977),
    [sym_add_expr] = STATE(977),
    [sym_in_expr] = STATE(977),
    [sym_comp_term] = STATE(977),
    [sym_instance_of] = STATE(977),
    [sym_negation] = STATE(977),
    [sym_if_term] = STATE(977),
    [sym_conjunction] = STATE(977),
    [sym_disjunction] = STATE(977),
    [sym_implication] = STATE(977),
    [sym_quantified] = STATE(977),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(977),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1413),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [203] = {
    [sym_special_call] = STATE(678),
    [sym_prefix_cast] = STATE(678),
    [sym_unary_expr] = STATE(678),
    [sym_mul_expr] = STATE(678),
    [sym_add_expr] = STATE(678),
    [sym_in_expr] = STATE(678),
    [sym_comp_term] = STATE(678),
    [sym_instance_of] = STATE(678),
    [sym_negation] = STATE(678),
    [sym_if_term] = STATE(678),
    [sym_conjunction] = STATE(678),
    [sym_disjunction] = STATE(678),
    [sym_implication] = STATE(678),
    [sym_quantified] = STATE(678),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(678),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [204] = {
    [sym_special_call] = STATE(925),
    [sym_prefix_cast] = STATE(925),
    [sym_unary_expr] = STATE(925),
    [sym_mul_expr] = STATE(925),
    [sym_add_expr] = STATE(925),
    [sym_in_expr] = STATE(925),
    [sym_comp_term] = STATE(925),
    [sym_instance_of] = STATE(925),
    [sym_negation] = STATE(925),
    [sym_if_term] = STATE(925),
    [sym_conjunction] = STATE(925),
    [sym_disjunction] = STATE(925),
    [sym_implication] = STATE(925),
    [sym_quantified] = STATE(925),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(925),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [205] = {
    [sym_special_call] = STATE(937),
    [sym_prefix_cast] = STATE(937),
    [sym_unary_expr] = STATE(937),
    [sym_mul_expr] = STATE(937),
    [sym_add_expr] = STATE(937),
    [sym_in_expr] = STATE(937),
    [sym_comp_term] = STATE(937),
    [sym_instance_of] = STATE(937),
    [sym_negation] = STATE(937),
    [sym_if_term] = STATE(937),
    [sym_conjunction] = STATE(937),
    [sym_disjunction] = STATE(937),
    [sym_implication] = STATE(937),
    [sym_quantified] = STATE(937),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(937),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [206] = {
    [sym_special_call] = STATE(815),
    [sym_prefix_cast] = STATE(815),
    [sym_unary_expr] = STATE(815),
    [sym_mul_expr] = STATE(815),
    [sym_add_expr] = STATE(815),
    [sym_in_expr] = STATE(815),
    [sym_comp_term] = STATE(815),
    [sym_instance_of] = STATE(815),
    [sym_negation] = STATE(815),
    [sym_if_term] = STATE(815),
    [sym_conjunction] = STATE(815),
    [sym_disjunction] = STATE(815),
    [sym_implication] = STATE(815),
    [sym_quantified] = STATE(815),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(815),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [207] = {
    [sym_special_call] = STATE(754),
    [sym_prefix_cast] = STATE(754),
    [sym_unary_expr] = STATE(754),
    [sym_mul_expr] = STATE(754),
    [sym_add_expr] = STATE(754),
    [sym_in_expr] = STATE(754),
    [sym_comp_term] = STATE(754),
    [sym_instance_of] = STATE(754),
    [sym_negation] = STATE(754),
    [sym_if_term] = STATE(754),
    [sym_conjunction] = STATE(754),
    [sym_disjunction] = STATE(754),
    [sym_implication] = STATE(754),
    [sym_quantified] = STATE(754),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(754),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [208] = {
    [sym_special_call] = STATE(990),
    [sym_prefix_cast] = STATE(990),
    [sym_unary_expr] = STATE(990),
    [sym_mul_expr] = STATE(990),
    [sym_add_expr] = STATE(990),
    [sym_in_expr] = STATE(990),
    [sym_comp_term] = STATE(990),
    [sym_instance_of] = STATE(990),
    [sym_negation] = STATE(990),
    [sym_if_term] = STATE(990),
    [sym_conjunction] = STATE(990),
    [sym_disjunction] = STATE(990),
    [sym_implication] = STATE(990),
    [sym_quantified] = STATE(990),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(990),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [209] = {
    [sym_special_call] = STATE(749),
    [sym_prefix_cast] = STATE(749),
    [sym_unary_expr] = STATE(749),
    [sym_mul_expr] = STATE(749),
    [sym_add_expr] = STATE(749),
    [sym_in_expr] = STATE(749),
    [sym_comp_term] = STATE(749),
    [sym_instance_of] = STATE(749),
    [sym_negation] = STATE(749),
    [sym_if_term] = STATE(749),
    [sym_conjunction] = STATE(749),
    [sym_disjunction] = STATE(749),
    [sym_implication] = STATE(749),
    [sym_quantified] = STATE(749),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(749),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [210] = {
    [sym_special_call] = STATE(950),
    [sym_prefix_cast] = STATE(950),
    [sym_unary_expr] = STATE(950),
    [sym_mul_expr] = STATE(950),
    [sym_add_expr] = STATE(950),
    [sym_in_expr] = STATE(950),
    [sym_comp_term] = STATE(950),
    [sym_instance_of] = STATE(950),
    [sym_negation] = STATE(950),
    [sym_if_term] = STATE(950),
    [sym_conjunction] = STATE(950),
    [sym_disjunction] = STATE(950),
    [sym_implication] = STATE(950),
    [sym_quantified] = STATE(950),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(950),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [211] = {
    [sym_special_call] = STATE(681),
    [sym_prefix_cast] = STATE(681),
    [sym_unary_expr] = STATE(681),
    [sym_mul_expr] = STATE(681),
    [sym_add_expr] = STATE(681),
    [sym_in_expr] = STATE(681),
    [sym_comp_term] = STATE(681),
    [sym_instance_of] = STATE(681),
    [sym_negation] = STATE(681),
    [sym_if_term] = STATE(681),
    [sym_conjunction] = STATE(681),
    [sym_disjunction] = STATE(681),
    [sym_implication] = STATE(681),
    [sym_quantified] = STATE(681),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(681),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [212] = {
    [sym_special_call] = STATE(935),
    [sym_prefix_cast] = STATE(935),
    [sym_unary_expr] = STATE(935),
    [sym_mul_expr] = STATE(935),
    [sym_add_expr] = STATE(935),
    [sym_in_expr] = STATE(935),
    [sym_comp_term] = STATE(935),
    [sym_instance_of] = STATE(935),
    [sym_negation] = STATE(935),
    [sym_if_term] = STATE(935),
    [sym_conjunction] = STATE(935),
    [sym_disjunction] = STATE(935),
    [sym_implication] = STATE(935),
    [sym_quantified] = STATE(935),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(935),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [213] = {
    [sym_special_call] = STATE(927),
    [sym_prefix_cast] = STATE(927),
    [sym_unary_expr] = STATE(927),
    [sym_mul_expr] = STATE(927),
    [sym_add_expr] = STATE(927),
    [sym_in_expr] = STATE(927),
    [sym_comp_term] = STATE(927),
    [sym_instance_of] = STATE(927),
    [sym_negation] = STATE(927),
    [sym_if_term] = STATE(927),
    [sym_conjunction] = STATE(927),
    [sym_disjunction] = STATE(927),
    [sym_implication] = STATE(927),
    [sym_quantified] = STATE(927),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(927),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [214] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [215] = {
    [sym_special_call] = STATE(985),
    [sym_prefix_cast] = STATE(985),
    [sym_unary_expr] = STATE(985),
    [sym_mul_expr] = STATE(985),
    [sym_add_expr] = STATE(985),
    [sym_in_expr] = STATE(985),
    [sym_comp_term] = STATE(985),
    [sym_instance_of] = STATE(985),
    [sym_negation] = STATE(985),
    [sym_if_term] = STATE(985),
    [sym_conjunction] = STATE(985),
    [sym_disjunction] = STATE(985),
    [sym_implication] = STATE(985),
    [sym_quantified] = STATE(985),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(985),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1414),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [216] = {
    [sym_special_call] = STATE(938),
    [sym_prefix_cast] = STATE(938),
    [sym_unary_expr] = STATE(938),
    [sym_mul_expr] = STATE(938),
    [sym_add_expr] = STATE(938),
    [sym_in_expr] = STATE(938),
    [sym_comp_term] = STATE(938),
    [sym_instance_of] = STATE(938),
    [sym_negation] = STATE(938),
    [sym_if_term] = STATE(938),
    [sym_conjunction] = STATE(938),
    [sym_disjunction] = STATE(938),
    [sym_implication] = STATE(938),
    [sym_quantified] = STATE(938),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(938),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [217] = {
    [sym_special_call] = STATE(988),
    [sym_prefix_cast] = STATE(988),
    [sym_unary_expr] = STATE(988),
    [sym_mul_expr] = STATE(988),
    [sym_add_expr] = STATE(988),
    [sym_in_expr] = STATE(988),
    [sym_comp_term] = STATE(988),
    [sym_instance_of] = STATE(988),
    [sym_negation] = STATE(988),
    [sym_if_term] = STATE(988),
    [sym_conjunction] = STATE(988),
    [sym_disjunction] = STATE(988),
    [sym_implication] = STATE(988),
    [sym_quantified] = STATE(988),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(988),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [218] = {
    [sym_special_call] = STATE(756),
    [sym_prefix_cast] = STATE(756),
    [sym_unary_expr] = STATE(756),
    [sym_mul_expr] = STATE(756),
    [sym_add_expr] = STATE(756),
    [sym_in_expr] = STATE(756),
    [sym_comp_term] = STATE(756),
    [sym_instance_of] = STATE(756),
    [sym_negation] = STATE(756),
    [sym_if_term] = STATE(756),
    [sym_conjunction] = STATE(756),
    [sym_disjunction] = STATE(756),
    [sym_implication] = STATE(756),
    [sym_quantified] = STATE(756),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(756),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [219] = {
    [sym_special_call] = STATE(767),
    [sym_prefix_cast] = STATE(767),
    [sym_unary_expr] = STATE(767),
    [sym_mul_expr] = STATE(767),
    [sym_add_expr] = STATE(767),
    [sym_in_expr] = STATE(767),
    [sym_comp_term] = STATE(767),
    [sym_instance_of] = STATE(767),
    [sym_negation] = STATE(767),
    [sym_if_term] = STATE(767),
    [sym_conjunction] = STATE(767),
    [sym_disjunction] = STATE(767),
    [sym_implication] = STATE(767),
    [sym_quantified] = STATE(767),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(767),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [220] = {
    [sym_special_call] = STATE(696),
    [sym_prefix_cast] = STATE(696),
    [sym_unary_expr] = STATE(696),
    [sym_mul_expr] = STATE(696),
    [sym_add_expr] = STATE(696),
    [sym_in_expr] = STATE(696),
    [sym_comp_term] = STATE(696),
    [sym_instance_of] = STATE(696),
    [sym_negation] = STATE(696),
    [sym_if_term] = STATE(696),
    [sym_conjunction] = STATE(696),
    [sym_disjunction] = STATE(696),
    [sym_implication] = STATE(696),
    [sym_quantified] = STATE(696),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(696),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [221] = {
    [sym_special_call] = STATE(970),
    [sym_prefix_cast] = STATE(970),
    [sym_unary_expr] = STATE(970),
    [sym_mul_expr] = STATE(970),
    [sym_add_expr] = STATE(970),
    [sym_in_expr] = STATE(970),
    [sym_comp_term] = STATE(970),
    [sym_instance_of] = STATE(970),
    [sym_negation] = STATE(970),
    [sym_if_term] = STATE(970),
    [sym_conjunction] = STATE(970),
    [sym_disjunction] = STATE(970),
    [sym_implication] = STATE(970),
    [sym_quantified] = STATE(970),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(970),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [222] = {
    [sym_special_call] = STATE(940),
    [sym_prefix_cast] = STATE(940),
    [sym_unary_expr] = STATE(940),
    [sym_mul_expr] = STATE(940),
    [sym_add_expr] = STATE(940),
    [sym_in_expr] = STATE(940),
    [sym_comp_term] = STATE(940),
    [sym_instance_of] = STATE(940),
    [sym_negation] = STATE(940),
    [sym_if_term] = STATE(940),
    [sym_conjunction] = STATE(940),
    [sym_disjunction] = STATE(940),
    [sym_implication] = STATE(940),
    [sym_quantified] = STATE(940),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(940),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [223] = {
    [sym_special_call] = STATE(781),
    [sym_prefix_cast] = STATE(781),
    [sym_unary_expr] = STATE(781),
    [sym_mul_expr] = STATE(781),
    [sym_add_expr] = STATE(781),
    [sym_in_expr] = STATE(781),
    [sym_comp_term] = STATE(781),
    [sym_instance_of] = STATE(781),
    [sym_negation] = STATE(781),
    [sym_if_term] = STATE(781),
    [sym_conjunction] = STATE(781),
    [sym_disjunction] = STATE(781),
    [sym_implication] = STATE(781),
    [sym_quantified] = STATE(781),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(781),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [224] = {
    [sym_special_call] = STATE(750),
    [sym_prefix_cast] = STATE(750),
    [sym_unary_expr] = STATE(750),
    [sym_mul_expr] = STATE(750),
    [sym_add_expr] = STATE(750),
    [sym_in_expr] = STATE(750),
    [sym_comp_term] = STATE(750),
    [sym_instance_of] = STATE(750),
    [sym_negation] = STATE(750),
    [sym_if_term] = STATE(750),
    [sym_conjunction] = STATE(750),
    [sym_disjunction] = STATE(750),
    [sym_implication] = STATE(750),
    [sym_quantified] = STATE(750),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(750),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [225] = {
    [sym_special_call] = STATE(963),
    [sym_prefix_cast] = STATE(963),
    [sym_unary_expr] = STATE(963),
    [sym_mul_expr] = STATE(963),
    [sym_add_expr] = STATE(963),
    [sym_in_expr] = STATE(963),
    [sym_comp_term] = STATE(963),
    [sym_instance_of] = STATE(963),
    [sym_negation] = STATE(963),
    [sym_if_term] = STATE(963),
    [sym_conjunction] = STATE(963),
    [sym_disjunction] = STATE(963),
    [sym_implication] = STATE(963),
    [sym_quantified] = STATE(963),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(963),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [226] = {
    [sym_special_call] = STATE(694),
    [sym_prefix_cast] = STATE(694),
    [sym_unary_expr] = STATE(694),
    [sym_mul_expr] = STATE(694),
    [sym_add_expr] = STATE(694),
    [sym_in_expr] = STATE(694),
    [sym_comp_term] = STATE(694),
    [sym_instance_of] = STATE(694),
    [sym_negation] = STATE(694),
    [sym_if_term] = STATE(694),
    [sym_conjunction] = STATE(694),
    [sym_disjunction] = STATE(694),
    [sym_implication] = STATE(694),
    [sym_quantified] = STATE(694),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(694),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [227] = {
    [sym_special_call] = STATE(961),
    [sym_prefix_cast] = STATE(961),
    [sym_unary_expr] = STATE(961),
    [sym_mul_expr] = STATE(961),
    [sym_add_expr] = STATE(961),
    [sym_in_expr] = STATE(961),
    [sym_comp_term] = STATE(961),
    [sym_instance_of] = STATE(961),
    [sym_negation] = STATE(961),
    [sym_if_term] = STATE(961),
    [sym_conjunction] = STATE(961),
    [sym_disjunction] = STATE(961),
    [sym_implication] = STATE(961),
    [sym_quantified] = STATE(961),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(961),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [228] = {
    [sym_special_call] = STATE(651),
    [sym_prefix_cast] = STATE(651),
    [sym_unary_expr] = STATE(651),
    [sym_mul_expr] = STATE(651),
    [sym_add_expr] = STATE(651),
    [sym_in_expr] = STATE(651),
    [sym_comp_term] = STATE(651),
    [sym_instance_of] = STATE(651),
    [sym_negation] = STATE(651),
    [sym_if_term] = STATE(651),
    [sym_conjunction] = STATE(651),
    [sym_disjunction] = STATE(651),
    [sym_implication] = STATE(651),
    [sym_quantified] = STATE(651),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(651),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [229] = {
    [sym_special_call] = STATE(936),
    [sym_prefix_cast] = STATE(936),
    [sym_unary_expr] = STATE(936),
    [sym_mul_expr] = STATE(936),
    [sym_add_expr] = STATE(936),
    [sym_in_expr] = STATE(936),
    [sym_comp_term] = STATE(936),
    [sym_instance_of] = STATE(936),
    [sym_negation] = STATE(936),
    [sym_if_term] = STATE(936),
    [sym_conjunction] = STATE(936),
    [sym_disjunction] = STATE(936),
    [sym_implication] = STATE(936),
    [sym_quantified] = STATE(936),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(936),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1433),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [230] = {
    [sym_special_call] = STATE(879),
    [sym_prefix_cast] = STATE(879),
    [sym_unary_expr] = STATE(879),
    [sym_mul_expr] = STATE(879),
    [sym_add_expr] = STATE(879),
    [sym_in_expr] = STATE(879),
    [sym_comp_term] = STATE(879),
    [sym_instance_of] = STATE(879),
    [sym_negation] = STATE(879),
    [sym_if_term] = STATE(879),
    [sym_conjunction] = STATE(879),
    [sym_disjunction] = STATE(879),
    [sym_implication] = STATE(879),
    [sym_quantified] = STATE(879),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(879),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [231] = {
    [sym_special_call] = STATE(882),
    [sym_prefix_cast] = STATE(882),
    [sym_unary_expr] = STATE(882),
    [sym_mul_expr] = STATE(882),
    [sym_add_expr] = STATE(882),
    [sym_in_expr] = STATE(882),
    [sym_comp_term] = STATE(882),
    [sym_instance_of] = STATE(882),
    [sym_negation] = STATE(882),
    [sym_if_term] = STATE(882),
    [sym_conjunction] = STATE(882),
    [sym_disjunction] = STATE(882),
    [sym_implication] = STATE(882),
    [sym_quantified] = STATE(882),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(882),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [232] = {
    [sym_special_call] = STATE(343),
    [sym_prefix_cast] = STATE(343),
    [sym_unary_expr] = STATE(343),
    [sym_mul_expr] = STATE(343),
    [sym_add_expr] = STATE(343),
    [sym_in_expr] = STATE(343),
    [sym_comp_term] = STATE(343),
    [sym_instance_of] = STATE(343),
    [sym_negation] = STATE(343),
    [sym_if_term] = STATE(343),
    [sym_conjunction] = STATE(343),
    [sym_disjunction] = STATE(343),
    [sym_implication] = STATE(343),
    [sym_quantified] = STATE(343),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(343),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [233] = {
    [sym_special_call] = STATE(863),
    [sym_prefix_cast] = STATE(863),
    [sym_unary_expr] = STATE(863),
    [sym_mul_expr] = STATE(863),
    [sym_add_expr] = STATE(863),
    [sym_in_expr] = STATE(863),
    [sym_comp_term] = STATE(863),
    [sym_instance_of] = STATE(863),
    [sym_negation] = STATE(863),
    [sym_if_term] = STATE(863),
    [sym_conjunction] = STATE(863),
    [sym_disjunction] = STATE(863),
    [sym_implication] = STATE(863),
    [sym_quantified] = STATE(863),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(863),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [234] = {
    [sym_special_call] = STATE(672),
    [sym_prefix_cast] = STATE(672),
    [sym_unary_expr] = STATE(672),
    [sym_mul_expr] = STATE(672),
    [sym_add_expr] = STATE(672),
    [sym_in_expr] = STATE(672),
    [sym_comp_term] = STATE(672),
    [sym_instance_of] = STATE(672),
    [sym_negation] = STATE(672),
    [sym_if_term] = STATE(672),
    [sym_conjunction] = STATE(672),
    [sym_disjunction] = STATE(672),
    [sym_implication] = STATE(672),
    [sym_quantified] = STATE(672),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(672),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [235] = {
    [sym_special_call] = STATE(895),
    [sym_prefix_cast] = STATE(895),
    [sym_unary_expr] = STATE(895),
    [sym_mul_expr] = STATE(895),
    [sym_add_expr] = STATE(895),
    [sym_in_expr] = STATE(895),
    [sym_comp_term] = STATE(895),
    [sym_instance_of] = STATE(895),
    [sym_negation] = STATE(895),
    [sym_if_term] = STATE(895),
    [sym_conjunction] = STATE(895),
    [sym_disjunction] = STATE(895),
    [sym_implication] = STATE(895),
    [sym_quantified] = STATE(895),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(895),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [236] = {
    [sym_special_call] = STATE(850),
    [sym_prefix_cast] = STATE(850),
    [sym_unary_expr] = STATE(850),
    [sym_mul_expr] = STATE(850),
    [sym_add_expr] = STATE(850),
    [sym_in_expr] = STATE(850),
    [sym_comp_term] = STATE(850),
    [sym_instance_of] = STATE(850),
    [sym_negation] = STATE(850),
    [sym_if_term] = STATE(850),
    [sym_conjunction] = STATE(850),
    [sym_disjunction] = STATE(850),
    [sym_implication] = STATE(850),
    [sym_quantified] = STATE(850),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(850),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [237] = {
    [sym_special_call] = STATE(671),
    [sym_prefix_cast] = STATE(671),
    [sym_unary_expr] = STATE(671),
    [sym_mul_expr] = STATE(671),
    [sym_add_expr] = STATE(671),
    [sym_in_expr] = STATE(671),
    [sym_comp_term] = STATE(671),
    [sym_instance_of] = STATE(671),
    [sym_negation] = STATE(671),
    [sym_if_term] = STATE(671),
    [sym_conjunction] = STATE(671),
    [sym_disjunction] = STATE(671),
    [sym_implication] = STATE(671),
    [sym_quantified] = STATE(671),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(671),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [238] = {
    [sym_special_call] = STATE(899),
    [sym_prefix_cast] = STATE(899),
    [sym_unary_expr] = STATE(899),
    [sym_mul_expr] = STATE(899),
    [sym_add_expr] = STATE(899),
    [sym_in_expr] = STATE(899),
    [sym_comp_term] = STATE(899),
    [sym_instance_of] = STATE(899),
    [sym_negation] = STATE(899),
    [sym_if_term] = STATE(899),
    [sym_conjunction] = STATE(899),
    [sym_disjunction] = STATE(899),
    [sym_implication] = STATE(899),
    [sym_quantified] = STATE(899),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(899),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [239] = {
    [sym_special_call] = STATE(934),
    [sym_prefix_cast] = STATE(934),
    [sym_unary_expr] = STATE(934),
    [sym_mul_expr] = STATE(934),
    [sym_add_expr] = STATE(934),
    [sym_in_expr] = STATE(934),
    [sym_comp_term] = STATE(934),
    [sym_instance_of] = STATE(934),
    [sym_negation] = STATE(934),
    [sym_if_term] = STATE(934),
    [sym_conjunction] = STATE(934),
    [sym_disjunction] = STATE(934),
    [sym_implication] = STATE(934),
    [sym_quantified] = STATE(934),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(934),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [240] = {
    [sym_special_call] = STATE(640),
    [sym_prefix_cast] = STATE(640),
    [sym_unary_expr] = STATE(640),
    [sym_mul_expr] = STATE(640),
    [sym_add_expr] = STATE(640),
    [sym_in_expr] = STATE(640),
    [sym_comp_term] = STATE(640),
    [sym_instance_of] = STATE(640),
    [sym_negation] = STATE(640),
    [sym_if_term] = STATE(640),
    [sym_conjunction] = STATE(640),
    [sym_disjunction] = STATE(640),
    [sym_implication] = STATE(640),
    [sym_quantified] = STATE(640),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(640),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [241] = {
    [sym_special_call] = STATE(922),
    [sym_prefix_cast] = STATE(922),
    [sym_unary_expr] = STATE(922),
    [sym_mul_expr] = STATE(922),
    [sym_add_expr] = STATE(922),
    [sym_in_expr] = STATE(922),
    [sym_comp_term] = STATE(922),
    [sym_instance_of] = STATE(922),
    [sym_negation] = STATE(922),
    [sym_if_term] = STATE(922),
    [sym_conjunction] = STATE(922),
    [sym_disjunction] = STATE(922),
    [sym_implication] = STATE(922),
    [sym_quantified] = STATE(922),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(922),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1432),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [242] = {
    [sym_special_call] = STATE(992),
    [sym_prefix_cast] = STATE(992),
    [sym_unary_expr] = STATE(992),
    [sym_mul_expr] = STATE(992),
    [sym_add_expr] = STATE(992),
    [sym_in_expr] = STATE(992),
    [sym_comp_term] = STATE(992),
    [sym_instance_of] = STATE(992),
    [sym_negation] = STATE(992),
    [sym_if_term] = STATE(992),
    [sym_conjunction] = STATE(992),
    [sym_disjunction] = STATE(992),
    [sym_implication] = STATE(992),
    [sym_quantified] = STATE(992),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(992),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [243] = {
    [sym_special_call] = STATE(908),
    [sym_prefix_cast] = STATE(908),
    [sym_unary_expr] = STATE(908),
    [sym_mul_expr] = STATE(908),
    [sym_add_expr] = STATE(908),
    [sym_in_expr] = STATE(908),
    [sym_comp_term] = STATE(908),
    [sym_instance_of] = STATE(908),
    [sym_negation] = STATE(908),
    [sym_if_term] = STATE(908),
    [sym_conjunction] = STATE(908),
    [sym_disjunction] = STATE(908),
    [sym_implication] = STATE(908),
    [sym_quantified] = STATE(908),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(908),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [244] = {
    [sym_special_call] = STATE(683),
    [sym_prefix_cast] = STATE(683),
    [sym_unary_expr] = STATE(683),
    [sym_mul_expr] = STATE(683),
    [sym_add_expr] = STATE(683),
    [sym_in_expr] = STATE(683),
    [sym_comp_term] = STATE(683),
    [sym_instance_of] = STATE(683),
    [sym_negation] = STATE(683),
    [sym_if_term] = STATE(683),
    [sym_conjunction] = STATE(683),
    [sym_disjunction] = STATE(683),
    [sym_implication] = STATE(683),
    [sym_quantified] = STATE(683),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(683),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [245] = {
    [sym_special_call] = STATE(358),
    [sym_prefix_cast] = STATE(358),
    [sym_unary_expr] = STATE(358),
    [sym_mul_expr] = STATE(358),
    [sym_add_expr] = STATE(358),
    [sym_in_expr] = STATE(358),
    [sym_comp_term] = STATE(358),
    [sym_instance_of] = STATE(358),
    [sym_negation] = STATE(358),
    [sym_if_term] = STATE(358),
    [sym_conjunction] = STATE(358),
    [sym_disjunction] = STATE(358),
    [sym_implication] = STATE(358),
    [sym_quantified] = STATE(358),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(358),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [246] = {
    [sym_special_call] = STATE(902),
    [sym_prefix_cast] = STATE(902),
    [sym_unary_expr] = STATE(902),
    [sym_mul_expr] = STATE(902),
    [sym_add_expr] = STATE(902),
    [sym_in_expr] = STATE(902),
    [sym_comp_term] = STATE(902),
    [sym_instance_of] = STATE(902),
    [sym_negation] = STATE(902),
    [sym_if_term] = STATE(902),
    [sym_conjunction] = STATE(902),
    [sym_disjunction] = STATE(902),
    [sym_implication] = STATE(902),
    [sym_quantified] = STATE(902),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(902),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [247] = {
    [sym_special_call] = STATE(956),
    [sym_prefix_cast] = STATE(956),
    [sym_unary_expr] = STATE(956),
    [sym_mul_expr] = STATE(956),
    [sym_add_expr] = STATE(956),
    [sym_in_expr] = STATE(956),
    [sym_comp_term] = STATE(956),
    [sym_instance_of] = STATE(956),
    [sym_negation] = STATE(956),
    [sym_if_term] = STATE(956),
    [sym_conjunction] = STATE(956),
    [sym_disjunction] = STATE(956),
    [sym_implication] = STATE(956),
    [sym_quantified] = STATE(956),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(956),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1429),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [248] = {
    [sym_special_call] = STATE(912),
    [sym_prefix_cast] = STATE(912),
    [sym_unary_expr] = STATE(912),
    [sym_mul_expr] = STATE(912),
    [sym_add_expr] = STATE(912),
    [sym_in_expr] = STATE(912),
    [sym_comp_term] = STATE(912),
    [sym_instance_of] = STATE(912),
    [sym_negation] = STATE(912),
    [sym_if_term] = STATE(912),
    [sym_conjunction] = STATE(912),
    [sym_disjunction] = STATE(912),
    [sym_implication] = STATE(912),
    [sym_quantified] = STATE(912),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(912),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [249] = {
    [sym_special_call] = STATE(993),
    [sym_prefix_cast] = STATE(993),
    [sym_unary_expr] = STATE(993),
    [sym_mul_expr] = STATE(993),
    [sym_add_expr] = STATE(993),
    [sym_in_expr] = STATE(993),
    [sym_comp_term] = STATE(993),
    [sym_instance_of] = STATE(993),
    [sym_negation] = STATE(993),
    [sym_if_term] = STATE(993),
    [sym_conjunction] = STATE(993),
    [sym_disjunction] = STATE(993),
    [sym_implication] = STATE(993),
    [sym_quantified] = STATE(993),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(993),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [250] = {
    [sym_special_call] = STATE(885),
    [sym_prefix_cast] = STATE(885),
    [sym_unary_expr] = STATE(885),
    [sym_mul_expr] = STATE(885),
    [sym_add_expr] = STATE(885),
    [sym_in_expr] = STATE(885),
    [sym_comp_term] = STATE(885),
    [sym_instance_of] = STATE(885),
    [sym_negation] = STATE(885),
    [sym_if_term] = STATE(885),
    [sym_conjunction] = STATE(885),
    [sym_disjunction] = STATE(885),
    [sym_implication] = STATE(885),
    [sym_quantified] = STATE(885),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(885),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [251] = {
    [sym_special_call] = STATE(355),
    [sym_prefix_cast] = STATE(355),
    [sym_unary_expr] = STATE(355),
    [sym_mul_expr] = STATE(355),
    [sym_add_expr] = STATE(355),
    [sym_in_expr] = STATE(355),
    [sym_comp_term] = STATE(355),
    [sym_instance_of] = STATE(355),
    [sym_negation] = STATE(355),
    [sym_if_term] = STATE(355),
    [sym_conjunction] = STATE(355),
    [sym_disjunction] = STATE(355),
    [sym_implication] = STATE(355),
    [sym_quantified] = STATE(355),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(355),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [252] = {
    [sym_special_call] = STATE(894),
    [sym_prefix_cast] = STATE(894),
    [sym_unary_expr] = STATE(894),
    [sym_mul_expr] = STATE(894),
    [sym_add_expr] = STATE(894),
    [sym_in_expr] = STATE(894),
    [sym_comp_term] = STATE(894),
    [sym_instance_of] = STATE(894),
    [sym_negation] = STATE(894),
    [sym_if_term] = STATE(894),
    [sym_conjunction] = STATE(894),
    [sym_disjunction] = STATE(894),
    [sym_implication] = STATE(894),
    [sym_quantified] = STATE(894),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(894),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [253] = {
    [sym_special_call] = STATE(371),
    [sym_prefix_cast] = STATE(371),
    [sym_unary_expr] = STATE(371),
    [sym_mul_expr] = STATE(371),
    [sym_add_expr] = STATE(371),
    [sym_in_expr] = STATE(371),
    [sym_comp_term] = STATE(371),
    [sym_instance_of] = STATE(371),
    [sym_negation] = STATE(371),
    [sym_if_term] = STATE(371),
    [sym_conjunction] = STATE(371),
    [sym_disjunction] = STATE(371),
    [sym_implication] = STATE(371),
    [sym_quantified] = STATE(371),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(371),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [254] = {
    [sym_special_call] = STATE(942),
    [sym_prefix_cast] = STATE(942),
    [sym_unary_expr] = STATE(942),
    [sym_mul_expr] = STATE(942),
    [sym_add_expr] = STATE(942),
    [sym_in_expr] = STATE(942),
    [sym_comp_term] = STATE(942),
    [sym_instance_of] = STATE(942),
    [sym_negation] = STATE(942),
    [sym_if_term] = STATE(942),
    [sym_conjunction] = STATE(942),
    [sym_disjunction] = STATE(942),
    [sym_implication] = STATE(942),
    [sym_quantified] = STATE(942),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(942),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [255] = {
    [sym_special_call] = STATE(900),
    [sym_prefix_cast] = STATE(900),
    [sym_unary_expr] = STATE(900),
    [sym_mul_expr] = STATE(900),
    [sym_add_expr] = STATE(900),
    [sym_in_expr] = STATE(900),
    [sym_comp_term] = STATE(900),
    [sym_instance_of] = STATE(900),
    [sym_negation] = STATE(900),
    [sym_if_term] = STATE(900),
    [sym_conjunction] = STATE(900),
    [sym_disjunction] = STATE(900),
    [sym_implication] = STATE(900),
    [sym_quantified] = STATE(900),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(900),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [256] = {
    [sym_special_call] = STATE(688),
    [sym_prefix_cast] = STATE(688),
    [sym_unary_expr] = STATE(688),
    [sym_mul_expr] = STATE(688),
    [sym_add_expr] = STATE(688),
    [sym_in_expr] = STATE(688),
    [sym_comp_term] = STATE(688),
    [sym_instance_of] = STATE(688),
    [sym_negation] = STATE(688),
    [sym_if_term] = STATE(688),
    [sym_conjunction] = STATE(688),
    [sym_disjunction] = STATE(688),
    [sym_implication] = STATE(688),
    [sym_quantified] = STATE(688),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(688),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [257] = {
    [sym_special_call] = STATE(921),
    [sym_prefix_cast] = STATE(921),
    [sym_unary_expr] = STATE(921),
    [sym_mul_expr] = STATE(921),
    [sym_add_expr] = STATE(921),
    [sym_in_expr] = STATE(921),
    [sym_comp_term] = STATE(921),
    [sym_instance_of] = STATE(921),
    [sym_negation] = STATE(921),
    [sym_if_term] = STATE(921),
    [sym_conjunction] = STATE(921),
    [sym_disjunction] = STATE(921),
    [sym_implication] = STATE(921),
    [sym_quantified] = STATE(921),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(921),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [258] = {
    [sym_special_call] = STATE(332),
    [sym_prefix_cast] = STATE(332),
    [sym_unary_expr] = STATE(332),
    [sym_mul_expr] = STATE(332),
    [sym_add_expr] = STATE(332),
    [sym_in_expr] = STATE(332),
    [sym_comp_term] = STATE(332),
    [sym_instance_of] = STATE(332),
    [sym_negation] = STATE(332),
    [sym_if_term] = STATE(332),
    [sym_conjunction] = STATE(332),
    [sym_disjunction] = STATE(332),
    [sym_implication] = STATE(332),
    [sym_quantified] = STATE(332),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(332),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [259] = {
    [sym_special_call] = STATE(369),
    [sym_prefix_cast] = STATE(369),
    [sym_unary_expr] = STATE(369),
    [sym_mul_expr] = STATE(369),
    [sym_add_expr] = STATE(369),
    [sym_in_expr] = STATE(369),
    [sym_comp_term] = STATE(369),
    [sym_instance_of] = STATE(369),
    [sym_negation] = STATE(369),
    [sym_if_term] = STATE(369),
    [sym_conjunction] = STATE(369),
    [sym_disjunction] = STATE(369),
    [sym_implication] = STATE(369),
    [sym_quantified] = STATE(369),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(369),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [260] = {
    [sym_special_call] = STATE(379),
    [sym_prefix_cast] = STATE(379),
    [sym_unary_expr] = STATE(379),
    [sym_mul_expr] = STATE(379),
    [sym_add_expr] = STATE(379),
    [sym_in_expr] = STATE(379),
    [sym_comp_term] = STATE(379),
    [sym_instance_of] = STATE(379),
    [sym_negation] = STATE(379),
    [sym_if_term] = STATE(379),
    [sym_conjunction] = STATE(379),
    [sym_disjunction] = STATE(379),
    [sym_implication] = STATE(379),
    [sym_quantified] = STATE(379),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(379),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [261] = {
    [sym_special_call] = STATE(951),
    [sym_prefix_cast] = STATE(951),
    [sym_unary_expr] = STATE(951),
    [sym_mul_expr] = STATE(951),
    [sym_add_expr] = STATE(951),
    [sym_in_expr] = STATE(951),
    [sym_comp_term] = STATE(951),
    [sym_instance_of] = STATE(951),
    [sym_negation] = STATE(951),
    [sym_if_term] = STATE(951),
    [sym_conjunction] = STATE(951),
    [sym_disjunction] = STATE(951),
    [sym_implication] = STATE(951),
    [sym_quantified] = STATE(951),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(951),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [262] = {
    [sym_special_call] = STATE(375),
    [sym_prefix_cast] = STATE(375),
    [sym_unary_expr] = STATE(375),
    [sym_mul_expr] = STATE(375),
    [sym_add_expr] = STATE(375),
    [sym_in_expr] = STATE(375),
    [sym_comp_term] = STATE(375),
    [sym_instance_of] = STATE(375),
    [sym_negation] = STATE(375),
    [sym_if_term] = STATE(375),
    [sym_conjunction] = STATE(375),
    [sym_disjunction] = STATE(375),
    [sym_implication] = STATE(375),
    [sym_quantified] = STATE(375),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(375),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [263] = {
    [sym_special_call] = STATE(374),
    [sym_prefix_cast] = STATE(374),
    [sym_unary_expr] = STATE(374),
    [sym_mul_expr] = STATE(374),
    [sym_add_expr] = STATE(374),
    [sym_in_expr] = STATE(374),
    [sym_comp_term] = STATE(374),
    [sym_instance_of] = STATE(374),
    [sym_negation] = STATE(374),
    [sym_if_term] = STATE(374),
    [sym_conjunction] = STATE(374),
    [sym_disjunction] = STATE(374),
    [sym_implication] = STATE(374),
    [sym_quantified] = STATE(374),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(374),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [264] = {
    [sym_special_call] = STATE(349),
    [sym_prefix_cast] = STATE(349),
    [sym_unary_expr] = STATE(349),
    [sym_mul_expr] = STATE(349),
    [sym_add_expr] = STATE(349),
    [sym_in_expr] = STATE(349),
    [sym_comp_term] = STATE(349),
    [sym_instance_of] = STATE(349),
    [sym_negation] = STATE(349),
    [sym_if_term] = STATE(349),
    [sym_conjunction] = STATE(349),
    [sym_disjunction] = STATE(349),
    [sym_implication] = STATE(349),
    [sym_quantified] = STATE(349),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(349),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [265] = {
    [sym_special_call] = STATE(368),
    [sym_prefix_cast] = STATE(368),
    [sym_unary_expr] = STATE(368),
    [sym_mul_expr] = STATE(368),
    [sym_add_expr] = STATE(368),
    [sym_in_expr] = STATE(368),
    [sym_comp_term] = STATE(368),
    [sym_instance_of] = STATE(368),
    [sym_negation] = STATE(368),
    [sym_if_term] = STATE(368),
    [sym_conjunction] = STATE(368),
    [sym_disjunction] = STATE(368),
    [sym_implication] = STATE(368),
    [sym_quantified] = STATE(368),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(368),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [266] = {
    [sym_special_call] = STATE(333),
    [sym_prefix_cast] = STATE(333),
    [sym_unary_expr] = STATE(333),
    [sym_mul_expr] = STATE(333),
    [sym_add_expr] = STATE(333),
    [sym_in_expr] = STATE(333),
    [sym_comp_term] = STATE(333),
    [sym_instance_of] = STATE(333),
    [sym_negation] = STATE(333),
    [sym_if_term] = STATE(333),
    [sym_conjunction] = STATE(333),
    [sym_disjunction] = STATE(333),
    [sym_implication] = STATE(333),
    [sym_quantified] = STATE(333),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(333),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [267] = {
    [sym_special_call] = STATE(335),
    [sym_prefix_cast] = STATE(335),
    [sym_unary_expr] = STATE(335),
    [sym_mul_expr] = STATE(335),
    [sym_add_expr] = STATE(335),
    [sym_in_expr] = STATE(335),
    [sym_comp_term] = STATE(335),
    [sym_instance_of] = STATE(335),
    [sym_negation] = STATE(335),
    [sym_if_term] = STATE(335),
    [sym_conjunction] = STATE(335),
    [sym_disjunction] = STATE(335),
    [sym_implication] = STATE(335),
    [sym_quantified] = STATE(335),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(335),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [268] = {
    [sym_special_call] = STATE(336),
    [sym_prefix_cast] = STATE(336),
    [sym_unary_expr] = STATE(336),
    [sym_mul_expr] = STATE(336),
    [sym_add_expr] = STATE(336),
    [sym_in_expr] = STATE(336),
    [sym_comp_term] = STATE(336),
    [sym_instance_of] = STATE(336),
    [sym_negation] = STATE(336),
    [sym_if_term] = STATE(336),
    [sym_conjunction] = STATE(336),
    [sym_disjunction] = STATE(336),
    [sym_implication] = STATE(336),
    [sym_quantified] = STATE(336),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(336),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [269] = {
    [sym_special_call] = STATE(365),
    [sym_prefix_cast] = STATE(365),
    [sym_unary_expr] = STATE(365),
    [sym_mul_expr] = STATE(365),
    [sym_add_expr] = STATE(365),
    [sym_in_expr] = STATE(365),
    [sym_comp_term] = STATE(365),
    [sym_instance_of] = STATE(365),
    [sym_negation] = STATE(365),
    [sym_if_term] = STATE(365),
    [sym_conjunction] = STATE(365),
    [sym_disjunction] = STATE(365),
    [sym_implication] = STATE(365),
    [sym_quantified] = STATE(365),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(365),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [270] = {
    [sym_special_call] = STATE(364),
    [sym_prefix_cast] = STATE(364),
    [sym_unary_expr] = STATE(364),
    [sym_mul_expr] = STATE(364),
    [sym_add_expr] = STATE(364),
    [sym_in_expr] = STATE(364),
    [sym_comp_term] = STATE(364),
    [sym_instance_of] = STATE(364),
    [sym_negation] = STATE(364),
    [sym_if_term] = STATE(364),
    [sym_conjunction] = STATE(364),
    [sym_disjunction] = STATE(364),
    [sym_implication] = STATE(364),
    [sym_quantified] = STATE(364),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(364),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [271] = {
    [sym_special_call] = STATE(363),
    [sym_prefix_cast] = STATE(363),
    [sym_unary_expr] = STATE(363),
    [sym_mul_expr] = STATE(363),
    [sym_add_expr] = STATE(363),
    [sym_in_expr] = STATE(363),
    [sym_comp_term] = STATE(363),
    [sym_instance_of] = STATE(363),
    [sym_negation] = STATE(363),
    [sym_if_term] = STATE(363),
    [sym_conjunction] = STATE(363),
    [sym_disjunction] = STATE(363),
    [sym_implication] = STATE(363),
    [sym_quantified] = STATE(363),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(363),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [272] = {
    [sym_special_call] = STATE(670),
    [sym_prefix_cast] = STATE(670),
    [sym_unary_expr] = STATE(670),
    [sym_mul_expr] = STATE(670),
    [sym_add_expr] = STATE(670),
    [sym_in_expr] = STATE(670),
    [sym_comp_term] = STATE(670),
    [sym_instance_of] = STATE(670),
    [sym_negation] = STATE(670),
    [sym_if_term] = STATE(670),
    [sym_conjunction] = STATE(670),
    [sym_disjunction] = STATE(670),
    [sym_implication] = STATE(670),
    [sym_quantified] = STATE(670),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(670),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [273] = {
    [sym_special_call] = STATE(634),
    [sym_prefix_cast] = STATE(634),
    [sym_unary_expr] = STATE(634),
    [sym_mul_expr] = STATE(634),
    [sym_add_expr] = STATE(634),
    [sym_in_expr] = STATE(634),
    [sym_comp_term] = STATE(634),
    [sym_instance_of] = STATE(634),
    [sym_negation] = STATE(634),
    [sym_if_term] = STATE(634),
    [sym_conjunction] = STATE(634),
    [sym_disjunction] = STATE(634),
    [sym_implication] = STATE(634),
    [sym_quantified] = STATE(634),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(634),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [274] = {
    [sym_special_call] = STATE(362),
    [sym_prefix_cast] = STATE(362),
    [sym_unary_expr] = STATE(362),
    [sym_mul_expr] = STATE(362),
    [sym_add_expr] = STATE(362),
    [sym_in_expr] = STATE(362),
    [sym_comp_term] = STATE(362),
    [sym_instance_of] = STATE(362),
    [sym_negation] = STATE(362),
    [sym_if_term] = STATE(362),
    [sym_conjunction] = STATE(362),
    [sym_disjunction] = STATE(362),
    [sym_implication] = STATE(362),
    [sym_quantified] = STATE(362),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(362),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [275] = {
    [sym_special_call] = STATE(886),
    [sym_prefix_cast] = STATE(886),
    [sym_unary_expr] = STATE(886),
    [sym_mul_expr] = STATE(886),
    [sym_add_expr] = STATE(886),
    [sym_in_expr] = STATE(886),
    [sym_comp_term] = STATE(886),
    [sym_instance_of] = STATE(886),
    [sym_negation] = STATE(886),
    [sym_if_term] = STATE(886),
    [sym_conjunction] = STATE(886),
    [sym_disjunction] = STATE(886),
    [sym_implication] = STATE(886),
    [sym_quantified] = STATE(886),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(886),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [276] = {
    [sym_special_call] = STATE(360),
    [sym_prefix_cast] = STATE(360),
    [sym_unary_expr] = STATE(360),
    [sym_mul_expr] = STATE(360),
    [sym_add_expr] = STATE(360),
    [sym_in_expr] = STATE(360),
    [sym_comp_term] = STATE(360),
    [sym_instance_of] = STATE(360),
    [sym_negation] = STATE(360),
    [sym_if_term] = STATE(360),
    [sym_conjunction] = STATE(360),
    [sym_disjunction] = STATE(360),
    [sym_implication] = STATE(360),
    [sym_quantified] = STATE(360),
    [sym_quantifier] = STATE(1532),
    [sym_call_or_unqual_agg_expr] = STATE(430),
    [sym_qualified_expr] = STATE(430),
    [sym_super_ref] = STATE(430),
    [sym_aggregate] = STATE(430),
    [sym_range] = STATE(430),
    [sym_set_literal] = STATE(430),
    [sym_par_expr] = STATE(430),
    [sym__exprOrTerm] = STATE(360),
    [sym__primary] = STATE(430),
    [sym_literal] = STATE(430),
    [sym_bool] = STATE(426),
    [sym_variable] = STATE(430),
    [sym_unop] = STATE(276),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(382),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1533),
    [sym_aritylessPredicateExpr] = STATE(1166),
    [sym_varName] = STATE(428),
    [sym_aggId] = STATE(1424),
    [sym__lower_id] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_not] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [sym_specialId] = ACTIONS(503),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(507),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(511),
    [sym_string] = ACTIONS(511),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(513),
    [sym_result] = ACTIONS(515),
    [sym_super] = ACTIONS(517),
    [sym_this] = ACTIONS(515),
    [sym_true] = ACTIONS(513),
  },
  [277] = {
    [sym_special_call] = STATE(868),
    [sym_prefix_cast] = STATE(868),
    [sym_unary_expr] = STATE(868),
    [sym_mul_expr] = STATE(868),
    [sym_add_expr] = STATE(868),
    [sym_in_expr] = STATE(868),
    [sym_comp_term] = STATE(868),
    [sym_instance_of] = STATE(868),
    [sym_negation] = STATE(868),
    [sym_if_term] = STATE(868),
    [sym_conjunction] = STATE(868),
    [sym_disjunction] = STATE(868),
    [sym_implication] = STATE(868),
    [sym_quantified] = STATE(868),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(868),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [278] = {
    [sym_special_call] = STATE(699),
    [sym_prefix_cast] = STATE(699),
    [sym_unary_expr] = STATE(699),
    [sym_mul_expr] = STATE(699),
    [sym_add_expr] = STATE(699),
    [sym_in_expr] = STATE(699),
    [sym_comp_term] = STATE(699),
    [sym_instance_of] = STATE(699),
    [sym_negation] = STATE(699),
    [sym_if_term] = STATE(699),
    [sym_conjunction] = STATE(699),
    [sym_disjunction] = STATE(699),
    [sym_implication] = STATE(699),
    [sym_quantified] = STATE(699),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(699),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [279] = {
    [sym_special_call] = STATE(698),
    [sym_prefix_cast] = STATE(698),
    [sym_unary_expr] = STATE(698),
    [sym_mul_expr] = STATE(698),
    [sym_add_expr] = STATE(698),
    [sym_in_expr] = STATE(698),
    [sym_comp_term] = STATE(698),
    [sym_instance_of] = STATE(698),
    [sym_negation] = STATE(698),
    [sym_if_term] = STATE(698),
    [sym_conjunction] = STATE(698),
    [sym_disjunction] = STATE(698),
    [sym_implication] = STATE(698),
    [sym_quantified] = STATE(698),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(698),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [280] = {
    [sym_special_call] = STATE(695),
    [sym_prefix_cast] = STATE(695),
    [sym_unary_expr] = STATE(695),
    [sym_mul_expr] = STATE(695),
    [sym_add_expr] = STATE(695),
    [sym_in_expr] = STATE(695),
    [sym_comp_term] = STATE(695),
    [sym_instance_of] = STATE(695),
    [sym_negation] = STATE(695),
    [sym_if_term] = STATE(695),
    [sym_conjunction] = STATE(695),
    [sym_disjunction] = STATE(695),
    [sym_implication] = STATE(695),
    [sym_quantified] = STATE(695),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(695),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [281] = {
    [sym_special_call] = STATE(675),
    [sym_prefix_cast] = STATE(675),
    [sym_unary_expr] = STATE(675),
    [sym_mul_expr] = STATE(675),
    [sym_add_expr] = STATE(675),
    [sym_in_expr] = STATE(675),
    [sym_comp_term] = STATE(675),
    [sym_instance_of] = STATE(675),
    [sym_negation] = STATE(675),
    [sym_if_term] = STATE(675),
    [sym_conjunction] = STATE(675),
    [sym_disjunction] = STATE(675),
    [sym_implication] = STATE(675),
    [sym_quantified] = STATE(675),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(675),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [282] = {
    [sym_special_call] = STATE(692),
    [sym_prefix_cast] = STATE(692),
    [sym_unary_expr] = STATE(692),
    [sym_mul_expr] = STATE(692),
    [sym_add_expr] = STATE(692),
    [sym_in_expr] = STATE(692),
    [sym_comp_term] = STATE(692),
    [sym_instance_of] = STATE(692),
    [sym_negation] = STATE(692),
    [sym_if_term] = STATE(692),
    [sym_conjunction] = STATE(692),
    [sym_disjunction] = STATE(692),
    [sym_implication] = STATE(692),
    [sym_quantified] = STATE(692),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(692),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [283] = {
    [sym_special_call] = STATE(687),
    [sym_prefix_cast] = STATE(687),
    [sym_unary_expr] = STATE(687),
    [sym_mul_expr] = STATE(687),
    [sym_add_expr] = STATE(687),
    [sym_in_expr] = STATE(687),
    [sym_comp_term] = STATE(687),
    [sym_instance_of] = STATE(687),
    [sym_negation] = STATE(687),
    [sym_if_term] = STATE(687),
    [sym_conjunction] = STATE(687),
    [sym_disjunction] = STATE(687),
    [sym_implication] = STATE(687),
    [sym_quantified] = STATE(687),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(687),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [284] = {
    [sym_special_call] = STATE(666),
    [sym_prefix_cast] = STATE(666),
    [sym_unary_expr] = STATE(666),
    [sym_mul_expr] = STATE(666),
    [sym_add_expr] = STATE(666),
    [sym_in_expr] = STATE(666),
    [sym_comp_term] = STATE(666),
    [sym_instance_of] = STATE(666),
    [sym_negation] = STATE(666),
    [sym_if_term] = STATE(666),
    [sym_conjunction] = STATE(666),
    [sym_disjunction] = STATE(666),
    [sym_implication] = STATE(666),
    [sym_quantified] = STATE(666),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(666),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [285] = {
    [sym_special_call] = STATE(685),
    [sym_prefix_cast] = STATE(685),
    [sym_unary_expr] = STATE(685),
    [sym_mul_expr] = STATE(685),
    [sym_add_expr] = STATE(685),
    [sym_in_expr] = STATE(685),
    [sym_comp_term] = STATE(685),
    [sym_instance_of] = STATE(685),
    [sym_negation] = STATE(685),
    [sym_if_term] = STATE(685),
    [sym_conjunction] = STATE(685),
    [sym_disjunction] = STATE(685),
    [sym_implication] = STATE(685),
    [sym_quantified] = STATE(685),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(685),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [286] = {
    [sym_special_call] = STATE(664),
    [sym_prefix_cast] = STATE(664),
    [sym_unary_expr] = STATE(664),
    [sym_mul_expr] = STATE(664),
    [sym_add_expr] = STATE(664),
    [sym_in_expr] = STATE(664),
    [sym_comp_term] = STATE(664),
    [sym_instance_of] = STATE(664),
    [sym_negation] = STATE(664),
    [sym_if_term] = STATE(664),
    [sym_conjunction] = STATE(664),
    [sym_disjunction] = STATE(664),
    [sym_implication] = STATE(664),
    [sym_quantified] = STATE(664),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(664),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [287] = {
    [sym_special_call] = STATE(684),
    [sym_prefix_cast] = STATE(684),
    [sym_unary_expr] = STATE(684),
    [sym_mul_expr] = STATE(684),
    [sym_add_expr] = STATE(684),
    [sym_in_expr] = STATE(684),
    [sym_comp_term] = STATE(684),
    [sym_instance_of] = STATE(684),
    [sym_negation] = STATE(684),
    [sym_if_term] = STATE(684),
    [sym_conjunction] = STATE(684),
    [sym_disjunction] = STATE(684),
    [sym_implication] = STATE(684),
    [sym_quantified] = STATE(684),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(684),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [288] = {
    [sym_special_call] = STATE(716),
    [sym_prefix_cast] = STATE(716),
    [sym_unary_expr] = STATE(716),
    [sym_mul_expr] = STATE(716),
    [sym_add_expr] = STATE(716),
    [sym_in_expr] = STATE(716),
    [sym_comp_term] = STATE(716),
    [sym_instance_of] = STATE(716),
    [sym_negation] = STATE(716),
    [sym_if_term] = STATE(716),
    [sym_conjunction] = STATE(716),
    [sym_disjunction] = STATE(716),
    [sym_implication] = STATE(716),
    [sym_quantified] = STATE(716),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(716),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [289] = {
    [sym_special_call] = STATE(679),
    [sym_prefix_cast] = STATE(679),
    [sym_unary_expr] = STATE(679),
    [sym_mul_expr] = STATE(679),
    [sym_add_expr] = STATE(679),
    [sym_in_expr] = STATE(679),
    [sym_comp_term] = STATE(679),
    [sym_instance_of] = STATE(679),
    [sym_negation] = STATE(679),
    [sym_if_term] = STATE(679),
    [sym_conjunction] = STATE(679),
    [sym_disjunction] = STATE(679),
    [sym_implication] = STATE(679),
    [sym_quantified] = STATE(679),
    [sym_quantifier] = STATE(1508),
    [sym_call_or_unqual_agg_expr] = STATE(832),
    [sym_qualified_expr] = STATE(832),
    [sym_super_ref] = STATE(832),
    [sym_aggregate] = STATE(832),
    [sym_range] = STATE(832),
    [sym_set_literal] = STATE(832),
    [sym_par_expr] = STATE(832),
    [sym__exprOrTerm] = STATE(679),
    [sym__primary] = STATE(832),
    [sym_literal] = STATE(832),
    [sym_bool] = STATE(837),
    [sym_variable] = STATE(832),
    [sym_unop] = STATE(289),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(719),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1509),
    [sym_aritylessPredicateExpr] = STATE(1153),
    [sym_varName] = STATE(835),
    [sym_aggId] = STATE(1430),
    [sym__lower_id] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [sym_specialId] = ACTIONS(451),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(455),
    [sym_integer] = ACTIONS(457),
    [sym_float] = ACTIONS(459),
    [sym_string] = ACTIONS(459),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(461),
    [sym_result] = ACTIONS(463),
    [sym_super] = ACTIONS(465),
    [sym_this] = ACTIONS(463),
    [sym_true] = ACTIONS(461),
  },
  [290] = {
    [sym_special_call] = STATE(964),
    [sym_prefix_cast] = STATE(964),
    [sym_unary_expr] = STATE(964),
    [sym_mul_expr] = STATE(964),
    [sym_add_expr] = STATE(964),
    [sym_in_expr] = STATE(964),
    [sym_comp_term] = STATE(964),
    [sym_instance_of] = STATE(964),
    [sym_negation] = STATE(964),
    [sym_if_term] = STATE(964),
    [sym_conjunction] = STATE(964),
    [sym_disjunction] = STATE(964),
    [sym_implication] = STATE(964),
    [sym_quantified] = STATE(964),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(964),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [291] = {
    [sym_special_call] = STATE(715),
    [sym_prefix_cast] = STATE(715),
    [sym_unary_expr] = STATE(715),
    [sym_mul_expr] = STATE(715),
    [sym_add_expr] = STATE(715),
    [sym_in_expr] = STATE(715),
    [sym_comp_term] = STATE(715),
    [sym_instance_of] = STATE(715),
    [sym_negation] = STATE(715),
    [sym_if_term] = STATE(715),
    [sym_conjunction] = STATE(715),
    [sym_disjunction] = STATE(715),
    [sym_implication] = STATE(715),
    [sym_quantified] = STATE(715),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(715),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [292] = {
    [sym_special_call] = STATE(967),
    [sym_prefix_cast] = STATE(967),
    [sym_unary_expr] = STATE(967),
    [sym_mul_expr] = STATE(967),
    [sym_add_expr] = STATE(967),
    [sym_in_expr] = STATE(967),
    [sym_comp_term] = STATE(967),
    [sym_instance_of] = STATE(967),
    [sym_negation] = STATE(967),
    [sym_if_term] = STATE(967),
    [sym_conjunction] = STATE(967),
    [sym_disjunction] = STATE(967),
    [sym_implication] = STATE(967),
    [sym_quantified] = STATE(967),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(967),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [293] = {
    [sym_special_call] = STATE(689),
    [sym_prefix_cast] = STATE(689),
    [sym_unary_expr] = STATE(689),
    [sym_mul_expr] = STATE(689),
    [sym_add_expr] = STATE(689),
    [sym_in_expr] = STATE(689),
    [sym_comp_term] = STATE(689),
    [sym_instance_of] = STATE(689),
    [sym_negation] = STATE(689),
    [sym_if_term] = STATE(689),
    [sym_conjunction] = STATE(689),
    [sym_disjunction] = STATE(689),
    [sym_implication] = STATE(689),
    [sym_quantified] = STATE(689),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(689),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [294] = {
    [sym_special_call] = STATE(714),
    [sym_prefix_cast] = STATE(714),
    [sym_unary_expr] = STATE(714),
    [sym_mul_expr] = STATE(714),
    [sym_add_expr] = STATE(714),
    [sym_in_expr] = STATE(714),
    [sym_comp_term] = STATE(714),
    [sym_instance_of] = STATE(714),
    [sym_negation] = STATE(714),
    [sym_if_term] = STATE(714),
    [sym_conjunction] = STATE(714),
    [sym_disjunction] = STATE(714),
    [sym_implication] = STATE(714),
    [sym_quantified] = STATE(714),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(714),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [295] = {
    [sym_special_call] = STATE(693),
    [sym_prefix_cast] = STATE(693),
    [sym_unary_expr] = STATE(693),
    [sym_mul_expr] = STATE(693),
    [sym_add_expr] = STATE(693),
    [sym_in_expr] = STATE(693),
    [sym_comp_term] = STATE(693),
    [sym_instance_of] = STATE(693),
    [sym_negation] = STATE(693),
    [sym_if_term] = STATE(693),
    [sym_conjunction] = STATE(693),
    [sym_disjunction] = STATE(693),
    [sym_implication] = STATE(693),
    [sym_quantified] = STATE(693),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(693),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [296] = {
    [sym_special_call] = STATE(669),
    [sym_prefix_cast] = STATE(669),
    [sym_unary_expr] = STATE(669),
    [sym_mul_expr] = STATE(669),
    [sym_add_expr] = STATE(669),
    [sym_in_expr] = STATE(669),
    [sym_comp_term] = STATE(669),
    [sym_instance_of] = STATE(669),
    [sym_negation] = STATE(669),
    [sym_if_term] = STATE(669),
    [sym_conjunction] = STATE(669),
    [sym_disjunction] = STATE(669),
    [sym_implication] = STATE(669),
    [sym_quantified] = STATE(669),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(669),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [297] = {
    [sym_special_call] = STATE(668),
    [sym_prefix_cast] = STATE(668),
    [sym_unary_expr] = STATE(668),
    [sym_mul_expr] = STATE(668),
    [sym_add_expr] = STATE(668),
    [sym_in_expr] = STATE(668),
    [sym_comp_term] = STATE(668),
    [sym_instance_of] = STATE(668),
    [sym_negation] = STATE(668),
    [sym_if_term] = STATE(668),
    [sym_conjunction] = STATE(668),
    [sym_disjunction] = STATE(668),
    [sym_implication] = STATE(668),
    [sym_quantified] = STATE(668),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(668),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [298] = {
    [sym_special_call] = STATE(706),
    [sym_prefix_cast] = STATE(706),
    [sym_unary_expr] = STATE(706),
    [sym_mul_expr] = STATE(706),
    [sym_add_expr] = STATE(706),
    [sym_in_expr] = STATE(706),
    [sym_comp_term] = STATE(706),
    [sym_instance_of] = STATE(706),
    [sym_negation] = STATE(706),
    [sym_if_term] = STATE(706),
    [sym_conjunction] = STATE(706),
    [sym_disjunction] = STATE(706),
    [sym_implication] = STATE(706),
    [sym_quantified] = STATE(706),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(706),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [299] = {
    [sym_special_call] = STATE(353),
    [sym_prefix_cast] = STATE(353),
    [sym_unary_expr] = STATE(353),
    [sym_mul_expr] = STATE(353),
    [sym_add_expr] = STATE(353),
    [sym_in_expr] = STATE(353),
    [sym_comp_term] = STATE(353),
    [sym_instance_of] = STATE(353),
    [sym_negation] = STATE(353),
    [sym_if_term] = STATE(353),
    [sym_conjunction] = STATE(353),
    [sym_disjunction] = STATE(353),
    [sym_implication] = STATE(353),
    [sym_quantified] = STATE(353),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(353),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [300] = {
    [sym_special_call] = STATE(700),
    [sym_prefix_cast] = STATE(700),
    [sym_unary_expr] = STATE(700),
    [sym_mul_expr] = STATE(700),
    [sym_add_expr] = STATE(700),
    [sym_in_expr] = STATE(700),
    [sym_comp_term] = STATE(700),
    [sym_instance_of] = STATE(700),
    [sym_negation] = STATE(700),
    [sym_if_term] = STATE(700),
    [sym_conjunction] = STATE(700),
    [sym_disjunction] = STATE(700),
    [sym_implication] = STATE(700),
    [sym_quantified] = STATE(700),
    [sym_quantifier] = STATE(1450),
    [sym_call_or_unqual_agg_expr] = STATE(807),
    [sym_qualified_expr] = STATE(807),
    [sym_super_ref] = STATE(807),
    [sym_aggregate] = STATE(807),
    [sym_range] = STATE(807),
    [sym_set_literal] = STATE(807),
    [sym_par_expr] = STATE(807),
    [sym__exprOrTerm] = STATE(700),
    [sym__primary] = STATE(807),
    [sym_literal] = STATE(807),
    [sym_bool] = STATE(798),
    [sym_variable] = STATE(807),
    [sym_unop] = STATE(186),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(718),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1472),
    [sym_aritylessPredicateExpr] = STATE(1168),
    [sym_varName] = STATE(803),
    [sym_aggId] = STATE(1437),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [301] = {
    [sym_special_call] = STATE(969),
    [sym_prefix_cast] = STATE(969),
    [sym_unary_expr] = STATE(969),
    [sym_mul_expr] = STATE(969),
    [sym_add_expr] = STATE(969),
    [sym_in_expr] = STATE(969),
    [sym_comp_term] = STATE(969),
    [sym_instance_of] = STATE(969),
    [sym_negation] = STATE(969),
    [sym_if_term] = STATE(969),
    [sym_conjunction] = STATE(969),
    [sym_disjunction] = STATE(969),
    [sym_implication] = STATE(969),
    [sym_quantified] = STATE(969),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(969),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [302] = {
    [sym_special_call] = STATE(354),
    [sym_prefix_cast] = STATE(354),
    [sym_unary_expr] = STATE(354),
    [sym_mul_expr] = STATE(354),
    [sym_add_expr] = STATE(354),
    [sym_in_expr] = STATE(354),
    [sym_comp_term] = STATE(354),
    [sym_instance_of] = STATE(354),
    [sym_negation] = STATE(354),
    [sym_if_term] = STATE(354),
    [sym_conjunction] = STATE(354),
    [sym_disjunction] = STATE(354),
    [sym_implication] = STATE(354),
    [sym_quantified] = STATE(354),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(354),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [303] = {
    [sym_special_call] = STATE(341),
    [sym_prefix_cast] = STATE(341),
    [sym_unary_expr] = STATE(341),
    [sym_mul_expr] = STATE(341),
    [sym_add_expr] = STATE(341),
    [sym_in_expr] = STATE(341),
    [sym_comp_term] = STATE(341),
    [sym_instance_of] = STATE(341),
    [sym_negation] = STATE(341),
    [sym_if_term] = STATE(341),
    [sym_conjunction] = STATE(341),
    [sym_disjunction] = STATE(341),
    [sym_implication] = STATE(341),
    [sym_quantified] = STATE(341),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(341),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [304] = {
    [sym_special_call] = STATE(381),
    [sym_prefix_cast] = STATE(381),
    [sym_unary_expr] = STATE(381),
    [sym_mul_expr] = STATE(381),
    [sym_add_expr] = STATE(381),
    [sym_in_expr] = STATE(381),
    [sym_comp_term] = STATE(381),
    [sym_instance_of] = STATE(381),
    [sym_negation] = STATE(381),
    [sym_if_term] = STATE(381),
    [sym_conjunction] = STATE(381),
    [sym_disjunction] = STATE(381),
    [sym_implication] = STATE(381),
    [sym_quantified] = STATE(381),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(381),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [305] = {
    [sym_special_call] = STATE(373),
    [sym_prefix_cast] = STATE(373),
    [sym_unary_expr] = STATE(373),
    [sym_mul_expr] = STATE(373),
    [sym_add_expr] = STATE(373),
    [sym_in_expr] = STATE(373),
    [sym_comp_term] = STATE(373),
    [sym_instance_of] = STATE(373),
    [sym_negation] = STATE(373),
    [sym_if_term] = STATE(373),
    [sym_conjunction] = STATE(373),
    [sym_disjunction] = STATE(373),
    [sym_implication] = STATE(373),
    [sym_quantified] = STATE(373),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(373),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [306] = {
    [sym_special_call] = STATE(361),
    [sym_prefix_cast] = STATE(361),
    [sym_unary_expr] = STATE(361),
    [sym_mul_expr] = STATE(361),
    [sym_add_expr] = STATE(361),
    [sym_in_expr] = STATE(361),
    [sym_comp_term] = STATE(361),
    [sym_instance_of] = STATE(361),
    [sym_negation] = STATE(361),
    [sym_if_term] = STATE(361),
    [sym_conjunction] = STATE(361),
    [sym_disjunction] = STATE(361),
    [sym_implication] = STATE(361),
    [sym_quantified] = STATE(361),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(361),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [307] = {
    [sym_special_call] = STATE(334),
    [sym_prefix_cast] = STATE(334),
    [sym_unary_expr] = STATE(334),
    [sym_mul_expr] = STATE(334),
    [sym_add_expr] = STATE(334),
    [sym_in_expr] = STATE(334),
    [sym_comp_term] = STATE(334),
    [sym_instance_of] = STATE(334),
    [sym_negation] = STATE(334),
    [sym_if_term] = STATE(334),
    [sym_conjunction] = STATE(334),
    [sym_disjunction] = STATE(334),
    [sym_implication] = STATE(334),
    [sym_quantified] = STATE(334),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(334),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [308] = {
    [sym_special_call] = STATE(840),
    [sym_prefix_cast] = STATE(840),
    [sym_unary_expr] = STATE(840),
    [sym_mul_expr] = STATE(840),
    [sym_add_expr] = STATE(840),
    [sym_in_expr] = STATE(840),
    [sym_comp_term] = STATE(840),
    [sym_instance_of] = STATE(840),
    [sym_negation] = STATE(840),
    [sym_if_term] = STATE(840),
    [sym_conjunction] = STATE(840),
    [sym_disjunction] = STATE(840),
    [sym_implication] = STATE(840),
    [sym_quantified] = STATE(840),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(840),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [309] = {
    [sym_special_call] = STATE(345),
    [sym_prefix_cast] = STATE(345),
    [sym_unary_expr] = STATE(345),
    [sym_mul_expr] = STATE(345),
    [sym_add_expr] = STATE(345),
    [sym_in_expr] = STATE(345),
    [sym_comp_term] = STATE(345),
    [sym_instance_of] = STATE(345),
    [sym_negation] = STATE(345),
    [sym_if_term] = STATE(345),
    [sym_conjunction] = STATE(345),
    [sym_disjunction] = STATE(345),
    [sym_implication] = STATE(345),
    [sym_quantified] = STATE(345),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(345),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [310] = {
    [sym_special_call] = STATE(350),
    [sym_prefix_cast] = STATE(350),
    [sym_unary_expr] = STATE(350),
    [sym_mul_expr] = STATE(350),
    [sym_add_expr] = STATE(350),
    [sym_in_expr] = STATE(350),
    [sym_comp_term] = STATE(350),
    [sym_instance_of] = STATE(350),
    [sym_negation] = STATE(350),
    [sym_if_term] = STATE(350),
    [sym_conjunction] = STATE(350),
    [sym_disjunction] = STATE(350),
    [sym_implication] = STATE(350),
    [sym_quantified] = STATE(350),
    [sym_quantifier] = STATE(1590),
    [sym_call_or_unqual_agg_expr] = STATE(460),
    [sym_qualified_expr] = STATE(460),
    [sym_super_ref] = STATE(460),
    [sym_aggregate] = STATE(460),
    [sym_range] = STATE(460),
    [sym_set_literal] = STATE(460),
    [sym_par_expr] = STATE(460),
    [sym__exprOrTerm] = STATE(350),
    [sym__primary] = STATE(460),
    [sym_literal] = STATE(460),
    [sym_bool] = STATE(456),
    [sym_variable] = STATE(460),
    [sym_unop] = STATE(310),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(385),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1594),
    [sym_aritylessPredicateExpr] = STATE(1156),
    [sym_varName] = STATE(458),
    [sym_aggId] = STATE(1438),
    [sym__lower_id] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(293),
    [anon_sym_not] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [sym_specialId] = ACTIONS(299),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(303),
    [sym_integer] = ACTIONS(305),
    [sym_float] = ACTIONS(307),
    [sym_string] = ACTIONS(307),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(309),
    [sym_result] = ACTIONS(311),
    [sym_super] = ACTIONS(313),
    [sym_this] = ACTIONS(311),
    [sym_true] = ACTIONS(309),
  },
  [311] = {
    [sym_special_call] = STATE(913),
    [sym_prefix_cast] = STATE(913),
    [sym_unary_expr] = STATE(913),
    [sym_mul_expr] = STATE(913),
    [sym_add_expr] = STATE(913),
    [sym_in_expr] = STATE(913),
    [sym_comp_term] = STATE(913),
    [sym_instance_of] = STATE(913),
    [sym_negation] = STATE(913),
    [sym_if_term] = STATE(913),
    [sym_conjunction] = STATE(913),
    [sym_disjunction] = STATE(913),
    [sym_implication] = STATE(913),
    [sym_quantified] = STATE(913),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(913),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [312] = {
    [sym_special_call] = STATE(673),
    [sym_prefix_cast] = STATE(673),
    [sym_unary_expr] = STATE(673),
    [sym_mul_expr] = STATE(673),
    [sym_add_expr] = STATE(673),
    [sym_in_expr] = STATE(673),
    [sym_comp_term] = STATE(673),
    [sym_instance_of] = STATE(673),
    [sym_negation] = STATE(673),
    [sym_if_term] = STATE(673),
    [sym_conjunction] = STATE(673),
    [sym_disjunction] = STATE(673),
    [sym_implication] = STATE(673),
    [sym_quantified] = STATE(673),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(673),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [313] = {
    [sym_special_call] = STATE(677),
    [sym_prefix_cast] = STATE(677),
    [sym_unary_expr] = STATE(677),
    [sym_mul_expr] = STATE(677),
    [sym_add_expr] = STATE(677),
    [sym_in_expr] = STATE(677),
    [sym_comp_term] = STATE(677),
    [sym_instance_of] = STATE(677),
    [sym_negation] = STATE(677),
    [sym_if_term] = STATE(677),
    [sym_conjunction] = STATE(677),
    [sym_disjunction] = STATE(677),
    [sym_implication] = STATE(677),
    [sym_quantified] = STATE(677),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(677),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(313),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [314] = {
    [sym_special_call] = STATE(370),
    [sym_prefix_cast] = STATE(370),
    [sym_unary_expr] = STATE(370),
    [sym_mul_expr] = STATE(370),
    [sym_add_expr] = STATE(370),
    [sym_in_expr] = STATE(370),
    [sym_comp_term] = STATE(370),
    [sym_instance_of] = STATE(370),
    [sym_negation] = STATE(370),
    [sym_if_term] = STATE(370),
    [sym_conjunction] = STATE(370),
    [sym_disjunction] = STATE(370),
    [sym_implication] = STATE(370),
    [sym_quantified] = STATE(370),
    [sym_quantifier] = STATE(1471),
    [sym_call_or_unqual_agg_expr] = STATE(449),
    [sym_qualified_expr] = STATE(449),
    [sym_super_ref] = STATE(449),
    [sym_aggregate] = STATE(449),
    [sym_range] = STATE(449),
    [sym_set_literal] = STATE(449),
    [sym_par_expr] = STATE(449),
    [sym__exprOrTerm] = STATE(370),
    [sym__primary] = STATE(449),
    [sym_literal] = STATE(449),
    [sym_bool] = STATE(443),
    [sym_variable] = STATE(449),
    [sym_unop] = STATE(314),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(383),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1451),
    [sym_aritylessPredicateExpr] = STATE(1162),
    [sym_varName] = STATE(446),
    [sym_aggId] = STATE(1436),
    [sym__lower_id] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_not] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(343),
    [sym_specialId] = ACTIONS(345),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(349),
    [sym_integer] = ACTIONS(351),
    [sym_float] = ACTIONS(353),
    [sym_string] = ACTIONS(353),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(355),
    [sym_result] = ACTIONS(357),
    [sym_super] = ACTIONS(359),
    [sym_this] = ACTIONS(357),
    [sym_true] = ACTIONS(355),
  },
  [315] = {
    [sym_special_call] = STATE(377),
    [sym_prefix_cast] = STATE(377),
    [sym_unary_expr] = STATE(377),
    [sym_mul_expr] = STATE(377),
    [sym_add_expr] = STATE(377),
    [sym_in_expr] = STATE(377),
    [sym_comp_term] = STATE(377),
    [sym_instance_of] = STATE(377),
    [sym_negation] = STATE(377),
    [sym_if_term] = STATE(377),
    [sym_conjunction] = STATE(377),
    [sym_disjunction] = STATE(377),
    [sym_implication] = STATE(377),
    [sym_quantified] = STATE(377),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(377),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [316] = {
    [sym_special_call] = STATE(708),
    [sym_prefix_cast] = STATE(708),
    [sym_unary_expr] = STATE(708),
    [sym_mul_expr] = STATE(708),
    [sym_add_expr] = STATE(708),
    [sym_in_expr] = STATE(708),
    [sym_comp_term] = STATE(708),
    [sym_instance_of] = STATE(708),
    [sym_negation] = STATE(708),
    [sym_if_term] = STATE(708),
    [sym_conjunction] = STATE(708),
    [sym_disjunction] = STATE(708),
    [sym_implication] = STATE(708),
    [sym_quantified] = STATE(708),
    [sym_quantifier] = STATE(1536),
    [sym_call_or_unqual_agg_expr] = STATE(612),
    [sym_qualified_expr] = STATE(612),
    [sym_super_ref] = STATE(612),
    [sym_aggregate] = STATE(612),
    [sym_range] = STATE(612),
    [sym_set_literal] = STATE(612),
    [sym_par_expr] = STATE(612),
    [sym__exprOrTerm] = STATE(708),
    [sym__primary] = STATE(612),
    [sym_literal] = STATE(612),
    [sym_bool] = STATE(630),
    [sym_variable] = STATE(612),
    [sym_unop] = STATE(228),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(597),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1527),
    [sym_aritylessPredicateExpr] = STATE(1154),
    [sym_varName] = STATE(619),
    [sym_aggId] = STATE(1425),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(437),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [317] = {
    [sym_special_call] = STATE(359),
    [sym_prefix_cast] = STATE(359),
    [sym_unary_expr] = STATE(359),
    [sym_mul_expr] = STATE(359),
    [sym_add_expr] = STATE(359),
    [sym_in_expr] = STATE(359),
    [sym_comp_term] = STATE(359),
    [sym_instance_of] = STATE(359),
    [sym_negation] = STATE(359),
    [sym_if_term] = STATE(359),
    [sym_conjunction] = STATE(359),
    [sym_disjunction] = STATE(359),
    [sym_implication] = STATE(359),
    [sym_quantified] = STATE(359),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(359),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [318] = {
    [sym_special_call] = STATE(380),
    [sym_prefix_cast] = STATE(380),
    [sym_unary_expr] = STATE(380),
    [sym_mul_expr] = STATE(380),
    [sym_add_expr] = STATE(380),
    [sym_in_expr] = STATE(380),
    [sym_comp_term] = STATE(380),
    [sym_instance_of] = STATE(380),
    [sym_negation] = STATE(380),
    [sym_if_term] = STATE(380),
    [sym_conjunction] = STATE(380),
    [sym_disjunction] = STATE(380),
    [sym_implication] = STATE(380),
    [sym_quantified] = STATE(380),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(380),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [319] = {
    [sym_special_call] = STATE(337),
    [sym_prefix_cast] = STATE(337),
    [sym_unary_expr] = STATE(337),
    [sym_mul_expr] = STATE(337),
    [sym_add_expr] = STATE(337),
    [sym_in_expr] = STATE(337),
    [sym_comp_term] = STATE(337),
    [sym_instance_of] = STATE(337),
    [sym_negation] = STATE(337),
    [sym_if_term] = STATE(337),
    [sym_conjunction] = STATE(337),
    [sym_disjunction] = STATE(337),
    [sym_implication] = STATE(337),
    [sym_quantified] = STATE(337),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(337),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [320] = {
    [sym_special_call] = STATE(338),
    [sym_prefix_cast] = STATE(338),
    [sym_unary_expr] = STATE(338),
    [sym_mul_expr] = STATE(338),
    [sym_add_expr] = STATE(338),
    [sym_in_expr] = STATE(338),
    [sym_comp_term] = STATE(338),
    [sym_instance_of] = STATE(338),
    [sym_negation] = STATE(338),
    [sym_if_term] = STATE(338),
    [sym_conjunction] = STATE(338),
    [sym_disjunction] = STATE(338),
    [sym_implication] = STATE(338),
    [sym_quantified] = STATE(338),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(338),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [321] = {
    [sym_special_call] = STATE(339),
    [sym_prefix_cast] = STATE(339),
    [sym_unary_expr] = STATE(339),
    [sym_mul_expr] = STATE(339),
    [sym_add_expr] = STATE(339),
    [sym_in_expr] = STATE(339),
    [sym_comp_term] = STATE(339),
    [sym_instance_of] = STATE(339),
    [sym_negation] = STATE(339),
    [sym_if_term] = STATE(339),
    [sym_conjunction] = STATE(339),
    [sym_disjunction] = STATE(339),
    [sym_implication] = STATE(339),
    [sym_quantified] = STATE(339),
    [sym_quantifier] = STATE(1489),
    [sym_call_or_unqual_agg_expr] = STATE(435),
    [sym_qualified_expr] = STATE(435),
    [sym_super_ref] = STATE(435),
    [sym_aggregate] = STATE(435),
    [sym_range] = STATE(435),
    [sym_set_literal] = STATE(435),
    [sym_par_expr] = STATE(435),
    [sym__exprOrTerm] = STATE(339),
    [sym__primary] = STATE(435),
    [sym_literal] = STATE(435),
    [sym_bool] = STATE(440),
    [sym_variable] = STATE(435),
    [sym_unop] = STATE(264),
    [sym_literalId] = STATE(1253),
    [sym_moduleExpr] = STATE(1528),
    [sym_primitiveType] = STATE(590),
    [sym_simpleId] = STATE(384),
    [sym_className] = STATE(591),
    [sym_typeExpr] = STATE(1490),
    [sym_aritylessPredicateExpr] = STATE(1170),
    [sym_varName] = STATE(438),
    [sym_aggId] = STATE(1434),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(291), 1,
      sym__lower_id,
    ACTIONS(301), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 1,
      sym__upper_id,
    ACTIONS(305), 1,
      sym_integer,
    ACTIONS(313), 1,
      sym_super,
    ACTIONS(523), 1,
      anon_sym_LPAREN,
    STATE(385), 1,
      sym_simpleId,
    STATE(456), 1,
      sym_bool,
    STATE(458), 1,
      sym_varName,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(1156), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1438), 1,
      sym_aggId,
    STATE(1528), 1,
      sym_moduleExpr,
    STATE(1594), 1,
      sym_typeExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(307), 2,
      sym_float,
      sym_string,
    ACTIONS(309), 2,
      sym_false,
      sym_true,
    ACTIONS(311), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(509), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [100] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(109), 1,
      sym__lower_id,
    ACTIONS(125), 1,
      anon_sym_LBRACK,
    ACTIONS(127), 1,
      sym__upper_id,
    ACTIONS(129), 1,
      sym_integer,
    ACTIONS(137), 1,
      sym_super,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(597), 1,
      sym_simpleId,
    STATE(619), 1,
      sym_varName,
    STATE(630), 1,
      sym_bool,
    STATE(1154), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1425), 1,
      sym_aggId,
    STATE(1527), 1,
      sym_typeExpr,
    STATE(1528), 1,
      sym_moduleExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(131), 2,
      sym_float,
      sym_string,
    ACTIONS(133), 2,
      sym_false,
      sym_true,
    ACTIONS(135), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(625), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [200] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(495), 1,
      sym__lower_id,
    ACTIONS(505), 1,
      anon_sym_LBRACK,
    ACTIONS(507), 1,
      sym__upper_id,
    ACTIONS(509), 1,
      sym_integer,
    ACTIONS(517), 1,
      sym_super,
    ACTIONS(527), 1,
      anon_sym_LPAREN,
    STATE(382), 1,
      sym_simpleId,
    STATE(426), 1,
      sym_bool,
    STATE(428), 1,
      sym_varName,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(1166), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1424), 1,
      sym_aggId,
    STATE(1528), 1,
      sym_moduleExpr,
    STATE(1533), 1,
      sym_typeExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(511), 2,
      sym_float,
      sym_string,
    ACTIONS(513), 2,
      sym_false,
      sym_true,
    ACTIONS(515), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(454), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [300] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(443), 1,
      sym__lower_id,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      sym__upper_id,
    ACTIONS(457), 1,
      sym_integer,
    ACTIONS(465), 1,
      sym_super,
    ACTIONS(529), 1,
      anon_sym_LPAREN,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(719), 1,
      sym_simpleId,
    STATE(835), 1,
      sym_varName,
    STATE(837), 1,
      sym_bool,
    STATE(1153), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1430), 1,
      sym_aggId,
    STATE(1509), 1,
      sym_typeExpr,
    STATE(1528), 1,
      sym_moduleExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(459), 2,
      sym_float,
      sym_string,
    ACTIONS(461), 2,
      sym_false,
      sym_true,
    ACTIONS(463), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(808), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [400] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(109), 1,
      sym__lower_id,
    ACTIONS(125), 1,
      anon_sym_LBRACK,
    ACTIONS(129), 1,
      sym_integer,
    ACTIONS(137), 1,
      sym_super,
    ACTIONS(437), 1,
      sym__upper_id,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(597), 1,
      sym_simpleId,
    STATE(619), 1,
      sym_varName,
    STATE(630), 1,
      sym_bool,
    STATE(1154), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1425), 1,
      sym_aggId,
    STATE(1527), 1,
      sym_typeExpr,
    STATE(1528), 1,
      sym_moduleExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(131), 2,
      sym_float,
      sym_string,
    ACTIONS(133), 2,
      sym_false,
      sym_true,
    ACTIONS(135), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(625), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [500] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(35), 1,
      sym__lower_id,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(57), 1,
      sym__upper_id,
    ACTIONS(59), 1,
      sym_integer,
    ACTIONS(67), 1,
      sym_super,
    ACTIONS(531), 1,
      anon_sym_LPAREN,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(718), 1,
      sym_simpleId,
    STATE(798), 1,
      sym_bool,
    STATE(803), 1,
      sym_varName,
    STATE(1168), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1437), 1,
      sym_aggId,
    STATE(1472), 1,
      sym_typeExpr,
    STATE(1528), 1,
      sym_moduleExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(61), 2,
      sym_float,
      sym_string,
    ACTIONS(63), 2,
      sym_false,
      sym_true,
    ACTIONS(65), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(872), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [600] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(337), 1,
      sym__lower_id,
    ACTIONS(347), 1,
      anon_sym_LBRACK,
    ACTIONS(349), 1,
      sym__upper_id,
    ACTIONS(351), 1,
      sym_integer,
    ACTIONS(359), 1,
      sym_super,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    STATE(383), 1,
      sym_simpleId,
    STATE(443), 1,
      sym_bool,
    STATE(446), 1,
      sym_varName,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(1162), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1436), 1,
      sym_aggId,
    STATE(1451), 1,
      sym_typeExpr,
    STATE(1528), 1,
      sym_moduleExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(353), 2,
      sym_float,
      sym_string,
    ACTIONS(355), 2,
      sym_false,
      sym_true,
    ACTIONS(357), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(525), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [700] = 24,
    ACTIONS(29), 1,
      sym_dbtype,
    ACTIONS(467), 1,
      sym__lower_id,
    ACTIONS(477), 1,
      anon_sym_LBRACK,
    ACTIONS(479), 1,
      sym__upper_id,
    ACTIONS(481), 1,
      sym_integer,
    ACTIONS(489), 1,
      sym_super,
    ACTIONS(535), 1,
      anon_sym_LPAREN,
    STATE(384), 1,
      sym_simpleId,
    STATE(438), 1,
      sym_varName,
    STATE(440), 1,
      sym_bool,
    STATE(590), 1,
      sym_primitiveType,
    STATE(591), 1,
      sym_className,
    STATE(1170), 1,
      sym_aritylessPredicateExpr,
    STATE(1253), 1,
      sym_literalId,
    STATE(1434), 1,
      sym_aggId,
    STATE(1490), 1,
      sym_typeExpr,
    STATE(1528), 1,
      sym_moduleExpr,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(483), 2,
      sym_float,
      sym_string,
    ACTIONS(485), 2,
      sym_false,
      sym_true,
    ACTIONS(487), 2,
      sym_result,
      sym_this,
    ACTIONS(27), 5,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
    STATE(413), 10,
      sym_call_or_unqual_agg_expr,
      sym_qualified_expr,
      sym_super_ref,
      sym_aggregate,
      sym_range,
      sym_set_literal,
      sym_par_expr,
      sym__primary,
      sym_literal,
      sym_variable,
    ACTIONS(55), 11,
      anon_sym_avg,
      anon_sym_concat,
      anon_sym_strictconcat,
      anon_sym_count,
      anon_sym_max,
      anon_sym_min,
      anon_sym_rank,
      anon_sym_strictcount,
      anon_sym_strictsum,
      anon_sym_sum,
      anon_sym_any,
  [800] = 19,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(543), 1,
      anon_sym_or,
    ACTIONS(545), 1,
      anon_sym_in,
    ACTIONS(547), 1,
      anon_sym_instanceof,
    ACTIONS(549), 1,
      anon_sym_and,
    ACTIONS(551), 1,
      anon_sym_implies,
    ACTIONS(559), 1,
      anon_sym_SLASH,
    STATE(267), 1,
      sym_addop,
    STATE(268), 1,
      sym_mulop,
    STATE(269), 1,
      sym_compop,
    STATE(1016), 1,
      sym_direction,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(557), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(561), 2,
      anon_sym_asc,
      anon_sym_desc,
    ACTIONS(541), 4,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(539), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym_dbtype,
      sym__upper_id,
    ACTIONS(537), 14,
      anon_sym_module,
      anon_sym_import,
      anon_sym_newtype,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_class,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_predicate,
  [882] = 19,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(559), 1,
      anon_sym_SLASH,
    ACTIONS(563), 1,
      anon_sym_or,
    ACTIONS(565), 1,
      anon_sym_in,
    ACTIONS(567), 1,
      anon_sym_instanceof,
    ACTIONS(569), 1,
      anon_sym_and,
    ACTIONS(571), 1,
      anon_sym_implies,
    STATE(317), 1,
      sym_addop,
    STATE(318), 1,
      sym_mulop,
    STATE(319), 1,
      sym_compop,
    STATE(1020), 1,
      sym_direction,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(557), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(573), 2,
      anon_sym_asc,
      anon_sym_desc,
    ACTIONS(541), 4,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(539), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym_dbtype,
      sym__upper_id,
    ACTIONS(537), 14,
      anon_sym_module,
      anon_sym_import,
      anon_sym_newtype,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_class,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_predicate,
  [964] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(251), 1,
      sym_addop,
    STATE(258), 1,
      sym_mulop,
    STATE(260), 1,
      sym_compop,
    ACTIONS(577), 13,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      sym_qldoc,
      sym_dbtype,
      sym__upper_id,
    ACTIONS(575), 24,
      anon_sym_module,
      anon_sym_import,
      anon_sym_as,
      anon_sym_or,
      anon_sym_newtype,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_class,
      anon_sym_in,
      anon_sym_instanceof,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_order,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_predicate,
  [1021] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(559), 1,
      anon_sym_SLASH,
    ACTIONS(583), 1,
      anon_sym_in,
    ACTIONS(585), 1,
      anon_sym_instanceof,
    ACTIONS(587), 1,
      anon_sym_and,
    STATE(251), 1,
      sym_addop,
    STATE(258), 1,
      sym_mulop,
    STATE(260), 1,
      sym_compop,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(557), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(541), 4,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(581), 5,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_qldoc,
      sym_dbtype,
      sym__upper_id,
    ACTIONS(579), 18,
      anon_sym_module,
      anon_sym_import,
      anon_sym_as,
      anon_sym_or,
      anon_sym_newtype,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_class,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_predicate,
  [1094] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(559), 1,
      anon_sym_SLASH,
    ACTIONS(593), 1,
      anon_sym_in,
    ACTIONS(595), 1,
      anon_sym_instanceof,
    STATE(302), 1,
      sym_addop,
    STATE(304), 1,
      sym_mulop,
    STATE(305), 1,
      sym_compop,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(557), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(541), 4,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(589), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      sym_qldoc,
      sym_dbtype,
      sym__upper_id,
    ACTIONS(591), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_as,
      anon_sym_or,
      anon_sym_newtype,
      anon_sym_from,
      anon_sym_where,
      anon_sym_select,
      anon_sym_class,
      anon_sym_and,
      anon_sym_implies,
      anon_sym_order,
      anon_sym_boolean,
      anon_sym_date,
      anon_sym_float,
      anon_sym_int,
      anon_sym_string,
      sym__lower_id,
      sym_predicate,
  [1165] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(559), 1,
      anon_sym_SLASH,
    STATE(267), 1,
      sym_addop,
    STATE(268), 1,
      sym_mulop,
    STATE(269