#!/bin/ksh
# spec.sh
# $Id: spec.sh,v 1.2 2001/08/26 02:27:25 gwiley Exp $
# Glen Wiley, gwiley@ieee.org
#
# tests for pdv spec related utilities and behavior
#
# TODO: negative tests - bogus arguments etc.

#-------------------- TEST: create spec via command line

print "BEGIN TEST:"
print "TARGET: pdvmkpkg (spec)"
print "GOAL:   create a spec file from a full argument list"
print "EXPECT: exit status 0, spec file and package created"

# setup the test files

cat >> foo.sh <<EOF
#!/bin/sh
echo "foo script executing"
EOF
chmod +x foo.sh

print "This is a help text for the foo package." > foo.hlp
print "This is the agreement text for the foo package." > foo.agr

../pdvmkpkg -a foo.agr -s foo.pdv -c foopkg -o bar.sh -e ./foo.sh -H foo.hlp foo.sh

print "exit status = $?"

print "+++ spec file follows:"
cat foo.pdv
print "+++ end spec file"

rm -f foo.sh foo.hlp bar.sh foopkg foo.pdv foo.agr

print "END TEST"

#-------------------- TEST: create package from spec file

print "\n\nBEGIN TEST:"
print "TARGET: pdvmkpkg (spec)"
print "GOAL:   create a package from a spec file"
print "EXPECT: exit status 0, package created"

# setup the test files

cat > foo.sh <<EOF
#!/bin/sh
echo "foo script executing"
EOF
chmod +x foo.sh

print "This is a help text for the foo package." > foo.hlp
print "This is the agreement text for the foo package." > foo.agr

cat > foo.pdv <<EOF
HELPMSGFILE foo.hlp
AGRMSGFILE foo.agr
OUTPUTFILE bar.sh
PAYLDFILE foo.sh
PDVSTUB
EXEC ./foo.sh
PKGFILE foopkg
COMPRESS n
TAR n
EOF

../pdvmkpkg -s foo.pdv

print "exit status = $?"

print "execute the package..."

./foopkg << EOF
yes
EOF

print "execute the package with -h..."

./foopkg -h

rm -f foo.sh foo.hlp bar.sh foopkg foo.pdv foo.agr

print "END TEST"

return 0
# spec.sh
