// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: ts/tspb/timeseries.proto

package tspb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "context"
	grpc "google.golang.org/grpc"
)

import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// TimeSeriesQueryAggregator describes a set of aggregation functions which can
// be used to combine multiple datapoints into a single datapoint.
//
// Aggregators are used to "downsample" series by combining datapoints from the
// same series at different times. They are also used to "aggregate" values from
// different series, combining data points from different series at the same
// time.
type TimeSeriesQueryAggregator int32

const (
	// AVG returns the average value of datapoints.
	TimeSeriesQueryAggregator_AVG TimeSeriesQueryAggregator = 1
	// SUM returns the sum value of datapoints.
	TimeSeriesQueryAggregator_SUM TimeSeriesQueryAggregator = 2
	// MAX returns the maximum value of datapoints.
	TimeSeriesQueryAggregator_MAX TimeSeriesQueryAggregator = 3
	// MIN returns the minimum value of datapoints.
	TimeSeriesQueryAggregator_MIN TimeSeriesQueryAggregator = 4
	// FIRST returns the value of the first datapoint in the set being aggregated.
	// This aggregator is not valid for a source aggregator, and should only be
	// used for downsampling.
	TimeSeriesQueryAggregator_FIRST TimeSeriesQueryAggregator = 5
	// LAST returns the value of the last datapoint in the set being aggregated.
	// This aggregator is not valid for a source aggregator, and should only be
	// used for downsampling.
	TimeSeriesQueryAggregator_LAST TimeSeriesQueryAggregator = 6
	// VARIANCE returns the variance (σ^2) of the datapoints.
	TimeSeriesQueryAggregator_VARIANCE TimeSeriesQueryAggregator = 7
)

var TimeSeriesQueryAggregator_name = map[int32]string{
	1: "AVG",
	2: "SUM",
	3: "MAX",
	4: "MIN",
	5: "FIRST",
	6: "LAST",
	7: "VARIANCE",
}
var TimeSeriesQueryAggregator_value = map[string]int32{
	"AVG":      1,
	"SUM":      2,
	"MAX":      3,
	"MIN":      4,
	"FIRST":    5,
	"LAST":     6,
	"VARIANCE": 7,
}

func (x TimeSeriesQueryAggregator) Enum() *TimeSeriesQueryAggregator {
	p := new(TimeSeriesQueryAggregator)
	*p = x
	return p
}
func (x TimeSeriesQueryAggregator) String() string {
	return proto.EnumName(TimeSeriesQueryAggregator_name, int32(x))
}
func (x *TimeSeriesQueryAggregator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TimeSeriesQueryAggregator_value, data, "TimeSeriesQueryAggregator")
	if err != nil {
		return err
	}
	*x = TimeSeriesQueryAggregator(value)
	return nil
}
func (TimeSeriesQueryAggregator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{0}
}

// TimeSeriesQueryDerivative describes a derivative function used to convert
// returned datapoints into a rate-of-change.
type TimeSeriesQueryDerivative int32

const (
	// NONE is the default value, and does not apply a derivative function.
	TimeSeriesQueryDerivative_NONE TimeSeriesQueryDerivative = 0
	// DERIVATIVE returns the first-order derivative of values in the time series.
	TimeSeriesQueryDerivative_DERIVATIVE TimeSeriesQueryDerivative = 1
	// NON_NEGATIVE_DERIVATIVE returns only non-negative values of the first-order
	// derivative; negative values are returned as zero. This should be used for
	// counters that monotonically increase, but might wrap or reset.
	TimeSeriesQueryDerivative_NON_NEGATIVE_DERIVATIVE TimeSeriesQueryDerivative = 2
)

var TimeSeriesQueryDerivative_name = map[int32]string{
	0: "NONE",
	1: "DERIVATIVE",
	2: "NON_NEGATIVE_DERIVATIVE",
}
var TimeSeriesQueryDerivative_value = map[string]int32{
	"NONE":                    0,
	"DERIVATIVE":              1,
	"NON_NEGATIVE_DERIVATIVE": 2,
}

func (x TimeSeriesQueryDerivative) Enum() *TimeSeriesQueryDerivative {
	p := new(TimeSeriesQueryDerivative)
	*p = x
	return p
}
func (x TimeSeriesQueryDerivative) String() string {
	return proto.EnumName(TimeSeriesQueryDerivative_name, int32(x))
}
func (x *TimeSeriesQueryDerivative) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TimeSeriesQueryDerivative_value, data, "TimeSeriesQueryDerivative")
	if err != nil {
		return err
	}
	*x = TimeSeriesQueryDerivative(value)
	return nil
}
func (TimeSeriesQueryDerivative) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{1}
}

// TimeSeriesDatapoint is a single point of time series data; a value associated
// with a timestamp.
type TimeSeriesDatapoint struct {
	// The timestamp when this datapoint is located, expressed in nanoseconds
	// since the unix epoch.
	TimestampNanos int64 `protobuf:"varint,1,opt,name=timestamp_nanos,json=timestampNanos" json:"timestamp_nanos"`
	// A floating point representation of the value of this datapoint.
	Value                float64  `protobuf:"fixed64,2,opt,name=value" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeSeriesDatapoint) Reset()         { *m = TimeSeriesDatapoint{} }
func (m *TimeSeriesDatapoint) String() string { return proto.CompactTextString(m) }
func (*TimeSeriesDatapoint) ProtoMessage()    {}
func (*TimeSeriesDatapoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{0}
}
func (m *TimeSeriesDatapoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeSeriesDatapoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TimeSeriesDatapoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSeriesDatapoint.Merge(dst, src)
}
func (m *TimeSeriesDatapoint) XXX_Size() int {
	return m.Size()
}
func (m *TimeSeriesDatapoint) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSeriesDatapoint.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSeriesDatapoint proto.InternalMessageInfo

// TimeSeriesData is a set of measurements of a single named variable at
// multiple points in time. This message contains a name and a source which, in
// combination, uniquely identify the time series being measured. Measurement
// data is represented as a repeated set of TimeSeriesDatapoint messages.
type TimeSeriesData struct {
	// A string which uniquely identifies the variable from which this data was
	// measured.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// A string which identifies the unique source from which the variable was measured.
	Source string `protobuf:"bytes,2,opt,name=source" json:"source"`
	// Datapoints representing one or more measurements taken from the variable.
	Datapoints           []TimeSeriesDatapoint `protobuf:"bytes,3,rep,name=datapoints" json:"datapoints"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TimeSeriesData) Reset()         { *m = TimeSeriesData{} }
func (m *TimeSeriesData) String() string { return proto.CompactTextString(m) }
func (*TimeSeriesData) ProtoMessage()    {}
func (*TimeSeriesData) Descriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{1}
}
func (m *TimeSeriesData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeSeriesData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TimeSeriesData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSeriesData.Merge(dst, src)
}
func (m *TimeSeriesData) XXX_Size() int {
	return m.Size()
}
func (m *TimeSeriesData) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSeriesData.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSeriesData proto.InternalMessageInfo

// Each Query defines a specific metric to query over the time span of
// this request.
type Query struct {
	// The name of the time series to query.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// A downsampling aggregation function to apply to datapoints within the
	// same sample period.
	Downsampler *TimeSeriesQueryAggregator `protobuf:"varint,2,opt,name=downsampler,enum=cockroach.ts.tspb.TimeSeriesQueryAggregator,def=1" json:"downsampler,omitempty"`
	// An aggregation function used to combine timelike datapoints from the
	// different sources being queried.
	SourceAggregator *TimeSeriesQueryAggregator `protobuf:"varint,3,opt,name=source_aggregator,json=sourceAggregator,enum=cockroach.ts.tspb.TimeSeriesQueryAggregator,def=2" json:"source_aggregator,omitempty"`
	// If set to a value other than 'NONE', query will return a derivative
	// (rate of change) of the aggregated datapoints.
	Derivative *TimeSeriesQueryDerivative `protobuf:"varint,4,opt,name=derivative,enum=cockroach.ts.tspb.TimeSeriesQueryDerivative,def=0" json:"derivative,omitempty"`
	// An optional list of sources to restrict the time series query. If no
	// sources are provided, all available sources will be queried.
	Sources              []string `protobuf:"bytes,5,rep,name=sources" json:"sources,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Query) Reset()         { *m = Query{} }
func (m *Query) String() string { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()    {}
func (*Query) Descriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{2}
}
func (m *Query) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Query) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Query) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Query.Merge(dst, src)
}
func (m *Query) XXX_Size() int {
	return m.Size()
}
func (m *Query) XXX_DiscardUnknown() {
	xxx_messageInfo_Query.DiscardUnknown(m)
}

var xxx_messageInfo_Query proto.InternalMessageInfo

const Default_Query_Downsampler TimeSeriesQueryAggregator = TimeSeriesQueryAggregator_AVG
const Default_Query_SourceAggregator TimeSeriesQueryAggregator = TimeSeriesQueryAggregator_SUM
const Default_Query_Derivative TimeSeriesQueryDerivative = TimeSeriesQueryDerivative_NONE

func (m *Query) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Query) GetDownsampler() TimeSeriesQueryAggregator {
	if m != nil && m.Downsampler != nil {
		return *m.Downsampler
	}
	return Default_Query_Downsampler
}

func (m *Query) GetSourceAggregator() TimeSeriesQueryAggregator {
	if m != nil && m.SourceAggregator != nil {
		return *m.SourceAggregator
	}
	return Default_Query_SourceAggregator
}

func (m *Query) GetDerivative() TimeSeriesQueryDerivative {
	if m != nil && m.Derivative != nil {
		return *m.Derivative
	}
	return Default_Query_Derivative
}

func (m *Query) GetSources() []string {
	if m != nil {
		return m.Sources
	}
	return nil
}

// TimeSeriesQueryRequest is the standard incoming time series query request
// accepted from cockroach clients.
type TimeSeriesQueryRequest struct {
	// A timestamp in nanoseconds which defines the early bound of the time span
	// for this query.
	StartNanos int64 `protobuf:"varint,1,opt,name=start_nanos,json=startNanos" json:"start_nanos"`
	// A timestamp in nanoseconds which defines the late bound of the time span
	// for this query. Must be greater than start_nanos.
	EndNanos int64 `protobuf:"varint,2,opt,name=end_nanos,json=endNanos" json:"end_nanos"`
	// A set of Queries for this request. A request must have at least one
	// Query.
	Queries []Query `protobuf:"bytes,3,rep,name=queries" json:"queries"`
	// Duration of requested sample period in nanoseconds. Returned data for each
	// query will be downsampled into periods of the supplied length. The
	// supplied duration must be a multiple of ten seconds.
	SampleNanos          int64    `protobuf:"varint,4,opt,name=sample_nanos,json=sampleNanos" json:"sample_nanos"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeSeriesQueryRequest) Reset()         { *m = TimeSeriesQueryRequest{} }
func (m *TimeSeriesQueryRequest) String() string { return proto.CompactTextString(m) }
func (*TimeSeriesQueryRequest) ProtoMessage()    {}
func (*TimeSeriesQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{3}
}
func (m *TimeSeriesQueryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeSeriesQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TimeSeriesQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSeriesQueryRequest.Merge(dst, src)
}
func (m *TimeSeriesQueryRequest) XXX_Size() int {
	return m.Size()
}
func (m *TimeSeriesQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSeriesQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSeriesQueryRequest proto.InternalMessageInfo

// TimeSeriesQueryResponse is the standard response for time series queries
// returned to cockroach clients.
type TimeSeriesQueryResponse struct {
	// A set of Results; there will be one result for each Query in the matching
	// TimeSeriesQueryRequest, in the same order. A Result will be present for
	// each Query even if there are zero datapoints to return.
	Results              []TimeSeriesQueryResponse_Result `protobuf:"bytes,1,rep,name=results" json:"results"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *TimeSeriesQueryResponse) Reset()         { *m = TimeSeriesQueryResponse{} }
func (m *TimeSeriesQueryResponse) String() string { return proto.CompactTextString(m) }
func (*TimeSeriesQueryResponse) ProtoMessage()    {}
func (*TimeSeriesQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{4}
}
func (m *TimeSeriesQueryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeSeriesQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TimeSeriesQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSeriesQueryResponse.Merge(dst, src)
}
func (m *TimeSeriesQueryResponse) XXX_Size() int {
	return m.Size()
}
func (m *TimeSeriesQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSeriesQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSeriesQueryResponse proto.InternalMessageInfo

// Result is the data returned from a single metric query over a time span.
type TimeSeriesQueryResponse_Result struct {
	Query                `protobuf:"bytes,1,opt,name=query,embedded=query" json:"query"`
	Datapoints           []TimeSeriesDatapoint `protobuf:"bytes,2,rep,name=datapoints" json:"datapoints"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TimeSeriesQueryResponse_Result) Reset()         { *m = TimeSeriesQueryResponse_Result{} }
func (m *TimeSeriesQueryResponse_Result) String() string { return proto.CompactTextString(m) }
func (*TimeSeriesQueryResponse_Result) ProtoMessage()    {}
func (*TimeSeriesQueryResponse_Result) Descriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{4, 0}
}
func (m *TimeSeriesQueryResponse_Result) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeSeriesQueryResponse_Result) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TimeSeriesQueryResponse_Result) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSeriesQueryResponse_Result.Merge(dst, src)
}
func (m *TimeSeriesQueryResponse_Result) XXX_Size() int {
	return m.Size()
}
func (m *TimeSeriesQueryResponse_Result) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSeriesQueryResponse_Result.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSeriesQueryResponse_Result proto.InternalMessageInfo

type DumpRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DumpRequest) Reset()         { *m = DumpRequest{} }
func (m *DumpRequest) String() string { return proto.CompactTextString(m) }
func (*DumpRequest) ProtoMessage()    {}
func (*DumpRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_timeseries_1f7ae1dea9c20e22, []int{5}
}
func (m *DumpRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DumpRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *DumpRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DumpRequest.Merge(dst, src)
}
func (m *DumpRequest) XXX_Size() int {
	return m.Size()
}
func (m *DumpRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DumpRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DumpRequest proto.InternalMessageInfo

func init() {
	proto.RegisterType((*TimeSeriesDatapoint)(nil), "cockroach.ts.tspb.TimeSeriesDatapoint")
	proto.RegisterType((*TimeSeriesData)(nil), "cockroach.ts.tspb.TimeSeriesData")
	proto.RegisterType((*Query)(nil), "cockroach.ts.tspb.Query")
	proto.RegisterType((*TimeSeriesQueryRequest)(nil), "cockroach.ts.tspb.TimeSeriesQueryRequest")
	proto.RegisterType((*TimeSeriesQueryResponse)(nil), "cockroach.ts.tspb.TimeSeriesQueryResponse")
	proto.RegisterType((*TimeSeriesQueryResponse_Result)(nil), "cockroach.ts.tspb.TimeSeriesQueryResponse.Result")
	proto.RegisterType((*DumpRequest)(nil), "cockroach.ts.tspb.DumpRequest")
	proto.RegisterEnum("cockroach.ts.tspb.TimeSeriesQueryAggregator", TimeSeriesQueryAggregator_name, TimeSeriesQueryAggregator_value)
	proto.RegisterEnum("cockroach.ts.tspb.TimeSeriesQueryDerivative", TimeSeriesQueryDerivative_name, TimeSeriesQueryDerivative_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TimeSeriesClient is the client API for TimeSeries service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TimeSeriesClient interface {
	// URL: /ts/query
	Query(ctx context.Context, in *TimeSeriesQueryRequest, opts ...grpc.CallOption) (*TimeSeriesQueryResponse, error)
	// Dump returns a stream of raw timeseries data that has been stored on the
	// server. Only data from the 10-second resolution is returned - rollup data is
	// not returned. Data is returned in the order it is read from disk, meaning
	// that data from different series may be interleaved.
	Dump(ctx context.Context, in *DumpRequest, opts ...grpc.CallOption) (TimeSeries_DumpClient, error)
}

type timeSeriesClient struct {
	cc *grpc.ClientConn
}

func NewTimeSeriesClient(cc *grpc.ClientConn) TimeSeriesClient {
	return &timeSeriesClient{cc}
}

func (c *timeSeriesClient) Query(ctx context.Context, in *TimeSeriesQueryRequest, opts ...grpc.CallOption) (*TimeSeriesQueryResponse, error) {
	out := new(TimeSeriesQueryResponse)
	err := c.cc.Invoke(ctx, "/cockroach.ts.tspb.TimeSeries/Query", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *timeSeriesClient) Dump(ctx context.Context, in *DumpRequest, opts ...grpc.CallOption) (TimeSeries_DumpClient, error) {
	stream, err := c.cc.NewStream(ctx, &_TimeSeries_serviceDesc.Streams[0], "/cockroach.ts.tspb.TimeSeries/Dump", opts...)
	if err != nil {
		return nil, err
	}
	x := &timeSeriesDumpClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TimeSeries_DumpClient interface {
	Recv() (*TimeSeriesData, error)
	grpc.ClientStream
}

type timeSeriesDumpClient struct {
	grpc.ClientStream
}

func (x *timeSeriesDumpClient) Recv() (*TimeSeriesData, error) {
	m := new(TimeSeriesData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TimeSeriesServer is the server API for TimeSeries service.
type TimeSeriesServer interface {
	// URL: /ts/query
	Query(context.Context, *TimeSeriesQueryRequest) (*TimeSeriesQueryResponse, error)
	// Dump returns a stream of raw timeseries data that has been stored on the
	// server. Only data from the 10-second resolution is returned - rollup data is
	// not returned. Data is returned in the order it is read from disk, meaning
	// that data from different series may be interleaved.
	Dump(*DumpRequest, TimeSeries_DumpServer) error
}

func RegisterTimeSeriesServer(s *grpc.Server, srv TimeSeriesServer) {
	s.RegisterService(&_TimeSeries_serviceDesc, srv)
}

func _TimeSeries_Query_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TimeSeriesQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TimeSeriesServer).Query(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.ts.tspb.TimeSeries/Query",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TimeSeriesServer).Query(ctx, req.(*TimeSeriesQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TimeSeries_Dump_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DumpRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TimeSeriesServer).Dump(m, &timeSeriesDumpServer{stream})
}

type TimeSeries_DumpServer interface {
	Send(*TimeSeriesData) error
	grpc.ServerStream
}

type timeSeriesDumpServer struct {
	grpc.ServerStream
}

func (x *timeSeriesDumpServer) Send(m *TimeSeriesData) error {
	return x.ServerStream.SendMsg(m)
}

var _TimeSeries_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.ts.tspb.TimeSeries",
	HandlerType: (*TimeSeriesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Query",
			Handler:    _TimeSeries_Query_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Dump",
			Handler:       _TimeSeries_Dump_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ts/tspb/timeseries.proto",
}

func (m *TimeSeriesDatapoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeSeriesDatapoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(m.TimestampNanos))
	dAtA[i] = 0x11
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
	i += 8
	return i, nil
}

func (m *TimeSeriesData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeSeriesData) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x12
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(len(m.Source)))
	i += copy(dAtA[i:], m.Source)
	if len(m.Datapoints) > 0 {
		for _, msg := range m.Datapoints {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTimeseries(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Query) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Query) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.Downsampler != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTimeseries(dAtA, i, uint64(*m.Downsampler))
	}
	if m.SourceAggregator != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTimeseries(dAtA, i, uint64(*m.SourceAggregator))
	}
	if m.Derivative != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTimeseries(dAtA, i, uint64(*m.Derivative))
	}
	if len(m.Sources) > 0 {
		for _, s := range m.Sources {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *TimeSeriesQueryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeSeriesQueryRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(m.StartNanos))
	dAtA[i] = 0x10
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(m.EndNanos))
	if len(m.Queries) > 0 {
		for _, msg := range m.Queries {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTimeseries(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(m.SampleNanos))
	return i, nil
}

func (m *TimeSeriesQueryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeSeriesQueryResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Results) > 0 {
		for _, msg := range m.Results {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTimeseries(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TimeSeriesQueryResponse_Result) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeSeriesQueryResponse_Result) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintTimeseries(dAtA, i, uint64(m.Query.Size()))
	n1, err := m.Query.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.Datapoints) > 0 {
		for _, msg := range m.Datapoints {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTimeseries(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *DumpRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DumpRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func encodeVarintTimeseries(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *TimeSeriesDatapoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovTimeseries(uint64(m.TimestampNanos))
	n += 9
	return n
}

func (m *TimeSeriesData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovTimeseries(uint64(l))
	l = len(m.Source)
	n += 1 + l + sovTimeseries(uint64(l))
	if len(m.Datapoints) > 0 {
		for _, e := range m.Datapoints {
			l = e.Size()
			n += 1 + l + sovTimeseries(uint64(l))
		}
	}
	return n
}

func (m *Query) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovTimeseries(uint64(l))
	if m.Downsampler != nil {
		n += 1 + sovTimeseries(uint64(*m.Downsampler))
	}
	if m.SourceAggregator != nil {
		n += 1 + sovTimeseries(uint64(*m.SourceAggregator))
	}
	if m.Derivative != nil {
		n += 1 + sovTimeseries(uint64(*m.Derivative))
	}
	if len(m.Sources) > 0 {
		for _, s := range m.Sources {
			l = len(s)
			n += 1 + l + sovTimeseries(uint64(l))
		}
	}
	return n
}

func (m *TimeSeriesQueryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovTimeseries(uint64(m.StartNanos))
	n += 1 + sovTimeseries(uint64(m.EndNanos))
	if len(m.Queries) > 0 {
		for _, e := range m.Queries {
			l = e.Size()
			n += 1 + l + sovTimeseries(uint64(l))
		}
	}
	n += 1 + sovTimeseries(uint64(m.SampleNanos))
	return n
}

func (m *TimeSeriesQueryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Results) > 0 {
		for _, e := range m.Results {
			l = e.Size()
			n += 1 + l + sovTimeseries(uint64(l))
		}
	}
	return n
}

func (m *TimeSeriesQueryResponse_Result) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Query.Size()
	n += 1 + l + sovTimeseries(uint64(l))
	if len(m.Datapoints) > 0 {
		for _, e := range m.Datapoints {
			l = e.Size()
			n += 1 + l + sovTimeseries(uint64(l))
		}
	}
	return n
}

func (m *DumpRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovTimeseries(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTimeseries(x uint64) (n int) {
	return sovTimeseries(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TimeSeriesDatapoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeSeriesDatapoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeSeriesDatapoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampNanos", wireType)
			}
			m.TimestampNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimestampNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipTimeseries(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeseries
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeSeriesData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeSeriesData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeSeriesData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datapoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Datapoints = append(m.Datapoints, TimeSeriesDatapoint{})
			if err := m.Datapoints[len(m.Datapoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTimeseries(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeseries
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Query) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Query: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Query: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Downsampler", wireType)
			}
			var v TimeSeriesQueryAggregator
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (TimeSeriesQueryAggregator(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Downsampler = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceAggregator", wireType)
			}
			var v TimeSeriesQueryAggregator
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (TimeSeriesQueryAggregator(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SourceAggregator = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Derivative", wireType)
			}
			var v TimeSeriesQueryDerivative
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (TimeSeriesQueryDerivative(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Derivative = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sources", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sources = append(m.Sources, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTimeseries(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeseries
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeSeriesQueryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeSeriesQueryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeSeriesQueryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartNanos", wireType)
			}
			m.StartNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndNanos", wireType)
			}
			m.EndNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Queries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Queries = append(m.Queries, Query{})
			if err := m.Queries[len(m.Queries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleNanos", wireType)
			}
			m.SampleNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SampleNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTimeseries(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeseries
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeSeriesQueryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeSeriesQueryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeSeriesQueryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Results", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Results = append(m.Results, TimeSeriesQueryResponse_Result{})
			if err := m.Results[len(m.Results)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTimeseries(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeseries
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeSeriesQueryResponse_Result) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Result: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Result: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Query.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datapoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeseries
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Datapoints = append(m.Datapoints, TimeSeriesDatapoint{})
			if err := m.Datapoints[len(m.Datapoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTimeseries(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeseries
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DumpRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DumpRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DumpRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTimeseries(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeseries
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTimeseries(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTimeseries
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTimeseries
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTimeseries
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTimeseries
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTimeseries(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTimeseries = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTimeseries   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("ts/tspb/timeseries.proto", fileDescriptor_timeseries_1f7ae1dea9c20e22)
}

var fileDescriptor_timeseries_1f7ae1dea9c20e22 = []byte{
	// 711 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x93, 0x4d, 0x6f, 0xda, 0x48,
	0x18, 0xc7, 0x19, 0x30, 0x01, 0x1e, 0xb2, 0xac, 0x33, 0x1b, 0x6d, 0xbc, 0x6c, 0xe4, 0x10, 0x4b,
	0xbb, 0xcb, 0xa2, 0x16, 0xda, 0x9c, 0x22, 0x6e, 0xa4, 0xd0, 0x08, 0x29, 0x38, 0x8a, 0x21, 0xa8,
	0xea, 0xa1, 0x74, 0x02, 0x23, 0x6a, 0x15, 0x3c, 0x8e, 0x67, 0x48, 0x95, 0x6b, 0x4f, 0x3d, 0x46,
	0xaa, 0xd4, 0x73, 0xbf, 0x4c, 0xa5, 0xa8, 0xa7, 0x54, 0xbd, 0xf4, 0x14, 0xb5, 0xb4, 0xdf, 0xa3,
	0x95, 0xc7, 0x26, 0xa1, 0x09, 0x4d, 0xa2, 0xf6, 0x36, 0x7e, 0x5e, 0x7e, 0xff, 0xe7, 0xcd, 0xa0,
	0x09, 0x5e, 0x12, 0xdc, 0xdd, 0x2b, 0x09, 0x7b, 0x48, 0x39, 0xf5, 0x6c, 0xca, 0x8b, 0xae, 0xc7,
	0x04, 0xc3, 0x0b, 0x5d, 0xd6, 0x7d, 0xea, 0x31, 0xd2, 0x7d, 0x52, 0x14, 0xbc, 0xe8, 0xc7, 0x64,
	0x17, 0xfb, 0xac, 0xcf, 0xa4, 0xb7, 0xe4, 0xbf, 0x82, 0xc0, 0xec, 0x72, 0x9f, 0xb1, 0xfe, 0x80,
	0x96, 0x88, 0x6b, 0x97, 0x88, 0xe3, 0x30, 0x41, 0x84, 0xcd, 0x9c, 0x10, 0x63, 0x3c, 0x86, 0x3f,
	0x5a, 0xf6, 0x90, 0x36, 0x25, 0xba, 0x4a, 0x04, 0x71, 0x99, 0xed, 0x08, 0x7c, 0x1b, 0x7e, 0x97,
	0x8a, 0x82, 0x0c, 0xdd, 0x8e, 0x43, 0x1c, 0xc6, 0x35, 0x94, 0x43, 0xf9, 0xd8, 0x86, 0x72, 0x7c,
	0xba, 0x12, 0xb1, 0x32, 0x67, 0x4e, 0xd3, 0xf7, 0xe1, 0x2c, 0xc4, 0x0f, 0xc8, 0x60, 0x44, 0xb5,
	0x68, 0x0e, 0xe5, 0x51, 0x18, 0x14, 0x98, 0x8c, 0x57, 0x08, 0x32, 0xdf, 0x4b, 0x60, 0x0d, 0x14,
	0x87, 0x0c, 0xa9, 0x44, 0xa6, 0xc2, 0x68, 0x69, 0xc1, 0xcb, 0x30, 0xc7, 0xd9, 0xc8, 0xeb, 0x06,
	0xa4, 0x89, 0x2f, 0xb4, 0xe1, 0x2d, 0x80, 0xde, 0xa4, 0x44, 0xae, 0xc5, 0x72, 0xb1, 0x7c, 0x7a,
	0xed, 0xdf, 0xe2, 0xa5, 0x41, 0x14, 0x67, 0x74, 0x14, 0x92, 0xa6, 0xf2, 0x8d, 0xb7, 0x51, 0x88,
	0xef, 0x8c, 0xa8, 0x77, 0x78, 0x45, 0x3d, 0x4d, 0x48, 0xf7, 0xd8, 0x33, 0x87, 0x93, 0xa1, 0x3b,
	0xa0, 0x9e, 0x2c, 0x2a, 0xb3, 0x76, 0xeb, 0x4a, 0x49, 0x89, 0xac, 0xf4, 0xfb, 0x1e, 0xed, 0x13,
	0xc1, 0xbc, 0x72, 0xac, 0xd2, 0xde, 0xb4, 0xa6, 0x29, 0xf8, 0x11, 0x2c, 0x04, 0x0d, 0x75, 0xc8,
	0x59, 0x98, 0x16, 0xfb, 0x19, 0x74, 0x73, 0xb7, 0x61, 0xa9, 0x01, 0xeb, 0xdc, 0x8c, 0x2d, 0x80,
	0x1e, 0xf5, 0xec, 0x03, 0x22, 0xec, 0x03, 0xaa, 0x29, 0x37, 0x05, 0x57, 0xcf, 0x72, 0xca, 0x8a,
	0xb9, 0x6d, 0xd6, 0xac, 0x29, 0x0a, 0xd6, 0x20, 0x11, 0xe8, 0x70, 0x2d, 0x9e, 0x8b, 0xe5, 0x53,
	0xd6, 0xe4, 0xb3, 0xac, 0xbc, 0x78, 0xbd, 0x82, 0x8c, 0x37, 0x08, 0xfe, 0xbc, 0xc0, 0xb3, 0xe8,
	0xfe, 0x88, 0x72, 0x81, 0xff, 0x81, 0x34, 0x17, 0xc4, 0x13, 0x33, 0xee, 0x08, 0xa4, 0x23, 0xb8,
	0xa1, 0x55, 0x48, 0x51, 0xa7, 0x17, 0x06, 0x45, 0xa7, 0x82, 0x92, 0xd4, 0xe9, 0x05, 0x21, 0xeb,
	0x90, 0xd8, 0x1f, 0x49, 0x81, 0x70, 0xf9, 0xda, 0x8c, 0xae, 0xa4, 0x76, 0x98, 0x3a, 0x09, 0xc7,
	0xff, 0xc1, 0x7c, 0x30, 0xfd, 0x90, 0xaf, 0x4c, 0xf1, 0xd3, 0x81, 0x47, 0x4a, 0x18, 0x5f, 0x11,
	0x2c, 0x5d, 0xea, 0x83, 0xbb, 0xcc, 0xe1, 0x14, 0xef, 0x40, 0xc2, 0xa3, 0x7c, 0x34, 0x10, 0x7e,
	0x13, 0xbe, 0xfc, 0xdd, 0xeb, 0x87, 0x3a, 0x49, 0x2e, 0x5a, 0x32, 0x73, 0x52, 0x57, 0xc8, 0xc9,
	0x1e, 0x21, 0x98, 0x0b, 0x3c, 0x78, 0x1d, 0xe2, 0x7e, 0xb5, 0x87, 0x72, 0x40, 0x57, 0xb5, 0x96,
	0xf4, 0x11, 0x27, 0xa7, 0x2b, 0xc8, 0x0a, 0x12, 0x2e, 0xfc, 0x16, 0xd1, 0x5f, 0xfc, 0x2d, 0x7e,
	0x83, 0x74, 0x75, 0x34, 0x74, 0xc3, 0xed, 0x15, 0xf6, 0xe0, 0xaf, 0x1f, 0x1e, 0x20, 0x4e, 0x80,
	0x7f, 0xdd, 0x2a, 0xf2, 0x1f, 0xcd, 0xdd, 0x86, 0x1a, 0xf5, 0x1f, 0x8d, 0xca, 0x03, 0x35, 0x26,
	0x1f, 0x75, 0x53, 0x55, 0x70, 0x0a, 0xe2, 0xf7, 0xeb, 0x56, 0xb3, 0xa5, 0xc6, 0x71, 0x12, 0x94,
	0xad, 0x4a, 0xb3, 0xa5, 0xce, 0xe1, 0x79, 0x48, 0xb6, 0x2b, 0x56, 0xbd, 0x62, 0xde, 0xab, 0xa9,
	0x89, 0x82, 0x75, 0x49, 0xe3, 0xfc, 0x16, 0xfd, 0x24, 0xff, 0x1a, 0xd5, 0x08, 0xce, 0x00, 0x54,
	0x6b, 0x56, 0xbd, 0x5d, 0x69, 0xd5, 0xdb, 0x35, 0x15, 0xe1, 0xbf, 0x61, 0xc9, 0xdc, 0x36, 0x3b,
	0x66, 0x6d, 0x53, 0x5a, 0x3a, 0x53, 0xce, 0xe8, 0xda, 0x3b, 0x04, 0x70, 0x0e, 0xc5, 0x62, 0xf2,
	0xaf, 0xff, 0x7f, 0x93, 0x9d, 0xc9, 0xd6, 0xb3, 0x85, 0x9b, 0xaf, 0xd7, 0x58, 0x7c, 0xfe, 0xfe,
	0xcb, 0xcb, 0x68, 0xc6, 0x48, 0x95, 0x04, 0x2f, 0xc9, 0xb5, 0x94, 0x51, 0x01, 0x37, 0x40, 0xf1,
	0x67, 0x89, 0xf5, 0x19, 0xa4, 0xa9, 0x21, 0x67, 0x57, 0xaf, 0xdd, 0x96, 0x11, 0xb9, 0x83, 0x36,
	0xf4, 0xe3, 0x4f, 0x7a, 0xe4, 0x78, 0xac, 0xa3, 0x93, 0xb1, 0x8e, 0x3e, 0x8c, 0x75, 0xf4, 0x71,
	0xac, 0xa3, 0xa3, 0xcf, 0x7a, 0xe4, 0xa1, 0xe2, 0xa7, 0x7c, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x0c,
	0x0b, 0xd4, 0xbd, 0x2e, 0x06, 0x00, 0x00,
}
