#!/usr/bin/env node

// ProtobufJS's CLI attempts to install its own CLI dependencies at runtime by
// exec'ing NPM. This is crazy. It introduces a dependency on NPM and breaks our
// dependency pinning and vendoring. There is an upstream issue about this [1],
// but it hasn't received any attention in nearly a year.
//
// As a workaround, this script figures out what NPM packages the ProtobufJS CLI
// would install, mirroring the logic in [0], and generates a package.json
// encoding those dependencies. The Makefile can then invoke `yarn install` on
// this synthesized package, giving us enough control over the dependency
// installation to pin and vendor the dependencies. The ProtobufJS CLI will not
// try to invoke NPM itself if its required dependencies are already installed.
//
// TODO(benesch): switch away from ProtobufJS and use protoc's support for
// generating JavaScript directly.
//
// [0]: https://github.com/dcodeIO/protobuf.js/blob/e8449c4/cli/util.js#L135-L157
// [1]: https://github.com/dcodeIO/protobuf.js/issues/716

var pbjsPkg = require("protobufjs/package");

const pbjsCliPkg = {
  "//": "File automatically generated by gen-protobuf-cli-deps. DO NOT EDIT!",
  dependencies: {},
};

pbjsPkg.cliDependencies.forEach(dep => {
  const version = pbjsPkg.dependencies[dep] || pbjsPkg.devDependencies[dep];
  pbjsCliPkg.dependencies[dep] = version;
})

process.stdout.write(JSON.stringify(pbjsCliPkg, null, 2));
