package hdinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// LocationsClient is the hDInsight Management Client
type LocationsClient struct {
	BaseClient
}

// NewLocationsClient creates an instance of the LocationsClient client.
func NewLocationsClient(subscriptionID string) LocationsClient {
	return NewLocationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLocationsClientWithBaseURI creates an instance of the LocationsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return LocationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckNameAvailability check the cluster name is available or not.
// Parameters:
// location - the Azure location (region) for which to make the request.
func (client LocationsClient) CheckNameAvailability(ctx context.Context, location string, parameters NameAvailabilityCheckRequestParameters) (result NameAvailabilityCheckResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationsClient.CheckNameAvailability")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CheckNameAvailabilityPreparer(ctx, location, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "CheckNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "CheckNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "CheckNameAvailability", resp, "Failure responding to request")
		return
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client LocationsClient) CheckNameAvailabilityPreparer(ctx context.Context, location string, parameters NameAvailabilityCheckRequestParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/locations/{location}/checkNameAvailability", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client LocationsClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client LocationsClient) CheckNameAvailabilityResponder(resp *http.Response) (result NameAvailabilityCheckResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAzureAsyncOperationStatus get the async operation status.
// Parameters:
// location - the Azure location (region) for which to make the request.
// operationID - the long running operation id.
func (client LocationsClient) GetAzureAsyncOperationStatus(ctx context.Context, location string, operationID string) (result AsyncOperationResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationsClient.GetAzureAsyncOperationStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAzureAsyncOperationStatusPreparer(ctx, location, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "GetAzureAsyncOperationStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAzureAsyncOperationStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "GetAzureAsyncOperationStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetAzureAsyncOperationStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "GetAzureAsyncOperationStatus", resp, "Failure responding to request")
		return
	}

	return
}

// GetAzureAsyncOperationStatusPreparer prepares the GetAzureAsyncOperationStatus request.
func (client LocationsClient) GetAzureAsyncOperationStatusPreparer(ctx context.Context, location string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"operationId":    autorest.Encode("path", operationID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/locations/{location}/azureasyncoperations/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAzureAsyncOperationStatusSender sends the GetAzureAsyncOperationStatus request. The method will close the
// http.Response Body if it receives an error.
func (client LocationsClient) GetAzureAsyncOperationStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAzureAsyncOperationStatusResponder handles the response to the GetAzureAsyncOperationStatus request. The method always
// closes the http.Response Body.
func (client LocationsClient) GetAzureAsyncOperationStatusResponder(resp *http.Response) (result AsyncOperationResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCapabilities gets the capabilities for the specified location.
// Parameters:
// location - the Azure location (region) for which to make the request.
func (client LocationsClient) GetCapabilities(ctx context.Context, location string) (result CapabilitiesResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationsClient.GetCapabilities")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCapabilitiesPreparer(ctx, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "GetCapabilities", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCapabilitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "GetCapabilities", resp, "Failure sending request")
		return
	}

	result, err = client.GetCapabilitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "GetCapabilities", resp, "Failure responding to request")
		return
	}

	return
}

// GetCapabilitiesPreparer prepares the GetCapabilities request.
func (client LocationsClient) GetCapabilitiesPreparer(ctx context.Context, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/locations/{location}/capabilities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCapabilitiesSender sends the GetCapabilities request. The method will close the
// http.Response Body if it receives an error.
func (client LocationsClient) GetCapabilitiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCapabilitiesResponder handles the response to the GetCapabilities request. The method always
// closes the http.Response Body.
func (client LocationsClient) GetCapabilitiesResponder(resp *http.Response) (result CapabilitiesResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBillingSpecs lists the billingSpecs for the specified subscription and location.
// Parameters:
// location - the Azure location (region) for which to make the request.
func (client LocationsClient) ListBillingSpecs(ctx context.Context, location string) (result BillingResponseListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationsClient.ListBillingSpecs")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListBillingSpecsPreparer(ctx, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ListBillingSpecs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBillingSpecsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ListBillingSpecs", resp, "Failure sending request")
		return
	}

	result, err = client.ListBillingSpecsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ListBillingSpecs", resp, "Failure responding to request")
		return
	}

	return
}

// ListBillingSpecsPreparer prepares the ListBillingSpecs request.
func (client LocationsClient) ListBillingSpecsPreparer(ctx context.Context, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/locations/{location}/billingSpecs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBillingSpecsSender sends the ListBillingSpecs request. The method will close the
// http.Response Body if it receives an error.
func (client LocationsClient) ListBillingSpecsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBillingSpecsResponder handles the response to the ListBillingSpecs request. The method always
// closes the http.Response Body.
func (client LocationsClient) ListBillingSpecsResponder(resp *http.Response) (result BillingResponseListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsages lists the usages for the specified location.
// Parameters:
// location - the Azure location (region) for which to make the request.
func (client LocationsClient) ListUsages(ctx context.Context, location string) (result UsagesListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationsClient.ListUsages")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListUsagesPreparer(ctx, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ListUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ListUsages", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ListUsages", resp, "Failure responding to request")
		return
	}

	return
}

// ListUsagesPreparer prepares the ListUsages request.
func (client LocationsClient) ListUsagesPreparer(ctx context.Context, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/locations/{location}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListUsagesSender sends the ListUsages request. The method will close the
// http.Response Body if it receives an error.
func (client LocationsClient) ListUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListUsagesResponder handles the response to the ListUsages request. The method always
// closes the http.Response Body.
func (client LocationsClient) ListUsagesResponder(resp *http.Response) (result UsagesListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ValidateClusterCreateRequest validate the cluster create request spec is valid or not.
// Parameters:
// location - the Azure location (region) for which to make the request.
func (client LocationsClient) ValidateClusterCreateRequest(ctx context.Context, location string, parameters ClusterCreateRequestValidationParameters) (result ClusterCreateValidationResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationsClient.ValidateClusterCreateRequest")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ValidateClusterCreateRequestPreparer(ctx, location, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ValidateClusterCreateRequest", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateClusterCreateRequestSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ValidateClusterCreateRequest", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateClusterCreateRequestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.LocationsClient", "ValidateClusterCreateRequest", resp, "Failure responding to request")
		return
	}

	return
}

// ValidateClusterCreateRequestPreparer prepares the ValidateClusterCreateRequest request.
func (client LocationsClient) ValidateClusterCreateRequestPreparer(ctx context.Context, location string, parameters ClusterCreateRequestValidationParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/locations/{location}/validateCreateRequest", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateClusterCreateRequestSender sends the ValidateClusterCreateRequest request. The method will close the
// http.Response Body if it receives an error.
func (client LocationsClient) ValidateClusterCreateRequestSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ValidateClusterCreateRequestResponder handles the response to the ValidateClusterCreateRequest request. The method always
// closes the http.Response Body.
func (client LocationsClient) ValidateClusterCreateRequestResponder(resp *http.Response) (result ClusterCreateValidationResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
