package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateScenarioParameter invokes the cloudcallcenter.CreateScenarioParameter API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createscenarioparameter.html
func (client *Client) CreateScenarioParameter(request *CreateScenarioParameterRequest) (response *CreateScenarioParameterResponse, err error) {
	response = CreateCreateScenarioParameterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateScenarioParameterWithChan invokes the cloudcallcenter.CreateScenarioParameter API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createscenarioparameter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateScenarioParameterWithChan(request *CreateScenarioParameterRequest) (<-chan *CreateScenarioParameterResponse, <-chan error) {
	responseChan := make(chan *CreateScenarioParameterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateScenarioParameter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateScenarioParameterWithCallback invokes the cloudcallcenter.CreateScenarioParameter API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createscenarioparameter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateScenarioParameterWithCallback(request *CreateScenarioParameterRequest, callback func(response *CreateScenarioParameterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateScenarioParameterResponse
		var err error
		defer close(result)
		response, err = client.CreateScenarioParameter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateScenarioParameterRequest is the request struct for api CreateScenarioParameter
type CreateScenarioParameterRequest struct {
	*requests.RpcRequest
	Description  string `position:"Query" name:"Description"`
	DefaultValue string `position:"Query" name:"DefaultValue"`
	Title        string `position:"Query" name:"Title"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	Name         string `position:"Query" name:"Name"`
	ScenarioId   string `position:"Query" name:"ScenarioId"`
}

// CreateScenarioParameterResponse is the response struct for api CreateScenarioParameter
type CreateScenarioParameterResponse struct {
	*responses.BaseResponse
	RequestId          string              `json:"RequestId" xml:"RequestId"`
	Success            bool                `json:"Success" xml:"Success"`
	Code               string              `json:"Code" xml:"Code"`
	Message            string              `json:"Message" xml:"Message"`
	HttpStatusCode     int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ScenarioParameters []ScenarioParameter `json:"ScenarioParameters" xml:"ScenarioParameters"`
}

// CreateCreateScenarioParameterRequest creates a request to invoke CreateScenarioParameter API
func CreateCreateScenarioParameterRequest() (request *CreateScenarioParameterRequest) {
	request = &CreateScenarioParameterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateScenarioParameter", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateScenarioParameterResponse creates a response to parse from CreateScenarioParameter response
func CreateCreateScenarioParameterResponse() (response *CreateScenarioParameterResponse) {
	response = &CreateScenarioParameterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
