package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteDataCorrect invokes the dms_enterprise.ExecuteDataCorrect API synchronously
func (client *Client) ExecuteDataCorrect(request *ExecuteDataCorrectRequest) (response *ExecuteDataCorrectResponse, err error) {
	response = CreateExecuteDataCorrectResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteDataCorrectWithChan invokes the dms_enterprise.ExecuteDataCorrect API asynchronously
func (client *Client) ExecuteDataCorrectWithChan(request *ExecuteDataCorrectRequest) (<-chan *ExecuteDataCorrectResponse, <-chan error) {
	responseChan := make(chan *ExecuteDataCorrectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteDataCorrect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteDataCorrectWithCallback invokes the dms_enterprise.ExecuteDataCorrect API asynchronously
func (client *Client) ExecuteDataCorrectWithCallback(request *ExecuteDataCorrectRequest, callback func(response *ExecuteDataCorrectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteDataCorrectResponse
		var err error
		defer close(result)
		response, err = client.ExecuteDataCorrect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteDataCorrectRequest is the request struct for api ExecuteDataCorrect
type ExecuteDataCorrectRequest struct {
	*requests.RpcRequest
	OrderId      requests.Integer       `position:"Query" name:"OrderId"`
	ActionName   string                 `position:"Query" name:"ActionName"`
	Tid          string                 `position:"Query" name:"Tid"`
	ActionDetail map[string]interface{} `position:"Query" name:"ActionDetail"`
}

// ExecuteDataCorrectResponse is the response struct for api ExecuteDataCorrect
type ExecuteDataCorrectResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateExecuteDataCorrectRequest creates a request to invoke ExecuteDataCorrect API
func CreateExecuteDataCorrectRequest() (request *ExecuteDataCorrectRequest) {
	request = &ExecuteDataCorrectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ExecuteDataCorrect", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExecuteDataCorrectResponse creates a response to parse from ExecuteDataCorrect response
func CreateExecuteDataCorrectResponse() (response *ExecuteDataCorrectResponse) {
	response = &ExecuteDataCorrectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
