// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/gsuiteaddons/v1/gsuiteaddons.proto

package gsuiteaddons

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_type "google.golang.org/genproto/googleapis/apps/script/type"
	calendar "google.golang.org/genproto/googleapis/apps/script/type/calendar"
	docs "google.golang.org/genproto/googleapis/apps/script/type/docs"
	drive "google.golang.org/genproto/googleapis/apps/script/type/drive"
	gmail "google.golang.org/genproto/googleapis/apps/script/type/gmail"
	sheets "google.golang.org/genproto/googleapis/apps/script/type/sheets"
	slides "google.golang.org/genproto/googleapis/apps/script/type/slides"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message to get Google Workspace Add-ons authorization information.
type GetAuthorizationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the project for which to get the Google Workspace Add-ons
	// authorization information.
	//
	// Example: `projects/my_project/authorization`.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAuthorizationRequest) Reset() {
	*x = GetAuthorizationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAuthorizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAuthorizationRequest) ProtoMessage() {}

func (x *GetAuthorizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAuthorizationRequest.ProtoReflect.Descriptor instead.
func (*GetAuthorizationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{0}
}

func (x *GetAuthorizationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The authorization information used when invoking deployment endpoints.
type Authorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The canonical full name of this resource.
	// Example:  `projects/123/authorization`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The email address of the service account used to authenticate requests to
	// add-on callback endpoints.
	ServiceAccountEmail string `protobuf:"bytes,2,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// The OAuth client ID used to obtain OAuth access tokens for a user on the
	// add-on's behalf.
	OauthClientId string `protobuf:"bytes,3,opt,name=oauth_client_id,json=oauthClientId,proto3" json:"oauth_client_id,omitempty"`
}

func (x *Authorization) Reset() {
	*x = Authorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Authorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Authorization) ProtoMessage() {}

func (x *Authorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Authorization.ProtoReflect.Descriptor instead.
func (*Authorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{1}
}

func (x *Authorization) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Authorization) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *Authorization) GetOauthClientId() string {
	if x != nil {
		return x.OauthClientId
	}
	return ""
}

// Request message to create a deployment.
type CreateDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the project in which to create the deployment.
	//
	// Example: `projects/my_project`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id to use for this deployment.  The full name of the created
	// resource will be `projects/<project_number>/deployments/<deployment_id>`.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Required. The deployment to create (deployment.name cannot be set).
	Deployment *Deployment `protobuf:"bytes,3,opt,name=deployment,proto3" json:"deployment,omitempty"`
}

func (x *CreateDeploymentRequest) Reset() {
	*x = CreateDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeploymentRequest) ProtoMessage() {}

func (x *CreateDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeploymentRequest.ProtoReflect.Descriptor instead.
func (*CreateDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{2}
}

func (x *CreateDeploymentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeploymentId() string {
	if x != nil {
		return x.DeploymentId
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

// Request message to create or replace a deployment.
type ReplaceDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The deployment to create or replace.
	Deployment *Deployment `protobuf:"bytes,2,opt,name=deployment,proto3" json:"deployment,omitempty"`
}

func (x *ReplaceDeploymentRequest) Reset() {
	*x = ReplaceDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplaceDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceDeploymentRequest) ProtoMessage() {}

func (x *ReplaceDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceDeploymentRequest.ProtoReflect.Descriptor instead.
func (*ReplaceDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{3}
}

func (x *ReplaceDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

// Request message to get a deployment.
type GetDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the deployment to get.
	//
	// Example:  `projects/my_project/deployments/my_deployment`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeploymentRequest) Reset() {
	*x = GetDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeploymentRequest) ProtoMessage() {}

func (x *GetDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{4}
}

func (x *GetDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to list deployments for a project.
type ListDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the project in which to create the deployment.
	//
	// Example: `projects/my_project`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of deployments to return. The service may return fewer
	// than this value.
	// If unspecified, at most 1000 deployments will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDeployments` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDeployments` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDeploymentsRequest) Reset() {
	*x = ListDeploymentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsRequest) ProtoMessage() {}

func (x *ListDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{5}
}

func (x *ListDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message to list deployments.
type ListDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of deployments for the given project.
	Deployments []*Deployment `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDeploymentsResponse) Reset() {
	*x = ListDeploymentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsResponse) ProtoMessage() {}

func (x *ListDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{6}
}

func (x *ListDeploymentsResponse) GetDeployments() []*Deployment {
	if x != nil {
		return x.Deployments
	}
	return nil
}

func (x *ListDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message to delete a deployment.
type DeleteDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the deployment to delete.
	//
	// Example:  `projects/my_project/deployments/my_deployment`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The etag of the deployment to delete.
	// If this is provided, it must match the server's etag.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteDeploymentRequest) Reset() {
	*x = DeleteDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeploymentRequest) ProtoMessage() {}

func (x *DeleteDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeploymentRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDeploymentRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message to install a developer mode deployment.
type InstallDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the deployment to install.
	//
	// Example:  `projects/my_project/deployments/my_deployment`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *InstallDeploymentRequest) Reset() {
	*x = InstallDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallDeploymentRequest) ProtoMessage() {}

func (x *InstallDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallDeploymentRequest.ProtoReflect.Descriptor instead.
func (*InstallDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{8}
}

func (x *InstallDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to uninstall a developer mode deployment.
type UninstallDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the deployment to install.
	//
	// Example:  `projects/my_project/deployments/my_deployment`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UninstallDeploymentRequest) Reset() {
	*x = UninstallDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UninstallDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UninstallDeploymentRequest) ProtoMessage() {}

func (x *UninstallDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UninstallDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UninstallDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{9}
}

func (x *UninstallDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to get the install status of a developer mode deployment.
type GetInstallStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the deployment.
	//
	// Example:  `projects/my_project/deployments/my_deployment/installStatus`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstallStatusRequest) Reset() {
	*x = GetInstallStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInstallStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstallStatusRequest) ProtoMessage() {}

func (x *GetInstallStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstallStatusRequest.ProtoReflect.Descriptor instead.
func (*GetInstallStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{10}
}

func (x *GetInstallStatusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Developer mode install status of a deployment
type InstallStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The canonical full resource name of the deployment install status.
	//
	// Example:  `projects/123/deployments/my_deployment/installStatus`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// True if the deployment is installed for the user
	Installed *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=installed,proto3" json:"installed,omitempty"`
}

func (x *InstallStatus) Reset() {
	*x = InstallStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallStatus) ProtoMessage() {}

func (x *InstallStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallStatus.ProtoReflect.Descriptor instead.
func (*InstallStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{11}
}

func (x *InstallStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstallStatus) GetInstalled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Installed
	}
	return nil
}

// A Google Workspace Add-on deployment
type Deployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The deployment resource name.
	// Example:  projects/123/deployments/my_deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The list of Google OAuth scopes for which to request consent from the end
	// user before executing an add-on endpoint.
	OauthScopes []string `protobuf:"bytes,2,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Workspace Add-on configuration.
	AddOns *AddOns `protobuf:"bytes,3,opt,name=add_ons,json=addOns,proto3" json:"add_ons,omitempty"`
	// This value is computed by the server based on the version of the
	// deployment in storage, and may be sent on update and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Deployment) Reset() {
	*x = Deployment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Deployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deployment) ProtoMessage() {}

func (x *Deployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deployment.ProtoReflect.Descriptor instead.
func (*Deployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{12}
}

func (x *Deployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Deployment) GetOauthScopes() []string {
	if x != nil {
		return x.OauthScopes
	}
	return nil
}

func (x *Deployment) GetAddOns() *AddOns {
	if x != nil {
		return x.AddOns
	}
	return nil
}

func (x *Deployment) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A Google Workspace Add-on configuration.
type AddOns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration that is common across all Google Workspace Add-ons.
	Common *_type.CommonAddOnManifest `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// Gmail add-on configuration.
	Gmail *gmail.GmailAddOnManifest `protobuf:"bytes,2,opt,name=gmail,proto3" json:"gmail,omitempty"`
	// Drive add-on configuration.
	Drive *drive.DriveAddOnManifest `protobuf:"bytes,5,opt,name=drive,proto3" json:"drive,omitempty"`
	// Calendar add-on configuration.
	Calendar *calendar.CalendarAddOnManifest `protobuf:"bytes,6,opt,name=calendar,proto3" json:"calendar,omitempty"`
	// Docs add-on configuration.
	Docs *docs.DocsAddOnManifest `protobuf:"bytes,7,opt,name=docs,proto3" json:"docs,omitempty"`
	// Sheets add-on configuration.
	Sheets *sheets.SheetsAddOnManifest `protobuf:"bytes,8,opt,name=sheets,proto3" json:"sheets,omitempty"`
	// Slides add-on configuration.
	Slides *slides.SlidesAddOnManifest `protobuf:"bytes,10,opt,name=slides,proto3" json:"slides,omitempty"`
	// Options for sending requests to add-on HTTP endpoints
	HttpOptions *_type.HttpOptions `protobuf:"bytes,15,opt,name=http_options,json=httpOptions,proto3" json:"http_options,omitempty"`
}

func (x *AddOns) Reset() {
	*x = AddOns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddOns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddOns) ProtoMessage() {}

func (x *AddOns) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddOns.ProtoReflect.Descriptor instead.
func (*AddOns) Descriptor() ([]byte, []int) {
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP(), []int{13}
}

func (x *AddOns) GetCommon() *_type.CommonAddOnManifest {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *AddOns) GetGmail() *gmail.GmailAddOnManifest {
	if x != nil {
		return x.Gmail
	}
	return nil
}

func (x *AddOns) GetDrive() *drive.DriveAddOnManifest {
	if x != nil {
		return x.Drive
	}
	return nil
}

func (x *AddOns) GetCalendar() *calendar.CalendarAddOnManifest {
	if x != nil {
		return x.Calendar
	}
	return nil
}

func (x *AddOns) GetDocs() *docs.DocsAddOnManifest {
	if x != nil {
		return x.Docs
	}
	return nil
}

func (x *AddOns) GetSheets() *sheets.SheetsAddOnManifest {
	if x != nil {
		return x.Sheets
	}
	return nil
}

func (x *AddOns) GetSlides() *slides.SlidesAddOnManifest {
	if x != nil {
		return x.Slides
	}
	return nil
}

func (x *AddOns) GetHttpOptions() *_type.HttpOptions {
	if x != nil {
		return x.HttpOptions
	}
	return nil
}

var File_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto protoreflect.FileDescriptor

var file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x67,
	0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x61, 0x6c, 0x65,
	0x6e, 0x64, 0x61, 0x72, 0x2f, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x5f, 0x61, 0x64,
	0x64, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x6f, 0x63, 0x73,
	0x2f, 0x64, 0x6f, 0x63, 0x73, 0x5f, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f,
	0x61, 0x64, 0x64, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70,
	0x73, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x67, 0x6d,
	0x61, 0x69, 0x6c, 0x2f, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x5f,
	0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x6d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73, 0x2f, 0x73, 0x68,
	0x65, 0x65, 0x74, 0x73, 0x5f, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x73, 0x6c, 0x69, 0x64, 0x65, 0x73, 0x2f, 0x73, 0x6c, 0x69, 0x64, 0x65, 0x73,
	0x5f, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x60, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x0d, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x26,
	0x0a, 0x0f, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x3a, 0x50, 0xea, 0x41, 0x4d, 0x0a, 0x29, 0x67, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdf, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x0a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x69, 0x0a, 0x18, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65,
	0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x5a, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa1, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4a, 0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x71, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64,
	0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x5e, 0x0a, 0x18, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x73, 0x75, 0x69,
	0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x1a, 0x55, 0x6e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x73,
	0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x17, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x67, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc8, 0x01, 0x0a,
	0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x3a, 0x69, 0xea, 0x41,
	0x66, 0x0a, 0x29, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x39, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xf0, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x3d, 0x0a,
	0x07, 0x61, 0x64, 0x64, 0x5f, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73,
	0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64,
	0x64, 0x4f, 0x6e, 0x73, 0x52, 0x06, 0x61, 0x64, 0x64, 0x4f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x3a, 0x58, 0xea, 0x41, 0x55, 0x0a, 0x26, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xdd, 0x04, 0x0a, 0x06, 0x41,
	0x64, 0x64, 0x4f, 0x6e, 0x73, 0x12, 0x44, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x05, 0x67,
	0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x2e, 0x47, 0x6d, 0x61, 0x69, 0x6c,
	0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x05, 0x67,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x47, 0x0a, 0x05, 0x64, 0x72, 0x69, 0x76, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x05, 0x64, 0x72, 0x69, 0x76, 0x65, 0x12, 0x53, 0x0a,
	0x08, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64,
	0x61, 0x72, 0x2e, 0x43, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x41, 0x64, 0x64, 0x4f, 0x6e,
	0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64,
	0x61, 0x72, 0x12, 0x43, 0x0a, 0x04, 0x64, 0x6f, 0x63, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x64, 0x6f, 0x63, 0x73, 0x2e,
	0x44, 0x6f, 0x63, 0x73, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x52, 0x04, 0x64, 0x6f, 0x63, 0x73, 0x12, 0x4b, 0x0a, 0x06, 0x73, 0x68, 0x65, 0x65, 0x74,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73, 0x2e, 0x53, 0x68, 0x65, 0x65, 0x74, 0x73, 0x41,
	0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x06, 0x73, 0x68,
	0x65, 0x65, 0x74, 0x73, 0x12, 0x4b, 0x0a, 0x06, 0x73, 0x6c, 0x69, 0x64, 0x65, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x73,
	0x6c, 0x69, 0x64, 0x65, 0x73, 0x2e, 0x53, 0x6c, 0x69, 0x64, 0x65, 0x73, 0x41, 0x64, 0x64, 0x4f,
	0x6e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x06, 0x73, 0x6c, 0x69, 0x64, 0x65,
	0x73, 0x12, 0x47, 0x0a, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x68,
	0x74, 0x74, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0xa4, 0x0d, 0x0a, 0x0c, 0x47,
	0x53, 0x75, 0x69, 0x74, 0x65, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x73, 0x12, 0xaa, 0x01, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xce, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x59,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x0a, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x12, 0xc6, 0x01, 0x0a, 0x11, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x1a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0xa1, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64,
	0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65,
	0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12,
	0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x95, 0x01,
	0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x2a, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa2, 0x01, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74,
	0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x30, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x13, 0x55,
	0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x22, 0x2d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x75, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb8, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65,
	0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x40,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xe1, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61, 0x64, 0x64,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x47, 0x53, 0x75, 0x69, 0x74, 0x65, 0x41, 0x64,
	0x64, 0x4f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61,
	0x64, 0x64, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x73, 0x75, 0x69, 0x74, 0x65, 0x61,
	0x64, 0x64, 0x6f, 0x6e, 0x73, 0xaa, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x53, 0x75, 0x69, 0x74, 0x65, 0x41, 0x64, 0x64, 0x4f, 0x6e,
	0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x47, 0x53, 0x75, 0x69, 0x74, 0x65, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x73,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x53, 0x75, 0x69, 0x74, 0x65, 0x41, 0x64, 0x64, 0x4f, 0x6e,
	0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescOnce sync.Once
	file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescData = file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDesc
)

func file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescGZIP() []byte {
	file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescOnce.Do(func() {
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescData)
	})
	return file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDescData
}

var file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_goTypes = []interface{}{
	(*GetAuthorizationRequest)(nil),        // 0: google.cloud.gsuiteaddons.v1.GetAuthorizationRequest
	(*Authorization)(nil),                  // 1: google.cloud.gsuiteaddons.v1.Authorization
	(*CreateDeploymentRequest)(nil),        // 2: google.cloud.gsuiteaddons.v1.CreateDeploymentRequest
	(*ReplaceDeploymentRequest)(nil),       // 3: google.cloud.gsuiteaddons.v1.ReplaceDeploymentRequest
	(*GetDeploymentRequest)(nil),           // 4: google.cloud.gsuiteaddons.v1.GetDeploymentRequest
	(*ListDeploymentsRequest)(nil),         // 5: google.cloud.gsuiteaddons.v1.ListDeploymentsRequest
	(*ListDeploymentsResponse)(nil),        // 6: google.cloud.gsuiteaddons.v1.ListDeploymentsResponse
	(*DeleteDeploymentRequest)(nil),        // 7: google.cloud.gsuiteaddons.v1.DeleteDeploymentRequest
	(*InstallDeploymentRequest)(nil),       // 8: google.cloud.gsuiteaddons.v1.InstallDeploymentRequest
	(*UninstallDeploymentRequest)(nil),     // 9: google.cloud.gsuiteaddons.v1.UninstallDeploymentRequest
	(*GetInstallStatusRequest)(nil),        // 10: google.cloud.gsuiteaddons.v1.GetInstallStatusRequest
	(*InstallStatus)(nil),                  // 11: google.cloud.gsuiteaddons.v1.InstallStatus
	(*Deployment)(nil),                     // 12: google.cloud.gsuiteaddons.v1.Deployment
	(*AddOns)(nil),                         // 13: google.cloud.gsuiteaddons.v1.AddOns
	(*wrapperspb.BoolValue)(nil),           // 14: google.protobuf.BoolValue
	(*_type.CommonAddOnManifest)(nil),      // 15: google.apps.script.type.CommonAddOnManifest
	(*gmail.GmailAddOnManifest)(nil),       // 16: google.apps.script.type.gmail.GmailAddOnManifest
	(*drive.DriveAddOnManifest)(nil),       // 17: google.apps.script.type.drive.DriveAddOnManifest
	(*calendar.CalendarAddOnManifest)(nil), // 18: google.apps.script.type.calendar.CalendarAddOnManifest
	(*docs.DocsAddOnManifest)(nil),         // 19: google.apps.script.type.docs.DocsAddOnManifest
	(*sheets.SheetsAddOnManifest)(nil),     // 20: google.apps.script.type.sheets.SheetsAddOnManifest
	(*slides.SlidesAddOnManifest)(nil),     // 21: google.apps.script.type.slides.SlidesAddOnManifest
	(*_type.HttpOptions)(nil),              // 22: google.apps.script.type.HttpOptions
	(*emptypb.Empty)(nil),                  // 23: google.protobuf.Empty
}
var file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_depIdxs = []int32{
	12, // 0: google.cloud.gsuiteaddons.v1.CreateDeploymentRequest.deployment:type_name -> google.cloud.gsuiteaddons.v1.Deployment
	12, // 1: google.cloud.gsuiteaddons.v1.ReplaceDeploymentRequest.deployment:type_name -> google.cloud.gsuiteaddons.v1.Deployment
	12, // 2: google.cloud.gsuiteaddons.v1.ListDeploymentsResponse.deployments:type_name -> google.cloud.gsuiteaddons.v1.Deployment
	14, // 3: google.cloud.gsuiteaddons.v1.InstallStatus.installed:type_name -> google.protobuf.BoolValue
	13, // 4: google.cloud.gsuiteaddons.v1.Deployment.add_ons:type_name -> google.cloud.gsuiteaddons.v1.AddOns
	15, // 5: google.cloud.gsuiteaddons.v1.AddOns.common:type_name -> google.apps.script.type.CommonAddOnManifest
	16, // 6: google.cloud.gsuiteaddons.v1.AddOns.gmail:type_name -> google.apps.script.type.gmail.GmailAddOnManifest
	17, // 7: google.cloud.gsuiteaddons.v1.AddOns.drive:type_name -> google.apps.script.type.drive.DriveAddOnManifest
	18, // 8: google.cloud.gsuiteaddons.v1.AddOns.calendar:type_name -> google.apps.script.type.calendar.CalendarAddOnManifest
	19, // 9: google.cloud.gsuiteaddons.v1.AddOns.docs:type_name -> google.apps.script.type.docs.DocsAddOnManifest
	20, // 10: google.cloud.gsuiteaddons.v1.AddOns.sheets:type_name -> google.apps.script.type.sheets.SheetsAddOnManifest
	21, // 11: google.cloud.gsuiteaddons.v1.AddOns.slides:type_name -> google.apps.script.type.slides.SlidesAddOnManifest
	22, // 12: google.cloud.gsuiteaddons.v1.AddOns.http_options:type_name -> google.apps.script.type.HttpOptions
	0,  // 13: google.cloud.gsuiteaddons.v1.GSuiteAddOns.GetAuthorization:input_type -> google.cloud.gsuiteaddons.v1.GetAuthorizationRequest
	2,  // 14: google.cloud.gsuiteaddons.v1.GSuiteAddOns.CreateDeployment:input_type -> google.cloud.gsuiteaddons.v1.CreateDeploymentRequest
	3,  // 15: google.cloud.gsuiteaddons.v1.GSuiteAddOns.ReplaceDeployment:input_type -> google.cloud.gsuiteaddons.v1.ReplaceDeploymentRequest
	4,  // 16: google.cloud.gsuiteaddons.v1.GSuiteAddOns.GetDeployment:input_type -> google.cloud.gsuiteaddons.v1.GetDeploymentRequest
	5,  // 17: google.cloud.gsuiteaddons.v1.GSuiteAddOns.ListDeployments:input_type -> google.cloud.gsuiteaddons.v1.ListDeploymentsRequest
	7,  // 18: google.cloud.gsuiteaddons.v1.GSuiteAddOns.DeleteDeployment:input_type -> google.cloud.gsuiteaddons.v1.DeleteDeploymentRequest
	8,  // 19: google.cloud.gsuiteaddons.v1.GSuiteAddOns.InstallDeployment:input_type -> google.cloud.gsuiteaddons.v1.InstallDeploymentRequest
	9,  // 20: google.cloud.gsuiteaddons.v1.GSuiteAddOns.UninstallDeployment:input_type -> google.cloud.gsuiteaddons.v1.UninstallDeploymentRequest
	10, // 21: google.cloud.gsuiteaddons.v1.GSuiteAddOns.GetInstallStatus:input_type -> google.cloud.gsuiteaddons.v1.GetInstallStatusRequest
	1,  // 22: google.cloud.gsuiteaddons.v1.GSuiteAddOns.GetAuthorization:output_type -> google.cloud.gsuiteaddons.v1.Authorization
	12, // 23: google.cloud.gsuiteaddons.v1.GSuiteAddOns.CreateDeployment:output_type -> google.cloud.gsuiteaddons.v1.Deployment
	12, // 24: google.cloud.gsuiteaddons.v1.GSuiteAddOns.ReplaceDeployment:output_type -> google.cloud.gsuiteaddons.v1.Deployment
	12, // 25: google.cloud.gsuiteaddons.v1.GSuiteAddOns.GetDeployment:output_type -> google.cloud.gsuiteaddons.v1.Deployment
	6,  // 26: google.cloud.gsuiteaddons.v1.GSuiteAddOns.ListDeployments:output_type -> google.cloud.gsuiteaddons.v1.ListDeploymentsResponse
	23, // 27: google.cloud.gsuiteaddons.v1.GSuiteAddOns.DeleteDeployment:output_type -> google.protobuf.Empty
	23, // 28: google.cloud.gsuiteaddons.v1.GSuiteAddOns.InstallDeployment:output_type -> google.protobuf.Empty
	23, // 29: google.cloud.gsuiteaddons.v1.GSuiteAddOns.UninstallDeployment:output_type -> google.protobuf.Empty
	11, // 30: google.cloud.gsuiteaddons.v1.GSuiteAddOns.GetInstallStatus:output_type -> google.cloud.gsuiteaddons.v1.InstallStatus
	22, // [22:31] is the sub-list for method output_type
	13, // [13:22] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_init() }
func file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_init() {
	if File_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAuthorizationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Authorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplaceDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeploymentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeploymentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UninstallDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInstallStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Deployment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddOns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_goTypes,
		DependencyIndexes: file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_depIdxs,
		MessageInfos:      file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_msgTypes,
	}.Build()
	File_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto = out.File
	file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_rawDesc = nil
	file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_goTypes = nil
	file_google_cloud_gsuiteaddons_v1_gsuiteaddons_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GSuiteAddOnsClient is the client API for GSuiteAddOns service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GSuiteAddOnsClient interface {
	// Gets the authorization information for deployments in a given project.
	GetAuthorization(ctx context.Context, in *GetAuthorizationRequest, opts ...grpc.CallOption) (*Authorization, error)
	// Creates a deployment with the specified name and configuration.
	CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Creates or replaces a deployment with the specified name.
	ReplaceDeployment(ctx context.Context, in *ReplaceDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Gets the deployment with the specified name.
	GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Lists all deployments in a particular project.
	ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error)
	// Deletes the deployment with the given name.
	DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Installs a deployment in developer mode.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	InstallDeployment(ctx context.Context, in *InstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Uninstalls a developer mode deployment.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	UninstallDeployment(ctx context.Context, in *UninstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Fetches the install status of a developer mode deployment.
	GetInstallStatus(ctx context.Context, in *GetInstallStatusRequest, opts ...grpc.CallOption) (*InstallStatus, error)
}

type gSuiteAddOnsClient struct {
	cc grpc.ClientConnInterface
}

func NewGSuiteAddOnsClient(cc grpc.ClientConnInterface) GSuiteAddOnsClient {
	return &gSuiteAddOnsClient{cc}
}

func (c *gSuiteAddOnsClient) GetAuthorization(ctx context.Context, in *GetAuthorizationRequest, opts ...grpc.CallOption) (*Authorization, error) {
	out := new(Authorization)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetAuthorization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/CreateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) ReplaceDeployment(ctx context.Context, in *ReplaceDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/ReplaceDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error) {
	out := new(ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/DeleteDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) InstallDeployment(ctx context.Context, in *InstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/InstallDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) UninstallDeployment(ctx context.Context, in *UninstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/UninstallDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) GetInstallStatus(ctx context.Context, in *GetInstallStatusRequest, opts ...grpc.CallOption) (*InstallStatus, error) {
	out := new(InstallStatus)
	err := c.cc.Invoke(ctx, "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetInstallStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GSuiteAddOnsServer is the server API for GSuiteAddOns service.
type GSuiteAddOnsServer interface {
	// Gets the authorization information for deployments in a given project.
	GetAuthorization(context.Context, *GetAuthorizationRequest) (*Authorization, error)
	// Creates a deployment with the specified name and configuration.
	CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error)
	// Creates or replaces a deployment with the specified name.
	ReplaceDeployment(context.Context, *ReplaceDeploymentRequest) (*Deployment, error)
	// Gets the deployment with the specified name.
	GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error)
	// Lists all deployments in a particular project.
	ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error)
	// Deletes the deployment with the given name.
	DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*emptypb.Empty, error)
	// Installs a deployment in developer mode.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	InstallDeployment(context.Context, *InstallDeploymentRequest) (*emptypb.Empty, error)
	// Uninstalls a developer mode deployment.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	UninstallDeployment(context.Context, *UninstallDeploymentRequest) (*emptypb.Empty, error)
	// Fetches the install status of a developer mode deployment.
	GetInstallStatus(context.Context, *GetInstallStatusRequest) (*InstallStatus, error)
}

// UnimplementedGSuiteAddOnsServer can be embedded to have forward compatible implementations.
type UnimplementedGSuiteAddOnsServer struct {
}

func (*UnimplementedGSuiteAddOnsServer) GetAuthorization(context.Context, *GetAuthorizationRequest) (*Authorization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorization not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeployment not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) ReplaceDeployment(context.Context, *ReplaceDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplaceDeployment not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeployment not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) InstallDeployment(context.Context, *InstallDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InstallDeployment not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) UninstallDeployment(context.Context, *UninstallDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UninstallDeployment not implemented")
}
func (*UnimplementedGSuiteAddOnsServer) GetInstallStatus(context.Context, *GetInstallStatusRequest) (*InstallStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstallStatus not implemented")
}

func RegisterGSuiteAddOnsServer(s *grpc.Server, srv GSuiteAddOnsServer) {
	s.RegisterService(&_GSuiteAddOns_serviceDesc, srv)
}

func _GSuiteAddOns_GetAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).GetAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetAuthorization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).GetAuthorization(ctx, req.(*GetAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_CreateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).CreateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/CreateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).CreateDeployment(ctx, req.(*CreateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_ReplaceDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplaceDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).ReplaceDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/ReplaceDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).ReplaceDeployment(ctx, req.(*ReplaceDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).GetDeployment(ctx, req.(*GetDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).ListDeployments(ctx, req.(*ListDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_DeleteDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).DeleteDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/DeleteDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).DeleteDeployment(ctx, req.(*DeleteDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_InstallDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstallDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).InstallDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/InstallDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).InstallDeployment(ctx, req.(*InstallDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_UninstallDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UninstallDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).UninstallDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/UninstallDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).UninstallDeployment(ctx, req.(*UninstallDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_GetInstallStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstallStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).GetInstallStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetInstallStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).GetInstallStatus(ctx, req.(*GetInstallStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GSuiteAddOns_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gsuiteaddons.v1.GSuiteAddOns",
	HandlerType: (*GSuiteAddOnsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAuthorization",
			Handler:    _GSuiteAddOns_GetAuthorization_Handler,
		},
		{
			MethodName: "CreateDeployment",
			Handler:    _GSuiteAddOns_CreateDeployment_Handler,
		},
		{
			MethodName: "ReplaceDeployment",
			Handler:    _GSuiteAddOns_ReplaceDeployment_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _GSuiteAddOns_GetDeployment_Handler,
		},
		{
			MethodName: "ListDeployments",
			Handler:    _GSuiteAddOns_ListDeployments_Handler,
		},
		{
			MethodName: "DeleteDeployment",
			Handler:    _GSuiteAddOns_DeleteDeployment_Handler,
		},
		{
			MethodName: "InstallDeployment",
			Handler:    _GSuiteAddOns_InstallDeployment_Handler,
		},
		{
			MethodName: "UninstallDeployment",
			Handler:    _GSuiteAddOns_UninstallDeployment_Handler,
		},
		{
			MethodName: "GetInstallStatus",
			Handler:    _GSuiteAddOns_GetInstallStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gsuiteaddons/v1/gsuiteaddons.proto",
}
