/* $Id$ */
/*
 * functions to make X11 BDF font bold-italic.
 */
#include "common.h"
#include "bold.h"
#include "italic.h"

/*
 * make font bold ant output.
 */
void bitmap_make_bold_output(FILE *fp, Bitmap *bitmap, int width, int height, int bdir, int pile)
{
  BoldBitmap *d;
  char **tmp;
  int y;
  size_t len;

  len = (width-1)/8+1;
  d = boldBitmap_new(len);
  tmp = bitmap_make_bdf_tmp(bitmap, width, height);
  for (y = 0; y < height; y++) {
    boldBitmap_make_bold(d, *tmp, len, bdir, pile);
    boldBitmap_output(fp, d, len);
    tmp++;
  }
  boldBitmap_delete(d);
}
