// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

func CopyOrigKeyValueSlice(dest, src []otlpcommon.KeyValue) []otlpcommon.KeyValue {
	var newDest []otlpcommon.KeyValue
	if cap(dest) < len(src) {
		newDest = make([]otlpcommon.KeyValue, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigKeyValue(&dest[i], false)
		}
	}
	for i := range src {
		CopyOrigKeyValue(&newDest[i], &src[i])
	}
	return newDest
}

func GenerateOrigTestKeyValueSlice() []otlpcommon.KeyValue {
	orig := make([]otlpcommon.KeyValue, 5)
	orig[1] = *GenTestOrigKeyValue()
	orig[3] = *GenTestOrigKeyValue()
	return orig
}
