/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.openwatcom;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.openwatcom.OpenWatcomCLinker;
import net.sf.antcontrib.cpptasks.openwatcom.OpenWatcomProcessor;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public final class OpenWatcomLibrarian
extends CommandLineLinker {
    private static final OpenWatcomLibrarian INSTANCE = new OpenWatcomLibrarian();

    public static OpenWatcomLibrarian getInstance() {
        return INSTANCE;
    }

    private OpenWatcomLibrarian() {
        super("wlib", null, new String[]{".obj"}, new String[0], ".lib", false, null);
    }

    protected void addBase(long base, Vector args) {
    }

    protected void addEntry(String entry, Vector args) {
    }

    protected void addFixed(Boolean fixed, Vector args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
    }

    protected void addIncremental(boolean incremental, Vector args) {
    }

    protected void addMap(boolean map, Vector args) {
    }

    protected void addStack(int stack, Vector args) {
    }

    protected String getCommandFileSwitch(String cmdFile) {
        return OpenWatcomProcessor.getCommandFileSwitch(cmdFile);
    }

    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return OpenWatcomProcessor.getLibraryPatterns(libnames, libType);
    }

    public Linker getLinker(LinkType type) {
        return OpenWatcomCLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    public String[] getOutputFileSwitch(String outFile) {
        return OpenWatcomProcessor.getOutputFileSwitch(outFile);
    }

    public boolean isCaseSensitive() {
        return OpenWatcomProcessor.isCaseSensitive();
    }

    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        outputFile.delete();
        super.link(task, outputFile, sourceFiles, config);
    }

    protected String[] prepareArguments(CCTask task, String outputDir, String outputName, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        StringBuffer buf = new StringBuffer();
        Vector<String> execArgs = new Vector<String>(preargs.length + endargs.length + 10 + sourceFiles.length);
        execArgs.addElement(this.getCommand());
        String outputFileName = new File(outputDir, outputName).toString();
        execArgs.addElement(this.quoteFilename(buf, outputFileName));
        int i = 0;
        while (i < preargs.length) {
            execArgs.addElement(preargs[i]);
            ++i;
        }
        int objBytes = 0;
        int i2 = 0;
        while (i2 < sourceFiles.length) {
            String last4 = sourceFiles[i2].substring(sourceFiles[i2].length() - 4).toLowerCase();
            if (!(last4.equals(".def") || last4.equals(".res") || last4.equals(".lib"))) {
                execArgs.addElement("+" + this.quoteFilename(buf, sourceFiles[i2]));
                objBytes = (int)((long)objBytes + new File(sourceFiles[i2]).length());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < endargs.length) {
            execArgs.addElement(endargs[i2]);
            ++i2;
        }
        Object[] execArguments = new String[execArgs.size()];
        execArgs.copyInto(execArguments);
        return execArguments;
    }
}

