//  FreeBSD divert sockets support

#ifndef WIN32

#include "config.h"
#ifdef __OS_BSD_LIKE
#ifdef __HAVE_BSD_DIVERT

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "iflist.h"
#include "thr.h"
#include "config.h"
#include "logger.h"
#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

#include "debug.h"
#include "ldefs.h"
#include "iptonf.h"

#define BUFSIZE 65535

void * bsd_divert_process(void * ptr){
	char logbuf[256];
    // create socket
    int fd=socket(AF_INET, SOCK_RAW, IPPROTO_DIVERT);
    if (fd==-1) {
        writelog("BSD_DIV: Can't create socket");
		pthread_exit(0);
    };

    /// bind to port
    struct sockaddr_in  sin;
    sin.sin_port = htons(cfg.bsd_div_port);
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;

	char * dev = "bsd_divert_iface0";
	if_list * iface = ifl_iface( dev ); /// reserved iface name!
	if(!iface){
		iface = ifl_add( dev ); 
		if(iface) {
			writelog("BSD_DIV: Device added: bsd_divert_iface0");
		}else{
			writelog("BSD_DIV: Can't add device bsd_divert_iface0!");
			pthread_exit(0);
		};
	}else{
		snprintf( logbuf, 256, "BSD_DIV: Iface already exist. All is ok. Iface <0x%x> iface->ifl_nfc <0x%x>", iface, iface->ifl_nfc);
		writelog(logbuf);
	};

    if (bind(fd, (struct sockaddr *)&sin, sizeof(sin)) == -1) {
		snprintf( logbuf, 256, "BSD_DIV: Can't bind to port. Error <%s>", strerror(errno));
		writelog(logbuf);
		pthread_exit(0);
    }

    unsigned char * packet = new unsigned char[BUFSIZE];
    socklen_t sinlen=sizeof(sin);
    ssize_t data_size;
	struct timeval ts;
	int sinlen_to, data_size_to;

	writelog("BSD_DIV: Successfully connected to ipfw divert/tee socket.");

    while(1) {
        data_size = recvfrom(fd, packet, BUFSIZE, 0, (struct sockaddr *)&sin, &sinlen);

        if (data_size < 0 && errno != EINTR) {
			snprintf( logbuf, 256, "BSD_DIV: Can't recv data from socket. Error <%s>", strerror(errno));
			writelog(logbuf);
            goto LOOP_END;
        }

		if(cfg.bsd_div_copy){
			// Doing copy data back to socket for another ipfw rules
			sinlen_to = sizeof(sin);
			data_size_to = sendto(fd, packet, data_size, 0, (struct sockaddr *)&sin, sinlen_to);
			if (data_size_to < 0) {
				snprintf( logbuf, 256, "BSD_DIV: Can't send data back to socket. Error <%s>", strerror(errno));
				writelog(logbuf);
				goto LOOP_END;
			}
		};
			
        if (data_size <= 0) continue;
		gettimeofday(&ts, NULL);
		iptonf((u_char *)iface, &ts, packet);
LOOP_END:
        continue;
    };

};

void run_bsd_divert(){
    /// run freebsd tee process if specified in config
    pthread_t th;
    char * pbuf = new char[64];
    writelog ("BSD_DIV: Starting worker thread for bsd divert socket.");
    pthread_create( &th, 0, bsd_divert_process, ( void * ) pbuf );
    pthread_detach( th );
};

#endif // __HAVE_BSD_DIVERT
#endif // __OS_BSD_LIKE
#endif // WIN32
