/** VSys:$config.h:0.0.3-018$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: config.h; File version: 0.0.3-018
 */
#ifndef __CONFIG_NDSAD_H__
#define __CONFIG_NDSAD_H__

#ifdef WIN32
#include <pcap.h>
#include <winsock2.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif
#include "handlers.h"
#include <map>
#include <string>
#include <vector>

struct cf_list;

struct nf_dest {
	sockaddr_in _sa_in; // Destination address
	int         sas;    // Sockadd size (for sendto call)
};

struct _conf_tag {
	pid_t   pid_child;  // PID of worker process
	char     *  file;   // Config file =)
	char     *  log;    // Log file
	char     *  bin;    // Binary file name
	char     *  pidfile;// PID file, Lock file...
	int         stat;   // Frequency of statistical dump. 
	                    // Seemed to be delay in seconds. 
	int    nf_lifetime; // NetFlow lifetime (default - 1800 sec)

	union {
		sockaddr_in _sa_in; // Destination address
		sockaddr    sa;     // Too but in correct type
	} sa;
	int         sas;    // Sockadd size (for sendto call)
	int         sock;   // UDP socket to send NF (one socket for all destinations ?)

	std::vector <u_int32_t>		ulog_groups; /// Groups for ulog 
	std::vector <nf_dest>    sa_pool; /// pool of destinations for NFv5 packets
	int         heap;   // Heap size for internal malloc
	int         dummy_mode; // Is dummy mode on?
	cf_list  *  dummy;  // Faces to ignore - to trace but not to store NF
	cf_list  *  force;  // Faces not to ignore - even if family is dummy
	cf_list  *  promisc;// Devices to be put in promisc mode.
	std::map<std::string, std::string> rules;
	int			bsd_div_port; /// FreeBSD ipfw divert port
	int			bsd_div_copy;	/// Doing copy of received packet throught ipfw divert socket. Use this if you doing divert not tee in ipfw rules!
};

#define sa_in sa._sa_in

/*
 * Structure to store faces read from configuration file.
 */
struct cf_list {
	char      cf_name[IFN_SIZE];
	cf_list * cf_next;
};

extern _conf_tag cfg;
int load_config();

void cfl_add  ( const char *, cf_list ** );
int  cfl_find ( const char *, cf_list *  );
int	 cfl_find_address( pcap_addr* addresses, cf_list* cfl);

#endif//__CONFIG_H__
