/** VSys:$nfc.h:0.0.3-001$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: nfc.h; File version: 0.0.3-001
 */
#ifndef __NF_IF_DATA__
#define __NF_IF_DATA__

#ifdef WIN32
#include "win32/types.h"
#else
#include <sys/types.h>
#endif

#include <pthread.h>

#include "ldefs.h"
#include "nf.h"

#define __PRE_DEFAULT_HASH_SIZE 128
extern u_int16_t __hs_default;

typedef nf5_stat nf5;

class nfc {
 public:
//	__LOCK_DEF( nfc[] );     // Lock for hash
	pthread_mutex_t * hml; // Hash mutex lock
	__LOCK_DEF( sq );      // Lock for send buffer
	nf5_msg sq;            // send buffer
	/*
	 * Structure similar to mempool_hdr
	 */
	struct nf_list {
		int        nfl_type;
		int        nfl_size;
		nf_list   *nfl_next;
		nf5        nfl_nf;
	};// *head;
	typedef nf_list* pnf_list;
	
	nf_list ** hash;
	const u_int16_t hsize; 
	/* 
	 * Have to be a power of 2! 
	 * Hash will not be efective otherwise.
	 */
	
	          nfc( const u_int16_t hs = 0 );
	          ~nfc();
	nf5 *     lookup( const nf5 * ); // Find out if node for argument exsists
	                                 // If not create new one.
	 
	nf5 *     apply( const nf5 * );  // Takes NF5 node and adds it values to
	                                 // stored ones
	 
	nf_list * crop( const nf5 * );   // Crops node from list. Returns pointer 
	                                 // to the dropped one. Memmore is not freed
	
	int       remove( const nf5 * ); // Front end for crop
	int       send( const nf5 * );   // Front end for crop

	static nf_list * alloc_nfl();    // Front ends for nfpool class
	static void free_nfl( nf_list * );

	void update( time_t, int dump = 0, const char * nmae = 0 );  
	                                 // Find out all expired nodes. Send them.
	                                 // Dump if necessary 
};

typedef nfc::nf_list _nf_list;
#define NF5( x )	( &(x)->nfl_nf )
#define MPH_NFLIST  0x1 // For RD - needed by mempool

#endif//__NF_IF_DATA__
