/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.BindExecCommand;
import com.impossibl.postgres.protocol.BufferedDataRow;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.SettingsContext;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import io.netty.util.ResourceLeakDetector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BindExecCommandImpl
extends CommandImpl
implements BindExecCommand {
    private static final int DEFAULT_MESSAGE_SIZE = 8192;
    private String statementName;
    private String portalName;
    private List<Type> parameterTypes;
    private List<Object> parameterValues;
    private List<ResultField> resultFields;
    private int maxRows;
    private int maxFieldLength;
    private QueryCommand.Status status;
    private QueryCommand.ResultBatch resultBatch;
    private List<ResultField.Format> resultFieldFormats;
    private SettingsContext parsingContext;
    private long queryTimeout;

    BindExecCommandImpl(String portalName, String statementName, List<Type> parameterTypes, List<Object> parameterValues, List<ResultField> resultFields) {
        this.statementName = statementName;
        this.portalName = portalName;
        this.parameterTypes = parameterTypes;
        this.parameterValues = parameterValues;
        this.resultFields = resultFields;
        this.maxRows = 0;
        this.maxFieldLength = Integer.MAX_VALUE;
        this.resultFieldFormats = resultFields != null ? BindExecCommandImpl.getResultFieldFormats(resultFields) : Collections.emptyList();
    }

    private void reset() {
        this.status = null;
        this.resultBatch = new QueryCommand.ResultBatch();
        this.resultBatch.setFields(this.resultFields);
        this.resultBatch.resetResults(true);
    }

    @Override
    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public String getPortalName() {
        return this.portalName;
    }

    @Override
    public QueryCommand.Status getStatus() {
        return this.status;
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public void setParameterTypes(List<Type> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public void setParameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
    }

    @Override
    public List<QueryCommand.ResultBatch> getResultBatches() {
        return Collections.singletonList(this.resultBatch);
    }

    @Override
    public void execute(ProtocolImpl protocol) throws IOException {
        this.parsingContext = new SettingsContext(protocol.getContext());
        this.parsingContext.setSetting("field.varying.length.max", this.maxFieldLength);
        Listener listener = new Listener(this.parsingContext);
        protocol.setListener(listener);
        ByteBuf msg = protocol.channel.alloc().buffer(8192);
        try {
            if (this.status != QueryCommand.Status.Suspended) {
                protocol.writeBind(msg, this.portalName, this.statementName, this.parameterTypes, this.parameterValues, this.resultFieldFormats);
            }
            this.reset();
            if (this.resultFields == null) {
                protocol.writeDescribe(msg, ServerObjectType.Portal, this.portalName);
            }
            protocol.writeExecute(msg, this.portalName, this.maxRows);
            if (this.maxRows > 0 && protocol.getTransactionStatus() == TransactionStatus.Idle) {
                protocol.writeFlush(msg);
            } else {
                protocol.writeSync(msg);
            }
        }
        catch (Throwable t) {
            msg.release();
            throw t;
        }
        protocol.send(msg);
        this.enableCancelTimer(protocol, this.queryTimeout);
        this.waitFor(listener);
        if (ResourceLeakDetector.getLevel().compareTo(ResourceLeakDetector.Level.SIMPLE) > 0 && this.resultBatch != null) {
            this.resultBatch.touch();
        }
    }

    private static List<ResultField.Format> getResultFieldFormats(List<ResultField> resultFields) {
        ArrayList<ResultField.Format> resultFieldFormats = new ArrayList<ResultField.Format>();
        for (ResultField resultField : resultFields) {
            resultField.setFormat(resultField.getTypeRef().get().getResultFormat());
            resultFieldFormats.add(resultField.getFormat());
        }
        return resultFieldFormats;
    }

    private class Listener
    extends BaseProtocolListener {
        Context context;

        Listener(Context context) {
            this.context = context;
        }

        @Override
        public boolean isComplete() {
            return BindExecCommandImpl.this.status != null || BindExecCommandImpl.this.error != null || BindExecCommandImpl.this.exception != null;
        }

        @Override
        public void bindComplete() {
        }

        @Override
        public void rowDescription(List<ResultField> newResultFields) {
            BindExecCommandImpl.this.resultFields = newResultFields;
            BindExecCommandImpl.this.resultFieldFormats = BindExecCommandImpl.getResultFieldFormats(newResultFields);
            BindExecCommandImpl.this.resultBatch.setFields(newResultFields);
            BindExecCommandImpl.this.resultBatch.resetResults(true);
        }

        @Override
        public void noData() {
            BindExecCommandImpl.this.resultBatch.setFields(Collections.emptyList());
            BindExecCommandImpl.this.resultBatch.resetResults(false);
        }

        @Override
        public void rowData(ByteBuf buffer) throws IOException {
            BindExecCommandImpl.this.resultBatch.addResult(BufferedDataRow.parse(buffer, BindExecCommandImpl.this.resultFields, BindExecCommandImpl.this.parsingContext));
        }

        @Override
        public void emptyQuery() {
            BindExecCommandImpl.this.resultBatch.setFields(Collections.emptyList());
            BindExecCommandImpl.this.resultBatch.resetResults(false);
            BindExecCommandImpl.this.status = QueryCommand.Status.Completed;
        }

        @Override
        public synchronized void portalSuspended() {
            BindExecCommandImpl.this.status = QueryCommand.Status.Suspended;
            this.notifyAll();
        }

        @Override
        public synchronized void commandComplete(String command, Long rowsAffected, Long oid) {
            BindExecCommandImpl.this.status = QueryCommand.Status.Completed;
            BindExecCommandImpl.this.resultBatch.setCommand(command);
            BindExecCommandImpl.this.resultBatch.setRowsAffected(rowsAffected);
            BindExecCommandImpl.this.resultBatch.setInsertedOid(oid);
            if (BindExecCommandImpl.this.maxRows > 0) {
                this.notifyAll();
            }
        }

        @Override
        public synchronized void error(Notice error) {
            BindExecCommandImpl.this.error = error;
            this.notifyAll();
        }

        @Override
        public synchronized void exception(Throwable cause) {
            BindExecCommandImpl.this.setException(cause);
            this.notifyAll();
        }

        @Override
        public void notice(Notice notice) {
            BindExecCommandImpl.this.addNotice(notice);
        }

        @Override
        public synchronized void ready(TransactionStatus txStatus) {
            this.notifyAll();
        }
    }
}

