/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.datetime.TimeZones;
import com.impossibl.postgres.datetime.instants.AmbiguousInstant;
import com.impossibl.postgres.datetime.instants.FutureInfiniteInstant;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.Instants;
import com.impossibl.postgres.datetime.instants.PastInfiniteInstant;
import com.impossibl.postgres.datetime.instants.PreciseInstant;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SettingSelectProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class Timestamps
extends SettingSelectProcProvider {
    private static final long PG_JAVA_EPOCH_DIFF_MICROS = Timestamps.calculateEpochDifferenceMicros();
    private TimeZone zone;
    private PrimitiveType primitiveType;

    public Timestamps(PrimitiveType primitiveType, String ... baseNames) {
        super("field.datetime.format", Integer.class, null, null, null, null, null, null, null, null, baseNames);
        this.primitiveType = primitiveType;
        this.zone = primitiveType == PrimitiveType.TimestampTZ ? TimeZones.UTC : null;
        this.matchedBinEncoder = new BinIntegerEncoder();
        this.matchedBinDecoder = new BinIntegerDecoder();
        this.matchedTxtEncoder = this.unmatchedTxtEncoder = new TxtEncoder();
        this.matchedTxtDecoder = this.unmatchedTxtDecoder = new TxtDecoder();
    }

    private static long calculateEpochDifferenceMicros() {
        Calendar pgEpochInJava = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        pgEpochInJava.clear();
        pgEpochInJava.set(2000, 0, 1);
        return TimeUnit.MILLISECONDS.toMicros(pgEpochInJava.getTimeInMillis());
    }

    public static boolean isInfinity(long micros) {
        return micros == Long.MAX_VALUE || micros == Long.MIN_VALUE;
    }

    class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return Timestamps.this.primitiveType;
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        protected void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            String strVal = context.getTimestampFormatter().getPrinter().format((Instant)val);
            buffer.append(strVal);
        }
    }

    class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return Timestamps.this.primitiveType;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        protected Object decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            HashMap<String, Object> pieces = new HashMap<String, Object>();
            context.getTimestampFormatter().getParser().parse(buffer.toString(), 0, pieces);
            Instant instant = Instants.timestampFromPieces(pieces, context.getTimeZone());
            if (Timestamps.this.primitiveType != PrimitiveType.TimestampTZ) {
                instant = instant.ambiguate();
            }
            return instant;
        }
    }

    class BinIntegerEncoder
    extends BinaryEncoder {
        BinIntegerEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return Timestamps.this.primitiveType;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                Instant inst = (Instant)val;
                long micros = Timestamps.this.primitiveType == PrimitiveType.TimestampTZ ? inst.getMicrosUTC() : inst.disambiguate(TimeZone.getDefault()).getMicrosLocal();
                if (!Timestamps.isInfinity(micros)) {
                    micros -= PG_JAVA_EPOCH_DIFF_MICROS;
                }
                buffer.writeInt(8);
                buffer.writeLong(micros);
            }
        }
    }

    class BinIntegerDecoder
    extends BinaryDecoder {
        BinIntegerDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return Timestamps.this.primitiveType;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        public Instant decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 8) {
                throw new IOException("invalid length");
            }
            long micros = buffer.readLong();
            if (micros == Long.MAX_VALUE) {
                return FutureInfiniteInstant.INSTANCE;
            }
            if (micros == Long.MIN_VALUE) {
                return PastInfiniteInstant.INSTANCE;
            }
            micros += PG_JAVA_EPOCH_DIFF_MICROS;
            if (Timestamps.this.zone != null) {
                return new PreciseInstant(Instant.Type.Timestamp, micros, Timestamps.this.zone);
            }
            return new AmbiguousInstant(Instant.Type.Timestamp, micros);
        }
    }
}

