/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.tables.PgAttribute;
import com.impossibl.postgres.system.tables.PgType;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.util.Collection;
import java.util.Map;

public class DomainType
extends Type {
    private Type base;
    private boolean nullable;
    private Map<String, Object> modifiers;
    private int numberOfDimensions;
    private String defaultValue;

    public Type getBase() {
        return this.base;
    }

    public void setBase(Type base) {
        this.base = base;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public boolean isParameterFormatSupported(ResultField.Format format) {
        return this.base.isParameterFormatSupported(format);
    }

    @Override
    public boolean isResultFormatSupported(ResultField.Format format) {
        return this.base.isResultFormatSupported(format);
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.Domain;
    }

    public Map<String, Object> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Map<String, Object> modifiers) {
        this.modifiers = modifiers;
    }

    public int getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public void setNumberOfDimensions(int numberOfDimensions) {
        this.numberOfDimensions = numberOfDimensions;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Type unwrap() {
        return this.base.unwrap();
    }

    @Override
    public void load(PgType.Row source, Collection<PgAttribute.Row> attrs, Registry registry) {
        super.load(source, attrs, registry);
        this.base = registry.loadType(source.getDomainBaseTypeId());
        this.nullable = !source.isDomainNotNull();
        this.modifiers = this.base.getModifierParser().parse(source.getDomainTypeMod());
        this.numberOfDimensions = source.getDomainDimensions();
        this.defaultValue = source.getDomainDefault() != null ? source.getDomainDefault() : "";
    }
}

