/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.http.impl.conn;

import com.microsoft.applicationinsights.core.dependencies.http.Consts;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.core.dependencies.http.impl.conn.Wire;
import com.microsoft.applicationinsights.core.dependencies.http.io.HttpTransportMetrics;
import com.microsoft.applicationinsights.core.dependencies.http.io.SessionOutputBuffer;
import com.microsoft.applicationinsights.core.dependencies.http.util.CharArrayBuffer;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LoggingSessionOutputBuffer
implements SessionOutputBuffer {
    private final SessionOutputBuffer out;
    private final Wire wire;
    private final String charset;

    public LoggingSessionOutputBuffer(SessionOutputBuffer out, Wire wire, String charset) {
        this.out = out;
        this.wire = wire;
        this.charset = charset != null ? charset : Consts.ASCII.name();
    }

    public LoggingSessionOutputBuffer(SessionOutputBuffer out, Wire wire) {
        this(out, wire, null);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.wire.enabled()) {
            this.wire.output(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void writeLine(CharArrayBuffer buffer) throws IOException {
        this.out.writeLine(buffer);
        if (this.wire.enabled()) {
            String s2 = new String(buffer.buffer(), 0, buffer.length());
            String tmp = s2 + "\r\n";
            this.wire.output(tmp.getBytes(this.charset));
        }
    }

    @Override
    public void writeLine(String s2) throws IOException {
        this.out.writeLine(s2);
        if (this.wire.enabled()) {
            String tmp = s2 + "\r\n";
            this.wire.output(tmp.getBytes(this.charset));
        }
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.out.getMetrics();
    }
}

