/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.processor;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BuiltInProcessor(value="RequestTelemetryFilter")
public final class RequestTelemetryFilter
implements TelemetryProcessor {
    private long minimumDurationInMS = 0L;
    private boolean hasBlocked;
    private final Set<String> exactBadResponseCodes = new HashSet<String>();
    private final List<FromTo> ignoredResponseCodeRange = new ArrayList<FromTo>();

    @Override
    public boolean process(Telemetry telemetry) {
        if (telemetry == null) {
            return true;
        }
        if (!this.hasBlocked && this.minimumDurationInMS <= 0L) {
            return true;
        }
        if (telemetry instanceof RequestTelemetry) {
            RequestTelemetry requestTelemetry = (RequestTelemetry)telemetry;
            String responseCode = requestTelemetry.getResponseCode();
            if (this.exactBadResponseCodes.contains(requestTelemetry.getResponseCode())) {
                return false;
            }
            int asInt = Integer.valueOf(responseCode);
            for (FromTo fromTo : this.ignoredResponseCodeRange) {
                if (fromTo.from > asInt || fromTo.to < asInt) continue;
                return false;
            }
            Duration requestDuration = requestTelemetry.getDuration();
            if (requestDuration != null && requestDuration.getTotalMilliseconds() < this.minimumDurationInMS) {
                return false;
            }
            if (LocalStringsUtils.isNullOrEmpty(requestTelemetry.getResponseCode())) {
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumDurationInMS(String minimumDurationInMS) throws Throwable {
        try {
            this.minimumDurationInMS = Long.valueOf(minimumDurationInMS);
            InternalLogger.INSTANCE.trace("RequestTelemetryFilter: successfully set MinimumDurationInMS = %d", this.minimumDurationInMS);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("RequestTelemetryFilter: failed to set minimum duration: %s, Exception : %s", minimumDurationInMS, ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            finally {
                throw t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotNeededResponseCodes(String notNeededResponseCodes) throws Throwable {
        try {
            if (LocalStringsUtils.isNullOrEmpty(notNeededResponseCodes)) {
                this.hasBlocked = false;
            } else {
                List<String> exclusions = Arrays.asList(notNeededResponseCodes.split(","));
                for (String ex : exclusions) {
                    if (LocalStringsUtils.isNullOrEmpty(ex = ex.trim())) continue;
                    List<String> fromTo = Arrays.asList(ex.split("-"));
                    if (fromTo.size() == 1) {
                        this.exactBadResponseCodes.add(ex);
                        continue;
                    }
                    if (fromTo.size() != 2 || LocalStringsUtils.isNullOrEmpty(fromTo.get(0)) || LocalStringsUtils.isNullOrEmpty(fromTo.get(1))) continue;
                    int f = Integer.valueOf(fromTo.get(0));
                    int t = Integer.valueOf(fromTo.get(1));
                    this.ignoredResponseCodeRange.add(new FromTo(f, t));
                }
                this.hasBlocked = !this.exactBadResponseCodes.isEmpty() || !this.ignoredResponseCodeRange.isEmpty();
            }
            InternalLogger.INSTANCE.trace(String.format("ResponseCodeFilter: successfully set non needed response codes: %s", notNeededResponseCodes), new Object[0]);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("RequestTelemetryFilter: failed to parse NotNeededResponseCodes: %s, Exception : %s", notNeededResponseCodes, ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            finally {
                throw t;
            }
        }
    }

    private final class FromTo {
        public final int from;
        public final int to;

        private FromTo(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }
}

