/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.internal.schemav2.MessageData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseSampleSourceTelemetry;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;

public final class TraceTelemetry
extends BaseSampleSourceTelemetry<MessageData> {
    private Double samplingPercentage;
    private final MessageData data = new MessageData();
    private static final String ENVELOPE_NAME = "Message";
    private static final String BASE_TYPE = "MessageData";

    public TraceTelemetry() {
        this("");
    }

    public TraceTelemetry(String message) {
        this(message, null);
    }

    public TraceTelemetry(String message, SeverityLevel severityLevel) {
        this.initialize(this.data.getProperties());
        this.setMessage(message);
        this.setSeverityLevel(severityLevel);
    }

    public String getMessage() {
        return this.data.getMessage();
    }

    public void setMessage(String message) {
        this.data.setMessage(message);
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
        this.data.setMessage(Sanitizer.sanitizeMessage(this.data.getMessage()));
    }

    @Override
    protected MessageData getData() {
        return this.data;
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.data.setSeverityLevel(severityLevel == null ? null : com.microsoft.applicationinsights.internal.schemav2.SeverityLevel.values()[severityLevel.getValue()]);
    }

    public SeverityLevel getSeverityLevel() {
        return this.data.getSeverityLevel() == null ? null : SeverityLevel.values()[this.data.getSeverityLevel().getValue()];
    }

    @Override
    public Double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }
}

