/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.remote;

import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.helper.oauth.OAuth;
import de.undercouch.citeproc.helper.oauth.OAuth1;
import de.undercouch.citeproc.helper.oauth.Response;
import de.undercouch.citeproc.helper.oauth.Token;
import de.undercouch.citeproc.helper.oauth.UnauthorizedException;
import de.undercouch.citeproc.remote.RemoteConnector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public abstract class AbstractRemoteConnector
implements RemoteConnector {
    protected final OAuth auth;
    protected Token requestToken;
    protected Token accessToken;

    public AbstractRemoteConnector(String consumerKey, String consumerSecret, String redirectUri) {
        this.auth = this.createOAuth(consumerKey, consumerSecret, redirectUri);
    }

    protected abstract String getOAuthRequestTokenURL();

    protected abstract String getOAuthAuthorizationURL();

    protected abstract String getOAuthAccessTokenURL();

    protected abstract OAuth.Method getOAuthAccessTokenMethod();

    protected OAuth createOAuth(String consumerKey, String consumerSecret, String redirectUri) {
        return new OAuth1(consumerKey, consumerSecret);
    }

    @Override
    public String getAuthorizationURL() throws IOException {
        String rtu = this.getOAuthRequestTokenURL();
        if (rtu == null) {
            return this.getOAuthAuthorizationURL();
        }
        try {
            this.requestToken = this.auth.requestTemporaryCredentials(new URL(rtu), OAuth.Method.GET);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this.getOAuthAuthorizationURL() + this.requestToken.getToken();
    }

    @Override
    public void authorize(String verificationCode) throws IOException {
        try {
            this.accessToken = this.auth.requestTokenCredentials(new URL(this.getOAuthAccessTokenURL()), this.getOAuthAccessTokenMethod(), this.requestToken, verificationCode);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAccessToken(String token, String secret) {
        this.accessToken = new Token(token, secret);
    }

    @Override
    public String getAccessTokenValue() {
        if (this.accessToken == null) {
            return null;
        }
        return this.accessToken.getToken();
    }

    @Override
    public String getAccessTokenSecret() {
        if (this.accessToken == null) {
            return null;
        }
        return this.accessToken.getSecret();
    }

    protected Map<String, Object> performRequestObject(String url, Map<String, String> additionalHeaders) throws IOException {
        Response response = this.performRequest(url, additionalHeaders);
        try (InputStream is = response.getInputStream();){
            Map<String, Object> map = this.parseResponseObject(response);
            return map;
        }
    }

    protected List<Object> performRequestArray(String url, Map<String, String> additionalHeaders) throws IOException {
        Response response = this.performRequest(url, additionalHeaders);
        try (InputStream is = response.getInputStream();){
            List<Object> list = this.parseResponseArray(response);
            return list;
        }
    }

    protected Response performRequest(String url, Map<String, String> additionalHeaders) throws IOException {
        if (this.accessToken == null) {
            throw new UnauthorizedException("Access token has not yet been requested");
        }
        URL u = new URL(url);
        return this.auth.request(u, OAuth.Method.GET, this.accessToken, additionalHeaders);
    }

    private JsonParser parseResponse(Response response) throws IOException {
        InputStream is = response.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        return new JsonParser(new JsonLexer(r));
    }

    protected Map<String, Object> parseResponseObject(Response response) throws IOException {
        return this.parseResponse(response).parseObject();
    }

    protected List<Object> parseResponseArray(Response response) throws IOException {
        return this.parseResponse(response).parseArray();
    }
}

