/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.cli;

import java.nio.file.Paths;
import org.jabref.gui.auximport.AuxParserResultViewModel;
import org.jabref.logic.auxparser.DefaultAuxParser;
import org.jabref.model.auxparser.AuxParserResult;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.strings.StringUtil;

public class AuxCommandLine {
    private final String auxFile;
    private final BibDatabase database;

    public AuxCommandLine(String auxFile, BibDatabase database) {
        this.auxFile = StringUtil.getCorrectFileName(auxFile, "aux");
        this.database = database;
    }

    public BibDatabase perform() {
        BibDatabase subDatabase = null;
        if (!this.auxFile.isEmpty() && this.database != null) {
            DefaultAuxParser auxParser = new DefaultAuxParser(this.database);
            AuxParserResult result = auxParser.parse(Paths.get(this.auxFile, new String[0]));
            subDatabase = result.getGeneratedBibDatabase();
            System.out.println(new AuxParserResultViewModel(result).getInformation(true));
        }
        return subDatabase;
    }
}

