/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.airhacks.afterburner.injection.Injector;
import com.airhacks.afterburner.injection.PresenterFactory;
import java.util.function.Function;
import org.jabref.Globals;
import org.jabref.gui.DialogService;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInjector
implements PresenterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultInjector.class);

    private static Object createDependency(Class<?> clazz) {
        if (clazz == DialogService.class) {
            return new FXDialogService();
        }
        if (clazz == TaskExecutor.class) {
            return Globals.TASK_EXECUTOR;
        }
        if (clazz == PreferencesService.class) {
            return Globals.prefs;
        }
        if (clazz == KeyBindingRepository.class) {
            return Globals.getKeyPrefs();
        }
        if (clazz == JournalAbbreviationLoader.class) {
            return Globals.journalAbbreviationLoader;
        }
        if (clazz == StateManager.class) {
            return Globals.stateManager;
        }
        if (clazz == FileUpdateMonitor.class) {
            return Globals.getFileUpdateMonitor();
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.error("Cannot instantiate dependency: " + clazz, ex);
            return null;
        }
    }

    @Override
    public <T> T instantiatePresenter(Class<T> clazz, Function<String, Object> injectionContext) {
        LOGGER.debug("Instantiate " + clazz.getName());
        Injector.setInstanceSupplier(DefaultInjector::createDependency);
        return Injector.instantiatePresenter(clazz, injectionContext);
    }
}

