/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.gui.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;

public class FXDialog
extends Alert {
    private final WindowAdapter fxOverSwingHelper = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            Platform.runLater(() -> {
                Stage fxDialogWindow = FXDialog.this.getDialogWindow();
                fxDialogWindow.toFront();
                fxDialogWindow.requestFocus();
            });
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            Platform.runLater(() -> {
                Stage fxDialogWindow = FXDialog.this.getDialogWindow();
                fxDialogWindow.toFront();
                fxDialogWindow.requestFocus();
            });
        }
    };

    public FXDialog(Alert.AlertType type, String title, Image image, boolean isModal) {
        this(type, title, isModal);
        this.setDialogIcon(image);
    }

    public FXDialog(Alert.AlertType type, String title, Image image) {
        this(type, title, true);
        this.setDialogIcon(image);
    }

    public FXDialog(Alert.AlertType type, String title, boolean isModal) {
        this(type, isModal);
        this.setTitle(title);
    }

    public FXDialog(Alert.AlertType type, String title) {
        this(type);
        this.setTitle(title);
    }

    public FXDialog(Alert.AlertType type, boolean isModal) {
        super(type);
        this.setDialogIcon(IconTheme.getJabRefImageFX());
        Stage dialogWindow = this.getDialogWindow();
        dialogWindow.setOnCloseRequest(evt -> this.close());
        if (isModal) {
            this.initModality(Modality.APPLICATION_MODAL);
        } else {
            this.initModality(Modality.NONE);
        }
        dialogWindow.setOnShown(evt -> {
            this.setSwingWindowsEnabledAndFocusable(!isModal);
            this.setLocationRelativeToMainWindow();
        });
        dialogWindow.setOnHiding(evt -> this.setSwingWindowsEnabledAndFocusable(true));
        dialogWindow.setOnCloseRequest(evt -> this.close());
        dialogWindow.getScene().setOnKeyPressed(event -> {
            KeyBindingRepository keyBindingRepository = Globals.getKeyPrefs();
            if (keyBindingRepository.checkKeyCombinationEquality(KeyBinding.CLOSE_DIALOG, (KeyEvent)event)) {
                dialogWindow.close();
            }
        });
    }

    public FXDialog(Alert.AlertType type) {
        this(type, true);
    }

    public void setDialogIcon(Image image) {
        Stage fxDialogWindow = this.getDialogWindow();
        fxDialogWindow.getIcons().add((Object)image);
    }

    private Stage getDialogWindow() {
        return (Stage)this.getDialogPane().getScene().getWindow();
    }

    private void setSwingWindowsEnabledAndFocusable(boolean enabled) {
        for (Window swingWindow : Window.getWindows()) {
            swingWindow.setEnabled(enabled);
            if (!enabled) {
                swingWindow.addWindowListener(this.fxOverSwingHelper);
                continue;
            }
            swingWindow.removeWindowListener(this.fxOverSwingHelper);
        }
    }

    private void setLocationRelativeToMainWindow() {
        double mainWindowX = JabRefGUI.getMainFrame().getLocationOnScreen().getX();
        double mainWindowY = JabRefGUI.getMainFrame().getLocationOnScreen().getY();
        double mainWindowWidth = JabRefGUI.getMainFrame().getSize().getWidth();
        double mainWindowHeight = JabRefGUI.getMainFrame().getSize().getHeight();
        this.setX(mainWindowX + mainWindowWidth / 2.0 - this.getWidth() / 2.0);
        this.setY(mainWindowY + mainWindowHeight / 2.0 - this.getHeight() / 2.0);
    }
}

