/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationTabView;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.FileAnnotationCache;
import org.jabref.model.entry.BibEntry;

public class FileAnnotationTab
extends EntryEditorTab {
    private final FileAnnotationCache fileAnnotationCache;

    public FileAnnotationTab(FileAnnotationCache cache) {
        this.fileAnnotationCache = cache;
        this.setText(Localization.lang("File annotations", new String[0]));
        this.setTooltip(new Tooltip(Localization.lang("Show file annotations", new String[0])));
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return entry.getField("file").isPresent();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        this.setContent((Node)new FileAnnotationTabView(entry, this.fileAnnotationCache).getView());
    }
}

