/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.filelist.FileListEntry;
import org.jabref.gui.filelist.FileListTableModel;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.undo.UndoableInsertEntry;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.logic.xmp.XmpUtilReader;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.IdGenerator;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroppedFileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DroppedFileHandler.class);
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final JRadioButton linkInPlace = new JRadioButton();
    private final JRadioButton copyRadioButton = new JRadioButton();
    private final JRadioButton moveRadioButton = new JRadioButton();
    private final JLabel destDirLabel = new JLabel();
    private final JCheckBox renameCheckBox = new JCheckBox();
    private final JTextField renameToTextBox = new JTextField(50);
    private final JPanel optionsPanel = new JPanel();

    public DroppedFileHandler(JabRefFrame frame, BasePanel panel) {
        this.frame = frame;
        this.panel = panel;
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.linkInPlace);
        grp.add(this.copyRadioButton);
        grp.add(this.moveRadioButton);
        FormLayout layout = new FormLayout("left:15dlu,pref,pref,pref", "bottom:14pt,pref,pref,pref,pref");
        layout.setRowGroups(new int[][]{{1, 2, 3, 4, 5}});
        FormBuilder builder = FormBuilder.create().layout(layout);
        builder.add(this.linkInPlace).xyw(1, 1, 4);
        builder.add(this.destDirLabel).xyw(1, 2, 4);
        builder.add(this.copyRadioButton).xyw(2, 3, 3);
        builder.add(this.moveRadioButton).xyw(2, 4, 3);
        builder.add(this.renameCheckBox).xyw(2, 5, 1);
        builder.add(this.renameToTextBox).xyw(4, 5, 1);
        this.optionsPanel.add(builder.getPanel());
    }

    public void handleDroppedfile(String fileName, ExternalFileType fileType, MainTable mainTable, int dropRow) {
        BibEntry entry = mainTable.getEntryAt(dropRow);
        this.handleDroppedfile(fileName, fileType, entry);
    }

    public void handleDroppedfile(String fileName, ExternalFileType fileType, BibEntry entry) {
        String destFilename;
        NamedCompound edits = new NamedCompound(Localization.lang("Drop %0", fileType.getExtension()));
        if (this.tryXmpImport(fileName, fileType, edits)) {
            edits.end();
            this.panel.getUndoManager().addEdit(edits);
            return;
        }
        if (!this.showLinkMoveCopyRenameDialog(fileName, fileType, entry, this.panel.getDatabase())) {
            return;
        }
        boolean success = true;
        if (this.linkInPlace.isSelected()) {
            destFilename = FileUtil.shortenFileName(Paths.get(fileName, new String[0]), this.panel.getBibDatabaseContext().getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences())).toString();
        } else {
            String string = destFilename = this.renameCheckBox.isSelected() ? this.renameToTextBox.getText() : Paths.get(fileName, new String[0]).toString();
            if (this.copyRadioButton.isSelected()) {
                success = this.doCopy(fileName, destFilename, edits);
            } else if (this.moveRadioButton.isSelected()) {
                success = this.doMove(fileName, destFilename, edits);
            }
        }
        if (success) {
            this.doLink(entry, fileType, destFilename, false, edits);
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        edits.end();
        this.panel.getUndoManager().addEdit(edits);
    }

    public void linkPdfToEntry(String fileName, MainTable entryTable, int dropRow) {
        BibEntry entry = entryTable.getEntryAt(dropRow);
        this.linkPdfToEntry(fileName, entry);
    }

    public void linkPdfToEntry(String fileName, BibEntry entry) {
        String destFilename;
        Optional<ExternalFileType> optFileType = ExternalFileTypes.getInstance().getExternalFileTypeByExt("pdf");
        if (!optFileType.isPresent()) {
            LOGGER.warn("No file type with extension 'pdf' registered.");
            return;
        }
        ExternalFileType fileType = optFileType.get();
        if (!this.showLinkMoveCopyRenameDialog(fileName, fileType, entry, this.panel.getDatabase())) {
            return;
        }
        boolean success = true;
        NamedCompound edits = new NamedCompound(Localization.lang("Drop %0", fileType.getExtension()));
        if (this.linkInPlace.isSelected()) {
            destFilename = FileUtil.shortenFileName(Paths.get(fileName, new String[0]), this.panel.getBibDatabaseContext().getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences())).toString();
        } else {
            String string = destFilename = this.renameCheckBox.isSelected() ? this.renameToTextBox.getText() : new File(fileName).getName();
            if (this.copyRadioButton.isSelected()) {
                success = this.doCopy(fileName, destFilename, edits);
            } else if (this.moveRadioButton.isSelected()) {
                success = this.doMove(fileName, destFilename, edits);
            }
        }
        if (success) {
            this.doLink(entry, fileType, destFilename, false, edits);
            this.panel.markBaseChanged();
        }
        edits.end();
        this.panel.getUndoManager().addEdit(edits);
    }

    private boolean tryXmpImport(String fileName, ExternalFileType fileType, NamedCompound edits) {
        String destFilename;
        List<BibEntry> xmpEntriesInFile;
        if (!"pdf".equals(fileType.getExtension())) {
            return false;
        }
        try {
            xmpEntriesInFile = XmpUtilReader.readXmp(fileName, Globals.prefs.getXMPPreferences());
        }
        catch (IOException e) {
            LOGGER.warn("Problem reading XMP", e);
            return false;
        }
        if (xmpEntriesInFile == null || xmpEntriesInFile.isEmpty()) {
            return false;
        }
        JLabel confirmationMessage = new JLabel(Localization.lang("The PDF contains one or several BibTeX-records.", new String[0]) + "\n" + Localization.lang("Do you want to import these as new entries into the current library?", new String[0]));
        JPanel entriesPanel = new JPanel();
        entriesPanel.setLayout(new BoxLayout(entriesPanel, 1));
        xmpEntriesInFile.forEach(entry -> {
            JTextArea entryArea = new JTextArea(entry.toString());
            entryArea.setEditable(false);
            entriesPanel.add(entryArea);
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)confirmationMessage, "North");
        contentPanel.add((Component)entriesPanel, "Center");
        int reply = JOptionPane.showConfirmDialog(this.frame, contentPanel, Localization.lang("XMP-metadata found in PDF: %0", fileName), 1, 3);
        if (reply == 2) {
            return true;
        }
        if (reply == 1) {
            return false;
        }
        boolean isSingle = xmpEntriesInFile.size() == 1;
        BibEntry single = isSingle ? xmpEntriesInFile.get(0) : null;
        boolean success = true;
        if (this.linkInPlace.isSelected()) {
            destFilename = FileUtil.shortenFileName(Paths.get(fileName, new String[0]), this.panel.getBibDatabaseContext().getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences())).toString();
        } else {
            destFilename = this.renameCheckBox.isSelected() || single == null ? fileName : single.getCiteKey() + "." + fileType.getExtension();
            if (this.copyRadioButton.isSelected()) {
                success = this.doCopy(fileName, destFilename, edits);
            } else if (this.moveRadioButton.isSelected()) {
                success = this.doMove(fileName, destFilename, edits);
            }
        }
        if (success) {
            for (BibEntry aXmpEntriesInFile : xmpEntriesInFile) {
                aXmpEntriesInFile.setId(IdGenerator.next());
                edits.addEdit(new UndoableInsertEntry(this.panel.getDatabase(), aXmpEntriesInFile, this.panel));
                this.panel.getDatabase().insertEntry(aXmpEntriesInFile);
                this.doLink(aXmpEntriesInFile, fileType, destFilename, true, edits);
            }
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showLinkMoveCopyRenameDialog(String linkFileName, ExternalFileType fileType, BibEntry entry, BibDatabase database) {
        String dialogTitle = Localization.lang("Link to file %0", linkFileName);
        Optional<Path> dir = this.panel.getBibDatabaseContext().getFirstExistingFileDir(Globals.prefs.getFileDirectoryPreferences());
        if (!dir.isPresent()) {
            this.destDirLabel.setText(Localization.lang("File directory is not set or does not exist!", new String[0]));
            this.copyRadioButton.setEnabled(false);
            this.moveRadioButton.setEnabled(false);
            this.renameToTextBox.setEnabled(false);
            this.renameCheckBox.setEnabled(false);
            this.linkInPlace.setSelected(true);
        } else {
            this.destDirLabel.setText(Localization.lang("File directory is '%0':", dir.get().toString()));
            this.copyRadioButton.setEnabled(true);
            this.moveRadioButton.setEnabled(true);
            this.renameToTextBox.setEnabled(true);
            this.renameCheckBox.setEnabled(true);
        }
        ChangeListener cl = arg0 -> {
            this.renameCheckBox.setEnabled(!this.linkInPlace.isSelected());
            this.renameToTextBox.setEnabled(!this.linkInPlace.isSelected());
        };
        this.linkInPlace.setText(Localization.lang("Leave file in its current directory", new String[0]));
        this.copyRadioButton.setText(Localization.lang("Copy file to file directory", new String[0]));
        this.moveRadioButton.setText(Localization.lang("Move file to file directory", new String[0]));
        this.renameCheckBox.setText(Localization.lang("Rename file to", new String[0]).concat(": "));
        String targetName = FileUtil.createFileNameFromPattern(database, entry, Globals.prefs.get("importFileNamePattern"));
        String fileDirPattern = Globals.prefs.get("importFileDirPattern");
        String targetDirName = "";
        if (!fileDirPattern.isEmpty()) {
            targetDirName = FileUtil.createDirNameFromPattern(database, entry, fileDirPattern);
        }
        if (targetDirName.isEmpty()) {
            this.renameToTextBox.setText(targetName.concat(".").concat(fileType.getExtension()));
        } else {
            this.renameToTextBox.setText(targetDirName.concat("/").concat(targetName.concat(".").concat(fileType.getExtension())));
        }
        this.linkInPlace.setSelected(this.frame.prefs().getBoolean("DroppedFileHandler_LeaveFileInDir"));
        this.copyRadioButton.setSelected(this.frame.prefs().getBoolean("DroppedFileHandler_CopyFile"));
        this.moveRadioButton.setSelected(this.frame.prefs().getBoolean("DroppedFileHandler_MoveFile"));
        this.renameCheckBox.setSelected(this.frame.prefs().getBoolean("DroppedFileHandler_RenameFile"));
        this.linkInPlace.addChangeListener(cl);
        cl.stateChanged(new ChangeEvent(this.linkInPlace));
        try {
            Object[] messages = new Object[]{Localization.lang("How would you like to link to '%0'?", linkFileName), this.optionsPanel};
            int reply = JOptionPane.showConfirmDialog(this.frame, messages, dialogTitle, 2, 3);
            if (reply == 0) {
                this.frame.prefs().putBoolean("DroppedFileHandler_LeaveFileInDir", this.linkInPlace.isSelected());
                this.frame.prefs().putBoolean("DroppedFileHandler_CopyFile", this.copyRadioButton.isSelected());
                this.frame.prefs().putBoolean("DroppedFileHandler_MoveFile", this.moveRadioButton.isSelected());
                this.frame.prefs().putBoolean("DroppedFileHandler_RenameFile", this.renameCheckBox.isSelected());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.linkInPlace.removeChangeListener(cl);
        }
    }

    private void doLink(BibEntry entry, ExternalFileType fileType, String filename, boolean avoidDuplicate, NamedCompound edits) {
        Optional<String> oldValue = entry.getField("file");
        FileListTableModel tm = new FileListTableModel();
        oldValue.ifPresent(tm::setContent);
        if (avoidDuplicate) {
            Optional<Path> file;
            List<Path> dirs = this.panel.getBibDatabaseContext().getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences());
            String absFilename = new File(filename).isAbsolute() || dirs.isEmpty() ? filename : ((file = FileHelper.expandFilenameAsPath(filename, dirs)).isPresent() ? file.get().toAbsolutePath().toString() : "");
            LOGGER.debug("absFilename: " + absFilename);
            for (int i = 0; i < tm.getRowCount(); ++i) {
                FileListEntry flEntry = tm.getEntry(i);
                String absName = flEntry.toParsedFileField().findIn(dirs).map(Path::toAbsolutePath).map(Path::toString).orElse(null);
                LOGGER.debug("absName: " + absName);
                if (!absFilename.equals(absName)) continue;
                return;
            }
        }
        tm.addEntry(tm.getRowCount(), new FileListEntry("", filename, fileType));
        String newValue = tm.getStringRepresentation();
        UndoableFieldChange edit = new UndoableFieldChange(entry, "file", oldValue.orElse(null), newValue);
        DefaultTaskExecutor.runInJavaFXThread(() -> entry.setField("file", newValue));
        if (edits == null) {
            this.panel.getUndoManager().addEdit(edit);
        } else {
            edits.addEdit(edit);
        }
    }

    private boolean doMove(String fileName, String destFilename, NamedCompound edits) {
        Optional<Path> dir = this.panel.getBibDatabaseContext().getFirstExistingFileDir(Globals.prefs.getFileDirectoryPreferences());
        if (dir.isPresent()) {
            int answer;
            Path destFile = dir.get().resolve(destFilename);
            if (Files.exists(destFile, new LinkOption[0]) && (answer = JOptionPane.showConfirmDialog(this.frame, Localization.lang("'%0' exists. Overwrite file?", destFile.toString()), Localization.lang("Overwrite file?", new String[0]), 0)) == 1) {
                return false;
            }
            Path fromFile = Paths.get(fileName, new String[0]);
            try {
                if (!Files.exists(destFile, new LinkOption[0])) {
                    Files.createDirectories(destFile, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                LOGGER.error("Problem creating target directories", e);
            }
            if (FileUtil.renameFile(fromFile, destFile, true)) {
                return true;
            }
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not move file '%0'.", destFile.toString()) + Localization.lang("Please move the file manually and link in place.", new String[0]), Localization.lang("Move file failed", new String[0]), 0);
            return false;
        }
        return false;
    }

    private boolean doCopy(String fileName, String toFile, NamedCompound edits) {
        int answer;
        List<String> dirs = this.panel.getBibDatabaseContext().getFileDirectories(Globals.prefs.getFileDirectoryPreferences());
        int found = -1;
        for (int i = 0; i < dirs.size(); ++i) {
            if (!new File(dirs.get(i)).exists()) continue;
            found = i;
            break;
        }
        if (found < 0) {
            LOGGER.warn("Cannot determine destination directory or destination directory does not exist");
            return false;
        }
        Path destFile = Paths.get(dirs.get(found), new String[0]).resolve(toFile);
        if (destFile.toString().equals(fileName)) {
            return true;
        }
        if (Files.exists(destFile, new LinkOption[0]) && (answer = JOptionPane.showConfirmDialog(this.frame, Localization.lang("'%0' exists. Overwrite file?", destFile.toString()), Localization.lang("File exists", new String[0]), 0, 3)) == 1) {
            return false;
        }
        try {
            if (!Files.exists(destFile, new LinkOption[0])) {
                Files.createDirectories(destFile, new FileAttribute[0]);
            }
            FileUtil.copyFile(Paths.get(fileName, new String[0]), destFile, true);
        }
        catch (IOException e) {
            LOGGER.error("Problem copying file", e);
            return false;
        }
        return true;
    }
}

