/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.logic.net.ProgressInputStream;
import org.jabref.logic.net.URLDownload;

public class FileDownloadTask
extends BackgroundTask<Void> {
    private final URL source;
    private final Path destination;

    public FileDownloadTask(URL source, Path destination) {
        this.source = source;
        this.destination = destination;
    }

    @Override
    protected Void call() throws Exception {
        URLDownload download = new URLDownload(this.source);
        try (ProgressInputStream inputStream = download.asInputStream();){
            EasyBind.subscribe(inputStream.totalNumBytesReadProperty(), bytesRead -> this.updateProgress(bytesRead.longValue(), inputStream.getMaxNumBytes()));
            Files.createDirectories(this.destination.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, this.destination, StandardCopyOption.REPLACE_EXISTING);
        }
        return null;
    }
}

