/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javax.swing.SwingUtilities;
import javax.xml.transform.TransformerException;
import org.jabref.Globals;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiles.DownloadExternalFile;
import org.jabref.gui.externalfiles.FileDownloadTask;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.fieldeditors.LinkedFilesEditorViewModel;
import org.jabref.gui.filelist.FileListEntryEditor;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.cleanup.CleanupPreferences;
import org.jabref.logic.cleanup.MoveFilesCleanup;
import org.jabref.logic.cleanup.RenamePdfCleanup;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilWriter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedFileViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedFileViewModel.class);
    private final LinkedFile linkedFile;
    private final BibDatabaseContext databaseContext;
    private final DoubleProperty downloadProgress = new SimpleDoubleProperty(-1.0);
    private final BooleanProperty downloadOngoing = new SimpleBooleanProperty(false);
    private final BooleanProperty isAutomaticallyFound = new SimpleBooleanProperty(false);
    private final BooleanProperty canWriteXMPMetadata = new SimpleBooleanProperty(false);
    private final DialogService dialogService;
    private final BibEntry entry;
    private final TaskExecutor taskExecutor;
    private final FileDirectoryPreferences fileDirectoryPreferences;
    private final CleanupPreferences cleanupPreferences;
    private final LayoutFormatterPreferences layoutFormatterPreferences;
    private final XmpPreferences xmpPreferences;
    private final String fileNamePattern;

    @Deprecated
    public LinkedFileViewModel(LinkedFile linkedFile, BibEntry entry, BibDatabaseContext databaseContext, TaskExecutor taskExecutor) {
        this(linkedFile, entry, databaseContext, taskExecutor, new FXDialogService(), Globals.prefs, Globals.journalAbbreviationLoader);
    }

    public LinkedFileViewModel(LinkedFile linkedFile, BibEntry entry, BibDatabaseContext databaseContext, TaskExecutor taskExecutor, DialogService dialogService, JabRefPreferences preferences, JournalAbbreviationLoader abbreviationLoader) {
        this.linkedFile = linkedFile;
        this.databaseContext = databaseContext;
        this.entry = entry;
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
        this.cleanupPreferences = preferences.getCleanupPreferences(abbreviationLoader);
        this.layoutFormatterPreferences = preferences.getLayoutFormatterPreferences(abbreviationLoader);
        this.xmpPreferences = preferences.getXMPPreferences();
        this.fileNamePattern = preferences.get("importFileNamePattern");
        this.fileDirectoryPreferences = preferences.getFileDirectoryPreferences();
        this.downloadOngoing.bind((ObservableValue)this.downloadProgress.greaterThanOrEqualTo(0).and((ObservableBooleanValue)this.downloadProgress.lessThan(1)));
        this.canWriteXMPMetadata.setValue(Boolean.valueOf(!linkedFile.isOnlineLink() && linkedFile.getFileType().equalsIgnoreCase("pdf")));
    }

    public BooleanProperty canWriteXMPMetadataProperty() {
        return this.canWriteXMPMetadata;
    }

    public boolean isAutomaticallyFound() {
        return this.isAutomaticallyFound.get();
    }

    public BooleanProperty isAutomaticallyFoundProperty() {
        return this.isAutomaticallyFound;
    }

    public BooleanProperty downloadOngoingProperty() {
        return this.downloadOngoing;
    }

    public DoubleProperty downloadProgressProperty() {
        return this.downloadProgress;
    }

    public StringProperty linkProperty() {
        return this.linkedFile.linkProperty();
    }

    public StringProperty descriptionProperty() {
        return this.linkedFile.descriptionProperty();
    }

    public String getDescription() {
        return this.linkedFile.getDescription();
    }

    public Optional<Path> findIn(List<Path> directories) {
        return this.linkedFile.findIn(directories);
    }

    public GlyphIcons getTypeIcon() {
        return MaterialDesignIcon.FILE_PDF;
    }

    public void markAsAutomaticallyFound() {
        this.isAutomaticallyFound.setValue(Boolean.valueOf(true));
    }

    public void acceptAsLinked() {
        this.isAutomaticallyFound.setValue(Boolean.valueOf(false));
    }

    public Observable[] getObservables() {
        ArrayList<Observable> observables = new ArrayList<Observable>(Arrays.asList(this.linkedFile.getObservables()));
        observables.add((Observable)this.downloadOngoing);
        observables.add((Observable)this.downloadProgress);
        observables.add((Observable)this.isAutomaticallyFound);
        return observables.toArray(new Observable[observables.size()]);
    }

    public void open() {
        try {
            Optional<ExternalFileType> type = ExternalFileTypes.getInstance().fromLinkedFile(this.linkedFile, true);
            JabRefDesktop.openExternalFileAnyFormat(this.databaseContext, this.linkedFile.getLink(), type);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot open selected file.", e);
        }
    }

    public void openFolder() {
        try {
            Path path = null;
            if (Paths.get(this.linkedFile.getLink(), new String[0]).isAbsolute()) {
                path = Paths.get(this.linkedFile.getLink(), new String[0]);
            } else {
                for (Path folder : this.databaseContext.getFileDirectoriesAsPaths(this.fileDirectoryPreferences)) {
                    Path file = folder.resolve(this.linkedFile.getLink());
                    if (!Files.exists(file, new LinkOption[0])) continue;
                    path = file;
                    break;
                }
            }
            if (path != null) {
                JabRefDesktop.openFolderAndSelectFile(path);
            } else {
                this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new String[0]));
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Cannot open folder", ex);
        }
    }

    public void rename() {
        if (this.linkedFile.isOnlineLink()) {
            return;
        }
        Optional<Path> fileDir = this.databaseContext.getFirstExistingFileDir(this.fileDirectoryPreferences);
        if (!fileDir.isPresent()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Rename file", new String[0]), Localization.lang("File directory is not set or does not exist!", new String[0]));
            return;
        }
        Optional<Path> file = this.linkedFile.findIn(this.databaseContext, this.fileDirectoryPreferences);
        if (file.isPresent() && Files.exists(file.get(), new LinkOption[0])) {
            RenamePdfCleanup pdfCleanup = new RenamePdfCleanup(false, this.databaseContext, this.cleanupPreferences.getFileNamePattern(), this.layoutFormatterPreferences, this.fileDirectoryPreferences, this.linkedFile);
            String targetFileName = pdfCleanup.getTargetFileName(this.linkedFile, this.entry);
            boolean confirm = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Rename file", new String[0]), Localization.lang("Rename file to", new String[0]) + " " + targetFileName, Localization.lang("Rename file", new String[0]), Localization.lang("Cancel", new String[0]));
            if (confirm) {
                Optional<Path> fileConflictCheck = pdfCleanup.findExistingFile(this.linkedFile, this.entry);
                this.performRenameWithConflictCheck(file, pdfCleanup, targetFileName, fileConflictCheck);
            }
        } else {
            this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new String[0]), Localization.lang("Could not find file '%0'.", this.linkedFile.getLink()));
        }
    }

    private void performRenameWithConflictCheck(Optional<Path> file, RenamePdfCleanup pdfCleanup, String targetFileName, Optional<Path> fileConflictCheck) {
        if (!fileConflictCheck.isPresent()) {
            try {
                pdfCleanup.cleanupWithException(this.entry);
            }
            catch (IOException e) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Rename failed", new String[0]), Localization.lang("JabRef cannot access the file because it is being used by another process.", new String[0]));
            }
        } else {
            boolean confirm = this.dialogService.showConfirmationDialogAndWait(Localization.lang("File exists", new String[0]), Localization.lang("'%0' exists. Overwrite file?", targetFileName), Localization.lang("Overwrite", new String[0]), Localization.lang("Cancel", new String[0]));
            if (confirm) {
                try {
                    FileUtil.renameFileWithException(fileConflictCheck.get(), file.get(), true);
                    pdfCleanup.cleanupWithException(this.entry);
                }
                catch (IOException e) {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Rename failed", new String[0]), Localization.lang("JabRef cannot access the file because it is being used by another process.", new String[0]));
                }
            }
        }
    }

    public void moveToDefaultDirectory() {
        if (this.linkedFile.isOnlineLink()) {
            return;
        }
        Optional<Path> fileDir = this.databaseContext.getFirstExistingFileDir(this.fileDirectoryPreferences);
        if (!fileDir.isPresent()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Move file", new String[0]), Localization.lang("File directory is not set or does not exist!", new String[0]));
            return;
        }
        Optional<Path> file = this.linkedFile.findIn(this.databaseContext, this.fileDirectoryPreferences);
        if (file.isPresent() && Files.exists(file.get(), new LinkOption[0])) {
            MoveFilesCleanup moveFiles = new MoveFilesCleanup(this.databaseContext, this.cleanupPreferences.getFileDirPattern(), this.fileDirectoryPreferences, this.layoutFormatterPreferences, this.linkedFile);
            boolean confirm = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Move file", new String[0]), Localization.lang("Move file to file directory?", new String[0]) + " " + fileDir.get(), Localization.lang("Move file", new String[0]), Localization.lang("Cancel", new String[0]));
            if (confirm) {
                moveFiles.cleanup(this.entry);
            }
        } else {
            this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new String[0]), Localization.lang("Could not find file '%0'.", this.linkedFile.getLink()));
        }
    }

    public boolean delete(FileDirectoryPreferences prefs) {
        Optional<Path> file = this.linkedFile.findIn(this.databaseContext, prefs);
        if (!file.isPresent()) {
            LOGGER.warn("Could not find file " + this.linkedFile.getLink());
            return true;
        }
        ButtonType removeFromEntry = new ButtonType(Localization.lang("Remove from entry", new String[0]), ButtonBar.ButtonData.YES);
        ButtonType deleteFromEntry = new ButtonType(Localization.lang("Delete from disk", new String[0]));
        Optional<ButtonType> buttonType = this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.INFORMATION, Localization.lang("Delete '%0'", file.get().toString()), Localization.lang("Delete the selected file permanently from disk, or just remove the file from the entry? Pressing Delete will delete the file permanently from disk.", new String[0]), removeFromEntry, deleteFromEntry, ButtonType.CANCEL);
        if (buttonType.isPresent()) {
            if (buttonType.get().equals(removeFromEntry)) {
                return true;
            }
            if (buttonType.get().equals(deleteFromEntry)) {
                try {
                    Files.delete(file.get());
                    return true;
                }
                catch (IOException ex) {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Cannot delete file", new String[0]), Localization.lang("File permission error", new String[0]));
                    LOGGER.warn("File permission error while deleting: " + this.linkedFile, ex);
                }
            }
        }
        return false;
    }

    public void edit() {
        FileListEntryEditor editor = new FileListEntryEditor(this.linkedFile, false, true, this.databaseContext);
        SwingUtilities.invokeLater(() -> editor.setVisible(true, false));
    }

    public void writeXMPMetadata() {
        BackgroundTask<Void> writeTask = BackgroundTask.wrap(() -> {
            Optional<Path> file = this.linkedFile.findIn(this.databaseContext, this.fileDirectoryPreferences);
            if (file.isPresent()) {
                try {
                    XmpUtilWriter.writeXmp(file.get(), this.entry, this.databaseContext.getDatabase(), this.xmpPreferences);
                }
                catch (IOException | TransformerException exception) {
                    // empty catch block
                }
            }
            return null;
        });
        this.taskExecutor.execute(writeTask);
    }

    public void download() {
        if (!this.linkedFile.isOnlineLink()) {
            throw new UnsupportedOperationException("In order to download the file it has to be an online link");
        }
        try {
            URLDownload urlDownload = new URLDownload(this.linkedFile.getLink());
            Optional<ExternalFileType> suggestedType = this.inferFileType(urlDownload);
            String suggestedTypeName = suggestedType.map(ExternalFileType::getName).orElse("");
            this.linkedFile.setFileType(suggestedTypeName);
            Optional<Path> targetDirectory = this.databaseContext.getFirstExistingFileDir(this.fileDirectoryPreferences);
            if (!targetDirectory.isPresent()) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Download file", new String[0]), Localization.lang("File directory is not set or does not exist!", new String[0]));
                return;
            }
            String suffix = suggestedType.map(ExternalFileType::getExtension).orElse("");
            String suggestedName = this.getSuggestedFileName(suffix);
            Path destination = targetDirectory.get().resolve(suggestedName);
            BackgroundTask<Void> downloadTask = new FileDownloadTask(urlDownload.getSource(), destination).onSuccess(event -> {
                LinkedFile newLinkedFile = LinkedFilesEditorViewModel.fromFile(destination, this.databaseContext.getFileDirectoriesAsPaths(this.fileDirectoryPreferences));
                this.linkedFile.setLink(newLinkedFile.getLink());
                this.linkedFile.setFileType(newLinkedFile.getFileType());
            }).onFailure(ex -> this.dialogService.showErrorDialogAndWait("Download failed", (Throwable)ex));
            this.downloadProgress.bind((ObservableValue)downloadTask.workDonePercentageProperty());
            this.taskExecutor.execute(downloadTask);
        }
        catch (MalformedURLException exception) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Invalid URL", new String[0]), exception);
        }
    }

    private Optional<ExternalFileType> inferFileType(URLDownload urlDownload) {
        Optional<ExternalFileType> suggestedType = this.inferFileTypeFromMimeType(urlDownload);
        if (!suggestedType.isPresent()) {
            suggestedType = this.inferFileTypeFromURL(urlDownload.getSource().toExternalForm());
        }
        return suggestedType;
    }

    private Optional<ExternalFileType> inferFileTypeFromMimeType(URLDownload urlDownload) {
        String mimeType = urlDownload.getMimeType();
        if (mimeType != null) {
            LOGGER.debug("MIME Type suggested: " + mimeType);
            return ExternalFileTypes.getInstance().getExternalFileTypeByMimeType(mimeType);
        }
        return Optional.empty();
    }

    private Optional<ExternalFileType> inferFileTypeFromURL(String url) {
        String extension = DownloadExternalFile.getSuffix(url);
        if (extension != null) {
            return ExternalFileTypes.getInstance().getExternalFileTypeByExt(extension);
        }
        return Optional.empty();
    }

    private String getSuggestedFileName(String suffix) {
        String plannedName = FileUtil.createFileNameFromPattern(this.databaseContext.getDatabase(), this.entry, this.fileNamePattern);
        if (!suffix.isEmpty()) {
            plannedName = plannedName + "." + suffix;
        }
        return plannedName;
    }

    public LinkedFile getFile() {
        return this.linkedFile;
    }
}

