/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import java.util.List;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.journals.UndoableUnabbreviator;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.InternalBibtexFields;

public class UnabbreviateAction
extends AbstractWorker {
    private final BasePanel panel;
    private String message = "";

    public UnabbreviateAction(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void init() {
        this.panel.output(Localization.lang("Unabbreviating...", new String[0]));
    }

    @Override
    public void run() {
        List<BibEntry> entries = this.panel.getSelectedEntries();
        if (entries == null) {
            return;
        }
        UndoableUnabbreviator undoableAbbreviator = new UndoableUnabbreviator(Globals.journalAbbreviationLoader.getRepository(Globals.prefs.getJournalAbbreviationPreferences()));
        NamedCompound ce = new NamedCompound(Localization.lang("Unabbreviate journal names", new String[0]));
        int count = 0;
        for (BibEntry entry : entries) {
            for (String journalField : InternalBibtexFields.getJournalNameFields()) {
                if (!undoableAbbreviator.unabbreviate(this.panel.getDatabase(), entry, journalField, ce)) continue;
                ++count;
            }
        }
        if (count > 0) {
            ce.end();
            this.panel.getUndoManager().addEdit(ce);
            this.panel.markBaseChanged();
            this.message = Localization.lang("Unabbreviated %0 journal names.", String.valueOf(count));
        } else {
            this.message = Localization.lang("No journal names could be unabbreviated.", new String[0]);
        }
    }

    @Override
    public void update() {
        this.panel.output(this.message);
    }
}

