/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.plaintextimport;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.collections.ObservableList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jabref.Globals;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.EntryMarker;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.OSXCompatibleToolbar;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.plaintextimport.BasicAction;
import org.jabref.gui.plaintextimport.PopupListener;
import org.jabref.gui.plaintextimport.TagToMarkedTextStore;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.component.OverlayPanel;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.LatexFieldFormatter;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.FreeCiteImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.UpdateField;
import org.jabref.model.EntryTypes;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInputDialog
extends JabRefDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextInputDialog.class);
    private final JButton okButton = new JButton(Localization.lang("Accept", new String[0]));
    private final JButton cancelButton = new JButton(Localization.lang("Cancel", new String[0]));
    private final JButton insertButton = new JButton(Localization.lang("Insert", new String[0]));
    private final JButton parseWithFreeCiteButton = new JButton(Localization.lang("Parse with FreeCite", new String[0]));
    private final JPanel panel1 = new JPanel();
    private final JPanel buttons = new JPanel();
    private final JPanel rawPanel = new JPanel();
    private final JPanel sourcePanel = new JPanel();
    private JList<String> fieldList;
    private final JRadioButton override = new JRadioButton(Localization.lang("Override", new String[0]));
    private final JRadioButton append = new JRadioButton(Localization.lang("Append", new String[0]));
    private final JToolBar toolBar = new OSXCompatibleToolbar();
    private final List<String> allFields = new ArrayList<String>();
    private final List<String> requiredFields = new ArrayList<String>();
    private final List<String> optionalFields = new ArrayList<String>();
    private final BibEntry entry;
    private final JPopupMenu inputMenu = new JPopupMenu();
    private StyledDocument document;
    private final JTextPane textPane = new JTextPane();
    private final JTextArea sourcePreview = new JTextArea();
    private final TagToMarkedTextStore markedTextStore;
    private final JabRefFrame frame;
    private boolean okPressed;

    public TextInputDialog(JabRefFrame frame, BibEntry bibEntry) {
        super((Frame)frame, true, TextInputDialog.class);
        this.frame = Objects.requireNonNull(frame);
        this.entry = Objects.requireNonNull(bibEntry);
        this.markedTextStore = new TagToMarkedTextStore();
        this.jbInit();
        this.pack();
        this.updateSourceView();
    }

    private void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        StringBuilder typeStr = new StringBuilder("Plain text import");
        if (this.entry.getType() != null) {
            typeStr.append(' ').append(Localization.lang("for", new String[0])).append(' ').append(this.entry.getType());
        }
        this.setTitle(typeStr.toString());
        this.getContentPane().add((Component)this.panel1, "Center");
        this.initRawPanel();
        this.initButtonPanel();
        this.initSourcePanel();
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.add((Component)this.rawPanel, Localization.lang("Raw source", new String[0]));
        tabbed.add((Component)this.sourcePanel, Localization.lang("%0 source", this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode().getFormattedName()));
        this.panel1.setLayout(new BorderLayout());
        this.panel1.add((Component)tabbed, "Center");
        this.panel1.add((Component)this.buttons, "South");
        ActionMap am = this.buttons.getActionMap();
        InputMap im = this.buttons.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextInputDialog.this.dispose();
            }
        });
    }

    private void initRawPanel() {
        this.rawPanel.setLayout(new BorderLayout());
        this.textPane.setEditable(false);
        this.document = this.textPane.getStyledDocument();
        this.addStylesToDocument();
        try {
            this.document.insertString(0, "", this.document.getStyle("regular"));
        }
        catch (BadLocationException ex) {
            LOGGER.warn("Problem setting style", ex);
        }
        OverlayPanel testPanel = new OverlayPanel(this.textPane, Localization.lang("paste text here", new String[0]));
        testPanel.setPreferredSize(new Dimension(450, 255));
        testPanel.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.fieldList = new JList<String>(this.getAllFields());
        this.fieldList.setCellRenderer(new SimpleCellRenderer(this.fieldList.getFont()));
        ListSelectionModel listSelectionModel = this.fieldList.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new FieldListSelectionHandler());
        this.fieldList.addMouseListener(new FieldListMouseListener());
        this.initPopupMenuAndToolbar();
        PopupListener popupListener = new PopupListener(this.inputMenu);
        this.textPane.addMouseListener(popupListener);
        testPanel.addMouseListener(popupListener);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.toolBar, "North");
        leftPanel.add((Component)testPanel, "Center");
        JPanel inputPanel = this.setUpFieldListPanel();
        this.parseWithFreeCiteButton.addActionListener(event -> {
            if (this.parseWithFreeCiteAndAddEntries()) {
                this.okPressed = false;
                this.dispose();
            }
        });
        this.rawPanel.add((Component)leftPanel, "Center");
        this.rawPanel.add((Component)inputPanel, "East");
        JLabel desc = new JLabel("<html><h3>" + Localization.lang("Plain text import", new String[0]) + "</h3><p>" + Localization.lang("This is a simple copy and paste dialog. First load or paste some text into the text input area.<br>After that, you can mark text and assign it to a BibTeX field.", new String[0]) + "</p></html>");
        desc.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rawPanel.add((Component)desc, "South");
    }

    private JPanel setUpFieldListPanel() {
        JPanel inputPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        con.weightx = 0.0;
        con.insets = new Insets(5, 5, 0, 5);
        con.fill = 2;
        inputPanel.setLayout(gbl);
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Localization.lang("Work options", new String[0]));
        inputPanel.setBorder(titledBorder1);
        inputPanel.setMinimumSize(new Dimension(10, 10));
        JScrollPane fieldScroller = new JScrollPane(this.fieldList);
        fieldScroller.setVerticalScrollBarPolicy(20);
        this.insertButton.addActionListener(event -> this.insertTextForTag(this.override.isSelected()));
        this.append.setToolTipText(Localization.lang("Append the selected text to BibTeX field", new String[0]));
        this.append.setMnemonic(65);
        this.append.setSelected(true);
        this.override.setToolTipText(Localization.lang("Override the BibTeX field by the selected text", new String[0]));
        this.override.setMnemonic(79);
        this.override.setSelected(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.append);
        group.add(this.override);
        JPanel radioPanel = new JPanel(new GridLayout(0, 1));
        radioPanel.add(this.append);
        radioPanel.add(this.override);
        JLabel label1 = new JLabel(Localization.lang("Available BibTeX fields", new String[0]));
        con.gridwidth = 0;
        gbl.setConstraints(label1, con);
        inputPanel.add(label1);
        con.gridwidth = 0;
        con.gridheight = 8;
        con.weighty = 1.0;
        con.fill = 1;
        gbl.setConstraints(fieldScroller, con);
        inputPanel.add(fieldScroller);
        con.fill = 2;
        con.weighty = 0.0;
        con.gridwidth = 2;
        gbl.setConstraints(radioPanel, con);
        inputPanel.add(radioPanel);
        con.gridwidth = 0;
        gbl.setConstraints(this.insertButton, con);
        inputPanel.add(this.insertButton);
        return inputPanel;
    }

    private void initPopupMenuAndToolbar() {
        PasteAction pasteAction = new PasteAction();
        ClearAction clearAction = new ClearAction();
        JMenuItem pasteMI = new JMenuItem(pasteAction);
        this.inputMenu.add(clearAction);
        this.inputMenu.addSeparator();
        this.inputMenu.add(pasteMI);
        this.inputMenu.addSeparator();
        JMenu appendMenu = new JMenu(Localization.lang("Append", new String[0]));
        appendMenu.setToolTipText(Localization.lang("Append the selected text to BibTeX field", new String[0]));
        JMenu overrideMenu = new JMenu(Localization.lang("Override", new String[0]));
        overrideMenu.setToolTipText(Localization.lang("Override the BibTeX field by the selected text", new String[0]));
        for (String field2 : this.allFields) {
            appendMenu.add(new JMenuItem(new MenuTextForTagAction(field2, false)));
            overrideMenu.add(new JMenuItem(new MenuTextForTagAction(field2, true)));
        }
        this.inputMenu.add(appendMenu);
        this.inputMenu.add(overrideMenu);
        this.toolBar.add(clearAction);
        this.toolBar.setBorderPainted(false);
        this.toolBar.addSeparator();
        this.toolBar.add(pasteAction);
        this.toolBar.add(new LoadAction());
    }

    private void initButtonPanel() {
        this.okButton.addActionListener(event -> {
            this.okPressed = true;
            this.dispose();
        });
        this.cancelButton.addActionListener(event -> this.dispose());
        ButtonBarBuilder bb = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)this.okButton);
        bb.addButton((JComponent)this.parseWithFreeCiteButton);
        bb.addButton((JComponent)this.cancelButton);
        bb.addGlue();
    }

    private void initSourcePanel() {
        this.sourcePreview.setEditable(false);
        this.sourcePreview.setFont(new Font("Monospaced", 0, Globals.prefs.getInt("fontSize")));
        JScrollPane paneScrollPane = new JScrollPane(this.sourcePreview);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setPreferredSize(new Dimension(500, 255));
        paneScrollPane.setMinimumSize(new Dimension(10, 10));
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourcePanel.add((Component)paneScrollPane, "Center");
    }

    private void addStylesToDocument() {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regularStyle = this.document.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, "SansSerif");
        StyleConstants.setFontSize(defaultStyle, Globals.prefs.getInt("fontSize"));
        Style s2 = this.document.addStyle("used", regularStyle);
        StyleConstants.setBold(s2, true);
        StyleConstants.setForeground(s2, Color.blue);
        s2 = this.document.addStyle("marked", regularStyle);
        StyleConstants.setBold(s2, true);
        StyleConstants.setForeground(s2, Color.red);
    }

    private void insertTextForTag(boolean overrideField) {
        String txt;
        String fieldName = this.fieldList.getSelectedValue();
        if (fieldName != null && (txt = this.textPane.getSelectedText()) != null) {
            int selectionStart = this.textPane.getSelectionStart();
            int selectionEnd = this.textPane.getSelectionEnd();
            this.textPane.setSelectionEnd(selectionStart);
            this.document.setCharacterAttributes(selectionStart, selectionEnd - selectionStart, this.document.getStyle("marked"), true);
            if (overrideField) {
                this.entry.setField(fieldName, txt);
                this.markedTextStore.setStyleForTag(fieldName, "regular", this.document);
                this.markedTextStore.insertPosition(fieldName, selectionStart, selectionEnd);
            } else {
                this.markedTextStore.appendPosition(fieldName, selectionStart, selectionEnd);
                Optional<String> old = this.entry.getField(fieldName);
                if (old.isPresent()) {
                    if (InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.PERSON_NAMES)) {
                        this.entry.setField(fieldName, old.get() + " and " + txt);
                    } else if ("keywords".equals(fieldName)) {
                        this.entry.addKeyword(txt, Globals.prefs.getKeywordDelimiter());
                    } else {
                        this.entry.setField(fieldName, old.get() + txt);
                    }
                } else {
                    this.entry.setField(fieldName, txt);
                }
            }
            this.updateSourceView();
        }
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private boolean parseWithFreeCiteAndAddEntries() {
        ObservableList<BibEntry> importedEntries;
        FreeCiteImporter fimp = new FreeCiteImporter(Globals.prefs.getImportFormatPreferences());
        String text = this.textPane.getText();
        text = text.replace(OS.NEWLINE.concat(OS.NEWLINE), "##NEWLINE##");
        text = text.replace("/".concat(OS.NEWLINE), "/");
        text = text.replace(OS.NEWLINE, " ");
        ParserResult importerResult = fimp.importEntries(text = text.replace("##NEWLINE##", OS.NEWLINE));
        if (importerResult.hasWarnings()) {
            this.frame.showMessage(importerResult.getErrorMessage());
        }
        if ((importedEntries = importerResult.getDatabase().getEntries()).isEmpty()) {
            return false;
        }
        UpdateField.setAutomaticFields(importedEntries, false, false, Globals.prefs.getUpdateFieldPreferences());
        boolean markEntries = EntryMarker.shouldMarkEntries();
        for (BibEntry e : importedEntries) {
            if (markEntries) {
                EntryMarker.markEntry(this.entry, 6, false, new NamedCompound(""));
            }
            this.frame.getCurrentBasePanel().insertEntry(e);
        }
        return true;
    }

    private void updateSourceView() {
        StringWriter sw = new StringWriter(200);
        try {
            new BibEntryWriter(new LatexFieldFormatter(Globals.prefs.getLatexFieldFormatterPreferences()), false).write(this.entry, sw, this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
            this.sourcePreview.setText(sw.getBuffer().toString());
        }
        catch (IOException ex) {
            LOGGER.error("Error in entry: " + ex.getMessage(), ex);
        }
        this.fieldList.clearSelection();
    }

    private String[] getAllFields() {
        Optional<EntryType> type = EntryTypes.getType(this.entry.getType(), this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
        if (type.isPresent()) {
            this.allFields.addAll(type.get().getAllFields());
            this.requiredFields.addAll(type.get().getRequiredFieldsFlat());
            this.optionalFields.addAll(type.get().getPrimaryOptionalFields());
        }
        for (String field2 : InternalBibtexFields.getAllPublicFieldNames()) {
            if (this.allFields.contains(field2)) continue;
            this.allFields.add(field2);
        }
        return this.allFields.toArray(new String[this.allFields.size()]);
    }

    private class MenuTextForTagAction
    extends AbstractAction {
        private final String field;
        private final Boolean overrideField;

        public MenuTextForTagAction(String field2, Boolean overrideField) {
            super(field2);
            this.field = field2;
            this.overrideField = overrideField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextInputDialog.this.fieldList.setSelectedValue(this.field, false);
            TextInputDialog.this.insertTextForTag(this.overrideField);
        }
    }

    private class FieldListMouseListener
    extends MouseAdapter {
        private FieldListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TextInputDialog.this.insertTextForTag(TextInputDialog.this.override.isSelected());
            }
        }
    }

    private class SimpleCellRenderer
    extends DefaultListCellRenderer {
        private final Font baseFont;
        private final Font usedFont;
        private final Icon okIcon = IconTheme.JabRefIcon.PLAIN_TEXT_IMPORT_DONE.getSmallIcon();
        private final Icon needIcon = IconTheme.JabRefIcon.PLAIN_TEXT_IMPORT_TODO.getSmallIcon();
        private final Color requiredColor = Globals.prefs.getColor("tableReqFieldBackground");
        private final Color optionalColor = Globals.prefs.getColor("tableOptFieldBackground");

        public SimpleCellRenderer(Font normFont) {
            this.baseFont = normFont;
            this.usedFont = this.baseFont.deriveFont(2);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent(list, value, index, iss, chf);
            String s2 = value.toString();
            if (TextInputDialog.this.entry.hasField(s2)) {
                this.setForeground(Color.gray);
                this.setFont(this.usedFont);
                this.setIcon(this.okIcon);
                this.setToolTipText(Localization.lang("Filled", new String[0]));
            } else {
                this.setIcon(this.needIcon);
                this.setToolTipText(Localization.lang("Field is missing", new String[0]));
            }
            if (TextInputDialog.this.requiredFields.contains(s2)) {
                this.setBackground(this.requiredColor);
            } else if (TextInputDialog.this.optionalFields.contains(s2)) {
                this.setBackground(this.optionalColor);
            }
            return this;
        }
    }

    class FieldListSelectionHandler
    implements ListSelectionListener {
        private int lastIndex = -1;

        FieldListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean isAdjusting;
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int index = lsm.getAnchorSelectionIndex();
            if (index != this.lastIndex && !(isAdjusting = e.getValueIsAdjusting())) {
                if (this.lastIndex > -1) {
                    String tag1 = (String)TextInputDialog.this.fieldList.getModel().getElementAt(this.lastIndex);
                    TextInputDialog.this.markedTextStore.setStyleForTag(tag1, "used", TextInputDialog.this.document);
                }
                String tag2 = (String)TextInputDialog.this.fieldList.getModel().getElementAt(index);
                TextInputDialog.this.markedTextStore.setStyleForTag(tag2, "marked", TextInputDialog.this.document);
                this.lastIndex = index;
            }
        }
    }

    private class ClearAction
    extends BasicAction {
        public ClearAction() {
            super(Localization.lang("Clear", new String[0]), Localization.lang("Clear inputarea", new String[0]), IconTheme.JabRefIcon.NEW.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextInputDialog.this.textPane.setText("");
        }
    }

    private class LoadAction
    extends BasicAction {
        public LoadAction() {
            super(Localization.lang("Open", new String[0]), Localization.lang("Open file", new String[0]), IconTheme.JabRefIcon.OPEN.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block14: {
                try {
                    FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(Localization.lang("Plain text", new String[0]), (FileType)StandardFileType.TXT).withDefaultExtension(Localization.lang("Plain text", new String[0]), StandardFileType.TXT).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
                    FXDialogService ds = new FXDialogService();
                    Optional path = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration));
                    if (!path.isPresent()) break block14;
                    Path file = (Path)path.get();
                    TextInputDialog.this.document.remove(0, TextInputDialog.this.document.getLength());
                    EditorKit eKit = TextInputDialog.this.textPane.getEditorKit();
                    if (eKit == null) break block14;
                    try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
                        eKit.read(fis, (Document)TextInputDialog.this.document, 0);
                        TextInputDialog.this.document.setLogicalStyle(0, TextInputDialog.this.document.getStyle("regular"));
                    }
                }
                catch (IOException | BadLocationException ex) {
                    LOGGER.warn("Problem reading or inserting file", ex);
                }
            }
        }
    }

    private class PasteAction
    extends BasicAction {
        public PasteAction() {
            super(Localization.lang("Paste", new String[0]), Localization.lang("Paste from clipboard", new String[0]), IconTheme.JabRefIcon.PASTE.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String data = new ClipBoardManager().getClipboardContents();
            int selStart = TextInputDialog.this.textPane.getSelectionStart();
            int selEnd = TextInputDialog.this.textPane.getSelectionEnd();
            if (selEnd - selStart > 0) {
                TextInputDialog.this.textPane.replaceSelection("");
            }
            int cPos = TextInputDialog.this.textPane.getCaretPosition();
            try {
                TextInputDialog.this.document.insertString(cPos, data, TextInputDialog.this.document.getStyle("regular"));
            }
            catch (BadLocationException ex) {
                LOGGER.warn("Could not paste text", ex);
            }
        }
    }
}

