/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.preftabs.ColorSetupPanel;
import org.jabref.gui.preftabs.FontSelectorDialog;
import org.jabref.gui.preftabs.PrefsTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppearancePrefsTab
extends JPanel
implements PrefsTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppearancePrefsTab.class);
    private static final String GTK_LF_CLASSNAME = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private final JabRefPreferences prefs;
    private final JCheckBox colorCodes;
    private final JCheckBox resolvedColorCodes;
    private final JCheckBox overrideFonts;
    private final JCheckBox showGrid;
    private final ColorSetupPanel colorPanel;
    private Font usedFont = GUIGlobals.currentFont;
    private int oldMenuFontSize;
    private int oldSmallIconSize;
    private int oldLargeIconSize;
    private boolean oldOverrideFontSize;
    private final JTextField fontSize;
    private final JTextField largeIconsTextField;
    private final JTextField smallIconsTextField;
    private final JTextField rowPadding;
    private final JComboBox<String> classNamesLAF;
    private String currentLAF = "";
    private boolean useDefaultLAF;
    private final JCheckBox customLAF;
    private final JCheckBox fxFontTweaksLAF;

    public AppearancePrefsTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.setLayout(new BorderLayout());
        this.fontSize = new JTextField(5);
        this.rowPadding = new JTextField(5);
        this.largeIconsTextField = new JTextField(5);
        this.smallIconsTextField = new JTextField(5);
        this.colorCodes = new JCheckBox(Localization.lang("Color codes for required and optional fields", new String[0]));
        this.resolvedColorCodes = new JCheckBox(Localization.lang("Color code for resolved fields", new String[0]));
        this.overrideFonts = new JCheckBox(Localization.lang("Override default font settings", new String[0]));
        this.showGrid = new JCheckBox(Localization.lang("Show gridlines", new String[0]));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        this.customLAF = new JCheckBox(Localization.lang("Use other look and feel", new String[0]));
        this.fxFontTweaksLAF = new JCheckBox(Localization.lang("Tweak font rendering for entry editor on Linux", new String[0]));
        Set<String> lookAndFeels = LookAndFeel.getAvailableLookAndFeels();
        this.classNamesLAF = new JComboBox<String>(lookAndFeels.toArray(new String[lookAndFeels.size()]));
        this.classNamesLAF.setEditable(true);
        this.customLAF.addChangeListener(e -> this.classNamesLAF.setEnabled(((JCheckBox)e.getSource()).isSelected()));
        this.colorPanel = new ColorSetupPanel(this.colorCodes, this.resolvedColorCodes, this.showGrid);
        JPanel pan = new JPanel();
        builder.appendSeparator(Localization.lang("Look and feel", new String[0]));
        JLabel lab = new JLabel(Localization.lang("Default look and feel", new String[0]) + ": " + UIManager.getSystemLookAndFeelClassName());
        builder.nextLine();
        builder.append(pan);
        builder.append(lab);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.customLAF);
        builder.nextLine();
        builder.append(pan);
        JPanel pan2 = new JPanel();
        lab = new JLabel(Localization.lang("Class name", new String[0]) + ':');
        pan2.add(lab);
        pan2.add(this.classNamesLAF);
        builder.append(pan2);
        builder.nextLine();
        builder.append(pan);
        lab = new JLabel(Localization.lang("Note that you must specify the fully qualified class name for the look and feel,", new String[0]));
        builder.append(lab);
        builder.nextLine();
        builder.append(pan);
        lab = new JLabel(Localization.lang("and the class must be available in your classpath next time you start JabRef.", new String[0]));
        builder.append(lab);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.fxFontTweaksLAF);
        builder.nextLine();
        builder.leadingColumnOffset(2);
        builder.appendSeparator(Localization.lang("General", new String[0]));
        FormBuilder generalBuilder = FormBuilder.create();
        JPanel generalPanel = generalBuilder.columns("left:pref, left:pref, 3dlu, pref, 7dlu, right:pref, 3dlu, pref", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref", new Object[0]).columnGroup(2, 6).columnGroup(4, 8).add(this.overrideFonts).xyw(1, 1, 5).add(new JLabel("    ")).xy(1, 3).add(new JLabel(Localization.lang("Menu and label font size", new String[0]) + ":")).xy(2, 3).add(this.fontSize).xy(4, 3).add(new JLabel(Localization.lang("Size of large icons", new String[0]) + ":")).xy(2, 5).add(this.largeIconsTextField).xy(4, 5).add(new JLabel(Localization.lang("Size of small icons", new String[0]) + ":")).xy(6, 5).add(this.smallIconsTextField).xy(8, 5).build();
        builder.append(generalPanel);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Table appearance", new String[0]));
        JPanel p2 = new JPanel();
        p2.add(new JLabel(Localization.lang("Table row height padding", new String[0]) + ":"));
        p2.add(this.rowPadding);
        builder.append(p2);
        builder.nextLine();
        builder.append(this.colorCodes);
        builder.nextLine();
        builder.append(this.resolvedColorCodes);
        builder.nextLine();
        builder.append(this.showGrid);
        builder.nextLine();
        JButton fontButton = new JButton(Localization.lang("Set table font", new String[0]));
        builder.append(fontButton);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Table and entry editor colors", new String[0]));
        builder.append(this.colorPanel);
        JPanel upper = new JPanel();
        JPanel sort = new JPanel();
        JPanel namesp = new JPanel();
        JPanel iconCol = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        upper.setLayout(gbl);
        sort.setLayout(gbl);
        namesp.setLayout(gbl);
        iconCol.setLayout(gbl);
        this.overrideFonts.addActionListener(e -> this.fontSize.setEnabled(this.overrideFonts.isSelected()));
        this.overrideFonts.addActionListener(e -> this.largeIconsTextField.setEnabled(this.overrideFonts.isSelected()));
        this.overrideFonts.addActionListener(e -> this.smallIconsTextField.setEnabled(this.overrideFonts.isSelected()));
        fontButton.addActionListener(e -> new FontSelectorDialog(null, this.usedFont).getSelectedFont().ifPresent(x -> {
            this.usedFont = x;
        }));
        JPanel panel = builder.getPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)panel, "Center");
    }

    @Override
    public void setValues() {
        this.useDefaultLAF = this.prefs.getBoolean("useDefaultLookAndFeel");
        this.fxFontTweaksLAF.setSelected(this.prefs.getBoolean("fxFontRenderingTweak"));
        this.currentLAF = this.prefs.get("lookAndFeel");
        this.customLAF.setSelected(!this.useDefaultLAF);
        this.classNamesLAF.setSelectedItem(this.currentLAF);
        this.classNamesLAF.setEnabled(!this.useDefaultLAF);
        this.colorCodes.setSelected(this.prefs.getBoolean("tableColorCodesOn"));
        this.resolvedColorCodes.setSelected(this.prefs.getBoolean("tableResolvedColorCodesOn"));
        this.rowPadding.setText(String.valueOf(this.prefs.getInt("tableRowPadding")));
        this.oldOverrideFontSize = this.prefs.getBoolean("overrideDefaultFonts");
        this.oldMenuFontSize = this.prefs.getInt("menuFontSize");
        this.oldLargeIconSize = this.prefs.getInt("iconSizeLarge");
        this.oldSmallIconSize = this.prefs.getInt("iconSizeSmall");
        this.overrideFonts.setSelected(this.oldOverrideFontSize);
        this.fontSize.setText(String.valueOf(this.oldMenuFontSize));
        this.smallIconsTextField.setText(String.valueOf(this.oldSmallIconSize));
        this.largeIconsTextField.setText(String.valueOf(this.oldLargeIconSize));
        this.fontSize.setEnabled(this.overrideFonts.isSelected());
        this.smallIconsTextField.setEnabled(this.overrideFonts.isSelected());
        this.largeIconsTextField.setEnabled(this.overrideFonts.isSelected());
        this.showGrid.setSelected(this.prefs.getBoolean("tableShowGrid"));
        this.colorPanel.setValues();
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("useDefaultLookAndFeel", !this.customLAF.isSelected());
        this.prefs.put("lookAndFeel", this.classNamesLAF.getSelectedItem().toString());
        boolean isRestartRequired = this.customLAF.isSelected() == this.useDefaultLAF || !this.currentLAF.equals(this.classNamesLAF.getSelectedItem().toString());
        boolean oldFxTweakValue = this.prefs.getBoolean("fxFontRenderingTweak");
        this.prefs.putBoolean("fxFontRenderingTweak", this.fxFontTweaksLAF.isSelected());
        isRestartRequired |= oldFxTweakValue != this.fxFontTweaksLAF.isSelected();
        this.prefs.putBoolean("tableColorCodesOn", this.colorCodes.isSelected());
        this.prefs.putBoolean("tableResolvedColorCodesOn", this.resolvedColorCodes.isSelected());
        this.prefs.put("fontFamily", this.usedFont.getFamily());
        this.prefs.putInt("fontStyle", this.usedFont.getStyle());
        this.prefs.putInt("fontSize", this.usedFont.getSize());
        this.prefs.putBoolean("overrideDefaultFonts", this.overrideFonts.isSelected());
        GUIGlobals.currentFont = this.usedFont;
        this.colorPanel.storeSettings();
        this.prefs.putBoolean("tableShowGrid", this.showGrid.isSelected());
        try {
            int size = Integer.parseInt(this.fontSize.getText());
            int smallIconSize = Integer.parseInt(this.smallIconsTextField.getText());
            int largeIconSize = Integer.parseInt(this.largeIconsTextField.getText());
            int padding = Integer.parseInt(this.rowPadding.getText());
            if (this.overrideFonts.isSelected()) {
                if (size != this.oldMenuFontSize) {
                    this.prefs.putInt("menuFontSize", size);
                    isRestartRequired = true;
                }
                if (smallIconSize != this.oldSmallIconSize) {
                    this.prefs.putInt("iconSizeSmall", smallIconSize);
                    isRestartRequired = true;
                }
                if (largeIconSize != this.oldLargeIconSize) {
                    this.prefs.putInt("iconSizeLarge", largeIconSize);
                    isRestartRequired = true;
                }
            } else if (this.overrideFonts.isSelected() != this.oldOverrideFontSize) {
                this.prefs.remove("iconSizeSmall");
                this.prefs.remove("iconSizeLarge");
                this.prefs.remove("menuFontSize");
                isRestartRequired = true;
            }
            if (isRestartRequired) {
                JOptionPane.showMessageDialog(null, Localization.lang("Some appearance settings you changed require to restart JabRef to come into effect.", new String[0]), Localization.lang("Settings", new String[0]), 2);
            }
            this.prefs.putInt("tableRowPadding", padding);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Invalid data value, integer expected", ex);
        }
    }

    private boolean validateIntegerField(String fieldName, String fieldValue, String errorTitle) {
        try {
            Integer.parseInt(fieldValue);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, Localization.lang("You must enter an integer value in the text field for", new String[0]) + " '" + fieldName + "'", errorTitle, 0);
            return false;
        }
        return true;
    }

    @Override
    public boolean validateSettings() {
        if (!this.validateIntegerField(Localization.lang("Menu and label font size", new String[0]), this.fontSize.getText(), Localization.lang("Invalid setting", new String[0]))) {
            return false;
        }
        if (!this.validateIntegerField(Localization.lang("Size of large icons", new String[0]), this.largeIconsTextField.getText(), Localization.lang("Invalid setting", new String[0]))) {
            return false;
        }
        if (!this.validateIntegerField(Localization.lang("Size of small icons", new String[0]), this.smallIconsTextField.getText(), Localization.lang("Invalid setting", new String[0]))) {
            return false;
        }
        return this.validateIntegerField(Localization.lang("Table row height padding", new String[0]), this.rowPadding.getText(), Localization.lang("Invalid setting", new String[0]));
    }

    @Override
    public String getTabName() {
        return Localization.lang("Appearance", new String[0]);
    }

    static class LookAndFeel {
        LookAndFeel() {
        }

        public static Set<String> getAvailableLookAndFeels() {
            return Arrays.stream(UIManager.getInstalledLookAndFeels()).map(UIManager.LookAndFeelInfo::getClassName).filter(style -> !AppearancePrefsTab.GTK_LF_CLASSNAME.equals(style)).collect(Collectors.toSet());
        }
    }
}

