/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util.component;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;
import org.jabref.gui.util.BindingsHelper;

public class TemporalAccessorPicker
extends DatePicker {
    private ObjectProperty<TemporalAccessor> temporalAccessorValue = new SimpleObjectProperty(null);
    private DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private ObjectProperty<StringConverter<TemporalAccessor>> converter = new SimpleObjectProperty(null);

    public TemporalAccessorPicker() {
        this.setConverter(new InternalConverter());
        BindingsHelper.bindBidirectional(this.valueProperty(), this.temporalAccessorValue, TemporalAccessorPicker::addCurrentTime, TemporalAccessorPicker::getDate);
    }

    private static TemporalAccessor addCurrentTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.of(date, LocalTime.now());
    }

    private static LocalDate getDate(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return TemporalAccessorPicker.getLocalDate(temporalAccessor);
    }

    private static LocalDate getLocalDate(TemporalAccessor dateTime) {
        LocalDate date = dateTime.query(TemporalQueries.localDate());
        if (date != null) {
            return date;
        }
        try {
            return YearMonth.from(dateTime).atDay(1);
        }
        catch (DateTimeException exception) {
            return Year.from(dateTime).atDay(1);
        }
    }

    public final ObjectProperty<StringConverter<TemporalAccessor>> stringConverterProperty() {
        return this.converter;
    }

    public final StringConverter<TemporalAccessor> getStringConverter() {
        StringConverter converter = (StringConverter)this.stringConverterProperty().get();
        if (converter != null) {
            return converter;
        }
        return new StringConverter<TemporalAccessor>(){

            public String toString(TemporalAccessor value) {
                return TemporalAccessorPicker.this.defaultFormatter.format(value);
            }

            public TemporalAccessor fromString(String value) {
                return LocalDateTime.parse(value, TemporalAccessorPicker.this.defaultFormatter);
            }
        };
    }

    public final void setStringConverter(StringConverter<TemporalAccessor> value) {
        this.stringConverterProperty().set(value);
    }

    public TemporalAccessor getTemporalAccessorValue() {
        return (TemporalAccessor)this.temporalAccessorValue.get();
    }

    public void setTemporalAccessorValue(TemporalAccessor temporalAccessorValue) {
        this.temporalAccessorValue.set((Object)temporalAccessorValue);
    }

    public ObjectProperty<TemporalAccessor> temporalAccessorValueProperty() {
        return this.temporalAccessorValue;
    }

    private class InternalConverter
    extends StringConverter<LocalDate> {
        private InternalConverter() {
        }

        public String toString(LocalDate object) {
            TemporalAccessor value = TemporalAccessorPicker.this.getTemporalAccessorValue();
            return value != null ? TemporalAccessorPicker.this.getStringConverter().toString((Object)value) : "";
        }

        public LocalDate fromString(String value) {
            if (value == null || value.isEmpty()) {
                TemporalAccessorPicker.this.temporalAccessorValue.set(null);
                return null;
            }
            TemporalAccessor dateTime = (TemporalAccessor)TemporalAccessorPicker.this.getStringConverter().fromString(value);
            TemporalAccessorPicker.this.temporalAccessorValue.set((Object)dateTime);
            return TemporalAccessorPicker.getLocalDate(dateTime);
        }
    }
}

