/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.auxparser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.auxparser.AuxParser;
import org.jabref.model.auxparser.AuxParserResult;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuxParser
implements AuxParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuxParser.class);
    private static final Pattern CITE_PATTERN = Pattern.compile("\\\\(citation|abx@aux@cite)\\{(.+)\\}");
    private static final Pattern INPUT_PATTERN = Pattern.compile("\\\\@input\\{(.+)\\}");
    private final BibDatabase masterDatabase;

    public DefaultAuxParser(BibDatabase database) {
        this.masterDatabase = database;
    }

    @Override
    public AuxParserResult parse(Path auxFile) {
        return this.parseAuxFile(auxFile);
    }

    private AuxParserResult parseAuxFile(Path auxFile) {
        AuxParserResult result = new AuxParserResult(this.masterDatabase);
        ArrayList<Path> fileList = new ArrayList<Path>(1);
        fileList.add(auxFile);
        for (int fileIndex = 0; fileIndex < fileList.size(); ++fileIndex) {
            Path file = (Path)fileList.get(fileIndex);
            try (BufferedReader br = Files.newBufferedReader(file);){
                String line;
                while ((line = br.readLine()) != null) {
                    this.matchCitation(result, line);
                    this.matchNestedAux(auxFile, result, fileList, line);
                }
                continue;
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Cannot locate input file", e);
                continue;
            }
            catch (IOException e) {
                LOGGER.warn("Problem opening file", e);
            }
        }
        this.resolveTags(result);
        return result;
    }

    private void matchNestedAux(Path baseAuxFile, AuxParserResult result, List<Path> fileList, String line) {
        Matcher inputMatch = INPUT_PATTERN.matcher(line);
        while (inputMatch.find()) {
            String inputString = inputMatch.group(1);
            Path rootPath = baseAuxFile.getParent();
            Path inputFile = rootPath != null ? rootPath.resolve(inputString) : Paths.get(inputString, new String[0]);
            if (fileList.contains(inputFile)) continue;
            fileList.add(inputFile);
            result.increaseNestedAuxFilesCounter();
        }
    }

    private void matchCitation(AuxParserResult result, String line) {
        Matcher citeMatch = CITE_PATTERN.matcher(line);
        while (citeMatch.find()) {
            String[] keys;
            String keyString = citeMatch.group(2);
            for (String key : keys = keyString.split(",")) {
                result.getUniqueKeys().add(key.trim());
            }
        }
    }

    private void resolveTags(AuxParserResult result) {
        for (String key : result.getUniqueKeys()) {
            Optional<BibEntry> entry = this.masterDatabase.getEntryByKey(key);
            if (result.getGeneratedBibDatabase().getEntryByKey(key).isPresent()) continue;
            if (entry.isPresent()) {
                this.insertEntry(entry.get(), result);
                this.resolveCrossReferences(entry.get(), result);
                continue;
            }
            result.getUnresolvedKeys().add(key);
        }
        if (result.getGeneratedBibDatabase().hasEntries()) {
            result.getGeneratedBibDatabase().copyPreamble(this.masterDatabase);
            result.insertStrings(this.masterDatabase.getUsedStrings((Collection<BibEntry>)result.getGeneratedBibDatabase().getEntries()));
        }
    }

    private void resolveCrossReferences(BibEntry entry, AuxParserResult result) {
        entry.getField("crossref").ifPresent(crossref -> {
            if (!result.getGeneratedBibDatabase().getEntryByKey((String)crossref).isPresent()) {
                Optional<BibEntry> refEntry = this.masterDatabase.getEntryByKey((String)crossref);
                if (refEntry.isPresent()) {
                    this.insertEntry(refEntry.get(), result);
                    result.increaseCrossRefEntriesCounter();
                } else {
                    result.getUnresolvedKeys().add((String)crossref);
                }
            }
        });
    }

    private void insertEntry(BibEntry entry, AuxParserResult result) {
        BibEntry clonedEntry = (BibEntry)entry.clone();
        result.getGeneratedBibDatabase().insertEntry(clonedEntry);
    }
}

