/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.Comparator;
import java.util.Locale;
import org.jabref.model.entry.BibtexString;

public class BibtexStringComparator
implements Comparator<BibtexString> {
    private final boolean considerRefs;

    public BibtexStringComparator(boolean considerRefs) {
        this.considerRefs = considerRefs;
    }

    @Override
    public int compare(BibtexString s1, BibtexString s2) {
        String name2;
        String name1 = s1.getName().toLowerCase(Locale.ROOT);
        int res = name1.compareTo(name2 = s2.getName().toLowerCase(Locale.ROOT));
        if (res == 0) {
            return res;
        }
        if (this.considerRefs) {
            BibtexString post;
            BibtexString pre;
            if (res < 0) {
                pre = s1;
                post = s2;
            } else {
                pre = s2;
                post = s1;
            }
            String namePost = post.getName().toLowerCase(Locale.ROOT);
            String textPre = pre.getContent().toLowerCase(Locale.ROOT);
            if (textPre.contains("#" + namePost + "#")) {
                res = -res;
            }
        }
        return res;
    }
}

