/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst;

import java.util.Locale;
import java.util.Stack;
import org.jabref.logic.bst.BibtexCaseChanger;
import org.jabref.logic.bst.VM;
import org.jabref.logic.bst.VMException;

public class ChangeCaseFunction
implements VM.BstFunction {
    private final VM vm;

    public ChangeCaseFunction(VM vm) {
        this.vm = vm;
    }

    @Override
    public void execute(VM.BstEntry context) {
        Stack<Object> stack = this.vm.getStack();
        if (stack.size() < 2) {
            throw new VMException("Not enough operands on stack for operation change.case$");
        }
        Object o1 = stack.pop();
        if (!(o1 instanceof String) || ((String)o1).length() != 1) {
            throw new VMException("A format string of length 1 is needed for change.case$");
        }
        Object o2 = stack.pop();
        if (!(o2 instanceof String)) {
            throw new VMException("A string is needed as second parameter for change.case$");
        }
        char format = ((String)o1).toLowerCase(Locale.ROOT).charAt(0);
        String s2 = (String)o2;
        stack.push(BibtexCaseChanger.changeCase(s2, BibtexCaseChanger.FORMAT_MODE.getFormatModeForBSTFormat(format)));
    }
}

