/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import de.undercouch.citeproc.CSL;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.bibtex.BibTeXConverter;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.output.Bibliography;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.formatter.bibtexfields.RemoveNewlinesFormatter;
import org.jabref.logic.layout.format.HTMLChars;
import org.jabref.model.entry.BibEntry;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.DigitStringValue;
import org.jbibtex.Key;

public class CSLAdapter {
    private static final BibTeXConverter BIBTEX_CONVERTER = new BibTeXConverter();
    private final JabRefItemDataProvider dataProvider = new JabRefItemDataProvider();
    private String style;
    private CitationStyleOutputFormat format;
    private CSL cslInstance;

    public synchronized List<String> makeBibliography(List<BibEntry> bibEntries, String style, CitationStyleOutputFormat outputFormat) throws IOException, IllegalArgumentException {
        this.dataProvider.setData(bibEntries);
        this.initialize(style, outputFormat);
        this.cslInstance.registerCitationItems(this.dataProvider.getIds());
        Bibliography bibliography = this.cslInstance.makeBibliography();
        return Arrays.asList(bibliography.getEntries());
    }

    private void initialize(String newStyle, CitationStyleOutputFormat newFormat) throws IOException {
        if (this.cslInstance == null || !Objects.equals(newStyle, this.style)) {
            this.cslInstance = new CSL(this.dataProvider, newStyle);
            this.style = newStyle;
        }
        if (!Objects.equals((Object)newFormat, (Object)this.format)) {
            this.cslInstance.setOutputFormat(newFormat.getFormat());
            this.format = newFormat;
        }
    }

    private static class JabRefItemDataProvider
    implements ItemDataProvider {
        private ArrayList<BibEntry> data = new ArrayList();

        private JabRefItemDataProvider() {
        }

        private static CSLItemData bibEntryToCSLItemData(BibEntry bibEntry) {
            String citeKey = bibEntry.getCiteKeyOptional().orElse("");
            BibTeXEntry bibTeXEntry = new BibTeXEntry(new Key(bibEntry.getType()), new Key(citeKey));
            HTMLChars latexToHtmlConverter = new HTMLChars();
            RemoveNewlinesFormatter removeNewlinesFormatter = new RemoveNewlinesFormatter();
            for (String key : bibEntry.getFieldMap().keySet()) {
                bibEntry.getField(key).map(removeNewlinesFormatter::format).map(latexToHtmlConverter::format).ifPresent(value -> bibTeXEntry.addField(new Key(key), new DigitStringValue((String)value)));
            }
            return BIBTEX_CONVERTER.toItemData(bibTeXEntry);
        }

        public void setData(List<BibEntry> data) {
            this.data.clear();
            this.data.addAll(data);
        }

        @Override
        public CSLItemData retrieveItem(String id) {
            return this.data.stream().filter(entry -> entry.getCiteKeyOptional().orElse("").equals(id)).map(JabRefItemDataProvider::bibEntryToCSLItemData).findFirst().orElse(null);
        }

        @Override
        public String[] getIds() {
            return (String[])this.data.stream().map(entry -> entry.getCiteKeyOptional().orElse("")).toArray(String[]::new);
        }
    }
}

