/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.CleanupJob;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenamePdfCleanup
implements CleanupJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenamePdfCleanup.class);
    private final BibDatabaseContext databaseContext;
    private final boolean onlyRelativePaths;
    private final String fileNamePattern;
    private final FileDirectoryPreferences fileDirectoryPreferences;
    private int unsuccessfulRenames;
    private LinkedFile singleFieldCleanup;

    public RenamePdfCleanup(boolean onlyRelativePaths, BibDatabaseContext databaseContext, String fileNamePattern, LayoutFormatterPreferences layoutPreferences, FileDirectoryPreferences fileDirectoryPreferences) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.onlyRelativePaths = onlyRelativePaths;
        this.fileNamePattern = Objects.requireNonNull(fileNamePattern);
        this.fileDirectoryPreferences = fileDirectoryPreferences;
    }

    public RenamePdfCleanup(boolean onlyRelativePaths, BibDatabaseContext databaseContext, String fileNamePattern, LayoutFormatterPreferences layoutPreferences, FileDirectoryPreferences fileDirectoryPreferences, LinkedFile singleField) {
        this(onlyRelativePaths, databaseContext, fileNamePattern, layoutPreferences, fileDirectoryPreferences);
        this.singleFieldCleanup = singleField;
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        try {
            return this.cleanupWithException(entry);
        }
        catch (IOException e) {
            LOGGER.error("Cleanup failed", e);
            return Collections.emptyList();
        }
    }

    public List<FieldChange> cleanupWithException(BibEntry entry) throws IOException {
        ArrayList<LinkedFile> newFileList;
        List<LinkedFile> oldFileList;
        if (this.singleFieldCleanup != null) {
            oldFileList = Collections.singletonList(this.singleFieldCleanup);
            newFileList = entry.getFiles().stream().filter(x -> !x.equals(this.singleFieldCleanup)).collect(Collectors.toList());
        } else {
            newFileList = new ArrayList();
            oldFileList = entry.getFiles();
        }
        boolean changed = false;
        for (LinkedFile oldLinkedFile : oldFileList) {
            boolean pathsDifferOnlyByCase;
            String realOldFilename = oldLinkedFile.getLink();
            if (StringUtil.isBlank(realOldFilename)) continue;
            if (this.onlyRelativePaths && Paths.get(realOldFilename, new String[0]).isAbsolute()) {
                newFileList.add(oldLinkedFile);
                continue;
            }
            Optional<Path> expandedOldFile = oldLinkedFile.findIn(this.databaseContext, this.fileDirectoryPreferences);
            if (!expandedOldFile.isPresent() || expandedOldFile.get().getParent() == null) {
                newFileList.add(oldLinkedFile);
                continue;
            }
            String targetFileName = this.getTargetFileName(oldLinkedFile, entry);
            Path newPath = expandedOldFile.get().getParent().resolve(targetFileName);
            String expandedOldFilePath = expandedOldFile.get().toString();
            boolean bl = pathsDifferOnlyByCase = newPath.toString().equalsIgnoreCase(expandedOldFilePath) && !newPath.toString().equals(expandedOldFilePath);
            if (Files.exists(newPath, new LinkOption[0]) && !pathsDifferOnlyByCase) {
                LOGGER.debug("There already exists a file with that name " + newPath.getFileName() + " so I won't rename it");
                newFileList.add(oldLinkedFile);
                continue;
            }
            try {
                if (!Files.exists(newPath, new LinkOption[0])) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not create necessary target directories for renaming", e);
            }
            boolean renameSuccessful = FileUtil.renameFileWithException(Paths.get(expandedOldFilePath, new String[0]), newPath, true);
            if (renameSuccessful) {
                changed = true;
                String description = oldLinkedFile.getDescription();
                String type = oldLinkedFile.getFileType();
                Path settingsDir = this.databaseContext.getFirstExistingFileDir(this.fileDirectoryPreferences).get();
                if (settingsDir.getRoot().equals(newPath.getRoot())) {
                    newFileList.add(new LinkedFile(description, settingsDir.relativize(newPath).toString(), type));
                    continue;
                }
                newFileList.add(new LinkedFile(description, newPath.toString(), type));
                continue;
            }
            ++this.unsuccessfulRenames;
        }
        if (changed) {
            Optional<FieldChange> change = entry.setFiles(newFileList);
            return change.map(Collections::singletonList).orElseGet(Collections::emptyList);
        }
        return Collections.emptyList();
    }

    public String getTargetFileName(LinkedFile flEntry, BibEntry entry) {
        String realOldFilename = flEntry.getLink();
        String targetFileName = FileUtil.createFileNameFromPattern(this.databaseContext.getDatabase(), entry, this.fileNamePattern).trim() + '.' + FileHelper.getFileExtension(realOldFilename).orElse("pdf");
        return FileUtil.getValidFileName(targetFileName);
    }

    public int getUnsuccessfulRenames() {
        return this.unsuccessfulRenames;
    }

    public Optional<Path> findExistingFile(LinkedFile flEntry, BibEntry entry) {
        String targetFileName = this.getTargetFileName(flEntry, entry);
        Path targetFilePath = flEntry.findIn(this.databaseContext, this.fileDirectoryPreferences).get().getParent().resolve(targetFileName);
        Path oldFilePath = flEntry.findIn(this.databaseContext, this.fileDirectoryPreferences).get();
        Optional<Path> matchedByDiffCase = Optional.empty();
        try (Stream<Path> stream = Files.list(oldFilePath.getParent());){
            matchedByDiffCase = stream.filter(name -> name.toString().equalsIgnoreCase(targetFilePath.toString())).findFirst();
        }
        catch (IOException e) {
            LOGGER.error("Could not get the list of files in target directory", e);
        }
        return matchedByDiffCase;
    }
}

