/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import org.jabref.logic.formatter.casechanger.LowerCaseFormatter;
import org.jabref.logic.formatter.casechanger.Title;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;

public class SentenceCaseFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Sentence case", new String[0]);
    }

    @Override
    public String getKey() {
        return "sentence_case";
    }

    @Override
    public String format(String input) {
        Title title = new Title(new LowerCaseFormatter().format(input));
        title.getWords().stream().findFirst().ifPresent(Word::toUpperFirst);
        return title.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Capitalize the first word, changes other words to lower case.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "i have {Aa} DREAM";
    }
}

