/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import org.jabref.logic.formatter.casechanger.Title;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;

public class TitleCaseFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Title case", new String[0]);
    }

    @Override
    public String getKey() {
        return "title_case";
    }

    @Override
    public String format(String input) {
        Title title = new Title(input);
        title.getWords().stream().filter(Word::isSmallerWord).forEach(Word::toLowerCase);
        title.getWords().stream().filter(Word::isLargerWord).forEach(Word::toUpperFirst);
        title.getFirstWord().ifPresent(Word::toUpperFirst);
        title.getLastWord().ifPresent(Word::toUpperFirst);
        for (int i = 0; i < title.getWords().size() - 2; ++i) {
            if (!title.getWords().get(i).endsWithColon()) continue;
            title.getWords().get(i + 1).toUpperFirst();
        }
        return title.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Capitalize all words, but converts articles, prepositions, and conjunctions to lower case.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "{BPMN} conformance In open source Engines";
    }
}

