/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.DOI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEEE
implements FulltextFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IEEE.class);
    private static final String STAMP_BASE_STRING_DOCUMENT = "/stamp/stamp.jsp?tp=&arnumber=";
    private static final Pattern STAMP_PATTERN = Pattern.compile("(/stamp/stamp.jsp\\?t?p?=?&?arnumber=[0-9]+)");
    private static final Pattern DOCUMENT_PATTERN = Pattern.compile("document/([0-9]+)/");
    private static final Pattern PDF_PATTERN = Pattern.compile("\"(https://ieeexplore.ieee.org/ielx[0-9/]+\\.pdf[^\"]+)\"");
    private static final String IEEE_DOI = "10.1109";
    private static final String BASE_URL = "https://ieeexplore.ieee.org";

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        Optional doi;
        Objects.requireNonNull(entry);
        String stampString = "";
        Optional<String> urlString = entry.getField("url");
        if (urlString.isPresent()) {
            Matcher stampMatcher;
            Matcher documentUrlMatcher = DOCUMENT_PATTERN.matcher(urlString.get());
            if (documentUrlMatcher.find()) {
                String docId = documentUrlMatcher.group(1);
                stampString = STAMP_BASE_STRING_DOCUMENT + docId;
            }
            if ((stampMatcher = STAMP_PATTERN.matcher(urlString.get())).find()) {
                stampString = stampMatcher.group(1);
            }
        }
        if (stampString.isEmpty() && (doi = entry.getField("doi").flatMap(DOI::parse)).isPresent() && ((DOI)doi.get()).getDOI().startsWith(IEEE_DOI) && ((DOI)doi.get()).getExternalURI().isPresent()) {
            URLDownload urlDownload = new URLDownload(((DOI)doi.get()).getExternalURI().get().toURL());
            urlDownload.getCookieFromUrl();
            String resolvedDOIPage = urlDownload.asString();
            Matcher matcher = STAMP_PATTERN.matcher(resolvedDOIPage);
            if (matcher.find()) {
                stampString = matcher.group(1);
            }
        }
        if (stampString.isEmpty()) {
            return Optional.empty();
        }
        URLDownload urlDownload = new URLDownload(BASE_URL + stampString);
        urlDownload.getCookieFromUrl();
        String framePage = urlDownload.asString();
        Matcher matcher = PDF_PATTERN.matcher(framePage);
        if (matcher.find()) {
            LOGGER.debug("Full text document found on IEEE Xplore");
            return Optional.of(new URL(matcher.group(1)));
        }
        return Optional.empty();
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.PUBLISHER;
    }
}

