/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.util.Optional;
import java.util.function.Function;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.identifier.Eprint;
import org.jabref.model.entry.identifier.ISBN;
import org.jabref.model.entry.identifier.Identifier;
import org.jabref.model.entry.identifier.MathSciNetId;
import org.jabref.model.strings.StringUtil;

public class IdentifierParser {
    public static Optional<? extends Identifier> parse(String fieldName, String input) {
        if (StringUtil.isBlank(input)) {
            return Optional.empty();
        }
        Function<String, Optional<? extends Identifier>> parser = IdentifierParser.getParserForField(fieldName);
        return parser.apply(input);
    }

    private static Function<String, Optional<? extends Identifier>> getParserForField(String fieldName) {
        switch (fieldName) {
            case "doi": {
                return DOI::parse;
            }
            case "isbn": {
                return ISBN::parse;
            }
            case "eprint": {
                return Eprint::build;
            }
            case "mrnumber": {
                return MathSciNetId::parse;
            }
        }
        return input -> Optional.empty();
    }
}

