/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;

public class HTMLCharacterChecker
implements IntegrityCheck.Checker {
    private static final Pattern HTML_CHARACTER_PATTERN = Pattern.compile("&[#\\p{Alnum}]+;");

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> results = new ArrayList<IntegrityMessage>();
        for (Map.Entry<String, String> field2 : entry.getFieldMap().entrySet()) {
            Matcher characterMatcher;
            if (InternalBibtexFields.getFieldProperties(field2.getKey()).contains((Object)FieldProperty.VERBATIM) || !(characterMatcher = HTML_CHARACTER_PATTERN.matcher(field2.getValue())).find()) continue;
            results.add(new IntegrityMessage(Localization.lang("HTML encoded character found", new String[0]), entry, field2.getKey()));
        }
        return results;
    }
}

