/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.util.Objects;
import javafx.beans.property.SimpleStringProperty;

public class Abbreviation
implements Comparable<Abbreviation> {
    private static final String SPLITTER = ";";
    private final SimpleStringProperty name = new SimpleStringProperty("");
    private final SimpleStringProperty abbreviation = new SimpleStringProperty("");

    public Abbreviation(String name, String abbreviation) {
        this.name.set(Objects.requireNonNull(name).trim());
        this.abbreviation.set(Objects.requireNonNull(abbreviation).trim());
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation.get();
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation.set(abbreviation);
    }

    public SimpleStringProperty abbreviationProperty() {
        return this.abbreviation;
    }

    public String getIsoAbbreviation() {
        if (this.getAbbreviation().contains(SPLITTER)) {
            String[] restParts = this.getAbbreviation().split(SPLITTER);
            return restParts[0].trim();
        }
        return this.getAbbreviation();
    }

    public String getMedlineAbbreviation() {
        return this.getIsoAbbreviation().replace(".", " ").replace("  ", " ").trim();
    }

    @Override
    public int compareTo(Abbreviation toCompare) {
        return this.getName().compareTo(toCompare.getName());
    }

    public String getNext(String current) {
        String currentTrimmed = current.trim();
        if (this.getMedlineAbbreviation().equals(currentTrimmed)) {
            return this.getName();
        }
        if (this.getName().equals(currentTrimmed)) {
            return this.getIsoAbbreviation();
        }
        return this.getMedlineAbbreviation();
    }

    public String toString() {
        return String.format("Abbreviation{name=%s, iso=%s, medline=%s}", this.getName(), this.getIsoAbbreviation(), this.getMedlineAbbreviation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Abbreviation) {
            Abbreviation that = (Abbreviation)o;
            return Objects.equals(this.getName(), that.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }
}

