/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.AbbreviationParser;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalAbbreviationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JournalAbbreviationLoader.class);
    private static final String JOURNALS_FILE_BUILTIN = "/journals/journalList.txt";
    private static final String JOURNALS_IEEE_ABBREVIATION_LIST_WITH_CODE = "/journals/IEEEJournalListCode.txt";
    private static final String JOURNALS_IEEE_ABBREVIATION_LIST_WITH_TEXT = "/journals/IEEEJournalListText.txt";
    private JournalAbbreviationRepository journalAbbrev;

    public static List<Abbreviation> getOfficialIEEEAbbreviations() {
        return JournalAbbreviationLoader.readJournalListFromResource(JOURNALS_IEEE_ABBREVIATION_LIST_WITH_CODE);
    }

    public static List<Abbreviation> getStandardIEEEAbbreviations() {
        return JournalAbbreviationLoader.readJournalListFromResource(JOURNALS_IEEE_ABBREVIATION_LIST_WITH_TEXT);
    }

    public static List<Abbreviation> getBuiltInAbbreviations() {
        return JournalAbbreviationLoader.readJournalListFromResource(JOURNALS_FILE_BUILTIN);
    }

    public static List<Abbreviation> readJournalListFromResource(String resource) {
        AbbreviationParser parser = new AbbreviationParser();
        parser.readJournalListFromResource(Objects.requireNonNull(resource));
        return parser.getAbbreviations();
    }

    public static List<Abbreviation> readJournalListFromFile(File file) throws FileNotFoundException {
        LOGGER.debug("Reading journal list from file " + file);
        AbbreviationParser parser = new AbbreviationParser();
        parser.readJournalListFromFile(Objects.requireNonNull(file));
        return parser.getAbbreviations();
    }

    public static List<Abbreviation> readJournalListFromFile(File file, Charset encoding) throws FileNotFoundException {
        LOGGER.debug("Reading journal list from file " + file);
        AbbreviationParser parser = new AbbreviationParser();
        parser.readJournalListFromFile(Objects.requireNonNull(file), Objects.requireNonNull(encoding));
        return parser.getAbbreviations();
    }

    public void update(JournalAbbreviationPreferences journalAbbreviationPreferences) {
        String personalJournalList;
        this.journalAbbrev = new JournalAbbreviationRepository(new Abbreviation[0]);
        this.journalAbbrev.addEntries(JournalAbbreviationLoader.readJournalListFromResource(JOURNALS_FILE_BUILTIN));
        if (journalAbbreviationPreferences.useIEEEAbbreviations()) {
            this.journalAbbrev.addEntries(JournalAbbreviationLoader.getOfficialIEEEAbbreviations());
        } else {
            this.journalAbbrev.addEntries(JournalAbbreviationLoader.getStandardIEEEAbbreviations());
        }
        List<String> lists = journalAbbreviationPreferences.getExternalJournalLists();
        if (!lists.isEmpty()) {
            Collections.reverse(lists);
            for (String filename : lists) {
                try {
                    this.journalAbbrev.addEntries(JournalAbbreviationLoader.readJournalListFromFile(new File(filename)));
                }
                catch (FileNotFoundException e) {
                    LOGGER.info("Cannot find external journal list file " + filename, e);
                }
            }
        }
        if ((personalJournalList = journalAbbreviationPreferences.getPersonalJournalLists()) != null && !personalJournalList.trim().isEmpty()) {
            try {
                this.journalAbbrev.addEntries(JournalAbbreviationLoader.readJournalListFromFile(new File(personalJournalList), journalAbbreviationPreferences.getDefaultEncoding()));
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Personal journal list file '" + personalJournalList + "' not found.", e);
            }
        }
    }

    public JournalAbbreviationRepository getRepository(JournalAbbreviationPreferences journalAbbreviationPreferences) {
        if (this.journalAbbrev == null) {
            this.update(journalAbbreviationPreferences);
        }
        return this.journalAbbrev;
    }
}

