/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.layout.LayoutFormatter;

public class HTMLParagraphs
implements LayoutFormatter {
    private static final Pattern BEFORE_NEW_LINES_PATTERN = Pattern.compile("(.*?)\\n\\s*\\n");

    @Override
    public String format(String fieldText) {
        if (fieldText == null) {
            return fieldText;
        }
        String trimmedFieldText = fieldText.trim();
        if (trimmedFieldText.isEmpty()) {
            return trimmedFieldText;
        }
        Matcher m3 = BEFORE_NEW_LINES_PATTERN.matcher(trimmedFieldText);
        StringBuffer s2 = new StringBuffer();
        while (m3.find()) {
            String middle = m3.group(1).trim();
            if (middle.isEmpty()) continue;
            s2.append("<p>\n");
            m3.appendReplacement(s2, m3.group(1));
            s2.append("\n</p>\n");
        }
        s2.append("<p>\n");
        m3.appendTail(s2);
        s2.append("\n</p>");
        return s2.toString();
    }
}

